package com.elitesland.tw.tw5.server.prd.purchase.purenum;

import lombok.Getter;

/**
 * 采购协议
 */
public interface PurchaseAgreementEnum {
    enum AgreementStatus implements PurchaseAgreementEnum {

        CREATE("create", "新建"),
        APPROVING("approving", "审批中"),
        ACTIVE("active", "激活"),
        PENDING("pending", "暂挂"),
        BREAK("break", "终止"),
        CLOSE("close", "关闭"),
        ;
        /**
         * 状态
         */
        @Getter
        private final String code;

        /**
         * 描述
         */
        @Getter
        private final String desc;

        AgreementStatus(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }
    }
}
