package com.elitesland.tw.tw5.server.prd.purchase.service;

import cn.hutool.extra.spring.SpringUtil;
import cn.zhxu.bs.BeanSearcher;
import cn.zhxu.bs.FieldOps;
import cn.zhxu.bs.util.MapBuilder;
import cn.zhxu.bs.util.MapUtils;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BookAccountService;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BookAccountVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.service.BusinessCustomerInfoService;
import com.elitesland.tw.tw5.api.prd.partner.identity.service.BusinessSupplierInfoService;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessSupplierInfoVO;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PurchaseAgreementDetailsPayload;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PurchaseAgreementPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.PurchaseAgreementDetailsQuery;
import com.elitesland.tw.tw5.api.prd.purchase.query.PurchaseAgreementQuery;
import com.elitesland.tw.tw5.api.prd.purchase.service.*;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseAgreementDetailsVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseAgreementVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchasePaymentDefaultVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.ResSetRateVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.server.common.GenerateSeqNumConstants;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.excel.ExcelUtil;
import com.elitesland.tw.tw5.server.common.permission.PermissionBeanSearcherFactory;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionDomainEnum;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.util.BeanUtil;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.partner.constants.AccountUsageEnum;
import com.elitesland.tw.tw5.server.prd.partner.constants.JdeDocType;
import com.elitesland.tw.tw5.server.prd.purchase.convert.PurchaseAgreementConvert;
import com.elitesland.tw.tw5.server.prd.purchase.convert.PurchaseAgreementDetailsConvert;
import com.elitesland.tw.tw5.server.prd.purchase.dao.PurchaseAgreementDAO;
import com.elitesland.tw.tw5.server.prd.purchase.dao.PurchaseAgreementDetailsDAO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.PurchaseAgreementDO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.PurchaseAgreementDetailsDO;
import com.elitesland.tw.tw5.server.prd.purchase.purenum.PurchaseAgreementEnum;
import com.elitesland.tw.tw5.server.prd.purchase.repo.PurchaseAgreementRepo;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import com.elitesland.tw.tw5.server.yeedocref.YeedocUtils;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.payload.StartProcessPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 采购协议
 *
 * @author Echo
 * @date 2023-06-08
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PurchaseAgreementServiceImpl extends BaseServiceImpl implements PurchaseAgreementService {

    @Autowired
    private PurchaseAgreementDetailsService purchaseAgreementDetailsService;
    private final PurchaseAgreementRepo purchaseAgreementRepo;
    private final PurchaseAgreementDAO purchaseAgreementDAO;
    private final PurchaseAgreementDetailsDAO purchaseAgreementDetailsDAO;
    private final FileUtil fileUtil;
    // private final PrdAbDAO prdAbDAO;
    private final CacheUtil cacheUtil;
    private final PrdSystemRoleService prdSystemRoleService;

    @Value("${tw5.workflow.enabled}")
    private Boolean workflow_enabled;

    @Value("${tw5.workflow.orgId}")
    private Long workflow_orgId;

    private final WorkflowUtil workflowUtil;

    private final PrdOrgOrganizationDAO daoOrg;
    private final TransactionUtilService transactionUtilService;

    private final UdcUtil udcUtil;

    private final BusinessPartnerService businessPartnerService;
    private final BookAccountService bookAccountService;
    private final PurchaseAgreementResService purchaseAgreementResService;
    @Autowired
    private PurchaseAgreementAssociationService purchaseAgreementAssociationService;
    private final ResSetRateService resSetRateService;
    private BeanSearcher beanSearcher;

    private final BusinessSupplierInfoService businessSupplierInfoService;
    private final YeedocUtils yeedocUtils;
    @Autowired
    public void setBeanSearcher(PermissionBeanSearcherFactory permissionBeanSearcherFactory) {
        this.beanSearcher = permissionBeanSearcherFactory.getBeanSearcherService(PermissionDomainEnum.BUSINESS_OPPORTUNITY);
    }

    @Override
    public PagingVO<PurchaseAgreementVO> queryPaging(PurchaseAgreementQuery query) {
        PagingVO<PurchaseAgreementVO> pagingVO = purchaseAgreementDAO.queryPaging(query);
        if (CollectionUtils.isEmpty(pagingVO.getRecords())) {
            return pagingVO;
        }
        // 查询地址簿
        List<PurchaseAgreementVO> purchaseAgreementVOS = pagingVO.getRecords();
        transSysSelectionAndName(purchaseAgreementVOS);
        return pagingVO;
    }

    @Override
    public PagingVO<PurchaseAgreementVO> permissionPaging(PurchaseAgreementQuery query) {
        // 构建查询参数
        MapBuilder mapBuilder = this.pageWhereBuilder(query);
        Number totalNum = beanSearcher.searchCount(PurchaseAgreementVO.class, mapBuilder.build());
        if (totalNum.equals(0)) {
            return null;
        }
        List<PurchaseAgreementVO> purchaseAgreementVOS = beanSearcher.searchList(PurchaseAgreementVO.class, mapBuilder.build());
        // 翻译
        transSysSelectionAndName(purchaseAgreementVOS);
        return PagingVO.<PurchaseAgreementVO>builder().records(purchaseAgreementVOS).total((Long) totalNum).build();
    }


    /**
     * 拼装where条件
     * @param query 查询条件
     * @return 检索参数构建器
     */
    private MapBuilder pageWhereBuilder(PurchaseAgreementQuery query) {
        MapBuilder builder = MapUtils.builder();
        // 采购协议名称/编号
        if (!ObjectUtils.isEmpty(query.getPurchaseAgreementNmNo())) {
            String likeStr = "%" + query.getPurchaseAgreementNmNo() + "%";
            builder.field(PurchaseAgreementVO::getPurchaseAgreementName, PurchaseAgreementVO::getPurchaseAgreementNo).sql("$1 like ? or $2 like ?", likeStr, likeStr);
        }
        // 协议类型
        if (!ObjectUtils.isEmpty(query.getAgreementType())) {
            builder.field(PurchaseAgreementVO::getAgreementType, query.getAgreementType()).op(FieldOps.Equal);
        }
        // 签约日期
        if (!ObjectUtils.isEmpty(query.getSignDate())) {
            builder.field(PurchaseAgreementVO::getSignDate, query.getSignDate()).op(FieldOps.Equal);
        }
        // 协议状态
        if (!ObjectUtils.isEmpty(query.getAgreementStatus())) {
            builder.field(PurchaseAgreementVO::getAgreementStatus, query.getAgreementStatus()).op(FieldOps.Equal);
        }
        // 供应商
        if (!ObjectUtils.isEmpty(query.getSupplierBookId())) {
            builder.field(PurchaseAgreementVO::getSupplierBookId, query.getSupplierBookId()).op(FieldOps.Equal);
        }
        // 签约公司
        if (!ObjectUtils.isEmpty(query.getSignCompanyBookId())) {
            builder.field(PurchaseAgreementVO::getSignCompanyBookId, query.getSignCompanyBookId()).op(FieldOps.Equal);
        }
        // 签约BU
        if (!ObjectUtils.isEmpty(query.getSignBuId())) {
            builder.field(PurchaseAgreementVO::getSignBuId, query.getSignBuId()).op(FieldOps.Equal);
        }
        // 验收方式
        if (!ObjectUtils.isEmpty(query.getAcceptanceType())) {
            builder.field(PurchaseAgreementVO::getAcceptanceType, query.getAcceptanceType()).op(FieldOps.Equal);
        }
        // 创建人
        if (!ObjectUtils.isEmpty(query.getCreateUserId())) {
            builder.field(PurchaseAgreementVO::getCreateUserId, query.getCreateUserId()).op(FieldOps.Equal);
        }
        // 创建日期
        if (!ObjectUtils.isEmpty(query.getCreateTimeStart())) {
            builder.field(PurchaseAgreementVO::getCreateTime, query.getCreateTimeStart()).op(FieldOps.GreaterEqual);
        }
        if (!ObjectUtils.isEmpty(query.getCreateTimeEnd())) {
            builder.field(PurchaseAgreementVO::getCreateTime, query.getCreateTimeEnd()).op(FieldOps.LessEqual);
        }
        // ids
        if (!ObjectUtils.isEmpty(query.getIds())) {
            builder.field(PurchaseAgreementVO::getId, query.getIds()).op(FieldOps.InList);
        }
        builder.field(PurchaseAgreementVO::getDeleteFlag, 0).op(FieldOps.Equal);
        // 常用基础查询条件拼装,动态排序,分页,功能代码
        SqlUtil.handleBS(builder, query);
        return builder;
    }

    @Override
    public List<PurchaseAgreementVO> queryListDynamic(PurchaseAgreementQuery query) {
        List<PurchaseAgreementVO> managerVOS = purchaseAgreementDAO.queryListDynamic(query);
        if (CollectionUtils.isEmpty(managerVOS)) {
            return managerVOS;
        }
        transSysSelectionAndName(managerVOS);
        return managerVOS;
    }

//    /**
//     * 签约公司/供应商-列表查询
//     *
//     * @param relateType 查询的类型
//     * @return vo
//     */
//    @Override
//    public List<PrdAbVO> abQueryList(String relateType) {
//        return prdAbDAO.queryBookInfoByRelat(relateType);
//    }

    @Override
    public PurchaseAgreementVO queryByKey(Long key) {
        PurchaseAgreementDO entity = purchaseAgreementRepo.findById(key).orElseGet(PurchaseAgreementDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PurchaseAgreementVO vo = PurchaseAgreementConvert.INSTANCE.toVo(entity);

        //文件
        vo.setPricecompereFile(fileUtil.getFileDatas(vo.getPricecompereFileCodes()));
        vo.setAgreementFile(fileUtil.getFileDatas(vo.getAgreementFileCodes()));
        vo.setStampFile(fileUtil.getFileDatas(vo.getStampFileCodes()));

        //查询采购明细
        PurchaseAgreementDetailsQuery purchaseAgreementDetailsQuery = new PurchaseAgreementDetailsQuery();
        purchaseAgreementDetailsQuery.setAgreementId(key);
        List<PurchaseAgreementDetailsVO> purchaseAgreementDetailsVOS = purchaseAgreementDetailsService.queryListDynamic(purchaseAgreementDetailsQuery);
        vo.setDetails(purchaseAgreementDetailsVOS);

        // 翻译
        transSysSelectionAndName(Collections.singletonList(vo));
        //app要求返回合同的创建人和级别
        if(vo.getCreateUserId()!=null){
            Long defaultOrgIdByUserId = cacheUtil.getDefaultOrgIdByUserId(vo.getCreateUserId());
            if(defaultOrgIdByUserId!=null){
                String orgName = cacheUtil.getOrgName(defaultOrgIdByUserId);
                vo.setBuName(orgName);
            }
            PrdOrgEmployeeVO employee = cacheUtil.getEmployee(vo.getCreateUserId());
            if(employee!=null){
                vo.setGrade(employee.getExtString1());
            }
        }
        // 查询供应商的 状态/id
        if (vo.getSupplierBookId() != null) {
            BusinessSupplierInfoVO businessSupplierInfoVO = businessSupplierInfoService.quertByBookId(vo.getSupplierBookId());
            if (businessSupplierInfoVO != null) {
                vo.setSupplierStatus(businessSupplierInfoVO.getSupplierStatus());
                vo.setSupplierParentId(businessSupplierInfoVO.getPartnerId());
            }


        }
        return vo;
    }

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return vo
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public PurchaseAgreementVO insert(PurchaseAgreementPayload payload) {
        checkData(payload);

        if (purchaseAgreementDAO.queryByName(payload)) {
            throw TwException.error("", "采购协议名称已存在，请核验！");
        }

        payload.setPurchaseAgreementNo(generateSeqNum(GenerateSeqNumConstants.PURCHASE_AGREEMENT_NO));
        payload.setAgreementStatus(PurchaseAgreementEnum.AgreementStatus.CREATE.getCode());
        // 保存附件
        saveAgreementFile(payload);
        PurchaseAgreementDO entityDo = PurchaseAgreementConvert.INSTANCE.toDo(payload);


        // 计算税额/税率,金额
        countTax(payload.getDetails(), entityDo);

        PurchaseAgreementDO save = purchaseAgreementRepo.save(entityDo);
        List<PurchaseAgreementDetailsPayload> details = payload.getDetails();
        details.forEach(e -> e.setAgreementId(save.getId()));
        //更新采购明细
        updateDetails(payload, save);
//        // 获取变更日志
//        final String fieldsCreateLog = changeFieldLogUtil.getFieldsCreateLog(save);
//        logService.saveNewLog(save.getId(), PrdSystemObjectEnum.PURCHASE_AGREEMENT.getCode(), fieldsCreateLog);
        return PurchaseAgreementConvert.INSTANCE.toVo(save);
    }

    /**
     * 校验数据（空值判断）
     *
     * @param payload
     */
    private void checkData(PurchaseAgreementPayload payload) {
        if (ObjectUtils.isEmpty(payload.getPurchaseAgreementName())) {
            throw TwException.error("", "采购协议名称不存在，请核验！");
        }
        if (ObjectUtils.isEmpty(payload.getDetails())) {
            throw TwException.error("", "采购明细不存在，请核验！");
        }
    }

    /**
     * 更新采购明细
     *
     * @param payload  单据数据
     * @param entityDo
     */
    private void updateDetails(PurchaseAgreementPayload payload, PurchaseAgreementDO entityDo) {
        if (ObjectUtils.isEmpty(payload.getDetails())) {
            throw TwException.error("", "采购明细不存在，请核验！");
        }
        List<PurchaseAgreementDetailsPayload> details = payload.getDetails();
        List<PurchaseAgreementDetailsDO> dDetails = PurchaseAgreementDetailsConvert.INSTANCE.toDoList(details);
//        ArrayList<PurchaseAgreementDetailsDO> dDetails = new ArrayList<>();
        dDetails.forEach(detail -> {
            detail.setAgreementId(entityDo.getId());
//            dDetails.add(PurchaseAgreementDetailsConvert.INSTANCE.toDo(detail));
        });
        PurchaseAgreementDetailsConvert.INSTANCE.toVoList(dDetails);
        purchaseAgreementDetailsDAO.saveAll(dDetails);
    }

    /**
     * 计算税额/税率,金额
     *
     * @param details
     * @param entityDo
     */
    public void countTax(List<PurchaseAgreementDetailsPayload> details, PurchaseAgreementDO entityDo) {
        // 计金额
        BigDecimal total = BigDecimal.ZERO;
        BigDecimal taxTotal = BigDecimal.ZERO;
        for (PurchaseAgreementDetailsPayload detail : details) {
//            BigDecimal taxAmt = detail.getTaxAmt() == null ? BigDecimal.ZERO : detail.getTaxAmt();
//            BigDecimal taxNotAmt = detail.getTaxNotAmt() == null ? BigDecimal.ZERO : detail.getTaxNotAmt();
            BigDecimal taxAmt = detail.getQuantity().multiply(detail.getTaxPrice());
            BigDecimal taxNotAmt = taxAmt.subtract(detail.getQuantity().multiply(detail.getTaxPrice()).multiply(new BigDecimal(detail.getTaxRate())).multiply(new BigDecimal("0.01")));
            detail.setTaxAmt(taxAmt);
            detail.setTaxNotAmt(taxNotAmt);
            //含税总额
            total = total.add(taxAmt);
            //不含税总额
            taxTotal = taxTotal.add(taxNotAmt);
        }
        //设置信息表中金额(含税总额)和税额(含税总额-不含税总额)
        entityDo.setAmt(total);
        entityDo.setTaxAmt(total.subtract(taxTotal));
        //如果含税总额为0，设置税率为0
        if (total.equals(BigDecimal.ZERO)) {
            entityDo.setTaxRate("0%");
            return;
        }
        //取税率的最大值和最小值
        String max = details.stream()
                .map(PurchaseAgreementDetailsPayload::getTaxRate)
                .max(Comparator.comparingInt(Integer::parseInt))
                .orElse("0");
        String min = details.stream()
                .map(PurchaseAgreementDetailsPayload::getTaxRate)
                .min(Comparator.comparingInt(Integer::parseInt))
                .orElse("0");
        if (max.equals(min)) {
            entityDo.setTaxRate(min + "%");
        } else {
            entityDo.setTaxRate(min + "%" + "~" + max + "%");
        }
//        entityDo.setTaxRate(min + "%" + "~" + max + "%");
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PurchaseAgreementVO update(PurchaseAgreementPayload payload) {
        PurchaseAgreementDO entity = purchaseAgreementRepo.findById(payload.getId()).orElseGet(PurchaseAgreementDO::new);
        Assert.notNull(entity.getId(), "不存在");

        // 采购合同名称唯一校验
        String name = payload.getPurchaseAgreementName();
        if (StringUtils.hasText(name)) {
            PurchaseAgreementQuery query = new PurchaseAgreementQuery();
            query.setPurchaseAgreementNameEq(name);
            PagingVO<PurchaseAgreementVO> queryPaging = purchaseAgreementDAO.queryPaging(query);
            List<PurchaseAgreementVO> records = queryPaging.getRecords();
            if (!org.springframework.util.CollectionUtils.isEmpty(records)) {
                List<PurchaseAgreementVO> collect = records.stream().filter(e -> !e.getId().equals(payload.getId())).collect(Collectors.toList());
                if (!org.springframework.util.CollectionUtils.isEmpty(collect)) {
                    throw TwException.warn("", "协议名称不可重复！");
                }
            }
        }
        // 保存附件
        saveAgreementFile(payload);
        PurchaseAgreementDO entityDo = PurchaseAgreementConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        // 计算税额/税率,金额
        countTax(payload.getDetails(), entity);
        PurchaseAgreementDO save = purchaseAgreementRepo.save(entityDo);
        List<PurchaseAgreementDetailsPayload> details = payload.getDetails();
        details.forEach(e -> e.setAgreementId(save.getId()));
        //更新采购明细
        updateDetails(payload, save);
//        // 修改NULL值特殊处理
//        PurchaseAgreementDO entityLog = new PurchaseAgreementDO();
//        BeanUtils.copyProperties(save, entityLog);
//        save.copy(entityDo);
//        final StringBuilder fieldsUpdateLog = changeFieldLogUtil.nullFieldsProcess(payload, entityLog, entity);
//        //获取变更日志
//        logService.saveNewLog(entityDo.getId(),
//                PrdSystemObjectEnum.PURCHASE_AGREEMENT.getCode(),
//                PrdSystemLogEnum.UPDATE.getDesc() + PrdSystemObjectEnum.CUSTOMER_OPERATION_PLAN_DETAIL.getDesc());
//        // 经营计划信息的修改：（张三）更新（状态/执行者/时间/内容/优先级/内容）为（字段新值）
//        // 获取变更日志
//        fieldsUpdateLog.append(changeFieldLogUtil.getFieldsUpdateLog(entityDo, entityLog));
//        if (StringUtils.hasText(fieldsUpdateLog)) {
//            logService.saveNewLog(entityDo.getId(), PrdSystemObjectEnum.CUSTOMER_OPERATION_PLAN_DETAIL.getCode(), fieldsUpdateLog.toString());
//        }
        return PurchaseAgreementConvert.INSTANCE.toVo(purchaseAgreementRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(PurchaseAgreementPayload payload) {
        PurchaseAgreementDO entity = purchaseAgreementRepo.findById(payload.getId()).orElseGet(PurchaseAgreementDO::new);
        Assert.notNull(entity.getId(), "不存在");
        // 保存附件
        saveAgreementFile(payload);
        long result = purchaseAgreementDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            // 删除采购协议
            purchaseAgreementDAO.deleteSoft(keys);
            // 删除关联资源
            purchaseAgreementResService.deleteSoftByDocumentIdList(keys);
            // 删除采购明细
            purchaseAgreementDetailsService.deleteSoftByDocumentIdList(keys);
            // 删除关联协议
            purchaseAgreementAssociationService.deleteSoftByDocumentIdList(keys);
            // 删除人力资源结算费率
            resSetRateService.deleteSoftByDocumentIdList(keys);
        }
    }

    @Override
    public void active(Long id) {
        PurchaseAgreementVO purchaseAgreementVO = purchaseAgreementDAO.queryByKey(id);
        if (ObjectUtils.isEmpty(purchaseAgreementVO)) {
            throw TwException.error("", "采购协议不存在！");
        }
        activeProc(purchaseAgreementVO);
    }

    @Override
    @Transactional
    public void pending(List<Long> ids) {
        PurchaseAgreementQuery query = new PurchaseAgreementQuery();
        query.setIds(ids);
        List<PurchaseAgreementVO> purchaseAgreementVOS = purchaseAgreementDAO.queryListDynamic(query);
        List<PurchaseAgreementVO> notActiveList = purchaseAgreementVOS.stream().filter(e -> !PurchaseAgreementEnum.AgreementStatus.ACTIVE.getCode().equalsIgnoreCase(e.getAgreementStatus())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(notActiveList)) {
            throw TwException.error("", "激活状态才可以暂挂！");
        }
        purchaseAgreementDAO.updateStatusByIds(ids, PurchaseAgreementEnum.AgreementStatus.PENDING.getCode());
    }

    @Override
    @Transactional
    public void purAgreementBreak(List<Long> ids, String overReason) {
        PurchaseAgreementQuery query = new PurchaseAgreementQuery();
        query.setIds(ids);
        List<PurchaseAgreementVO> purchaseAgreementVOS = purchaseAgreementDAO.queryListDynamic(query);
        List<PurchaseAgreementVO> notActiveList = purchaseAgreementVOS.stream().filter(e -> !PurchaseAgreementEnum.AgreementStatus.ACTIVE.getCode().equalsIgnoreCase(e.getAgreementStatus())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(notActiveList)) {
            throw TwException.error("", "激活状态才可以终止！");
        }
        purchaseAgreementDAO.purAgreementBreakByIds(ids, overReason);
    }

    @Override
    public void download(HttpServletResponse response, PurchaseAgreementQuery query) {
        try {
            log.info("=============================开始查询=======================================");
            PagingVO<PurchaseAgreementVO> paging = queryPaging(query);
            log.info("=============================结束查询=======================================");
            List<PurchaseAgreementVO> records = paging.getRecords();
            download(udcUtil.translateList(records), response);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void permissionDownload(PurchaseAgreementQuery query, HttpServletResponse response) {
        try {
            log.info("=============================开始查询=======================================");
            PagingVO<PurchaseAgreementVO> paging = permissionPaging(query);
            log.info("=============================结束查询=======================================");
            List<PurchaseAgreementVO> records = paging.getRecords();
            download(udcUtil.translateList(records), response);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void download(List<PurchaseAgreementVO> records, HttpServletResponse response) throws IOException {
//        int order = 1;
        //定义文件名称
        String sheetName = "采购协议数据";
//        List<CrmPotentialCustomerListExcelExport> resultList = CrmPotentialCustomerConvert.INSTANCE.voListVoExcelExport(records);
//        resultList = udcUtil.translateList(resultList);
        //对文件名进行固定格式编码
        String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
        //设置请求响应内容类型
        //作用:使客户端浏览器，区分不同种类的数据，并根据不同的MIME调用浏览器内不同的程序嵌入模块来处理相应的数据。
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        //设置请求响应内容编码方式
        response.setCharacterEncoding("utf-8");
        //文件下载，指定默认名
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);

        final ExcelWriterSheetBuilder sheet = EasyExcel.write(response.getOutputStream(), PurchaseAgreementVO.class)
                .registerWriteHandler(new LongestMatchColumnWidthStyleStrategy())
                .sheet(sheetName);
        // 列
        ExcelUtil.excelHelper(sheet, PurchaseAgreementVO.class, null);
        //写入
        sheet.doWrite(records);
    }


    private void transSysSelectionAndName(List<PurchaseAgreementVO> purchaseAgreementVOList) {
        // 地址簿列表
        List<Long> bookIdList = new ArrayList<>();
        purchaseAgreementVOList.forEach(purchaseAgreementVO -> {
            bookIdList.add(purchaseAgreementVO.getInvoice());
            bookIdList.add(purchaseAgreementVO.getSupplierBookId());
            bookIdList.add(purchaseAgreementVO.getSignCompanyBookId());
        });
        Map<Long, String> nameByBookIds = businessPartnerService.findNameByBookIds(bookIdList);
        // 翻译
        purchaseAgreementVOList.forEach(purchaseAgreementVO -> {
            // 翻译地址簿
            purchaseAgreementVO.setInvoiceName(nameByBookIds.get(purchaseAgreementVO.getInvoice()));
            purchaseAgreementVO.setSupplierName(nameByBookIds.get(purchaseAgreementVO.getSupplierBookId()));
            purchaseAgreementVO.setSignCompanyName(nameByBookIds.get(purchaseAgreementVO.getSignCompanyBookId()));
            // 翻译名称
            purchaseAgreementVO.setCreateUserName(cacheUtil.getUserName(purchaseAgreementVO.getCreateUserId()));
        });
    }

    /**
     * 发起激活审批流程
     *
     * @param
     */
    private void activeProc(PurchaseAgreementVO agreementVO) {
        ProcessInfo processInfo = new ProcessInfo();
        String status = PurchaseAgreementEnum.AgreementStatus.CREATE.getCode();
        if (workflow_enabled) {
            status = PurchaseAgreementEnum.AgreementStatus.APPROVING.getCode();
            HashMap<String, Object> variables = new HashMap<>();
            // 签约bu负责人
            Long signBuManageUserId = null;
            if (agreementVO.getSignBuId() != null) {
                signBuManageUserId = daoOrg.queryManageIdById(agreementVO.getSignBuId());
            }
            variables.put("Activity_0i7952g", signBuManageUserId);
            // 平台采购主管（平台业务总负责人）
            variables.put("Activity_128wjc7", prdSystemRoleService.queryUserIdByRoleCode(RoleEnum.PLAT_BUSINESS_PIC.getCode()));
            //发起流程审批
            processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                    ProcDefKey.PA_AGREEMENT_ACTIVE.name(),
                    agreementVO.getPurchaseAgreementName() + "-采购协议激活审批流程",
                    agreementVO.getId() + "",
                    variables)
            );
        }
        //流程启动成功后，回写业务表数据
        PurchaseAgreementPayload payload = new PurchaseAgreementPayload();
        payload.setProcInstId(processInfo.getProcInstId());
        payload.setId(agreementVO.getId());
        payload.setProcInstStatus(processInfo.getProcInstStatus());
        payload.setSubmitTime(LocalDateTime.now());
        payload.setAgreementStatus(status);
        //开启事务执行修改，主要是修改审批状态
        transactionUtilService.executeWithRunnable(() -> {
            purchaseAgreementDAO.updateByKeyDynamic(payload);
        });
    }


    @Override
    public PurchasePaymentDefaultVO findPaymentDefaultByDocNo(String docNo) {
        PurchasePaymentDefaultVO purchasePaymentDefaultVO = new PurchasePaymentDefaultVO();
        PurchaseAgreementVO byPurchaseAgreementNo = purchaseAgreementDAO.findByPurchaseAgreementNo(docNo);
        if (byPurchaseAgreementNo != null) {
            if (byPurchaseAgreementNo.getReceivingUnitBookId() != null) {
                // 查询供应商的收款银行、收款账号
                BookAccountVO bookAccountVO = bookAccountService.queryDefaultByBookId(byPurchaseAgreementNo.getReceivingUnitBookId());
                if (bookAccountVO != null && AccountUsageEnum.RECEIVE.getCode().equals(bookAccountVO.getAccountUsage())) {
                    // 收款账号
                    purchasePaymentDefaultVO.setReceivingId(String.valueOf(bookAccountVO.getId()));
                    // 收款银行
                    purchasePaymentDefaultVO.setReceivingBank(bookAccountVO.getDepositBank());
                }
            }
            // 关联单据id
            purchasePaymentDefaultVO.setDocId(byPurchaseAgreementNo.getId());
            // 验收方式
            purchasePaymentDefaultVO.setAcceptanceType(byPurchaseAgreementNo.getAcceptanceType());
            // 币种
            purchasePaymentDefaultVO.setCurrCode(byPurchaseAgreementNo.getCurrCode());
            // 关联单据号
            purchasePaymentDefaultVO.setDocNo(byPurchaseAgreementNo.getPurchaseAgreementNo());
            // 关联单据名称
            purchasePaymentDefaultVO.setDocName(byPurchaseAgreementNo.getPurchaseAgreementName());
            // 供应商BookId
            purchasePaymentDefaultVO.setSupplierBookId(byPurchaseAgreementNo.getSupplierBookId());
            // 收款人BookId
            purchasePaymentDefaultVO.setReceivingUnitBookId(byPurchaseAgreementNo.getReceivingUnitBookId());
            // 付款方式
            purchasePaymentDefaultVO.setPayMethod(byPurchaseAgreementNo.getPayMethod());
            // 需求编号
            purchasePaymentDefaultVO.setDemandNo(byPurchaseAgreementNo.getDemandNo());
            // 付款公司BookId
            purchasePaymentDefaultVO.setPaymentCompanyBooKId(byPurchaseAgreementNo.getSignCompanyBookId());
            // 应付付款金额
            purchasePaymentDefaultVO.setPaymentAmt(byPurchaseAgreementNo.getAmt());
        }
        return purchasePaymentDefaultVO;
    }

    @Override
    public Long findIdByNo(String docNo) {
        return purchaseAgreementDAO.findIdByNo(docNo);
    }

    @Override
    public PurchaseAgreementVO queryByNo(String docNo) {
        return purchaseAgreementDAO.queryByNo(docNo);
    }

    @Override
    public BigDecimal getRateByAgreementId(Long agreementId, BigDecimal amt) {
        // 根据采购协议编号获取人力资源结算费率列表
        List<ResSetRateVO> resSetRateVOS = resSetRateService.findByAgreementId(agreementId);
        // 返回费率，现在费率的配置为[]，而不是[)
        return resSetRateVOS.stream()
                .filter(e -> e.getEndAtm().compareTo(amt) >= 0 && e.getStartAtm().compareTo(amt) <= 0)
                .findFirst()
                .map(ResSetRateVO::getServiceRate)
                .orElseThrow(() -> {
                    log.error("[PAYMENT_APPLY]===获取费率异常===");
                    return TwException.error("", "获取费率异常");
                });
    }
    // 保存协议附件
    private void saveAgreementFile(PurchaseAgreementPayload payload){
        Map<String, Object> context = BeanUtil.beanToMap(payload);
        // 比价资料
        String pricecompereFileCodeStr = yeedocUtils.saveYeedocFileByFieldConfig(context, payload.getPricecompereFileCodes());
        payload.setPricecompereFileCodes(pricecompereFileCodeStr);
        // 协议附件
        String agreementFileCodeStr = yeedocUtils.saveYeedocFileByFieldConfig(context, payload.getAgreementFileCodes());
        payload.setAgreementFileCodes(agreementFileCodeStr);
        // 盖章附件
        String stampFileCodeStr = yeedocUtils.saveYeedocFileByFieldConfig(context, payload.getStampFileCodes());
        payload.setStampFileCodes(stampFileCodeStr);
    }
}
