package com.elitesland.tw.tw5.server.prd.purchase.service;

import cn.hutool.core.collection.CollUtil;
import cn.zhxu.bs.BeanSearcher;
import cn.zhxu.bs.FieldOps;
import cn.zhxu.bs.util.MapBuilder;
import cn.zhxu.bs.util.MapUtils;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgRoleVO;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BookAccountService;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BookAccountVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.service.BusinessSupplierInfoService;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessSupplierInfoVO;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.product.service.PrdProductService;
import com.elitesland.tw.tw5.api.prd.product.vo.PrdProductVO;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PurchaseContractDetailsPayload;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PurchaseContractManagerPayload;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PurchasePaymentPlanPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.PurchaseContractDetailsQuery;
import com.elitesland.tw.tw5.api.prd.purchase.query.PurchaseContractManagerQuery;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchaseContractDetailsService;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchaseContractManagerService;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchasePaymentPlanService;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchasePaymentService;
import com.elitesland.tw.tw5.api.prd.purchase.vo.*;
import com.elitesland.tw.tw5.api.prd.salecon.service.SaleConContractService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.SaleConContractVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemLogVO;
import com.elitesland.tw.tw5.server.common.GenerateSeqNumConstants;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.permission.PermissionBeanSearcherFactory;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionDomainEnum;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldLogUtil;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.*;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.partner.constants.AccountUsageEnum;
import com.elitesland.tw.tw5.server.prd.purchase.convert.PurchaseContractDetailsConvert;
import com.elitesland.tw.tw5.server.prd.purchase.convert.PurchaseContractManagerConvert;
import com.elitesland.tw.tw5.server.prd.purchase.convert.PurchasePaymentPlanConvert;
import com.elitesland.tw.tw5.server.prd.purchase.dao.PurchaseContractDetailsDAO;
import com.elitesland.tw.tw5.server.prd.purchase.dao.PurchaseContractManagerDAO;
import com.elitesland.tw.tw5.server.prd.purchase.dao.PurchasePaymentPlanDAO;
import com.elitesland.tw.tw5.server.prd.purchase.dao.TPurchaseContractOverDAO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.PurchaseContractManagerDO;
import com.elitesland.tw.tw5.server.prd.purchase.purenum.PurchaseContractEnum;
import com.elitesland.tw.tw5.server.prd.purchase.purenum.PurchaseContractStatusEnum;
import com.elitesland.tw.tw5.server.prd.purchase.repo.PurchaseContractManagerRepo;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConEpibolyCostConDDAO;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConPurchaseDemandDDAO;
import com.elitesland.tw.tw5.server.prd.salecon.dao.SaleConContractDAO;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.SetVariablesPayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 采购合同管理
 *
 * @author lipengfei
 * @date 2023-05-30
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PurchaseContractManagerServiceImpl extends BaseServiceImpl implements PurchaseContractManagerService {

    private final PurchaseContractManagerRepo purchaseContractManagerRepo;
    private final PurchaseContractManagerDAO purchaseContractManagerDAO;
    private final CacheUtil cacheUtil;
    private final PrdSystemLogService logService;
    private final ChangeFieldLogUtil changeFieldLogUtil;
    private final FileUtil fileUtil;
    private final PurchasePaymentPlanDAO purchasePaymentPlanDAO;
    private final PurchaseContractDetailsDAO purchaseContractDetailsDAO;
    @Autowired
    private PurchaseContractDetailsService purchaseContractDetailsService;
    @Autowired
    private PurchasePaymentPlanService purchasePaymentPlanService;
    private final SaleConContractDAO saleConContractDAO;
    @Autowired
    private SaleConContractService saleConContractService;
    private final WorkflowUtil workflowUtil;
    private final TransactionUtilService transactionUtilService;
    private final PrdOrgOrganizationDAO daoOrg;
    private final PrdProductService productService;
    private final ConEpibolyCostConDDAO costConDDAO;
    @Value("${tw5.workflow.enabled}")
    private Boolean workflow_enabled;

    private final UdcUtil udcUtil;

    private final TPurchaseContractOverDAO purchaseContractOverDAO;

    private final ConEpibolyCostConDDAO conEpibolyCostConDDAO;

    private final ConPurchaseDemandDDAO conPurchaseDemandDDAO;

    @Value("${tw5.workflow.orgId}")
    private Long workflow_orgId;

    private final BookAccountService bookAccountService;
    // private final PrdAbDAO prdAbDAO;
    private final BusinessPartnerService businessPartnerService;
    private final PrdSystemRoleService systemRoleService;

    private final BusinessSupplierInfoService businessSupplierInfoService;
    @Autowired
    private PurchasePaymentService purchasePaymentService;

    private BeanSearcher beanSearcher;

    private final PmsProjectService pmsProjectService;

    @Autowired
    public void setBeanSearcher(PermissionBeanSearcherFactory permissionBeanSearcherFactory) {
        this.beanSearcher = permissionBeanSearcherFactory.getBeanSearcherService(PermissionDomainEnum.BUSINESS_OPPORTUNITY);
    }

    @Override
    public PagingVO<PurchaseContractManagerVO> queryPaging(PurchaseContractManagerQuery query) {
        PagingVO<PurchaseContractManagerVO> pagingVO = purchaseContractManagerDAO.queryPaging(query);
        if (CollectionUtils.isEmpty(pagingVO.getRecords())) {
            return pagingVO;
        }
        // 翻译
        transSysSelectionAndName(pagingVO.getRecords());
        return pagingVO;
    }

    @Override
    public PagingVO<PurchaseContractManagerVO> queryPermissionPaging(PurchaseContractManagerQuery query) {
        // 构建查询参数
        MapBuilder mapBuilder = this.pageWhereBuilder(query);
        Number totalNum = beanSearcher.searchCount(PurchaseContractManagerVO.class, mapBuilder.build());
        if (totalNum.equals(0)) {
            return null;
        }
        List<PurchaseContractManagerVO> PurchaseContractManagerVOS = beanSearcher.searchList(PurchaseContractManagerVO.class, mapBuilder.build());
        // 翻译
        transSysSelectionAndName(PurchaseContractManagerVOS);
        ;
        return PagingVO.<PurchaseContractManagerVO>builder().records(PurchaseContractManagerVOS).total((Long) totalNum).build();

    }

    private MapBuilder pageWhereBuilder(PurchaseContractManagerQuery query) {
        MapBuilder builder = MapUtils.builder();
        // 采购合同名称/编号

        if (!ObjectUtils.isEmpty(query.getPurchaseContractNo())) {
            builder.field(PurchaseContractManagerVO::getPurchaseContractNo, query.getPurchaseContractNo()).op(FieldOps.Equal);
        }
        // ID
        if (!ObjectUtils.isEmpty(query.getId())) {
            builder.field(PurchaseContractManagerVO::getId, query.getId()).op(FieldOps.Equal);
        }
        // IDS
        if (!org.springframework.util.CollectionUtils.isEmpty(query.getIds())) {
            builder.field(PurchaseContractManagerVO::getId, query.getIds()).op(FieldOps.InList);
        }

        /** 采购合同名称 精确 */
        if (!ObjectUtils.isEmpty(query.getPurchaseContractName())) {
            String likeStr = "%" + query.getPurchaseContractName() + "%";
            builder.field(PurchaseContractManagerVO::getPurchaseContractName, PurchaseContractManagerVO::getPurchaseContractNo).sql("$1 like ? or $2 like ?", likeStr, likeStr);
        }
        if (!ObjectUtils.isEmpty(query.getPurchaseContractNameEq())) {
            builder.field(PurchaseContractManagerVO::getPurchaseContractName, query.getPurchaseContractNameEq()).op(FieldOps.Equal);
        }
        /** 平台合同类型 udc[salecon:plat_type] 精确 */
        if (!ObjectUtils.isEmpty(query.getPlatType())) {
            builder.field(PurchaseContractManagerVO::getPlatType, query.getPlatType()).op(FieldOps.Equal);
        }
        /** 采购合同类型 udc[purchase:con_type] 精确 */
        if (!ObjectUtils.isEmpty(query.getPurchaseContractType())) {
            builder.field(PurchaseContractManagerVO::getPurchaseContractType, query.getPurchaseContractType()).op(FieldOps.Equal);
        }
        /** 业务类型 udc[purchase:business_type] 精确 */
        if (!ObjectUtils.isEmpty(query.getBusinessType())) {
            builder.field(PurchaseContractManagerVO::getBusinessType, query.getBusinessType()).op(FieldOps.Equal);
        }
        /** 验收方式 udc[purchase:check] 精确 */
        if (!ObjectUtils.isEmpty(query.getAcceptanceType())) {
            builder.field(PurchaseContractManagerVO::getAcceptanceType, query.getAcceptanceType()).op(FieldOps.Equal);
        }
        /** 采购公司地址簿Id 精确 */
        if (!ObjectUtils.isEmpty(query.getPurchaseCompanyBookId())) {
            builder.field(PurchaseContractManagerVO::getPurchaseCompanyBookId, query.getPurchaseCompanyBookId()).op(FieldOps.Equal);
        }
        /** 供应商地址簿ID 精确 */
        if (!ObjectUtils.isEmpty(query.getSupplierBookId())) {
            builder.field(PurchaseContractManagerVO::getSupplierBookId, query.getSupplierBookId()).op(FieldOps.Equal);
        }
        /** 采购BU 精确 */
        if (!ObjectUtils.isEmpty(query.getPurchaseBuId())) {
            builder.field(PurchaseContractManagerVO::getPurchaseBuId, query.getPurchaseBuId()).op(FieldOps.Equal);
        }
        /** 采购负责人 精确 */
        if (!ObjectUtils.isEmpty(query.getPurchaseInchargeResId())) {
            builder.field(PurchaseContractManagerVO::getPurchaseInchargeResId, query.getPurchaseInchargeResId()).op(FieldOps.Equal);
        }
        /** 签约日期 精确 */
        if (!ObjectUtils.isEmpty(query.getSignDateStart())) {
            builder.field(PurchaseContractManagerVO::getSignDate, query.getSignDateStart()).op(FieldOps.GreaterEqual);
        }
        /** 签约日期 精确 */
        if (!ObjectUtils.isEmpty(query.getSignDateEnd())) {
            builder.field(PurchaseContractManagerVO::getSignDate, query.getSignDateEnd()).op(FieldOps.LessEqual);
        }
        if (!ObjectUtils.isEmpty(query.getSignDateStart()) && !ObjectUtils.isEmpty(query.getSignDateEnd())) {
            builder.field(PurchaseContractManagerVO::getSignDate).sql("$1 >= ? and $1 <= ?", query.getSignDateStart(), query.getSignDateEnd());
        }
        /** 申请日期 精确 */
        if (!ObjectUtils.isEmpty(query.getApplicationDateStart())) {
            builder.field(PurchaseContractManagerVO::getApplicationDate, query.getApplicationDateStart()).op(FieldOps.GreaterEqual);
        }
        /** 申请日期 精确 */
        if (!ObjectUtils.isEmpty(query.getApplicationDateEnd())) {
            builder.field(PurchaseContractManagerVO::getApplicationDate, query.getApplicationDateEnd()).op(FieldOps.LessEqual);
        }
        if (!ObjectUtils.isEmpty(query.getApplicationDateStart()) && !ObjectUtils.isEmpty(query.getApplicationDateEnd())) {
            builder.field(PurchaseContractManagerVO::getApplicationDate).sql("$1 >= ? and $1 <= ?", query.getApplicationDateStart().toString(), query.getApplicationDateEnd().toString());
        }
        /** 币种 udc[SYSTEM_BASIC:CURRENCY] 精确 */
        if (!ObjectUtils.isEmpty(query.getCurrCode())) {
            builder.field(PurchaseContractManagerVO::getCurrCode, query.getCurrCode()).op(FieldOps.Equal);
        }
        /** 金额 精确 */
        if (!ObjectUtils.isEmpty(query.getAmt())) {
            builder.field(PurchaseContractManagerVO::getAmt, query.getAmt()).op(FieldOps.Equal);
        }
        /** 税率 精确 */
        if (!ObjectUtils.isEmpty(query.getTaxRate())) {
            builder.field(PurchaseContractManagerVO::getTaxRate, query.getTaxRate()).op(FieldOps.Equal);
        }
        /** 税额 精确 */
        if (!ObjectUtils.isEmpty(query.getTaxAmt())) {
            builder.field(PurchaseContractManagerVO::getTaxAmt, query.getTaxAmt()).op(FieldOps.Equal);
        }
        /** 合同状态 精确 */
        if (!ObjectUtils.isEmpty(query.getContractStatus())) {
            builder.field(PurchaseContractManagerVO::getContractStatus, query.getContractStatus()).op(FieldOps.Equal);
        }
        /** 审批状态 精确 */
        if (!ObjectUtils.isEmpty(query.getApprStatus())) {
            builder.field(PurchaseContractManagerVO::getApprStatus, query.getApprStatus()).op(FieldOps.Equal);
        }
        /** 关联销售合同 精确 */
        if (!ObjectUtils.isEmpty(query.getRelatedSalesContract())) {
            builder.field(PurchaseContractManagerVO::getRelatedSalesContract, query.getRelatedSalesContract()).op(FieldOps.Equal);
        }
        /** 关联协议 精确 */
        if (!ObjectUtils.isEmpty(query.getRelatedAgreement())) {
            builder.field(PurchaseContractManagerVO::getRelatedAgreement, query.getRelatedAgreement()).op(FieldOps.Equal);
        }
        /** 需求编号 精确 */
        if (!ObjectUtils.isEmpty(query.getDemandNo())) {
            builder.field(PurchaseContractManagerVO::getDemandNo, query.getDemandNo()).op(FieldOps.Equal);
        }
        /** 比价资料 精确 */
        if (!ObjectUtils.isEmpty(query.getPricecompereFileCodes())) {
            builder.field(PurchaseContractManagerVO::getPricecompereFileCodes, query.getPricecompereFileCodes()).op(FieldOps.Equal);
        }
        /** 合同附件 精确 */
        if (!ObjectUtils.isEmpty(query.getContractFileCodes())) {
            builder.field(PurchaseContractManagerVO::getContractFileCodes, query.getContractFileCodes()).op(FieldOps.Equal);
        }
        /** 盖章附件 精确 */
        if (!ObjectUtils.isEmpty(query.getStampFileCodes())) {
            builder.field(PurchaseContractManagerVO::getStampFileCodes, query.getStampFileCodes()).op(FieldOps.Equal);
        }
        /** 项目ID 精确 */
        if (!ObjectUtils.isEmpty(query.getRelatedProjectId())) {
            builder.field(PurchaseContractManagerVO::getRelatedProjectId, query.getRelatedProjectId()).op(FieldOps.Equal);
        }
        /** 项目名称 精确 */
        if (!ObjectUtils.isEmpty(query.getRelatedProjectName())) {
            String likeStr = "%" + query.getRelatedProjectName() + "%";
            builder.field(PurchaseContractManagerVO::getRelatedProjectName, PurchaseContractManagerVO::getRelatedProjectNo).sql("$1 like ? or $2 like ?", likeStr, likeStr);
        }
        /** 任务包 精确 */
        if (!ObjectUtils.isEmpty(query.getRelatedTask())) {
            builder.field(PurchaseContractManagerVO::getRelatedTask, query.getRelatedTask()).op(FieldOps.Equal);
        }
        /** 开票方 精确 */
        if (!ObjectUtils.isEmpty(query.getInvoice())) {
            builder.field(PurchaseContractManagerVO::getInvoice, query.getInvoice()).op(FieldOps.Equal);
        }
        /** 付款方式 精确 */
        if (!ObjectUtils.isEmpty(query.getPayMethod())) {
            builder.field(PurchaseContractManagerVO::getPayMethod, query.getPayMethod()).op(FieldOps.Equal);
        }
        /** 采购来源 精确 */
        if (!ObjectUtils.isEmpty(query.getContractSource())) {
            builder.field(PurchaseContractManagerVO::getContractSource, query.getContractSource()).op(FieldOps.Equal);
        }
        /** 采购来源编号 精确 */
        if (!ObjectUtils.isEmpty(query.getContractSourceNo())) {
            String likeStr = "%" + query.getContractSourceNo() + "%";
            builder.field(PurchaseContractManagerVO::getContractSourceNo).sql("$1 like ? ", likeStr);
        }
        /** 激活时间 精确 */
        if (!ObjectUtils.isEmpty(query.getActivateDate())) {
            builder.field(PurchaseContractManagerVO::getActivateDate, query.getActivateDate()).op(FieldOps.Equal);
        }
        /** 终止原因 精确 */
        if (!ObjectUtils.isEmpty(query.getOverWhy())) {
            String likeStr = "%" + query.getOverWhy() + "%";
            builder.field(PurchaseContractManagerVO::getOverWhy).sql("$1 like ? ", likeStr);
        }
        /** 终止时间 精确 */
        if (!ObjectUtils.isEmpty(query.getOverDate())) {
            builder.field(PurchaseContractManagerVO::getOverDate, query.getOverDate()).op(FieldOps.Equal);
        }
        /** 合同归档标志，0：未归档，1：归档 精确 */
        if (!ObjectUtils.isEmpty(query.getFilingFlag())) {
            builder.field(PurchaseContractManagerVO::getFilingFlag, query.getFilingFlag()).op(FieldOps.Equal);
        }
        /**
         * 采购大类
         */
        if (!ObjectUtils.isEmpty(query.getClassId())) {
            builder.field(PurchaseContractManagerVO::getClassId, query.getClassId()).op(FieldOps.Equal);
        }

        if (!ObjectUtils.isEmpty(query.getContractNmNo())) {
            String likeStr = "%" + query.getContractNmNo() + "%";
            builder.field(PurchaseContractManagerVO::getRelatedSalesContractName, PurchaseContractManagerVO::getRelatedSalesContractCode).sql("$1 like ? or $2 like ?", likeStr, likeStr);
        }
        if (!ObjectUtils.isEmpty(query.getPurContractNmNo())) {
            String likeStr = "%" + query.getPurContractNmNo() + "%";
            builder.field(PurchaseContractManagerVO::getPurchaseContractNo, PurchaseContractManagerVO::getPurchaseContractName).sql("$1 like ? or $2 like ?", likeStr, likeStr);
        }
        if (!ObjectUtils.isEmpty(query.getProjNmNo())) {
            //   builder.field(PurchaseContractManagerVO::getProjNmNo, query.getProjNmNo()).op(FieldOps.Equal);
            String likeStr = "%" + query.getProjNmNo() + "%";
            builder.field(PurchaseContractManagerVO::getRelatedProjectName, PurchaseContractManagerVO::getRelatedProjectNo).sql("$1 like ? or $2 like ?", likeStr, likeStr);
        }
        // 常用基础查询条件拼装,动态排序,分页,功能代码
        SqlUtil.handleBS(builder, query);
        return builder;
    }

    @Override
    public List<PurchaseContractManagerVO> queryListDynamic(PurchaseContractManagerQuery query) {
        List<PurchaseContractManagerVO> managerVOS = purchaseContractManagerDAO.queryListDynamic(query);
        if (CollectionUtils.isEmpty(managerVOS)) {
            return managerVOS;
        }
        // 翻译
        transSysSelectionAndName(managerVOS);
        return managerVOS;
    }

    @Override
    public PurchaseContractManagerVO queryByKey(Long key) {
        PurchaseContractManagerDO entity = purchaseContractManagerRepo.findById(key).orElseGet(PurchaseContractManagerDO::new);
        if(entity == null || entity.getId() ==null){
            return null;
        }
        PurchaseContractManagerVO vo = PurchaseContractManagerConvert.INSTANCE.toVo(entity);
        //文件类型
        vo.setContractFile(fileUtil.getFileDatas(vo.getContractFileCodes()));
        vo.setStampFile(fileUtil.getFileDatas(vo.getStampFileCodes()));
        vo.setPricecompereFile(fileUtil.getFileDatas(vo.getPricecompereFileCodes()));

        // 查询采购合同明细
        PurchaseContractDetailsQuery detail = new PurchaseContractDetailsQuery();
        detail.setPurchaseContractId(key);
        List<PurchaseContractDetailsVO> purchaseContractDetailsVOS = purchaseContractDetailsService.queryListDynamic(detail);
        vo.setPurchaseDetailViews(purchaseContractDetailsVOS);

        // 查询采购付款计划（不包含预付款核销时新增的）
        List<PurchasePaymentPlanVO> purchasePaymentPlanVOS = purchasePaymentPlanService.queryListByConId(key, true);
        vo.setPaymentPlanViews(purchasePaymentPlanVOS);

        // 销售合同
        if (vo.getRelatedSalesContract() != null) {
            SaleConContractVO saleConContractVO = saleConContractDAO.queryByKey(vo.getRelatedSalesContract());
            vo.setSaleContractView(saleConContractVO);
            if (saleConContractVO != null) {
                vo.setRelatedSalesContractName(saleConContractVO.getName());
//                vo.setDemandNo(saleConContractVO.getRelatedContractCode());
                vo.setRelatedSalesContractCode(saleConContractVO.getCode());
            }
        }
        // 查询终止原因和终止时间
        TPurchaseContractOverVO purchaseContractOverVO = purchaseContractOverDAO.queryByConId(key);
        if (!ObjectUtils.isEmpty(purchaseContractOverVO)) {
            vo.setOverVO(purchaseContractOverVO);
        }

        //app要求返回合同的创建人和级别
        if (vo.getCreateUserId() != null) {
            Long defaultOrgIdByUserId = cacheUtil.getDefaultOrgIdByUserId(vo.getCreateUserId());
            if (defaultOrgIdByUserId != null) {
                String orgName = cacheUtil.getOrgName(defaultOrgIdByUserId);
                vo.setBuName(orgName);
            }
            PrdOrgEmployeeVO employee = cacheUtil.getEmployee(vo.getCreateUserId());
            if (employee != null) {
                vo.setGrade(employee.getExtString1());
            }
        }

        // 翻译
        transSysSelectionAndName(vo);

        // 查询供应商的 状态/id
        if (vo.getSupplierBookId() != null) {
            BusinessSupplierInfoVO businessSupplierInfoVO = businessSupplierInfoService.quertByBookId(vo.getSupplierBookId());
            if (businessSupplierInfoVO != null) {
                vo.setSupplierStatus(businessSupplierInfoVO.getSupplierStatus());
                vo.setSupplierParentId(businessSupplierInfoVO.getPartnerId());
            }
        }
        return vo;
    }

    @Override
   // @Transactional(rollbackFor = Exception.class)
    public PurchaseContractManagerVO insert(PurchaseContractManagerPayload payload) {
        // 采购合同名称唯一校验
        String name = payload.getPurchaseContractName();
        if (StringUtils.hasText(name)) {
            PurchaseContractManagerQuery query = new PurchaseContractManagerQuery();
            query.setPurchaseContractNameEq(name);
            PagingVO<PurchaseContractManagerVO> queryPaging = purchaseContractManagerDAO.queryPaging(query);
            List<PurchaseContractManagerVO> records = queryPaging.getRecords();
            if (!org.springframework.util.CollectionUtils.isEmpty(records)) {
                List<PurchaseContractManagerVO> collect = records.stream().filter(e -> !e.getId().equals(payload.getId())).collect(Collectors.toList());
                if (!org.springframework.util.CollectionUtils.isEmpty(collect)) {
                    throw TwException.warn("", "合同名称不可重复！");
                }
            }
        }
        // 校验：采购明细含税总额的总金额与付款金额的总金额是否相等
        if (ObjectUtils.isEmpty(payload.getPurchaseDetailViews())) {
            throw TwException.error("", "采购明细不存在，请核验！");
        }
        if (ObjectUtils.isEmpty(payload.getPaymentPlanViews())) {
            throw TwException.error("", "付款计划不存在，请核验！");
        }

        BigDecimal totalAmount1 = payload.getPurchaseDetailViews().stream()
                .map(view -> view.getTaxAmt())
                .reduce(BigDecimal.ZERO, BigDecimal::add);

        BigDecimal totalAmount2 = payload.getPaymentPlanViews().stream()
                .map(view -> view.getPaymentAmt())
                .reduce(BigDecimal.ZERO, BigDecimal::add);

        if (totalAmount1.compareTo(totalAmount2) != 0) {
            throw TwException.error("", "采购明细含税总额的总金额与付款金额的总金额不相等，请核验！");
        }
        payload.setPurchaseContractNo(generateSeqNum(GenerateSeqNumConstants.PURCHASE_CONTRACT_NO));
        PurchaseContractManagerDO entityDo = PurchaseContractManagerConvert.INSTANCE.toDo(payload);

        // TODO 根据审批流程关联单据信息
        entityDo.setContractStatus(PurchaseContractStatusEnum.CREATE.getCode());
        // TODO 根据审批时间关联
//        entityDo.setActivateDate(DateUtil.toLocalDateTime(new Date()));
        // TODO 如果是保存按钮 则是未提交状态,否则是提交状态
        entityDo.setApprStatus(WorkFlowStatusEnum.NOTSUBMIT.getCode());

        // 计算税额/税率,金额
        countTax(payload.getPurchaseDetailViews(), entityDo);
        PurchaseContractManagerDO purchaseContractManagerDO = transactionUtilService.executeWithCallable(() -> {
            // 合同明细表数据更新
            PurchaseContractManagerDO save = purchaseContractManagerRepo.save(entityDo);
            // 更新合同明细
            if (!CollectionUtils.isEmpty(payload.getPurchaseDetailViews())) {
                payload.getPurchaseDetailViews().stream().forEach(item -> {
                    item.setPurchaseContractId(save.getId());
                    item.setPurchaseContractNo(save.getPurchaseContractNo());
                    PurchaseContractDetailsPayload detailsPayload = PurchaseContractDetailsConvert.INSTANCE.toPayload(item);
                    purchaseContractDetailsService.insert(detailsPayload);
                    if (item.getConEpibolyCostConDId() != null) {
                        conEpibolyCostConDDAO.updateChannelCostConIdNumber(item.getConEpibolyCostConDId(), save.getPurchaseContractNo());
                    }
                    if (item.getPurchaseDemandId() != null) {
                        conPurchaseDemandDDAO.updatePurContractId(item.getPurchaseDemandId(), save.getId());
                    }
                });
            }

            // 更新付款计划
            if (!CollectionUtils.isEmpty(payload.getPaymentPlanViews())) {
                payload.getPaymentPlanViews().stream().forEach(item -> {
                    item.setContractId(save.getId());
                    item.setContractNo(save.getPurchaseContractNo());
                    PurchasePaymentPlanPayload detailsPayload = PurchasePaymentPlanConvert.INSTANCE.toPayload(item);
                    purchasePaymentPlanService.insert(detailsPayload);
                });
            }
            return save;
        });

        // 流程
        if (payload.getSubmit()) {
            startProcInst(purchaseContractManagerDO);
        }
        // 获取变更日志
        logService.saveNewLog(purchaseContractManagerDO.getId(), PrdSystemObjectEnum.PROCUREMENT_CONTRACT.getCode(), PrdSystemLogEnum.CREATE.getDesc() + PrdSystemObjectEnum.PROCUREMENT_CONTRACT.getDesc());
        return PurchaseContractManagerConvert.INSTANCE.toVo(purchaseContractManagerDO);
    }

    void countTax(List<PurchaseContractDetailsVO> views, PurchaseContractManagerDO entityDo) {
        if (CollectionUtils.isEmpty(views)) {
            return;
        }
        // 计金额
        BigDecimal total = BigDecimal.ZERO;
        BigDecimal taxTotal = BigDecimal.ZERO;
        for (PurchaseContractDetailsVO temp : views) {
            BigDecimal taxAmt = temp.getTaxAmt() == null ? BigDecimal.ZERO : temp.getTaxAmt();
            BigDecimal taxNotAmt = temp.getTaxNotAmt() == null ? BigDecimal.ZERO : temp.getTaxNotAmt();
            //含税总额
            total = total.add(taxAmt);
            //不含税总额
            taxTotal = taxTotal.add(taxNotAmt);
        }
        //设置信息表中金额(含税总额)和税额(含税总额-不含税总额)
        entityDo.setAmt(total);
        entityDo.setTaxAmt(total.subtract(taxTotal));
        //如果含税总额为0，设置税率为0
        if (total.equals(BigDecimal.ZERO)) {
            entityDo.setTaxRate("0%");
            return;
        }
        //取税率的最大值和最小值
        String max = views.stream()
                .map(PurchaseContractDetailsVO::getTaxRate)
                .max(Comparator.comparingDouble(Double::parseDouble))
                .orElse("0");
        String min = views.stream()
                .map(PurchaseContractDetailsVO::getTaxRate)
                .min(Comparator.comparingDouble(Double::parseDouble))
                .orElse("0");
        entityDo.setTaxRate(min + "%" + "~" + max + "%");
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PurchaseContractManagerVO update(PurchaseContractManagerPayload payload) {
        // 采购合同名称唯一校验
        String name = payload.getPurchaseContractName();
        if (StringUtils.hasText(name)) {
            PurchaseContractManagerQuery query = new PurchaseContractManagerQuery();
            query.setPurchaseContractNameEq(name);
            PagingVO<PurchaseContractManagerVO> queryPaging = purchaseContractManagerDAO.queryPaging(query);
            List<PurchaseContractManagerVO> records = queryPaging.getRecords();
            if (!org.springframework.util.CollectionUtils.isEmpty(records)) {
                List<PurchaseContractManagerVO> collect = records.stream().filter(e -> !e.getId().equals(payload.getId())).collect(Collectors.toList());
                if (!org.springframework.util.CollectionUtils.isEmpty(collect)) {
                    throw TwException.warn("", "合同名称不可重复！");
                }
            }
        }
        PurchaseContractManagerDO entity = purchaseContractManagerRepo.findById(payload.getId()).orElseGet(PurchaseContractManagerDO::new);
        Assert.notNull(entity.getId(), "不存在");
        //通过反射来获取 BigDecimal 类型的所有字段(用来把前端传过来的BigDecimal整数保留两位小数)
        Class<?> clazz = payload.getClass();
        Field[] fields = clazz.getDeclaredFields();
        for (Field field : fields) {
            if ("java.math.BigDecimal".equals(field.getType().getName())) {
                //属性名
                String fieldName = field.getName();
                //获取属性值的方法名
                String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                //属性值
                try {
                    Method getMethod = clazz.getMethod(getMethodName);
                    //获取属性值
                    BigDecimal value = (BigDecimal) getMethod.invoke(payload);
                    if (value != null) {
                        String setMethodName = "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                        Method setMethod = clazz.getDeclaredMethod(setMethodName, field.getType());
                        //判断是否为整数，为整数则保留两位小数
//                        if (new BigDecimal(value.intValue()).compareTo(value) == 0){
//                            setMethod.invoke(payload,value.setScale(2));
//                        }
                        setMethod.invoke(payload, value.setScale(2));
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        // 变更日志用
        PurchaseContractManagerDO entityLog = new PurchaseContractManagerDO();
        BeanUtils.copyProperties(entity, entityLog);

        PurchaseContractManagerDO entityDo = PurchaseContractManagerConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);

        // 计算税额/税率,金额
        countTax(payload.getPurchaseDetailViews(), entity);

        // 修改NULL值特殊处理
        final StringBuilder fieldsUpdateLog = changeFieldLogUtil.nullFieldsProcess(payload, entityLog, entity);
        PurchaseContractManagerDO save = purchaseContractManagerRepo.save(entity);

        //获取变更日志
        fieldsUpdateLog.append(changeFieldLogUtil.getFieldsUpdateLog(entityDo, entityLog));
        if (StringUtils.hasText(fieldsUpdateLog)) {
            logService.saveNewLog(entityDo.getId(), PrdSystemObjectEnum.PROCUREMENT_CONTRACT.getCode(), fieldsUpdateLog.toString());
        }
        if (payload.getSubmit()) {
            if (StringUtils.hasText(payload.getProcInstId())) {
                dealVariablesByUpdate(save);
            } else {
                startProcInst(save);
            }
        }
        return PurchaseContractManagerConvert.INSTANCE.toVo(save);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(PurchaseContractManagerPayload payload) {
        PurchaseContractManagerDO entity = purchaseContractManagerRepo.findById(payload.getId()).orElseGet(PurchaseContractManagerDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = purchaseContractManagerDAO.updateByKeyDynamic(payload);
        //todo 驳回的时候需要重新设置工作流的参数
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        List<PurchaseContractManagerVO> purchaseContractViewList = purchaseContractManagerDAO.queryByKeys(keys);
        String create = PurchaseContractStatusEnum.CREATE.getCode();

        boolean allCreate = purchaseContractViewList.stream().allMatch(view -> create.equals(view.getContractStatus()));

        if (!allCreate) {
            throw TwException.error("", "采购合同状态等于新建状态才允许删除");
        }
        List<String> purContractNoList = purchaseContractViewList.stream().map(PurchaseContractManagerVO::getPurchaseContractNo).collect(Collectors.toList());
        List<Long> purContractIdList = purchaseContractViewList.stream().map(PurchaseContractManagerVO::getId).collect(Collectors.toList());
        long delTotal = purchaseContractManagerDAO.deleteSoft(keys);
        purchaseContractDetailsDAO.logicalDeleteByContractIds(keys);
        purchasePaymentPlanDAO.logicalDeleteByContractIds(keys);
        costConDDAO.cancelPurContract(purContractNoList);
        // 采购需求取消关联
        conPurchaseDemandDDAO.cancelPurContract(purContractIdList);

        //删流程
        /*List<Long> ids = keys;
        ids.stream().forEach(id -> {
            //根据流程id查找流程类型
            TwBpmProcDef procDef = twReimService.getReimProcType(id);
            String procKey = procDef.getKey();
            //根据流程id 流程类型 查找流程实例id
            String procId = twReimService.getProcInstId(procKey, id);//流程实例id
            if (StringUtils.hasText(procId)) {
                bpmProcService.cancelProcess(procId);
            }
        });*/
    }

//    @Override
//    public List<PrdAbVO> abQueryList(String relateType) {
//        return prdAbDAO.queryBookInfoByRelat(relateType);
//    }

    @Override
    public List<PrdSystemLogVO> queryLogList(Long key) {
        return logService.queryLogList(key, PrdSystemObjectEnum.PROCUREMENT_CONTRACT.getCode());
    }

    @Override
    @Transactional
    public Long active(List<Long> keys) {
        List<PurchaseContractManagerDO> repoAllById = purchaseContractManagerRepo.findAllById(keys);
        if (CollectionUtils.isEmpty(repoAllById)) {
            return 0L;
        }
        List<PurchaseContractManagerDO> filterList = repoAllById.stream().filter(e -> (!PurchaseContractStatusEnum.NOT_ACTIVE.getCode().equals(e.getContractStatus())) && (!PurchaseContractStatusEnum.PENDING.getCode().equals(e.getContractStatus()))).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(filterList)) {
            throw TwException.error("", "采购合同状态为未激活或暂挂时才允许激活");
        }
        // 修改状态为激活
        purchaseContractManagerDAO.active(keys, PurchaseContractStatusEnum.ACTIVE.getCode(), LocalDateTime.now());

//        for(PurchaseContractManagerDO temp:repoAllById){
//            //发起流程审批
//            ProcessInfo processInfo = new ProcessInfo();
//            String status = WorkFlowStatusEnum.APPROVED_WORK.getCode();
//            if(workflow_enabled){
//                status = WorkFlowStatusEnum.APPROVING_WORK.getCode();
//                /** 开启流程 */
//                processInfo = this.startProcInst(processInfo, temp);
//            }
//            //流程启动成功后，回写业务表数据
//            PurchaseContractManagerPayload payload = new PurchaseContractManagerPayload();
//            payload.setProcInstId(processInfo.getProcInstId());
//            payload.setId(temp.getId());
//            payload.setProcInstStatus(processInfo.getProcInstStatus());
//            payload.setSubmitTime(LocalDateTime.now());
//            payload.setApprStatus(status);
//            //开启事务执行修改，主要是修改审批状态
//            transactionUtilService.executeWithRunnable(() -> {
//                purchaseContractManagerDAO.updateByKeyDynamic(payload);
//            });
//        }
        return 1L;
    }

    @Override
    @Transactional
    public void contractFilingByIds(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        purchaseContractManagerDAO.updateFilingFlag(ids, 1);
    }

    @Override
    @Transactional
    public void closeContract(List<Long> ids, String closeReason) {
        purchaseContractManagerDAO.closeContract(ids, closeReason);
    }

    @Override
    @Transactional
    public Integer purchaseContractCloseBatch() {
        return purchaseContractManagerRepo.purchaseContractCloseBatch();
    }

    @Override
    public void downloadPurCon(HttpServletResponse response, PurchaseContractManagerQuery query) {
        try {
            log.info("=============================开始查询=======================================");
            PagingVO<PurchaseContractManagerVO> paging = queryPaging(query);
            log.info("=============================结束查询=======================================");
            List<PurchaseContractManagerVO> records = paging.getRecords();
            download(udcUtil.translateList(records), response);
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    @Override
    public void permissionDownloadPurCon(HttpServletResponse response, PurchaseContractManagerQuery query) {
        try {
            log.info("=============================开始查询=======================================");
            PagingVO<PurchaseContractManagerVO> paging = queryPermissionPaging(query);
            log.info("=============================结束查询=======================================");
            List<PurchaseContractManagerVO> records = paging.getRecords();
            download(udcUtil.translateList(records), response);
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void download(List<PurchaseContractManagerVO> records, HttpServletResponse response) throws IOException {
//        int order = 1;
        //定义文件名称
        String sheetName = "采购合同数据";
//        List<CrmPotentialCustomerListExcelExport> resultList = CrmPotentialCustomerConvert.INSTANCE.voListVoExcelExport(records);
//        resultList = udcUtil.translateList(resultList);
        //对文件名进行固定格式编码
        String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
        //设置请求响应内容类型
        //作用:使客户端浏览器，区分不同种类的数据，并根据不同的MIME调用浏览器内不同的程序嵌入模块来处理相应的数据。
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        //设置请求响应内容编码方式
        response.setCharacterEncoding("utf-8");
        //文件下载，指定默认名
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);

        final ExcelWriterSheetBuilder sheet = EasyExcel.write(response.getOutputStream(), PurchaseContractManagerVO.class)
                .registerWriteHandler(new LongestMatchColumnWidthStyleStrategy())
                .sheet(sheetName);
        // 列
        com.elitesland.tw.tw5.server.common.excel.ExcelUtil.excelHelper(sheet, PurchaseContractManagerVO.class, null);
        //写入
        sheet.doWrite(records);
    }


    /**
     * 发起采购合同激活审批流程
     *
     * @param conContract
     */
    private void startProcInst(PurchaseContractManagerDO conContract) {
        // 发起流程审批
        ProcessInfo processInfo = new ProcessInfo();
        String status = WorkFlowStatusEnum.APPROVED_WORK.getCode();
        if (workflow_enabled) {
            status = WorkFlowStatusEnum.APPROVING_WORK.getCode();
            processInfo = this.getProcInst(processInfo, conContract);
        }
        //流程启动成功后，回写业务表数据
        PurchaseContractManagerPayload payload = new PurchaseContractManagerPayload();
        payload.setProcInstId(processInfo.getProcInstId());
        payload.setId(conContract.getId());
        payload.setProcInstStatus(processInfo.getProcInstStatus());
        payload.setSubmitTime(LocalDateTime.now());
        payload.setApprStatus(status);
        if (ProcInstStatus.APPROVING.getDesc().equals(processInfo.getProcInstStatus().getDesc())) {
            payload.setContractStatus(PurchaseContractStatusEnum.APPROVING.getCode());
        } else if (ProcInstStatus.APPROVED.getDesc().equals(processInfo.getProcInstStatus().getDesc())) {
            payload.setProcInstStatus(ProcInstStatus.APPROVED);
            payload.setApprovedTime(LocalDateTime.now());
            payload.setContractStatus(PurchaseContractStatusEnum.NOT_ACTIVE.getCode());
        }
        //开启事务执行修改，主要是修改审批状态
        transactionUtilService.executeWithRunnable(() -> {
            purchaseContractManagerDAO.updateByKeyDynamic(payload);
        });
    }

    /**
     * 获取角色Code
     */
    private Map<String, List<Long>> getRoleCodeMap() {
        // 查询系统角色
        List<String> roleCodes = new ArrayList<>();
        // 平台业务总负责人（平台采购主管）
        roleCodes.add(RoleEnum.PLAT_BUSINESS_PIC.getCode());
        // 运营总裁
        roleCodes.add(RoleEnum.OPERATION_PRESIDENT.getCode());
        // 平台首席财务官（CFO）
        roleCodes.add(RoleEnum.PLAT_CFO.getCode());
        // 行政负责人
        roleCodes.add(RoleEnum.PLAT_OFFI_AM.getCode());
        return systemRoleService.queryUserIdMapByRoleCodes(roleCodes);
    }

    /**
     * 流程
     */
    private ProcessInfo getProcInst(ProcessInfo processInfo, PurchaseContractManagerDO temp) {
        HashMap<String, Object> variables = new HashMap<>();
        // 获取角色CodeMap
        Map<String, List<Long>> roleCodeMap = this.getRoleCodeMap();
        dealVariables(temp, variables, roleCodeMap);
        String desc = PurchaseContractEnum.PurchaseConType.valueOf(temp.getPurchaseContractType()).getDesc();
        String name = temp.getPurchaseContractName() + temp.getAmt() + "-" + desc;
        PurchaseContractManagerVO purchaseContractManagerVO = PurchaseContractManagerConvert.INSTANCE.toVo(temp);
        // 1.销售BU负责人（关联子合同销售BU负责人）
        Long relatedSalesContract = purchaseContractManagerVO.getRelatedSalesContract();
        if (relatedSalesContract != null) {
            SaleConContractVO saleConContractVO = saleConContractService.queryByKey(relatedSalesContract);
            purchaseContractManagerVO.setSaleSignBuId(saleConContractVO.getSignBuId());
        }
        // 2.项目BU负责人
        Long relatedProjectId = purchaseContractManagerVO.getRelatedProjectId();
        if (relatedProjectId != null) {
            PmsProjectVO pmsProjectVO = pmsProjectService.queryByKey(relatedProjectId);
            purchaseContractManagerVO.setPrjDeliBuId(pmsProjectVO.getDeliBuId());
        }

        processInfo = this.runProcessInfo(purchaseContractManagerVO, ProcDefKey.DIB_PURCAHSE_CONTRACT.getName(), name, variables);

//        // 根据合同类型,业务类型确定流程
//        switch (PurchaseContractEnum.PurchaseConType.match(temp.getPurchaseContractType())) {
//            // 合同采购
//            case CON_PURCHASE -> {
//                switch (PurchaseContractEnum.PurchaseBusinessType.match(temp.getBusinessType())) {
//                    // 服务贸易
//                    case TRADE_SERVICES -> {
//                        dealTradeServicesVariables(temp, variables, roleCodeMap);
//                        name = temp.getPurchaseContractName() + temp.getAmt() + "-" + ProcDefKey.PC_SERVICE_TRADE.getDesc();
//                        processInfo = this.runProcessInfo(temp, ProcDefKey.PC_SERVICE_TRADE.getName(), name, variables);
//                    }
//                    // 产品贸易
//                    case TRADE_PRODUCT -> {
//                        dealTradeProductVariables(temp, variables, roleCodeMap);
//                        name = temp.getPurchaseContractName() + temp.getAmt() + "-" + ProcDefKey.PC_PRODUCT_TRADE.getDesc();
//                        processInfo = this.runProcessInfo(temp, ProcDefKey.PC_PRODUCT_TRADE.getName(), name, variables);
//                    }
//                    // 外包
//                    case OUTSOURCING -> {
//                        dealOutSourcingVariables(variables, roleCodeMap);
//                        name = temp.getPurchaseContractName() + temp.getAmt() + "-" + ProcDefKey.PC_CHANNEL_COST.getDesc();
//                        processInfo = this.runProcessInfo(temp, ProcDefKey.PC_CHANNEL_COST.getName(), name, variables);
//                    }
//                }
//            }
//            // 项目采购
//            case PROJECT_PURCHASE -> {
//                switch (PurchaseContractEnum.PurchaseBusinessType.match(temp.getBusinessType())) {
//                    // 杂项采购
//                    case MIS_PURCHASE -> {
//                        dealMisPurchaseVariables(temp, variables, roleCodeMap);
//                        name = temp.getPurchaseContractName() + temp.getAmt() + "-" + ProcDefKey.PC_SUNDRY_PURCHASE.getDesc();
//                        processInfo = this.runProcessInfo(temp, ProcDefKey.PC_SUNDRY_PURCHASE.getName(), name, variables);
//                    }
//                    // 房屋租赁
//                    case HOUSE_RENTAL -> {
//                        dealHouseRentalVariables(temp, variables, roleCodeMap);
//                        name = temp.getPurchaseContractName() + temp.getAmt() + "-" + ProcDefKey.PC_HOUSE_RENTAL.getDesc();
//                        processInfo = this.runProcessInfo(temp, ProcDefKey.PC_HOUSE_RENTAL.getName(), name, variables);
//                    }
//                }
//            }
//            // 市场渠道
//            case MARKET -> {
//                if (PurchaseContractEnum.PurchaseBusinessType.EMPTY.getCode().equals(temp.getBusinessType())) {
//                    dealMarketChannelVariables(temp, variables, roleCodeMap);
//                    name = temp.getPurchaseContractName() + temp.getAmt() + "-" + ProcDefKey.PC_MARKET_CHANNEL.getDesc();
//                    processInfo = this.runProcessInfo(temp, ProcDefKey.PC_MARKET_CHANNEL.getName(), name, variables);
//                }
//            }
//            // 研发类采购
//            case RESEARCH -> {
//                if (PurchaseContractEnum.PurchaseBusinessType.EMPTY.getCode().equals(temp.getBusinessType())) {
//                    dealResearchVariables(temp, variables, roleCodeMap);
//                    name = temp.getPurchaseContractName() + temp.getAmt() + "-" + ProcDefKey.PC_RESEARCH_PURCHASE.getDesc();
//                    processInfo = this.runProcessInfo(temp, ProcDefKey.PC_RESEARCH_PURCHASE.getName(), name, variables);
//                }
//            }
//            // 公司管理类采购
//            case COMPANY -> {
//                if (PurchaseContractEnum.PurchaseBusinessType.EMPTY.getCode().equals(temp.getBusinessType())) {
//                    dealCompanyVariables(temp, variables, roleCodeMap);
//                    name = temp.getPurchaseContractName() + temp.getAmt() + "-" + ProcDefKey.PC_COMPANY_MANAGE.getDesc();
//                    processInfo = this.runProcessInfo(temp, ProcDefKey.PC_COMPANY_MANAGE.getName(), name, variables);
//                }
//            }
//            // 行政运营类采购
//            case OPERATE -> {
//                if (PurchaseContractEnum.PurchaseBusinessType.EMPTY.getCode().equals(temp.getBusinessType())) {
//                    dealOperateVariables(temp, variables, roleCodeMap);
//                    name = temp.getPurchaseContractName() + temp.getAmt() + "-" + ProcDefKey.PC_ADM_OPERATE_PUR.getDesc();
//                    processInfo = this.runProcessInfo(temp, ProcDefKey.PC_ADM_OPERATE_PUR.getName(), name, variables);
//                }
//            }
//            // 资源赋能类采购
//            case RESOURCE -> {
//                if (PurchaseContractEnum.PurchaseBusinessType.EMPTY.getCode().equals(temp.getBusinessType())) {
//                    dealResourcesVariables(temp, variables, roleCodeMap);
//                    name = temp.getPurchaseContractName() + temp.getAmt() + "-" + ProcDefKey.PC_ASS_EMPOWER.getDesc();
//                    processInfo = this.runProcessInfo(temp, ProcDefKey.PC_ASS_EMPOWER.getName(), name, variables);
//                }
//            }
//        }
        return processInfo;
    }

    private ProcessInfo runProcessInfo(PurchaseContractManagerVO purchaseContractManagerVO, String code, String name, HashMap<String, Object> variables) {
        return workflowUtil.simpleStartProcess(StartProcessPayload.of(code, name, purchaseContractManagerVO.getId() + "", variables), purchaseContractManagerVO);
    }

    private void transSysSelectionAndName(PurchaseContractManagerVO purchaseContractManagerVO) {
        // 地址簿列表
        List<Long> bookIdList = new ArrayList<>(3);
        bookIdList.add(purchaseContractManagerVO.getSupplierBookId());
        bookIdList.add(purchaseContractManagerVO.getPurchaseCompanyBookId());
        bookIdList.add(purchaseContractManagerVO.getInvoice());
        Map<Long, String> nameByBookIds = businessPartnerService.findNameByBookIds(bookIdList);
        // 名称翻译
        if (purchaseContractManagerVO.getPurchaseInchargeResId() != null) {
            purchaseContractManagerVO.setPurchaseInchargeResName(cacheUtil.getUserName(purchaseContractManagerVO.getPurchaseInchargeResId()));
        }
        if (purchaseContractManagerVO.getPurchaseBuId() != null) {
            purchaseContractManagerVO.setPurchaseBuName(cacheUtil.getOrgName(purchaseContractManagerVO.getPurchaseBuId()));
        }
        // 翻译税率
        if (!CollectionUtils.isEmpty(purchaseContractManagerVO.getPurchaseDetailViews())) {
            purchaseContractManagerVO.getPurchaseDetailViews().forEach(purchaseContractDetailsVO -> {
                if (purchaseContractDetailsVO.getTaxRate() != null) {
                    purchaseContractDetailsVO.setTaxRateDesc(purchaseContractDetailsVO.getTaxRate() + "%");
                }
            });
        }
        // 翻译地址簿
        purchaseContractManagerVO.setInvoiceName(nameByBookIds.get((purchaseContractManagerVO.getInvoice())));
        purchaseContractManagerVO.setSupplierName(nameByBookIds.get(purchaseContractManagerVO.getSupplierBookId()));
        purchaseContractManagerVO.setPurchaseCompanyName(nameByBookIds.get(purchaseContractManagerVO.getPurchaseCompanyBookId()));

    }

    private void transSysSelectionAndName(List<PurchaseContractManagerVO> result) {
        // 地址簿列表
        List<Long> bookIdList = new ArrayList<>();
        result.forEach(purchaseContractManagerVO -> {
            bookIdList.add(purchaseContractManagerVO.getSupplierBookId());
            bookIdList.add(purchaseContractManagerVO.getPurchaseCompanyBookId());
            bookIdList.add(purchaseContractManagerVO.getInvoice());
        });
        Map<Long, String> nameByBookIds = businessPartnerService.findNameByBookIds(bookIdList);
        // 翻译
        result.forEach(purchaseContractManagerVO -> {
            // 翻译地址簿
            purchaseContractManagerVO.setInvoiceName(nameByBookIds.get((purchaseContractManagerVO.getInvoice())));
            purchaseContractManagerVO.setSupplierName(nameByBookIds.get(purchaseContractManagerVO.getSupplierBookId()));
            purchaseContractManagerVO.setPurchaseCompanyName(nameByBookIds.get(purchaseContractManagerVO.getPurchaseCompanyBookId()));
            // 翻译名称
            if (purchaseContractManagerVO.getPurchaseInchargeResId() != null) {
                purchaseContractManagerVO.setPurchaseInchargeResName(cacheUtil.getUserName(purchaseContractManagerVO.getPurchaseInchargeResId()));
            }
            if (purchaseContractManagerVO.getPurchaseBuId() != null) {
                purchaseContractManagerVO.setPurchaseBuName(cacheUtil.getOrgName(purchaseContractManagerVO.getPurchaseBuId()));
            }
        });
    }

    private void dealVariables(PurchaseContractManagerDO purchaseContractManagerDO, HashMap<String, Object> variables, Map<String, List<Long>> roleCodeMap) {
        // 代理采购/外包
        Boolean agentAndOutFlag = false;
        // 项目房租/成本
        Boolean projectFlag = false;
        //运营支撑类
        Boolean operationFlag = false;
        // 金额是否大于5000
        Boolean amtFlag = false;
        if (PurchaseContractEnum.PurchaseConType.PURCHASING_AGENT.getCode().equals(purchaseContractManagerDO.getPurchaseContractType()) || PurchaseContractEnum.PurchaseConType.OUTSOURCING.getCode().equals(purchaseContractManagerDO.getPurchaseContractType())) {
            agentAndOutFlag = true;
        }

        if (PurchaseContractEnum.PurchaseConType.PROJECT_COST.getCode().equals(purchaseContractManagerDO.getPurchaseContractType()) || PurchaseContractEnum.PurchaseConType.PROJECT_RENT.getCode().equals(purchaseContractManagerDO.getPurchaseContractType())) {
            projectFlag = true;
        }

        if (PurchaseContractEnum.PurchaseConType.OPERATION_SUPPORT.getCode().equals(purchaseContractManagerDO.getPurchaseContractType())) {
            operationFlag = true;
        }

        if (purchaseContractManagerDO.getAmt() != null && purchaseContractManagerDO.getAmt().compareTo(new BigDecimal(5000)) >= 0) {
            amtFlag = true;
        }
        variables.put("agentAndOutFlag", agentAndOutFlag);
        variables.put("projectFlag", projectFlag);
        variables.put("operationFlag", operationFlag);
        variables.put("amtFlag", amtFlag);
    }


    // 处理服务贸易参数
    public void dealTradeServicesVariables(PurchaseContractManagerDO purchaseContractManagerDO, HashMap<String, Object> variables, Map<String, List<Long>> roleCodeMap) {
        Long relatedSalesContract = purchaseContractManagerDO.getRelatedSalesContract();
        SaleConContractVO saleConContractVO = saleConContractService.queryByKey(relatedSalesContract);
        // 交付负责人
        variables.put("Activity_04cvqth", saleConContractVO.getDeliUserId());
        // 交付bu leader
        Long deliBuManageUserId = null;
        if (saleConContractVO.getDeliBuId() != null) {
            deliBuManageUserId = daoOrg.queryManageIdById(saleConContractVO.getDeliBuId());
        }
        variables.put("Activity_0o666fi", deliBuManageUserId);
        // 平台采购主管
        variables.put("Activity_0lfzwqu", roleCodeMap.get(RoleEnum.PLAT_BUSINESS_PIC.getCode()));
        // CFO
        variables.put("Activity_1jf9y70", roleCodeMap.get(RoleEnum.PLAT_CFO.getCode()));
        // 运营总裁
        variables.put("Activity_1g3xhid", roleCodeMap.get(RoleEnum.OPERATION_PRESIDENT.getCode()));
        // 打印合同
        PrdOrgRoleVO serviceTradePrint = daoOrg.queryRoleByOrgIdAndRoleCode(workflow_orgId, WorkFlowRoleCodeEnum.SERVICE_TRADE_PRINT.getCode());
        if (ObjectUtils.isEmpty(serviceTradePrint)) {
            throw TwException.error("", "打印合同负责人不存在");
        }
        String[] splitByServiceTradePrint = serviceTradePrint.getRoleEmployees().split(",");
        variables.put("Activity_0jba9gf", Arrays.asList(splitByServiceTradePrint));

        //合同归档
        PrdOrgRoleVO serviceTradeCollect = daoOrg.queryRoleByOrgIdAndRoleCode(workflow_orgId, WorkFlowRoleCodeEnum.PRODUCT_TRADE_COLLECT.getCode());
        if (ObjectUtils.isEmpty(serviceTradeCollect)) {
            throw TwException.error("", "合同归档负责人不存在");
        }
        String[] splitByServiceTradeCollect = serviceTradeCollect.getRoleEmployees().split(",");
        variables.put("Activity_0r7aerq", Arrays.asList(splitByServiceTradeCollect));
    }

    // 处理产品贸易参数
    public void dealTradeProductVariables(PurchaseContractManagerDO purchaseContractManagerDO, HashMap<String, Object> variables, Map<String, List<Long>> roleCodeMap) {
        Long relatedSalesContract = purchaseContractManagerDO.getRelatedSalesContract();
        SaleConContractVO saleConContractVO = saleConContractService.queryByKey(relatedSalesContract);
        boolean pdmFlag = false;
        // 产品大类是否是软件&MA 且 产品标签是否是sap
        if (PrdProductClassEnum.software_MA_core.getCode().equals(saleConContractVO.getProductClass())) {
            List<PurConOrAgreementDetailsSimpleVO> purConOrAgreementDetailsSimpleVOS = purchaseContractDetailsService.queryByPurConId(purchaseContractManagerDO.getId());
            if (!CollectionUtils.isEmpty(purConOrAgreementDetailsSimpleVOS)) {
                long count = purConOrAgreementDetailsSimpleVOS.stream().filter(p -> StringUtils.hasText(p.getTagDesc()) && "SAP".equalsIgnoreCase(p.getTagDesc().trim())).count();
                if (count > 0) {
                    pdmFlag = true;
                }
            }
        }
        // 是否要pdm审批
        variables.put("pdmFlag", pdmFlag);
        PurchaseContractDetailsQuery purchaseContractDetailsQuery = new PurchaseContractDetailsQuery();
        purchaseContractDetailsQuery.setPurchaseContractId(purchaseContractManagerDO.getId());
        List<PurchaseContractDetailsVO> purchaseContractDetailsVOS = purchaseContractDetailsService.queryListDynamic(purchaseContractDetailsQuery);
        if (CollectionUtils.isEmpty(purchaseContractDetailsVOS)) {
            throw TwException.error("", "采购合同明细不能为空");
        }
        List<Long> collect = purchaseContractDetailsVOS.stream().map(PurchaseContractDetailsVO::getRelatedProductId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            throw TwException.error("", "采购合同明细未关联产品信息");
        }
        List<PrdProductVO> prdProductVOS = productService.queryByKeys(collect);
        List<String> picResIdList = prdProductVOS.stream().map(p -> String.valueOf(p.getPicResId())).collect(Collectors.toList());
        // pdm审批
        variables.put("Activity_0n3h3dk", picResIdList);
        // 平台采购主管
        variables.put("Activity_0sleykw", roleCodeMap.get(RoleEnum.PLAT_BUSINESS_PIC.getCode()));
        // CFO
        variables.put("Activity_1xqb3nv", roleCodeMap.get(RoleEnum.PLAT_CFO.getCode()));
        // 运营总裁
        variables.put("Activity_0u5edwt", roleCodeMap.get(RoleEnum.OPERATION_PRESIDENT.getCode()));
        // 打印合同
        PrdOrgRoleVO serviceTradePrint = daoOrg.queryRoleByOrgIdAndRoleCode(workflow_orgId, WorkFlowRoleCodeEnum.PRODUCT_TRADE_PRINT.getCode());
        if (ObjectUtils.isEmpty(serviceTradePrint)) {
            throw TwException.error("", "打印合同负责人不存在");
        }
        String[] splitByServiceTradePrint = serviceTradePrint.getRoleEmployees().split(",");
        variables.put("Activity_0ttqjm3", Arrays.asList(splitByServiceTradePrint));

        // 合同归档
        PrdOrgRoleVO serviceTradeCollect = daoOrg.queryRoleByOrgIdAndRoleCode(workflow_orgId, WorkFlowRoleCodeEnum.PRODUCT_TRADE_COLLECT.getCode());
        if (ObjectUtils.isEmpty(serviceTradeCollect)) {
            throw TwException.error("", "合同归档负责人不存在");
        }
        String[] splitByServiceTradeCollect = serviceTradeCollect.getRoleEmployees().split(",");
        variables.put("Activity_1snhapc", Arrays.asList(splitByServiceTradeCollect));
    }

    // 外包费用
    public void dealOutSourcingVariables(HashMap<String, Object> variables, Map<String, List<Long>> roleCodeMap) {
        // 运营总裁
        variables.put("Activity_0hpznx2", roleCodeMap.get(RoleEnum.OPERATION_PRESIDENT.getCode()));
        // 平台采购主管
        variables.put("Activity_15bff5q", roleCodeMap.get(RoleEnum.PLAT_BUSINESS_PIC.getCode()));

        //合同归档
        PrdOrgRoleVO serviceTradeCollect = daoOrg.queryRoleByOrgIdAndRoleCode(workflow_orgId, WorkFlowRoleCodeEnum.PRODUCT_TRADE_COLLECT.getCode());
        if (ObjectUtils.isEmpty(serviceTradeCollect)) {
            throw TwException.error("", "合同归档负责人不存在");
        }
        String[] splitByServiceTradeCollect = serviceTradeCollect.getRoleEmployees().split(",");
        variables.put("Activity_1evabwk", Arrays.asList(splitByServiceTradeCollect));
    }


    // 杂项采购
    public void dealMisPurchaseVariables(PurchaseContractManagerDO purchaseContractManagerDO, HashMap<String, Object> variables, Map<String, List<Long>> roleCodeMap) {
        // 行政负责人
        variables.put("Activity_1iz3khk", roleCodeMap.get(RoleEnum.PLAT_OFFI_AM.getCode()));

        // 交付负责人
        Long relatedSalesContract = purchaseContractManagerDO.getRelatedSalesContract();
        if (relatedSalesContract == null) {
            throw TwException.error("", "关联销售合同不存在");
        }
        SaleConContractVO saleConContractVO = saleConContractService.queryByKey(relatedSalesContract);
        variables.put("Activity_0f7mny5", saleConContractVO.getDeliUserId());

        // 交付bU leader
        Long deliBuId = saleConContractVO.getDeliBuId();
        Long deliBuManageUserId = daoOrg.queryManageIdById(deliBuId);
        variables.put("Activity_012gygz", CollUtil.newArrayList(deliBuManageUserId));

        // 合同归档
        PrdOrgRoleVO serviceTradeCollect = daoOrg.queryRoleByOrgIdAndRoleCode(workflow_orgId, WorkFlowRoleCodeEnum.PUR_CONTRACT_FILING.getCode());
        if (ObjectUtils.isEmpty(serviceTradeCollect)) {
            throw TwException.error("", "合同归档负责人不存在");
        }
        String[] splitByServiceTradeCollect = serviceTradeCollect.getRoleEmployees().split(",");
        variables.put("Activity_0crr9zy", Arrays.asList(splitByServiceTradeCollect));
    }

    // 房屋租赁
    public void dealHouseRentalVariables(PurchaseContractManagerDO purchaseContractManagerDO, HashMap<String, Object> variables, Map<String, List<Long>> roleCodeMap) {
        // 公司行政主管
        variables.put("Activity_1un3ad2", roleCodeMap.get(RoleEnum.PLAT_OFFI_AM.getCode()));
        // 平台财务出纳
        PrdOrgRoleVO platFinCashier = daoOrg.queryRoleByOrgIdAndRoleCode(workflow_orgId, WorkFlowRoleCodeEnum.PLAT_FIN_CASHIER.getCode());
        if (ObjectUtils.isEmpty(platFinCashier)) {
            throw TwException.error("", "平台财务出纳不存在");
        }
        String[] splitByPlatFinCashier = platFinCashier.getRoleEmployees().split(",");
        variables.put("Activity_05c5yto", Arrays.asList(splitByPlatFinCashier));

        // 交付负责人
        Long relatedSalesContract = purchaseContractManagerDO.getRelatedSalesContract();
        if (relatedSalesContract == null) {
            throw TwException.error("", "关联销售合同不存在");
        }
        SaleConContractVO saleConContractVO = saleConContractService.queryByKey(relatedSalesContract);
        variables.put("Activity_1tt2hx8", saleConContractVO.getDeliUserId());

        // 交付bU leader
        Long deliBuId = saleConContractVO.getDeliBuId();
        Long deliBuManageUserId = daoOrg.queryManageIdById(deliBuId);
        variables.put("Activity_0m5gcrb", CollUtil.newArrayList(deliBuManageUserId));

        // 运营总裁
        variables.put("Activity_0mj5c37", roleCodeMap.get(RoleEnum.OPERATION_PRESIDENT.getCode()));

        // 合同归档
        PrdOrgRoleVO serviceTradeCollect = daoOrg.queryRoleByOrgIdAndRoleCode(workflow_orgId, WorkFlowRoleCodeEnum.PUR_CONTRACT_FILING.getCode());
        if (ObjectUtils.isEmpty(serviceTradeCollect)) {
            throw TwException.error("", "合同归档负责人不存在");
        }
        String[] splitByServiceTradeCollect = serviceTradeCollect.getRoleEmployees().split(",");
        variables.put("Activity_0pxm72i", Arrays.asList(splitByServiceTradeCollect));

    }


    // 采购合同市场渠道
    public void dealMarketChannelVariables(PurchaseContractManagerDO purchaseContractManagerDO, HashMap<String, Object> variables, Map<String, List<Long>> roleCodeMap) {

        // 市场bu Leader
        PrdOrgRoleVO marketResponsiblePerson = daoOrg.queryRoleByOrgIdAndRoleCode(workflow_orgId, WorkFlowRoleCodeEnum.MARKET_RESPONSIBLE_PERSON.getCode());
        if (ObjectUtils.isEmpty(marketResponsiblePerson)) {
            throw TwException.error("", "市场BU Leader不存在");
        }
        String[] splitByMarketResponsiblePerson = marketResponsiblePerson.getRoleEmployees().split(",");
        variables.put("Activity_0se2msn", Arrays.asList(splitByMarketResponsiblePerson));

        // 采购BU负责人
        Long purchaseBuId = purchaseContractManagerDO.getPurchaseBuId();
        Long purchaseBuManageUserId = daoOrg.queryManageIdById(purchaseBuId);
        variables.put("Activity_0i3qhz1", purchaseBuManageUserId);

        // 平台总体负责人
        PrdOrgRoleVO generalResponsiblePerson = daoOrg.queryRoleByOrgIdAndRoleCode(workflow_orgId, WorkFlowRoleCodeEnum.GENERAL_RESPONSIBLE_PERSON.getCode());
        if (ObjectUtils.isEmpty(generalResponsiblePerson)) {
            throw TwException.error("", "平台总体负责人不存在");
        }
        String[] splitByGeneralResponsiblePerson = generalResponsiblePerson.getRoleEmployees().split(",");
        variables.put("Activity_072zu5s", Arrays.asList(splitByGeneralResponsiblePerson));


        //打印合同
//        PrdOrgRoleVO serviceTradePrint = daoOrg.queryRoleByOrgIdAndRoleCode(workflow_orgId, WorkFlowRoleCodeEnum.PRODUCT_TRADE_PRINT.getCode());
//        if (ObjectUtils.isEmpty(serviceTradePrint)) {
//            throw TwException.error("","打印合同负责人不存在");
//        }
//        String[] splitByServiceTradePrint = serviceTradePrint.getRoleEmployees().split(",");
        variables.put("Activity_1v83wci", purchaseContractManagerDO.getCreateUserId());

        // 运营总裁
        variables.put("Activity_0865ovy", roleCodeMap.get(RoleEnum.OPERATION_PRESIDENT.getCode()));

        // 合同归档
        PrdOrgRoleVO serviceTradeCollect = daoOrg.queryRoleByOrgIdAndRoleCode(workflow_orgId, WorkFlowRoleCodeEnum.PUR_CONTRACT_FILING.getCode());
        if (ObjectUtils.isEmpty(serviceTradeCollect)) {
            throw TwException.error("", "合同归档负责人不存在");
        }
        String[] splitByServiceTradeCollect = serviceTradeCollect.getRoleEmployees().split(",");
        variables.put("Activity_1mqct2e", Arrays.asList(splitByServiceTradeCollect));


    }

    // 研发类采购
    public void dealResearchVariables(PurchaseContractManagerDO purchaseContractManagerDO, HashMap<String, Object> variables, Map<String, List<Long>> roleCodeMap) {
        // 采购BU负责人
        Long purchaseBuId = purchaseContractManagerDO.getPurchaseBuId();
        Long purchaseBuManageUserId = daoOrg.queryManageIdById(purchaseBuId);
        variables.put("Activity_0l10rlg", purchaseBuManageUserId);

        // 平台总体负责人
        PrdOrgRoleVO generalResponsiblePerson = daoOrg.queryRoleByOrgIdAndRoleCode(workflow_orgId, WorkFlowRoleCodeEnum.GENERAL_RESPONSIBLE_PERSON.getCode());
        if (ObjectUtils.isEmpty(generalResponsiblePerson)) {
            throw TwException.error("", "平台总体负责人不存在");
        }
        String[] splitByGeneralResponsiblePerson = generalResponsiblePerson.getRoleEmployees().split(",");
        variables.put("Activity_1u4v1xx", Arrays.asList(splitByGeneralResponsiblePerson));


        // 打印合同
        PrdOrgRoleVO serviceTradePrint = daoOrg.queryRoleByOrgIdAndRoleCode(workflow_orgId, WorkFlowRoleCodeEnum.PUR_CON_RESEARCH_PRINT.getCode());
        if (ObjectUtils.isEmpty(serviceTradePrint)) {
            throw TwException.error("", "打印合同负责人不存在");
        }
        String[] splitByServiceTradePrint = serviceTradePrint.getRoleEmployees().split(",");
        variables.put("Activity_0ksg8tp", Arrays.asList(splitByServiceTradePrint));

        // 运营总裁
        variables.put("Activity_1uuvgk7", roleCodeMap.get(RoleEnum.OPERATION_PRESIDENT.getCode()));

        // 合同归档
        PrdOrgRoleVO serviceTradeCollect = daoOrg.queryRoleByOrgIdAndRoleCode(workflow_orgId, WorkFlowRoleCodeEnum.PRODUCT_TRADE_COLLECT.getCode());
        if (ObjectUtils.isEmpty(serviceTradeCollect)) {
            throw TwException.error("", "合同归档负责人不存在");
        }
        String[] splitByServiceTradeCollect = serviceTradeCollect.getRoleEmployees().split(",");
        variables.put("Activity_0rcpg7b", Arrays.asList(splitByServiceTradeCollect));


    }

    // 公司管理类采购
    public void dealCompanyVariables(PurchaseContractManagerDO purchaseContractManagerDO, HashMap<String, Object> variables, Map<String, List<Long>> roleCodeMap) {
        //采购BU负责人
        Long purchaseBuId = purchaseContractManagerDO.getPurchaseBuId();
        Long purchaseBuManageUserId = daoOrg.queryManageIdById(purchaseBuId);
        variables.put("Activity_1mqqgbp", purchaseBuManageUserId);

        // 运营总裁
        variables.put("Activity_08lp7yx", roleCodeMap.get(RoleEnum.OPERATION_PRESIDENT.getCode()));

        // 打印合同
        PrdOrgRoleVO serviceTradePrint = daoOrg.queryRoleByOrgIdAndRoleCode(workflow_orgId, WorkFlowRoleCodeEnum.PUR_CON_COMPANY_MANAGE_PRINT.getCode());
        if (ObjectUtils.isEmpty(serviceTradePrint)) {
            throw TwException.error("", "打印合同负责人不存在");
        }
        String[] splitByServiceTradePrint = serviceTradePrint.getRoleEmployees().split(",");
        variables.put("Activity_1e24gkk", Arrays.asList(splitByServiceTradePrint));

        //合同归档
        PrdOrgRoleVO serviceTradeCollect = daoOrg.queryRoleByOrgIdAndRoleCode(workflow_orgId, WorkFlowRoleCodeEnum.PRODUCT_TRADE_COLLECT.getCode());
        if (ObjectUtils.isEmpty(serviceTradeCollect)) {
            throw TwException.error("", "合同归档负责人不存在");
        }
        String[] splitByServiceTradeCollect = serviceTradeCollect.getRoleEmployees().split(",");
        variables.put("Activity_1yfni0u", Arrays.asList(splitByServiceTradeCollect));


    }

    //行政运营类采购
    public void dealOperateVariables(PurchaseContractManagerDO purchaseContractManagerDO, HashMap<String, Object> variables, Map<String, List<Long>> roleCodeMap) {
        //采购BU负责人
        Long purchaseBuId = purchaseContractManagerDO.getPurchaseBuId();
        Long purchaseBuManageUserId = daoOrg.queryManageIdById(purchaseBuId);
        variables.put("Activity_1lurjn2", purchaseBuManageUserId);

        // 平台采购主管
        variables.put("Activity_0yl5ic6", roleCodeMap.get(RoleEnum.PLAT_BUSINESS_PIC.getCode()));

        // 运营总裁
        variables.put("Activity_06n22sk", roleCodeMap.get(RoleEnum.OPERATION_PRESIDENT.getCode()));

        // 打印合同
        PrdOrgRoleVO serviceTradePrint = daoOrg.queryRoleByOrgIdAndRoleCode(workflow_orgId, WorkFlowRoleCodeEnum.PUR_CONTRACT_ADM_OPERATE_PRINT.getCode());
        if (ObjectUtils.isEmpty(serviceTradePrint)) {
            throw TwException.error("", "打印合同负责人不存在");
        }
        String[] splitByServiceTradePrint = serviceTradePrint.getRoleEmployees().split(",");
        variables.put("Activity_0nfj5gw", Arrays.asList(splitByServiceTradePrint));

        // 合同归档
        PrdOrgRoleVO serviceTradeCollect = daoOrg.queryRoleByOrgIdAndRoleCode(workflow_orgId, WorkFlowRoleCodeEnum.PRODUCT_TRADE_COLLECT.getCode());
        if (ObjectUtils.isEmpty(serviceTradeCollect)) {
            throw TwException.error("", "合同归档负责人不存在");
        }
        String[] splitByServiceTradeCollect = serviceTradeCollect.getRoleEmployees().split(",");
        variables.put("Activity_1na6ej6", Arrays.asList(splitByServiceTradeCollect));

    }


    // 资源赋能类采购
    public void dealResourcesVariables(PurchaseContractManagerDO purchaseContractManagerDO, HashMap<String, Object> variables, Map<String, List<Long>> roleCodeMap) {
        // 采购BU负责人
        Long purchaseBuId = purchaseContractManagerDO.getPurchaseBuId();
        Long purchaseBuManageUserId = daoOrg.queryManageIdById(purchaseBuId);
        variables.put("Activity_041y443", purchaseBuManageUserId);

        // 平台采购主管
        variables.put("Activity_19xrtur", roleCodeMap.get(RoleEnum.PLAT_BUSINESS_PIC.getCode()));

        //运营总裁
        variables.put("Activity_056vn4r", roleCodeMap.get(RoleEnum.OPERATION_PRESIDENT.getCode()));

        // 平台总体负责人
        PrdOrgRoleVO generalResponsiblePerson = daoOrg.queryRoleByOrgIdAndRoleCode(workflow_orgId, WorkFlowRoleCodeEnum.GENERAL_RESPONSIBLE_PERSON.getCode());
        if (ObjectUtils.isEmpty(generalResponsiblePerson)) {
            throw TwException.error("", "平台总体负责人不存在");
        }
        String[] splitByGeneralResponsiblePerson = generalResponsiblePerson.getRoleEmployees().split(",");
        variables.put("Activity_0gn84qd", Arrays.asList(splitByGeneralResponsiblePerson));

        // 打印合同
        PrdOrgRoleVO serviceTradePrint = daoOrg.queryRoleByOrgIdAndRoleCode(workflow_orgId, WorkFlowRoleCodeEnum.PUR_CONTRACT_ASS_EMPOWER_PRINT.getCode());
        if (ObjectUtils.isEmpty(serviceTradePrint)) {
            throw TwException.error("", "打印合同负责人不存在");
        }
        String[] splitByServiceTradePrint = serviceTradePrint.getRoleEmployees().split(",");
        variables.put("Activity_05axqb6", Arrays.asList(splitByServiceTradePrint));

        // 合同归档
        PrdOrgRoleVO serviceTradeCollect = daoOrg.queryRoleByOrgIdAndRoleCode(workflow_orgId, WorkFlowRoleCodeEnum.PRODUCT_TRADE_COLLECT.getCode());
        if (ObjectUtils.isEmpty(serviceTradeCollect)) {
            throw TwException.error("", "合同归档负责人不存在");
        }
        String[] splitByServiceTradeCollect = serviceTradeCollect.getRoleEmployees().split(",");
        variables.put("Activity_056aj3v", Arrays.asList(splitByServiceTradeCollect));
    }

    private void dealVariablesByUpdate(PurchaseContractManagerDO temp) {
        // 获取角色CodeMap
//        Map<String, List<Long>> roleCodeMap = this.getRoleCodeMap();
        HashMap<String, Object> variables = new HashMap<>();
        // 根据合同类型,业务类型确定流程
//        switch (PurchaseContractEnum.PurchaseConType.match(temp.getPurchaseContractType())) {
//            // 合同采购
//            case CON_PURCHASE -> {
//                switch (PurchaseContractEnum.PurchaseBusinessType.match(temp.getBusinessType())) {
//                    // 服务贸易
//                    case TRADE_SERVICES -> dealTradeServicesVariables(temp, variables, roleCodeMap);
//                    // 产品贸易
//                    case TRADE_PRODUCT -> dealTradeProductVariables(temp, variables, roleCodeMap);
//                    // 外包
//                    case OUTSOURCING -> dealOutSourcingVariables(variables, roleCodeMap);
//                }
//            }
//            // 项目采购
//            case PROJECT_PURCHASE -> {
//                switch (PurchaseContractEnum.PurchaseBusinessType.match(temp.getBusinessType())) {
//                    // 杂项采购
//                    case MIS_PURCHASE -> dealMisPurchaseVariables(temp, variables, roleCodeMap);
//                    // 房屋租赁
//                    case HOUSE_RENTAL -> dealHouseRentalVariables(temp, variables, roleCodeMap);
//                }
//            }
//            // 市场渠道
//            case MARKET -> {
//                if (PurchaseContractEnum.PurchaseBusinessType.EMPTY.getCode().equals(temp.getBusinessType())) {
//                    dealMarketChannelVariables(temp, variables, roleCodeMap);
//                }
//            }
//            // 研发类采购
//            case RESEARCH -> {
//                if (PurchaseContractEnum.PurchaseBusinessType.EMPTY.getCode().equals(temp.getBusinessType())) {
//                    dealResearchVariables(temp, variables, roleCodeMap);
//                }
//            }
//            // 公司管理类采购
//            case COMPANY -> {
//                if (PurchaseContractEnum.PurchaseBusinessType.EMPTY.getCode().equals(temp.getBusinessType())) {
//                    dealCompanyVariables(temp, variables, roleCodeMap);
//                }
//            }
//            // 行政运营类采购
//            case OPERATE -> {
//                if (PurchaseContractEnum.PurchaseBusinessType.EMPTY.getCode().equals(temp.getBusinessType())) {
//                    dealOperateVariables(temp, variables, roleCodeMap);
//                }
//            }
//            // 资源赋能类采购
//            case RESOURCE -> {
//                if (PurchaseContractEnum.PurchaseBusinessType.EMPTY.getCode().equals(temp.getBusinessType())) {
//                    dealResourcesVariables(temp, variables, roleCodeMap);
//                }
//            }
//        }
        SetVariablesPayload payload = new SetVariablesPayload();
        payload.setProcInstId(temp.getProcInstId());
        payload.setVariables(variables);
        workflowUtil.setVaribales(payload);
    }

    @Override
    public PurchaseContractManagerVO selectPurchaseContractByOverId(Long overId) {
        TPurchaseContractOverVO overView = purchaseContractOverDAO.queryByKey(overId);
        PurchaseContractManagerVO purchaseContractDetailsVO = null;
        if (!Objects.isNull(overView) && !StringUtils.isEmpty(overView.getContractId())) {
            Long key = overView.getContractId();
            purchaseContractDetailsVO = queryByKey(key);
            purchaseContractDetailsVO.setOverVO(overView);
        }
        return purchaseContractDetailsVO;
    }

    @Override
    public PurchasePaymentDefaultVO findPaymentDefaultByDocNo(String docNo) {
        PurchasePaymentDefaultVO purchasePaymentDefaultVO = new PurchasePaymentDefaultVO();
        PurchaseContractDocumentView purchaseView = purchaseContractManagerDAO.findByPurchaseContractNo(docNo);
        if (purchaseView != null) {
            if (purchaseView.getReceivingUnitBookId() != null) {
                // 查询供应商的收款银行、收款账号
                BookAccountVO bookAccountVO = bookAccountService.queryDefaultByBookId(purchaseView.getReceivingUnitBookId());
                if (bookAccountVO != null && AccountUsageEnum.RECEIVE.getCode().equals(bookAccountVO.getAccountUsage())) {
                    // 收款账号
                    purchasePaymentDefaultVO.setReceivingId(String.valueOf(bookAccountVO.getId()));
                    // 收款银行
                    purchasePaymentDefaultVO.setReceivingBank(bookAccountVO.getDepositBank());
                }
            }
            // 应付金额
            BigDecimal totalPlanAmt = purchaseContractManagerRepo.findPayableAmtNew(purchaseView.getId());
            purchasePaymentDefaultVO.setPaymentAmt(totalPlanAmt);
            // 验收方式
            purchasePaymentDefaultVO.setAcceptanceType(purchaseView.getAcceptanceType());
            // 币种
            purchasePaymentDefaultVO.setCurrCode(purchaseView.getCurrCode());
            // 关联单据号
            purchasePaymentDefaultVO.setDocNo(purchaseView.getPurchaseContractNo());
            // 关联单据名称
            purchasePaymentDefaultVO.setDocName(purchaseView.getPurchaseContractName());
            // 关联项目号
            purchasePaymentDefaultVO.setRelatedProjectNo(purchaseView.getProjNo());
            // 关联销售合同号
            purchasePaymentDefaultVO.setRelatedSalesContract(purchaseView.getSaleConNo());
            // 供应商BookId
            purchasePaymentDefaultVO.setSupplierBookId(purchaseView.getSupplierBookId());
            // 任务包
            purchasePaymentDefaultVO.setRelatedTask(purchaseView.getRelatedTask());
            // 收款人/单位编码
            purchasePaymentDefaultVO.setReceivingUnitBookId(purchaseView.getReceivingUnitBookId());
            // 付款方式
            purchasePaymentDefaultVO.setPayMethod(purchaseView.getPayMethod());
            // 需求编号
            purchasePaymentDefaultVO.setDemandNo(purchaseView.getDemandNo());
            // 付款公司BookId
            purchasePaymentDefaultVO.setPaymentCompanyBooKId(purchaseView.getPurchaseCompanyBookId());
            // 采购合同类型
            purchasePaymentDefaultVO.setPurchaseContractType(purchaseView.getPurchaseContractType());
        }
        return purchasePaymentDefaultVO;
    }

    @Override
    public Long findIdByNo(String docNo) {
        return purchaseContractManagerDAO.findIdByNo(docNo);
    }

    @Override
    public PurchaseContractManagerVO queryByNo(String docNo) {
        return purchaseContractManagerDAO.queryByNo(docNo);
    }

    @Override
    @Transactional
    public void purContractArchiving(Long purConId, String stampFileCodes) {
        purchaseContractManagerDAO.purContractArchiving(purConId, stampFileCodes);
    }

    @Override
    public List<PurchaseContractManagerVO> queryBySaleConId(Long saleConId) {
        return purchaseContractManagerDAO.queryBySaleConId(saleConId);
    }


    @Override
    public List<PurchaseContractManagerVO> queryPurContractInfo(PurchaseContractManagerQuery query) {
        return purchaseContractManagerDAO.queryPurContractInfo(query);
    }
}
