package com.elitesland.tw.tw5.server.prd.purchase.service;

import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseAgreementResVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.purchase.purenum.SettleApplyCoopWayEnum;
import com.elitesland.tw.tw5.server.prd.purchase.repo.SettleApplyDetailsRepo;
import com.elitesland.tw.tw5.server.prd.purchase.dao.SettleApplyDetailsDAO;
import com.elitesland.tw.tw5.server.prd.purchase.convert.SettleApplyDetailsConvert;
import com.elitesland.tw.tw5.api.prd.purchase.service.SettleApplyDetailsService;
import com.elitesland.tw.tw5.api.prd.purchase.payload.SettleApplyDetailsPayload;
import com.elitesland.tw.tw5.server.prd.purchase.entity.SettleApplyDetailsDO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.SettleApplyDetailsVO;
import com.elitesland.tw.tw5.api.prd.purchase.query.SettleApplyDetailsQuery;
import com.elitesland.tw.tw5.server.prd.purchase.convert.SettleApplyDetailsConvert;
import org.springframework.stereotype.Service;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import org.springframework.transaction.annotation.Transactional;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import javax.servlet.http.HttpServletResponse;
import java.time.LocalDate;
import java.util.*;

/**
 * 结算申请明细
 *
 * @author wangly
 * @date 2024-08-21
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class SettleApplyDetailsServiceImpl extends BaseServiceImpl implements SettleApplyDetailsService {

    private final SettleApplyDetailsRepo settleApplyDetailsRepo;
    private final SettleApplyDetailsDAO settleApplyDetailsDAO;

    @Override
    public PagingVO<SettleApplyDetailsVO> queryPaging(SettleApplyDetailsQuery query){
        return settleApplyDetailsDAO.queryPaging(query);
    }

    @Override
    public List<SettleApplyDetailsVO> queryListDynamic(SettleApplyDetailsQuery query){
        return settleApplyDetailsDAO.queryListDynamic(query);
    }

    @Override
    public SettleApplyDetailsVO queryByKey(Long key) {
        SettleApplyDetailsDO entity = settleApplyDetailsRepo.findById(key).orElseGet(SettleApplyDetailsDO::new);
        Assert.notNull(entity.getId(), "不存在");
        SettleApplyDetailsVO vo = SettleApplyDetailsConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public SettleApplyDetailsVO insert(SettleApplyDetailsPayload payload) {
        SettleApplyDetailsDO entityDo = SettleApplyDetailsConvert.INSTANCE.toDo(payload);
        return SettleApplyDetailsConvert.INSTANCE.toVo(settleApplyDetailsRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public SettleApplyDetailsVO update(SettleApplyDetailsPayload payload) {
        SettleApplyDetailsDO entity = settleApplyDetailsRepo.findById(payload.getId()).orElseGet(SettleApplyDetailsDO::new);
        Assert.notNull(entity.getId(), "不存在");
        SettleApplyDetailsDO entityDo = SettleApplyDetailsConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return SettleApplyDetailsConvert.INSTANCE.toVo(settleApplyDetailsRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(SettleApplyDetailsPayload payload) {
        SettleApplyDetailsDO entity = settleApplyDetailsRepo.findById(payload.getId()).orElseGet(SettleApplyDetailsDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = settleApplyDetailsDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            settleApplyDetailsDAO.deleteSoft(keys);
        }
    }

    @Override
    public PurchaseAgreementResVO queryAssocationResoure(Long userId, LocalDate settleStartDate, LocalDate settleEndDate) {
        PurchaseAgreementResVO purchaseAgreementResVO = settleApplyDetailsDAO.queryAssocationResoure(userId, settleStartDate, settleEndDate);
        /** 结算资源：选择的资源未关联激活的外部专家资源外包采购协议，提示：“该资源未关联采购协议”
         *  结算开始~结束日期：选择后，校验证1，当前结算资源+结算开始结束日期是否匹配到激活的外部专家资源外包采购协议-关联资源的资源日期之内，否提示：当前结算资源结算日期不在结算范围日期内！
         *  结算开始~结束日期：选择后，校验证2，当前结算资源+结算开始结束日期是否在历史结算记录范围内(含审批中、已审批结算单)，否，提示：“当前资源结算周期已发起过结算申请单，单号：“EV20240102002”
         *  结算开始~结束日期：选择后，校验证3，结算资源，合作方式属于打包结算只允许在关联资源服务周期内结算1次，否提示：“当前结算资源属于打包结算，已发起过结算申请单，单号“EV20240102001”
         */
        if(purchaseAgreementResVO==null){
           throw TwException.error("","该资源未关联采购协议");
        }
        String cooperationWay = purchaseAgreementResVO.getCooperationWay();
        SettleApplyDetailsQuery query = new SettleApplyDetailsQuery();
        query.setCoopWay(cooperationWay);
        query.setPurchaseAgreementId(purchaseAgreementResVO.getDocumentId());
        query.setSettleResId(userId);
        if(SettleApplyCoopWayEnum.demand_settlement.getCode().equals(cooperationWay)){
            query.setStartDate(settleStartDate);
            query.setEndDate(settleEndDate);
        }
        List<SettleApplyDetailsVO> settleApplyDetailsVOS = settleApplyDetailsDAO.queryListDynamic(query);
        if(!CollectionUtils.isEmpty(settleApplyDetailsVOS)){
            throw TwException.error("","当前资源结算周期已发起过结算申请单，单号:"+settleApplyDetailsVOS.get(0).getSettleNo());
        }
        return  purchaseAgreementResVO;
    }

}
