package com.elitesland.tw.tw5.server.prd.salecon.controller;


import com.elitesland.tw.tw5.api.prd.salecon.payload.ConInvSettingMonthPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConInvSettingMonthQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConInvSettingMonthService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConInvSettingMonthVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitescloud.cloudt.common.base.PagingVO;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * ConInvSettingMonthController
 *
 * @author zoey
 * @date 2024-03-14
 */
@Api(tags = "ConInvSettingMonthController")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/conInvSettingMonth")
@Slf4j
public class ConInvSettingMonthController {

private final ConInvSettingMonthService conInvSettingMonthService;

    /**
     * ConInvSettingMonthController-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("ConInvSettingMonthController-新增")
    public TwOutputUtil<ConInvSettingMonthVO> insert(@RequestBody ConInvSettingMonthPayload payload){
         return TwOutputUtil.ok(conInvSettingMonthService.insert(payload));
    }

    /**
     * ConInvSettingMonthController-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("ConInvSettingMonthController-更新")
    public TwOutputUtil<ConInvSettingMonthVO> update(@RequestBody ConInvSettingMonthPayload payload){
        return TwOutputUtil.ok(conInvSettingMonthService.update(payload));
    }

    /**
     * ConInvSettingMonthController-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("ConInvSettingMonthController-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody ConInvSettingMonthPayload payload){
        return TwOutputUtil.ok(conInvSettingMonthService.updateByKeyDynamic(payload));
    }

    /**
     * ConInvSettingMonthController-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("ConInvSettingMonthController-主键查询")
    public TwOutputUtil<ConInvSettingMonthVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(conInvSettingMonthService.queryByKey(key));
    }

    /**
     * ConInvSettingMonthController-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("ConInvSettingMonthController-分页")
    public TwOutputUtil<PagingVO<ConInvSettingMonthVO>> paging(ConInvSettingMonthQuery query) {
        return TwOutputUtil.ok(conInvSettingMonthService.queryPaging(query));
    }

    /**
     * ConInvSettingMonthController-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("ConInvSettingMonthController-查询列表")
    public TwOutputUtil<List<ConInvSettingMonthVO>> queryList(ConInvSettingMonthQuery query) {
        return TwOutputUtil.ok(conInvSettingMonthService.queryListDynamic(query));
    }

    /**
     * ConInvSettingMonthController-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("ConInvSettingMonthController-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         conInvSettingMonthService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

