package com.elitesland.tw.tw5.server.prd.salecon.repo;

import com.elitesland.tw.tw5.server.prd.salecon.entity.ConInvBatchDO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConReceivablePlanDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;

/**
 * 合同开票批次
 *
 * @author likunpeng
 * @date 2023-07-19
 */
public interface ConInvBatchRepo extends JpaRepository<ConInvBatchDO, Long>, JpaSpecificationExecutor<ConInvBatchDO> {

    List<ConInvBatchDO> findByBatchStatusInAndInvTypeNotAndInvOuIdIn(List<String> batchStatus,String typeNot,List<Long> invOuId);

    @Transactional
    @Modifying
    @Query(value = "update ConInvBatchDO set disDisc = null,modifyTime=current_time  where  id = ?1")
    void delDistDisc(Long batchId);

    @Transactional
    @Modifying
    @Query(value = "update con_inv_batch set sale_contract_id=(select sale_con_id from con_receivable_plan where inv_batch_id=?1 limit 1),modify_time=current_time  where  id = ?1",nativeQuery = true)
    void updateContractId(Long batchId);

    @Transactional
    @Modifying
    @Query(value = "update con_inv_batch set inv_flag=?2,modify_time=current_time  where  id = ?1",nativeQuery = true)
    void updateInvFlag(Long batchId,Integer invFlag);



    @Query(value = " select * from con_inv_batch e where e.modify_time >= ?1", nativeQuery = true)
    List<ConInvBatchDO> findByModifyTimeStart(String format);


    @Transactional(rollbackFor = Exception.class)
    @Query(value = "update con_inv_batch set modify_time=now()  where id=?1",nativeQuery = true)
    @Modifying
    void updateRemark(Long id);

    @Transactional(rollbackFor = Exception.class)
    @Query(value = "update ConInvBatchDO set invBatchIdV4=?1,modifyTime=current_time where id=?2")
    @Modifying
    void updateInvBatchIdV4(Long idV4,Long id);


//    @Query(value = "SELECT c.name FROM `con_receivable_plan` p LEFT JOIN sale_con_contract c ON p.sale_con_id=c.id WHERE p.id=?1",nativeQuery = true)
//    String queryContractName(Long planId);
}
