package com.elitesland.tw.tw5.server.prd.system.controller;


import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemSiteRefPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemSiteRefQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemSiteRefService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSiteRefVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitescloud.cloudt.common.base.PagingVO;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 业务地点关系表
 *
 * @author zoey
 * @date 2024-04-22
 */
@Api(tags = "业务地点关系表")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/prdSystemSiteRef")
@Slf4j
public class PrdSystemSiteRefController {

private final PrdSystemSiteRefService prdSystemSiteRefService;

    /**
     * 业务地点关系表-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("业务地点关系表-新增")
    public TwOutputUtil<PrdSystemSiteRefVO> insert(@RequestBody PrdSystemSiteRefPayload payload){
         return TwOutputUtil.ok(prdSystemSiteRefService.insert(payload));
    }

    /**
     * 业务地点关系表-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("业务地点关系表-更新")
    public TwOutputUtil<PrdSystemSiteRefVO> update(@RequestBody PrdSystemSiteRefPayload payload){
        return TwOutputUtil.ok(prdSystemSiteRefService.update(payload));
    }

    /**
     * 业务地点关系表-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("业务地点关系表-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody PrdSystemSiteRefPayload payload){
        return TwOutputUtil.ok(prdSystemSiteRefService.updateByKeyDynamic(payload));
    }

    /**
     * 业务地点关系表-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("业务地点关系表-主键查询")
    public TwOutputUtil<PrdSystemSiteRefVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(prdSystemSiteRefService.queryByKey(key));
    }

    /**
     * 业务地点关系表-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("业务地点关系表-分页")
    public TwOutputUtil<PagingVO<PrdSystemSiteRefVO>> paging(PrdSystemSiteRefQuery query) {
        return TwOutputUtil.ok(prdSystemSiteRefService.queryPaging(query));
    }

    /**
     * 业务地点关系表-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("业务地点关系表-查询列表")
    public TwOutputUtil<List<PrdSystemSiteRefVO>> queryList(PrdSystemSiteRefQuery query) {
        return TwOutputUtil.ok(prdSystemSiteRefService.queryListDynamic(query));
    }

    /**
     * 业务地点关系表-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("业务地点关系表-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         prdSystemSiteRefService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

