package com.elitesland.tw.tw5.server.prd.system.dao;


import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemGrossMarginPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemGrossMarginQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemGrossMarginVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemGrossMarginDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemGrossMarginDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemGrossMarginRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 阶梯毛利率设置
 *
 * @author likunpeng
 * @date 2023-04-03
 */
@Repository
@RequiredArgsConstructor
public class PrdSystemGrossMarginDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final PrdSystemGrossMarginRepo repo;
    private final QPrdSystemGrossMarginDO qdo = QPrdSystemGrossMarginDO.prdSystemGrossMarginDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdSystemGrossMarginVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(PrdSystemGrossMarginVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // BU_ID
                qdo.buId,
                // 年度
                qdo.yearly,
                // 合同金额
                qdo.amt,
                // BU负责人ID
                qdo.buDirectorId,
                // BU毛利率
                qdo.buGrossMargin,
                // 阶梯毛利率1
                qdo.ladderGrossMargin1,
                // 阶梯负责人1ID
                qdo.ladderDirectorId1,
                // 阶梯毛利率2
                qdo.ladderGrossMargin2,
                // 阶梯负责人2ID
                qdo.ladderDirectorId2
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<PrdSystemGrossMarginVO> getJpaQueryWhere(PrdSystemGrossMarginQuery query) {
        JPAQuery<PrdSystemGrossMarginVO> jpaQuery = getJpaQuerySelect();
            // 条件封装
            jpaQuery.where(where(query));
            // 常用基础查询条件拼装
            SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
            // 动态排序
            jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
            return jpaQuery;
            }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(PrdSystemGrossMarginQuery query) {
        long total = jpaQueryFactory
            .select(qdo.count())
            .from(qdo)
            .where(where(query))
            .fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(PrdSystemGrossMarginQuery query){
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** BU_ID 精确 */
        if (!ObjectUtils.isEmpty(query.getBuId())) {
            list.add(qdo.buId.eq(query.getBuId()));
        }
        /** 年度 精确 */
        if (!ObjectUtils.isEmpty(query.getYearly())) {
            list.add(qdo.yearly.eq(query.getYearly()));
        }
        /** 合同金额 精确 */
        if (!ObjectUtils.isEmpty(query.getAmt())) {
            list.add(qdo.amt.eq(query.getAmt()));
        }
        /** BU负责人ID 精确 */
        if (!ObjectUtils.isEmpty(query.getBuDirectorId())) {
            list.add(qdo.buDirectorId.eq(query.getBuDirectorId()));
        }
        /** BU毛利率 精确 */
        if (!ObjectUtils.isEmpty(query.getBuGrossMargin())) {
            list.add(qdo.buGrossMargin.eq(query.getBuGrossMargin()));
        }
        /** 阶梯毛利率1 精确 */
        if (!ObjectUtils.isEmpty(query.getLadderGrossMargin1())) {
            list.add(qdo.ladderGrossMargin1.eq(query.getLadderGrossMargin1()));
        }
        /** 阶梯负责人1ID 精确 */
        if (!ObjectUtils.isEmpty(query.getLadderDirectorId1())) {
            list.add(qdo.ladderDirectorId1.eq(query.getLadderDirectorId1()));
        }
        /** 阶梯毛利率2 精确 */
        if (!ObjectUtils.isEmpty(query.getLadderGrossMargin2())) {
            list.add(qdo.ladderGrossMargin2.eq(query.getLadderGrossMargin2()));
        }
        /** 阶梯负责人2ID 精确 */
        if (!ObjectUtils.isEmpty(query.getLadderDirectorId2())) {
            list.add(qdo.ladderDirectorId2.eq(query.getLadderDirectorId2()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public PrdSystemGrossMarginVO queryByKey(Long id) {
        JPAQuery<PrdSystemGrossMarginVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<PrdSystemGrossMarginVO> queryListDynamic(PrdSystemGrossMarginQuery query) {
        JPAQuery<PrdSystemGrossMarginVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<PrdSystemGrossMarginVO> queryPaging(PrdSystemGrossMarginQuery query) {
        long total = count(query);
        if (total == 0) {
             return PagingVO.empty();
        }
        JPAQuery<PrdSystemGrossMarginVO> jpaQuery = getJpaQueryWhere(query);
        List<PrdSystemGrossMarginVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<PrdSystemGrossMarginVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PrdSystemGrossMarginDO save(PrdSystemGrossMarginDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<PrdSystemGrossMarginDO> saveAll(List<PrdSystemGrossMarginDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(PrdSystemGrossMarginPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
        .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // BU_ID
        if (payload.getBuId() != null) {
            update.set(qdo.buId, payload.getBuId());
        }
        // 年度
        if (payload.getYearly() != null) {
            update.set(qdo.yearly, payload.getYearly());
        }
        // 合同金额
        if (payload.getAmt() != null) {
            update.set(qdo.amt, payload.getAmt());
        }
        // BU负责人ID
        if (payload.getBuDirectorId() != null) {
            update.set(qdo.buDirectorId, payload.getBuDirectorId());
        }
        // BU毛利率
        if (payload.getBuGrossMargin() != null) {
            update.set(qdo.buGrossMargin, payload.getBuGrossMargin());
        }
        // 阶梯毛利率1
        if (payload.getLadderGrossMargin1() != null) {
            update.set(qdo.ladderGrossMargin1, payload.getLadderGrossMargin1());
        }
        // 阶梯负责人1ID
        if (payload.getLadderDirectorId1() != null) {
            update.set(qdo.ladderDirectorId1, payload.getLadderDirectorId1());
        }
        // 阶梯毛利率2
        if (payload.getLadderGrossMargin2() != null) {
            update.set(qdo.ladderGrossMargin2, payload.getLadderGrossMargin2());
        }
        // 阶梯负责人2ID
        if (payload.getLadderDirectorId2() != null) {
            update.set(qdo.ladderDirectorId2, payload.getLadderDirectorId2());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // BU_ID
            if (nullFields.contains("buId")) {
                update.setNull(qdo.buId);
            }
            // 年度
            if (nullFields.contains("yearly")) {
                update.setNull(qdo.yearly);
            }
            // 合同金额
            if (nullFields.contains("amt")) {
                update.setNull(qdo.amt);
            }
            // BU负责人ID
            if (nullFields.contains("buDirectorId")) {
                update.setNull(qdo.buDirectorId);
            }
            // BU毛利率
            if (nullFields.contains("buGrossMargin")) {
                update.setNull(qdo.buGrossMargin);
            }
            // 阶梯毛利率1
            if (nullFields.contains("ladderGrossMargin1")) {
                update.setNull(qdo.ladderGrossMargin1);
            }
            // 阶梯负责人1ID
            if (nullFields.contains("ladderDirectorId1")) {
                update.setNull(qdo.ladderDirectorId1);
            }
            // 阶梯毛利率2
            if (nullFields.contains("ladderGrossMargin2")) {
                update.setNull(qdo.ladderGrossMargin2);
            }
            // 阶梯负责人2ID
            if (nullFields.contains("ladderDirectorId2")) {
                update.setNull(qdo.ladderDirectorId2);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}

