package com.elitesland.tw.tw5.server.prd.system.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Comment;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 业务对象与菜单关联表
 *
 * @Author Bill
 * @Date 2023/9/15 16:13
 **/
@Entity
@Table(name = "prd_system_business_object_menu")
@org.hibernate.annotations.Table(appliesTo = "prd_system_business_object_menu", comment = "业务对象与菜单关联表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag = 0")
public class PrdSystemBusinessObjectMenuDO extends BaseModel {

    @Comment("对象主键")
    @Column(name = "object_id")
    private Long objectId;

    @Comment("菜单主键")
    @Column(name = "menu_id")
    private Long menuId;

}
