package com.elitesland.tw.tw5.server.prd.system.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Comment;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * @Author Quruiqizz
 * @Date 2023/10/8 14:06
 **/
@Entity
@Table(name = "prd_system_permission_field_obj_role_function")
@org.hibernate.annotations.Table(appliesTo = "prd_system_permission_field_obj_role_function", comment = "字段相关信息维护表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag = 0")
public class PrdSystemPermissionFieldObjRoleFunctionDO extends BaseModel {

    private static final long serialVersionUID = -4115962489170705199L;

    @Comment("字段主键")
    @Column(name = "field_id")
    private Long fieldId;

    @Comment("角色主键")
    @Column(name = "role_id")
    private Long roleId;

    @Comment("是否可见")
    @Column(name = "is_visible")
    private Integer isVisible;

    @Comment("是否可编辑")
    @Column(name = "is_edit")
    private Integer isEdit;

    @Comment("功能对象主键")
    @Column(name = "function_object_id")
    private Long functionObjectId;

    public void copy(PrdSystemPermissionFieldObjRoleFunctionDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }

}
