package com.elitesland.tw.tw5.server.prd.system.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;

/**
 * 公共地点表
 *
 * @author zoey
 * @date 2024-04-22
 */
@Entity
@Table(name = "prd_system_site", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "prd_system_site", comment = "公共地点表")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrdSystemSiteDO extends BaseModel implements Serializable  {
    /** 地点名称 */
    @Comment("地点名称")
    @Column()
    private String siteDesc;
    /** 经度 */
    @Comment("经度")
    @Column()
    private String siteLongitude;
    /** 纬度 */
    @Comment("纬度")
    @Column()
    private String siteLatitude;

    public void copy(PrdSystemSiteDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
