package com.elitesland.tw.tw5.server.prd.system.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;

/**
 * 业务地点关系表
 *
 * @author zoey
 * @date 2024-04-22
 */
@Entity
@Table(name = "prd_system_site_ref", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "prd_system_site_ref", comment = "业务地点关系表")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrdSystemSiteRefDO extends BaseModel implements Serializable  {
    /** 地点ID */
    @Comment("地点ID")
    @Column()
    private Long siteId;
    /** 单据ID */
    @Comment("单据ID")
    @Column()
    private Long docId;
    /** 单据类型 */
    @Comment("单据类型,项目：proj;打卡：attendance")
    @Column()
    private String docType;

    public void copy(PrdSystemSiteRefDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
