package com.elitesland.tw.tw5.server.prd.system.service;

import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemPermissionFieldPayload;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemPermissionFunctionObjectPayload;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemPermissionFunctionObjectService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemBusinessObjectVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemPermissionFunctionObjectVO;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdSystemPermissionFunctionObjectConvert;
import com.elitesland.tw.tw5.server.prd.system.dao.*;
import com.elitesland.tw.tw5.server.prd.system.entity.*;
import com.elitesland.tw.tw5.server.prd.system.repo.*;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

/**
 * 功能对象
 *
 * @author : JS
 * @date 2023/10/11
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PrdSystemPermissionFunctionObjectServiceImpl implements PrdSystemPermissionFunctionObjectService {

    private final PrdSystemPermissionFunctionObjectRepo repo;

    private final PrdSystemPermissionFunctionObjectDAO dao;

    private final PrdSystemPermissionFieldRepo fieldRepo;

    private final PrdSystemPermissionFieldDAO fieldDao;

    private final PrdSystemNewFunctionRepo functionRepo;

    private final PrdSystemBusinessObjectDAO businessObjectDAO;

    private final PrdSystemPermissionTableFieldsRepo businessTableFieldsRepo;

    private final PrdSystemPermissionTableFieldsDAO tableFieldsDAO;

    private final PrdSystemPermissionFieldObjRoleFunctionDAO fieldObjRoleFunctionDAO;

    private final PrdSystemPermissionFieldObjRoleFunctionRepo fieldObjRoleFunctionRepo;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void autoCreate(Map<String, List<PrdSystemPermissionFunctionObjectPayload>> functionMap) {
        List<String> objectCodes = new ArrayList<>(functionMap.keySet());

        // 查询业务对象
        List<PrdSystemBusinessObjectVO> objectList = businessObjectDAO.queryByObjectCodes(objectCodes);
        Map<String, PrdSystemBusinessObjectVO> objectMap = objectList.stream().collect(Collectors.toMap(PrdSystemBusinessObjectVO::getObjectCode, e -> e, (l, r) -> r));

        // 查询功能
        List<String> functionCodes = functionMap.values().stream().flatMap(Collection::stream).map(PrdSystemPermissionFunctionObjectPayload::getFunctionCodes).flatMap(Collection::stream).distinct().toList();
        List<PrdSystemNewFunctionDO> functionList = functionRepo.findAllByFunctionCodeIn(functionCodes);
        Map<String, PrdSystemNewFunctionDO> existFunctionMap = functionList.stream().collect(Collectors.toMap(PrdSystemNewFunctionDO::getFunctionCode, e -> e, (l, r) -> l));

        // 查询已有功能对象
        List<Long> objectIds = objectList.stream().map(PrdSystemBusinessObjectVO::getId).toList();
        List<PrdSystemPermissionFunctionObjectDO> existFunctionObjectList = repo.findAllByObjectIdIn(objectIds);

        // 查询已有字段
        List<PrdSystemPermissionFieldDO> existFieldList = fieldRepo.findAllByObjectIdIn(objectIds);

        List<PrdSystemPermissionFieldDO> updateList = new ArrayList<>();
        List<PrdSystemPermissionFieldDO> insertList = new ArrayList<>();
        List<PrdSystemPermissionTableFieldsDO> syncInsertList = new ArrayList<>();
        List<Long> deleteList = new ArrayList<>();
        List<Long> syncDeleteList = new ArrayList<>();
        Set<Long> functionSet = new HashSet<>();
        Set<String> distinctFunctionObject = new HashSet<>();

        functionMap.forEach((k, v) -> {
            if (objectMap.containsKey(k)) {
                PrdSystemBusinessObjectVO businessObject = objectMap.get(k);
                v.forEach(functionObject -> functionObject.getFunctionCodes().forEach(functionCode -> {
                    if (!existFunctionMap.containsKey(functionCode)) {
                        return;
                    }
                    PrdSystemNewFunctionDO prdSystemNewFunctionDO = existFunctionMap.get(functionCode);
                    Long functionId = prdSystemNewFunctionDO.getId();

                    Optional<PrdSystemPermissionFunctionObjectDO> functionObjectOptional = existFunctionObjectList.stream()
                            .filter(item -> functionId.equals(item.getFunctionId()) && functionObject.getClassName().equals(item.getClassName())).findFirst();

                    // 已存在
                    if (functionObjectOptional.isPresent()) {
                        // 更新 功能对象
                        PrdSystemPermissionFunctionObjectDO existFunctionObject = functionObjectOptional.get();
                        existFunctionObject.setClassPathName(prdSystemNewFunctionDO.getFunctionName());
                        existFunctionObject.setFunctionId(functionId);
                        repo.save(existFunctionObject);

                        //处理字段
                        functionObject.getFields().forEach(field -> {
                            Optional<PrdSystemPermissionFieldDO> optional = existFieldList.stream()
                                    .filter(item -> item.getFunctionObjectId().equals(existFunctionObject.getId())
                                            && item.getObjectId().equals(businessObject.getId())
                                            && item.getField().equals(field.getField()))
                                    .findFirst();
                            if (optional.isPresent()) {
                                PrdSystemPermissionFieldDO prdSystemPermissionFieldDO = optional.get();
                                prdSystemPermissionFieldDO.setFieldName(field.getFieldName());
                                prdSystemPermissionFieldDO.setFieldType(field.getFieldType());

                                updateList.add(prdSystemPermissionFieldDO);
                            } else {
                                PrdSystemPermissionFieldDO prdSystemPermissionFieldDO = PrdSystemPermissionFunctionObjectConvert.INSTANCE.fieldPayload2DO(field);
                                prdSystemPermissionFieldDO.setObjectId(businessObject.getId());
                                prdSystemPermissionFieldDO.setFunctionObjectId(existFunctionObject.getId());
                                insertList.add(prdSystemPermissionFieldDO);

                                PrdSystemPermissionTableFieldsDO tableFieldsDO = new PrdSystemPermissionTableFieldsDO();
                                fillBusinessTableFieldDO(tableFieldsDO, prdSystemPermissionFieldDO, existFunctionObject);
                                syncInsertList.add(tableFieldsDO);
                            }
                        });

                        // 已删除字段
                        List<String> fieldList = functionObject.getFields().stream().map(PrdSystemPermissionFieldPayload::getField).toList();
                        List<PrdSystemPermissionFieldDO> deleteField = existFieldList.stream().filter(item -> item.getFunctionObjectId().equals(existFunctionObject.getId())
                                && item.getObjectId().equals(businessObject.getId())
                                && !fieldList.contains(item.getField())).toList();
                        if (!CollectionUtils.isEmpty(deleteField)) {

                            // 拿到功能对象
                            List<Long> funcObjIds = deleteField.stream().map(PrdSystemPermissionFieldDO::getFunctionObjectId).toList();
                            // 拿到功能对象对应的功能主键
                            List<PrdSystemPermissionFunctionObjectVO> fobj = dao.getByV2Ids(funcObjIds);
                            // 拿到功能和功能对象关系
                            Map<Long, Long> funcMap = new HashMap<>();
                            if (!CollectionUtils.isEmpty(fobj)) {
                                funcMap = fobj.stream().collect(Collectors.toMap(
                                        PrdSystemPermissionFunctionObjectVO::getId,
                                        PrdSystemPermissionFunctionObjectVO::getFunctionId
                                ));
                            }
                            // 拿到删除的字段主键
                            List<Long> deleteFieldIds = deleteField.stream().map(PrdSystemPermissionFieldDO::getId).toList();
                            deleteList.addAll(deleteFieldIds);
                            // 拿到一个字段map集合
                            Map<Long, List<String>> fieldMap = new HashMap<>();
                            for (PrdSystemPermissionFieldDO field : deleteField) {
                                Long funcId = funcMap.get(field.getFunctionObjectId());
                                if (fieldMap.containsKey(funcId)) {
                                    List<String> strs = fieldMap.get(funcId);
                                    strs.add(humpToUnderline(field.getField()));
                                    continue;
                                }

                                List<String> strs = new ArrayList<>();
                                strs.add(humpToUnderline(field.getField()));
                                fieldMap.put(funcId, strs);

                            }

                            // 拿到同步表需要删除的数据
                            for (Map.Entry<Long, List<String>> entry : fieldMap.entrySet()) {
                                List<Long> businessFieldIds = tableFieldsDAO.queryListByTableIdAndField(entry.getKey(), entry.getValue());
                                if (!CollectionUtils.isEmpty(businessFieldIds)) {
                                    syncDeleteList.addAll(businessFieldIds);
                                }
                            }
                        }

                    } else {
                        PrdSystemPermissionFunctionObjectDO functionObjectDO = PrdSystemPermissionFunctionObjectConvert.INSTANCE.functionPayload2DO(functionObject);
                        functionObjectDO.setObjectId(businessObject.getId());
                        functionObjectDO.setFunctionId(functionId);
                        functionObjectDO.setClassPathName(prdSystemNewFunctionDO.getFunctionName());

                        String element = functionObjectDO.getObjectId() + "_" + functionObjectDO.getFunctionId() + "_" + functionObjectDO.getClassPathName();
                        //重复的 功能对象 不保存，字段也不保存
                        if (distinctFunctionObject.add(element)) {
                            repo.save(functionObjectDO);

                            //新增的功能对象，也要保存字段，保存到prd_system_permission_field、prd_system_permission_table_fields
                            functionObject.getFields().forEach(field -> {
                                PrdSystemPermissionFieldDO prdSystemPermissionFieldDO = PrdSystemPermissionFunctionObjectConvert.INSTANCE.fieldPayload2DO(field);
                                prdSystemPermissionFieldDO.setObjectId(businessObject.getId());
                                prdSystemPermissionFieldDO.setFunctionObjectId(functionObjectDO.getId());
                                insertList.add(prdSystemPermissionFieldDO);

                                PrdSystemPermissionTableFieldsDO tableFieldsDO = new PrdSystemPermissionTableFieldsDO();
                                fillBusinessTableFieldDO(tableFieldsDO, prdSystemPermissionFieldDO, functionObjectDO);
                                syncInsertList.add(tableFieldsDO);

                            });
                        }
                    }
                }));
            }
        });

        List<String> classNameFunctionIds = functionMap.values().stream().flatMap(Collection::stream)
                .map(functionObject -> functionObject.getFunctionCodes().stream()
                        .map(functionCode -> {
                            if (existFunctionMap.containsKey(functionCode)) {
                                Long functionId = existFunctionMap.get(functionCode).getId();
                                return functionObject.getClassName() + "_" + functionId;
                            } else {
                                return null;
                            }
                        }).filter(Objects::nonNull).toList()).flatMap(Collection::stream).distinct().toList();
        List<Long> deleteFunctionObjectIds = existFunctionObjectList.stream().filter(item -> !classNameFunctionIds.contains(item.getClassName() + "_" + item.getFunctionId())).map(prdSystemPermissionFunctionObjectDO -> {
            functionSet.add(prdSystemPermissionFunctionObjectDO.getFunctionId());
            return prdSystemPermissionFunctionObjectDO.getId();
        }).toList();
        if (!CollectionUtils.isEmpty(deleteFunctionObjectIds)) {
            // 拿到功能对象对应的功能主键
            List<Long> funcIds = dao.getByIds(deleteFunctionObjectIds);
            dao.deleteByIds(deleteFunctionObjectIds);
            fieldDao.deleteByFunctionObjectIds(deleteFunctionObjectIds);
            // 拿到同步表 删除数据
            List<Long> businessFieldIds = tableFieldsDAO.queryListByTableIds(funcIds);
            // 删除同步表 数据
            if (!CollectionUtils.isEmpty(businessFieldIds)) {
                tableFieldsDAO.deleteSoftCopy(businessFieldIds);
            }

            fieldObjRoleFunctionDAO.deleteByFunctionObjectIds(deleteFunctionObjectIds);
        }

        if (!CollectionUtils.isEmpty(insertList)) {
            List<PrdSystemPermissionFieldDO> fieldDOS = fieldRepo.saveAll(insertList);
            List<Long> functionObjectIds = fieldDOS.stream().map(PrdSystemPermissionFieldDO::getFunctionObjectId).collect(Collectors.toList());
            List<Long> roleIds = fieldObjRoleFunctionDAO.queryRoleIdsByFunctionObjectIds(functionObjectIds);
            //实体类新增字段，角色-字段-功能对象表也要插入 新增字段
            List<PrdSystemPermissionFieldObjRoleFunctionDO> list = new ArrayList<>();
            for (Long roleId : roleIds) {
                for (PrdSystemPermissionFieldDO fieldDO : fieldDOS) {

                    PrdSystemPermissionFieldObjRoleFunctionDO fieldObjRoleFunctionDO = new PrdSystemPermissionFieldObjRoleFunctionDO();
                    fieldObjRoleFunctionDO.setFieldId(fieldDO.getId());
                    fieldObjRoleFunctionDO.setFunctionObjectId(fieldDO.getFunctionObjectId());
                    fieldObjRoleFunctionDO.setRoleId(roleId);
                    fieldObjRoleFunctionDO.setIsVisible(0);
                    fieldObjRoleFunctionDO.setIsEdit(1);
                    list.add(fieldObjRoleFunctionDO);
                }
            }
            fieldObjRoleFunctionRepo.saveAll(list);
        }
        if (!CollectionUtils.isEmpty(syncInsertList)) {
            businessTableFieldsRepo.saveAll(syncInsertList);
        }
        if (!CollectionUtils.isEmpty(updateList)) {
            fieldRepo.saveAll(updateList);
        }
        if (!CollectionUtils.isEmpty(deleteList)) {
            fieldDao.deleteByIds(deleteList);
        }
        if (!CollectionUtils.isEmpty(deleteList)) {
            fieldObjRoleFunctionDAO.deleteByFieldIds(deleteList);
        }
        if (!CollectionUtils.isEmpty(syncDeleteList)) {
            tableFieldsDAO.deleteSoftCopy(syncDeleteList);
        }
    }

    /**
     * 通过功能集合查询字段
     *
     * @param functionIds
     * @return
     */
    @Override
    public List<PrdSystemPermissionFunctionObjectVO> queryByFunctionId(List<Long> functionIds) {
        return dao.queryByFunctionId(functionIds);
    }

    /**
     * 填充 business表属性实体类
     *
     * @param tableFieldsDO
     * @param fieldDO
     */
    private void fillBusinessTableFieldDO(PrdSystemPermissionTableFieldsDO tableFieldsDO, PrdSystemPermissionFieldDO fieldDO, PrdSystemPermissionFunctionObjectDO functionObjectDO) {

        // 存储functionId
        tableFieldsDO.setTableId(functionObjectDO.getFunctionId());
        // 存储field类型
        tableFieldsDO.setType(fieldDO.getMappingField());
        // 使用扩充类型 存储字段类型
        tableFieldsDO.setExt3(fieldDO.getFieldType());
        // 存储feild
        tableFieldsDO.setField(humpToUnderline(fieldDO.getField()));
        // 权限field 对应 business字段表属性fieldKey
        tableFieldsDO.setFieldKey(fieldDO.getField());
        // fieldName匹配
        tableFieldsDO.setFieldName(fieldDO.getFieldName());
        // showName同fieldName
        tableFieldsDO.setShowName(fieldDO.getFieldName());
        // 填充基本属性
        tableFieldsDO.setBusinessFlag(true);
        tableFieldsDO.setNotNull(false);

    }

    /**
     * 驼峰转为下划线
     *
     * @param field
     * @return
     */
    private String humpToUnderline(String field) {
        String regex = "([A-Z])";
        Matcher matcher = Pattern.compile(regex).matcher(field);
        while (matcher.find()) {
            String group = matcher.group();
            field = field.replaceAll(group, "_" + group.toLowerCase());
        }
        return field;
    }

}
