package com.elitesland.tw.tw5.server.prd.ts.dao;


import com.elitesland.tw.tw5.api.prd.ts.payload.TsNotaskApprovalConfigRulePayload;
import com.elitesland.tw.tw5.api.prd.ts.query.TsNotaskApprovalConfigRuleQuery;
import com.elitesland.tw.tw5.api.prd.ts.vo.TsNotaskApprovalConfigRuleVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.prd.ts.entity.QTsNotaskApprovalConfigRuleDO;
import com.elitesland.tw.tw5.server.prd.ts.entity.TsNotaskApprovalConfigRuleDO;
import com.elitesland.tw.tw5.server.prd.ts.repo.TsNotaskApprovalConfigRuleRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * notask_approval_1
 *
 * @author zoey
 * @date 2024-04-30
 */
@Repository
@RequiredArgsConstructor
public class TsNotaskApprovalConfigRuleDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final TsNotaskApprovalConfigRuleRepo repo;
    private final QTsNotaskApprovalConfigRuleDO qdo = QTsNotaskApprovalConfigRuleDO.tsNotaskApprovalConfigRuleDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<TsNotaskApprovalConfigRuleVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(TsNotaskApprovalConfigRuleVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 报配置主表id
                qdo.configId,
                // 活动
                qdo.activity,
                // 用户配置
                qdo.isUser,
                // 人员
                qdo.users,
                // 范围（udc:每人，事业部）
                qdo.scope,
                // 填报天数上限
                qdo.upperLimit,
                // UT值
                qdo.ut,
                // 触发条件
                qdo.triggerCondition,
                // 触发条件天数
                qdo.conditionDays,
                // 报配置主表id
                qdo.apprUserId,
                qdo.firstApprUserRole
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<TsNotaskApprovalConfigRuleVO> getJpaQueryWhere(TsNotaskApprovalConfigRuleQuery query) {
        JPAQuery<TsNotaskApprovalConfigRuleVO> jpaQuery = getJpaQuerySelect();
            // 条件封装
            jpaQuery.where(where(query));
            // 常用基础查询条件拼装
            SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
            // 动态排序
            jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
            return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(TsNotaskApprovalConfigRuleQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
        .select(qdo.count())
        .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(TsNotaskApprovalConfigRuleQuery query){
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 报配置主表id 精确 */
        if (!ObjectUtils.isEmpty(query.getConfigId())) {
            list.add(qdo.configId.eq(query.getConfigId()));
        }
        /** 活动 精确 */
        if (!ObjectUtils.isEmpty(query.getActivity())) {
            list.add(qdo.activity.like(SqlUtil.toSqlLikeString(query.getActivity())));
        }

        /** 人员 精确 */
        if (!ObjectUtils.isEmpty(query.getUsers())) {
            /** 用户配置 精确 */
            BooleanExpression orExpression = (qdo.isUser.eq(1).and(qdo.users.like(SqlUtil.toSqlLikeString(query.getUsers()))));
            orExpression = orExpression.or((qdo.isUser.eq(0)));
            list.add(orExpression);
        }

        /** 范围（udc:每人，事业部） 精确 */
        if (!ObjectUtils.isEmpty(query.getScope())) {
            list.add(qdo.scope.eq(query.getScope()));
        }
        /** 填报天数上限 精确 */
        if (!ObjectUtils.isEmpty(query.getUpperLimit())) {
            list.add(qdo.upperLimit.eq(query.getUpperLimit()));
        }
        /** UT值 精确 */
        if (!ObjectUtils.isEmpty(query.getUt())) {
            list.add(qdo.ut.eq(query.getUt()));
        }
        /** 触发条件 精确 */
        if (!ObjectUtils.isEmpty(query.getTriggerCondition())) {
            list.add(qdo.triggerCondition.eq(query.getTriggerCondition()));
        }
        /** 触发条件 精确 */
//        if (!ObjectUtils.isEmpty(query.getConditionDays())) {
//            BooleanExpression conditionExpression = (qdo.triggerCondition.eq("gt").and(qdo.conditionDays.lt(query.getConditionDays())));
//            conditionExpression = conditionExpression.or(qdo.triggerCondition.eq("ltoe").and(qdo.conditionDays.goe(query.getConditionDays())));
//            list.add(conditionExpression);
//        }

        /** 报配置主表id 精确 */
        if (!ObjectUtils.isEmpty(query.getApprUserId())) {
            list.add(qdo.apprUserId.eq(query.getApprUserId()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public TsNotaskApprovalConfigRuleVO queryByKey(Long id) {
        JPAQuery<TsNotaskApprovalConfigRuleVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<TsNotaskApprovalConfigRuleVO> queryListDynamic(TsNotaskApprovalConfigRuleQuery query) {
        JPAQuery<TsNotaskApprovalConfigRuleVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<TsNotaskApprovalConfigRuleVO> queryPaging(TsNotaskApprovalConfigRuleQuery query) {
        long total = count(query);
        if (total == 0) {
             return PagingVO.empty();
        }
        JPAQuery<TsNotaskApprovalConfigRuleVO> jpaQuery = getJpaQueryWhere(query);
        List<TsNotaskApprovalConfigRuleVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<TsNotaskApprovalConfigRuleVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public TsNotaskApprovalConfigRuleDO save(TsNotaskApprovalConfigRuleDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<TsNotaskApprovalConfigRuleDO> saveAll(List<TsNotaskApprovalConfigRuleDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(TsNotaskApprovalConfigRulePayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
        .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 报配置主表id
        if (payload.getConfigId() != null) {
            update.set(qdo.configId, payload.getConfigId());
        }
        // 活动
        if (payload.getActivity() != null) {
            update.set(qdo.activity, payload.getActivity());
        }
        // 用户配置
        if (payload.getIsUser() != null) {
            update.set(qdo.isUser, payload.getIsUser());
        }
        // 人员
        if (payload.getUsers() != null) {
            update.set(qdo.users, payload.getUsers());
        }
        // 范围（udc:每人，事业部）
        if (payload.getScope() != null) {
            update.set(qdo.scope, payload.getScope());
        }
        // 填报天数上限
        if (payload.getUpperLimit() != null) {
            update.set(qdo.upperLimit, payload.getUpperLimit());
        }
        // UT值
        if (payload.getUt() != null) {
            update.set(qdo.ut, payload.getUt());
        }
        // 触发条件
        if (payload.getTriggerCondition() != null) {
            update.set(qdo.triggerCondition, payload.getTriggerCondition());
        }
        if (payload.getConditionDays() != null) {
            update.set(qdo.conditionDays, payload.getConditionDays());
        }
        // 报配置主表id
        if (payload.getApprUserId() != null) {
            update.set(qdo.apprUserId, payload.getApprUserId());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 报配置主表id
            if (nullFields.contains("configId")) {
                update.setNull(qdo.configId);
            }
            // 活动
            if (nullFields.contains("activity")) {
                update.setNull(qdo.activity);
            }
            // 用户配置
            if (nullFields.contains("isUser")) {
                update.setNull(qdo.isUser);
            }
            // 人员
            if (nullFields.contains("users")) {
                update.setNull(qdo.users);
            }
            // 范围（udc:每人，事业部）
            if (nullFields.contains("scope")) {
                update.setNull(qdo.scope);
            }
            // 填报天数上限
            if (nullFields.contains("upperLimit")) {
                update.setNull(qdo.upperLimit);
            }
            // UT值
            if (nullFields.contains("ut")) {
                update.setNull(qdo.ut);
            }
            // 触发条件
            if (nullFields.contains("condition")) {
                update.setNull(qdo.triggerCondition);
            }
            // 触发条件天数
            if (nullFields.contains("conditionDays")) {
                update.setNull(qdo.conditionDays);
            }
            // 报配置主表id
            if (nullFields.contains("apprUserId")) {
                update.setNull(qdo.apprUserId);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param configIds 主集合
     * @return 删除的行数
     */
    public long deleteSoftByConfigId(List<Long> configIds) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.configId.in(configIds));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}

