package com.elitesland.tw.tw5.server.prd.ts.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;

/**
 * notask_config
 *
 * @author zoey
 * @date 2024-04-30
 */
@Entity
@Table(name = "ts_notask_approval_config", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "ts_notask_approval_config", comment = "notask_config")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class TsNotaskApprovalConfigDO extends BaseModel implements Serializable  {
    /** 工时年度 */
    @Comment("工时年度")
    @Column()
    private Integer tsYear;
    /** 事业部id */
    @Comment("事业部id")
    @Column()
    private Long deliBuId;
    /** 状态:1 有效；0 无效 */
    @Comment("状态:1 有效；0 无效")
    @Column()
    private Integer effective;

    public void copy(TsNotaskApprovalConfigDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
