package com.elitesland.tw.tw5.server.yeedoc.service;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.http.HttpException;
import cn.hutool.http.HttpRequest;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.tw.tw5.server.common.util.JwtUtil;
import com.elitesland.tw.tw5.server.log.constant.ApiRequestLogTypeEnum;
import com.elitesland.tw.tw5.server.log.service.ApiRequestLogService;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.yeedoc.config.YeedocProperties;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;

import java.nio.charset.StandardCharsets;
import java.util.*;

/**
 * yeedoc服务
 *
 * @author
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class YeedocServiceImpl implements YeedocService {

    private final ApiRequestLogService apiRequestLogService;
    /**
     * yeedoc属性配置
     */
    private final YeedocProperties yeedocProperties;
    private final PrdOrgEmployeeDAO prdOrgEmployeeDAO;

    /**
     * 在新版易道壳创建文件
     * @param map
     */
    @Override
    public String createFolder(Map<String, Object> map,String authToken) {
        String createFolderUrl = yeedocProperties.getYeeDocLinkUrl()+"/itemapi/Item/CreatrFolderForTw";
        log.info("[易道壳]-createFolderUrl:{}",createFolderUrl);
        return executePost(createFolderUrl, map, authToken);
    }

    @Override
    public String createFolder(Map<String, Object> map) {
        String yeedocJwt = getYeedocJwt();
        String createFolderUrl = yeedocProperties.getYeeDocLinkUrl()+"/itemapi/Item/CreatrFolderForTw";
        log.info("[易道壳]-createFolderUrl:{}",createFolderUrl);
        return executePost(createFolderUrl, map, yeedocJwt);
    }

    @Override
    public String reNameFolder(Map<String, Object> map, String authToken) {
        String reNameFolderUrl = yeedocProperties.getYeeDocLinkUrl()+"/itemapi/Item/ReName";
        log.info("[易道壳]-createFolderUrl:{}",reNameFolderUrl);
        return executePost(reNameFolderUrl, map, authToken);
    }

    @Override
    public String reNameFolder(Map<String, Object> map) {
        String yeedocJwt = getYeedocJwt();
        String reNameFolderUrl = yeedocProperties.getYeeDocLinkUrl()+"/itemapi/Item/ReName";
        log.info("[易道壳]-createFolderUrl:{}",reNameFolderUrl);
        return executePost(reNameFolderUrl, map, yeedocJwt);
    }

    @Override
    public String newUploadFilesSave(Map<String, Object> map, String authToken) {
        String newUploadFilesSaveUrl = yeedocProperties.getYeeDocLinkUrl()+"/itemapi/Item/NewUploadFilesSave";
        log.info("[易道壳]-newUploadFilesSave:{}",newUploadFilesSaveUrl);
        return executePost(newUploadFilesSaveUrl, map, authToken);
    }

    @Override
    public String getCaCheKeyItemId(Map<String, Object> map, String authToken) {
        String getCaCheKeyItemIdUrl = yeedocProperties.getYeeDocLinkUrl()+"/itemapi/Item/GetCaCheKeyItemId";
        log.info("[易道壳]-getCaCheKeyItemId:{}",getCaCheKeyItemIdUrl);
        return executePost(getCaCheKeyItemIdUrl, map, authToken);
    }

    /**
     * 在易道壳赋权
     *
     * @param itemId
     * @param permissionIds
     */
    @Override
    public String setPermission(String itemId, List<String> permissionIds) {
        String yeedocJwt = getYeedocJwt();
        HashMap<String, Object> map = new HashMap<>();
        map.put("itemid", itemId);
        map.put("PermissionIds", permissionIds);
        String setPermissionUrl = yeedocProperties.getYeeDocLinkUrl() + "/itemapi/Item/SetPermissionObject";
        log.info("[项目文档-易道壳]-setPermissionUrl:{}", setPermissionUrl);
        return executePost(setPermissionUrl, map, yeedocJwt);
    }

    /**
     * 获取item文件夹链接
     * 在易道壳返回浏览链接
     *
     * @param itemId
     */
    @Override
    public String preViewItem(String itemId) {
        //1. 获取token
        String token = getToken();
        //2. 加密
        String externalToken = base64Encrypt(token);
        String preViewItemUrl = yeedocProperties.getYeeDocLinkUrl() + "/api/item/external/previewitem/" + itemId + "" +
            "?ExternalSource=" + yeedocProperties.getExternalSource() +
            "&ExternalToken=" + externalToken;
        log.debug("[易道壳]-preViewItemUrl:{}", preViewItemUrl);
        return executePost(preViewItemUrl, new HashMap<>(3));
    }

    /**
     * 在易道壳返回浏览链接
     *
     * @param itemId
     */
    @Override
    public String preViewItemPro(String itemId) {
        String yeedocJwt = getYeedocJwt();
        String preViewItemUrl = yeedocProperties.getYeeDocLinkUrl() + "/itemapi/Item/GetItemDetailForTwCrm";
        HashMap<String, Object> map = new HashMap<>();
        map.put("ItemId", itemId);
        log.info("[项目文档-易道壳]-preViewItemUrl:{}", preViewItemUrl);
        return executePost(preViewItemUrl, map, yeedocJwt);
    }

    /**
     * 删除易道壳的文件夹
     *
     * @param itemId
     */
    @Override
    public String deleteItem(String itemId) {
        String yeedocJwt = getYeedocJwt();
        return deleteItem(itemId,yeedocJwt);
    }

    /**
     * 删除易稻壳文件
     *
     * @param itemId    itemId
     * @param authToken 身份验证令牌
     * @return {@link String}
     */
    @Override
    public String deleteItem(String itemId, String authToken) {
        if(itemId == null || itemId.isEmpty()){
            return "";
        }
        String deleteItemUrl =  yeedocProperties.getYeeDocLinkUrl() +"/itemapi/Item/ItemRecycled";
        log.info("[项目文档-易道壳]-deleteItemUrl:{}",deleteItemUrl);
        HashMap<String, Object> map = new HashMap<>();
        map.put("ItemId",Collections.singletonList(itemId));
        return executePost(deleteItemUrl,map, authToken);
    }

    /**
     * 通过用户信息生成易稻壳的jwt
     *
     * @param  loginUser
     */
    @Override
    public String getYeedocJwt(SysUserDTO loginUser) {
        String sercretKey = yeedocProperties.getSercretKey();
        Map payloadMap = new HashMap<>();
        Map userInfoMap = new HashMap();
        userInfoMap.put("LoginName",loginUser.getEmail());
        userInfoMap.put("UserName",loginUser.getUsername());
        userInfoMap.put("UserMail",loginUser.getEmail());

        payloadMap.put("jwt", JSONUtil.toJsonStr(userInfoMap));
        payloadMap.put("exp", DateUtil.offsetDay(new Date(),30));
        String token = JwtUtil.getToken(null, payloadMap, sercretKey);

        return token;
    }

    @Override
    public String getYeedocJwt() {
        SysUserDTO loginUser = GlobalUtil.getLoginUser();
        return getYeedocJwt(loginUser);
    }

    @Override
    public String getAllItemsInfo(List<String> fileCodes) {
        String yeedocJwt = getYeedocJwt();
        String itemsInfoUrl = yeedocProperties.getYeeDocLinkUrl() + "/itemapi/Item/GetAllItemsInfo";
        HashMap<String, Object> map = new HashMap<>();
        map.put("ItemIds", fileCodes);
        log.info("获取易稻壳文件详情url:{}", itemsInfoUrl);
        return executePost(itemsInfoUrl, map, yeedocJwt);
    }

    /**
     * 获取现在登录用户的token
     *
     * @return
     */
    private String getToken() {
        final Long userId = GlobalUtil.getLoginUserId();
        PrdOrgEmployeeDO prdOrgEmployeeDO = prdOrgEmployeeDAO.queryByUserId(userId);
        Assert.notNull(prdOrgEmployeeDO, "员工信息未维护");
        return prdOrgEmployeeDO.getPcLoginTicket();
    }

    /**
     * base64加密
     *
     * @param value
     * @return
     */
    private String base64Encrypt(String value) {
        byte[] b;
        String s = null;
        if (StringUtils.isEmpty(value)) {
            return value;
        }
        b = value.getBytes(StandardCharsets.UTF_8);
        if (b != null) {
            s = Base64.getEncoder().encodeToString(b);
        }
        return s;
    }

    /**
     * http post请求
     *
     * @param url 接口url
     * @param map
     * @return 返回接口数据
     */
    private String executePost(String url, Map<String, Object> map) {
        final String param = JSONObject.toJSONString(map);
        String result;
        String status = HttpStatus.SC_OK + "";
        long start = System.currentTimeMillis();
        try {
            result = HttpRequest.post(url)
                .header("Content-Type", "application/json;charset=utf-8")
                .body(param, "application/json")
                //超时，毫秒
                .timeout(20000)
                .execute().body();
        } catch (HttpException e) {
            status = "x";
            result = e.getMessage();
            e.printStackTrace();
        }
        long time = System.currentTimeMillis() - start;
        String finalResult = result;
        String finalStatus = status;
        apiRequestLogService.saveOutLog(ApiRequestLogTypeEnum.YEEDOC, url, RequestMethod.POST, param, "", finalResult, finalStatus, time);
        return result;
    }

    /**
     * http post请求
     *
     * @param url    url
     * @param object 对象
     * @return {@link String}
     */
    @Deprecated
    private String executePost(String url, Object object) {
        final String param = JSONObject.toJSONString(object);
        String result;
        String status = HttpStatus.SC_OK + "";
        long start = System.currentTimeMillis();
        try {
            result = HttpRequest.post(url)
                .header("Content-Type", "application/json;charset=utf-8")
                .body(param, "application/json")
                //超时，毫秒
                .timeout(20000)
                .execute().body();
        } catch (HttpException e) {
            status = "x";
            result = e.getMessage();
            e.printStackTrace();
        }
        long time = System.currentTimeMillis() - start;
        String finalResult = result;
        String finalStatus = status;
        apiRequestLogService.saveOutLog(ApiRequestLogTypeEnum.YEEDOC, url, RequestMethod.POST, param, "", finalResult, finalStatus, time);
        return result;
    }

    /**
     * http post请求
     *
     * @param url    url
     * @param map
     * @param authToken
     * @return {@link String}
     */
    private String executePost(String url,Map<String, Object> map,String authToken) {
        final String param = JSONObject.toJSONString(map);
        String result;
        String status = HttpStatus.SC_OK + "";
        long start = System.currentTimeMillis();
        Map<String, List<String>> headers = new HashMap<>();
        try {
            HttpRequest header = HttpRequest.post(url)
                .header("Content-Type", "application/json;charset=utf-8")
                .header("Source", yeedocProperties.getSource())
                .header("AuthToken", authToken);
            headers = header.headers();
            result = header
                    .body(param, "application/json")
                    //超时，毫秒
                    .timeout(20000)
                    .execute().body();
        } catch (HttpException e) {
            status = "x";
            result = e.getMessage();
            e.printStackTrace();
        }
        long time = System.currentTimeMillis() - start;
        String finalResult = result;
        String finalStatus = status;
        log.info("请求地址：{}，请求参数：{}，请求头：{}，返回结果：{}", url, param, JSONUtil.toJsonStr(headers), result);
        apiRequestLogService.saveOutLog(ApiRequestLogTypeEnum.YEEDOC, url, RequestMethod.POST, param, JSONUtil.toJsonStr(headers), finalResult, finalStatus, time);
        return result;
    }
}
