package com.elitesland.tw.tw5.server.yeedocref.functions;

import com.elitesland.tw.tw5.server.yeedocref.CommonFormulaFunction;
import com.elitesland.tw.tw5.server.yeedocref.TwFormulaFunctionAnnotation;
import org.springframework.stereotype.Component;

import java.time.LocalDate;
import java.util.List;

@Component(CommonFormulaFunction.SERVICE_NAME_PREFIX + TwYearFunction.FUNCTION_CODE)
@TwFormulaFunctionAnnotation(
        name = "获取当前年份",
        code = TwYearFunction.FUNCTION_CODE,
        scope = "COMMON",
        tableName = "",
        params = "",
        description = "获取当前年份",
        enabled = true
)
public class TwYearFunction implements CommonFormulaFunction {

    public static final String FUNCTION_CODE = "GetYear";

    @Override
    public Object exec(List list) {
        return LocalDate.now().getYear() + "";
    }
}
