package com.elitesland.tw.tw5.server.yeedocref.functions;

import com.elitesland.tw.tw5.server.yeedocref.CommonFormulaFunction;
import com.elitesland.tw.tw5.server.yeedocref.TwFormulaFunctionAnnotation;
import org.springframework.stereotype.Component;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;

@Component(CommonFormulaFunction.SERVICE_NAME_PREFIX + TwYearMonthFunction.FUNCTION_CODE)
@TwFormulaFunctionAnnotation(
        name = "获取当前年月",
        code = TwYearMonthFunction.FUNCTION_CODE,
        scope = "COMMON",
        tableName = "",
        params = "",
        description = "获取当前年月",
        enabled = true
)
public class TwYearMonthFunction implements CommonFormulaFunction {

    public static final String FUNCTION_CODE = "GetYearMonth";

    @Override
    public Object exec(List list) {
        return LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM"));
    }
}
