/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.common.funConfig.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.common.funConfig.payload.BusinessTableFieldsPayload;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessTableFieldsQuery;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessTableQuery;
import com.elitesland.tw.tw5.api.common.funConfig.service.BusinessTableFieldsService;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessTableFieldsVO;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessTableVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.funConfig.convert.BusinessTableFieldsConvert;
import com.elitesland.tw.tw5.server.common.funConfig.dao.BusinessTableDAO;
import com.elitesland.tw.tw5.server.common.funConfig.dao.BusinessTableFieldsDAO;
import com.elitesland.tw.tw5.server.common.funConfig.entity.BusinessTableFieldsDO;
import com.elitesland.tw.tw5.server.common.funConfig.repo.BusinessTableFieldsRepo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class BusinessTableFieldsServiceImpl
extends BaseServiceImpl
implements BusinessTableFieldsService {
    private static final Logger log = LoggerFactory.getLogger(BusinessTableFieldsServiceImpl.class);
    private final BusinessTableFieldsRepo businessTableFieldsRepo;
    private final BusinessTableFieldsDAO businessTableFieldsDAO;
    @Resource
    private BusinessTableDAO businessTableDAO;
    @PersistenceContext
    private EntityManager em;

    public PagingVO<BusinessTableFieldsVO> queryPaging(BusinessTableFieldsQuery query) {
        return this.businessTableFieldsDAO.queryPaging(query);
    }

    public List<BusinessTableFieldsVO> query(String tableName) {
        String sql = "select column_name, is_nullable, data_type, column_comment, column_key, extra,column_default,column_type  from information_schema.columns where table_name = ? and table_schema = (select database()) order by ordinal_position";
        Query query = this.em.createNativeQuery(sql);
        query.setParameter(1, (Object)tableName);
        List result = query.getResultList();
        List<BusinessTableFieldsVO> columnInfos = new ArrayList<BusinessTableFieldsVO>();
        for (Object obj : result) {
            Object[] arr = (Object[])obj;
            columnInfos.add(new BusinessTableFieldsVO(tableName, arr[0].toString(), Boolean.valueOf("NO".equals(arr[1])), arr[2].toString(), ObjectUtil.isNotNull((Object)arr[3]) ? arr[3].toString() : null, ObjectUtil.isNotNull((Object)arr[4]) ? arr[4].toString() : null, ObjectUtil.isNotNull((Object)arr[5]) ? arr[5].toString() : null, ObjectUtil.isNotNull((Object)arr[6]) ? arr[6].toString() : null));
        }
        columnInfos = this.getColumnInfos(columnInfos);
        return columnInfos;
    }

    public List<BusinessTableFieldsVO> queryListDynamic(BusinessTableFieldsQuery query) {
        Long tableId;
        OrderItem orderItem = OrderItem.asc((String)"createTime");
        query.setOrders(Arrays.asList(orderItem));
        if (query.getTableName() != null) {
            BusinessTableQuery tableQuery = new BusinessTableQuery();
            tableQuery.setTableNameEquals(query.getTableName());
            List<BusinessTableVO> businessTableVOS = this.businessTableDAO.queryListDynamic(tableQuery);
            if (businessTableVOS == null || businessTableVOS.isEmpty()) {
                throw TwException.error("", "tableName\u5bf9\u5e94\u7684\u8868\u4e0d\u5b58\u5728");
            }
            query.setTableId(businessTableVOS.get(0).getId());
        }
        if ((tableId = query.getTableId()) == null) {
            throw TwException.error("", "tableId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<BusinessTableFieldsVO> businessTableFieldsVOS = this.businessTableFieldsDAO.queryListDynamic(query);
        return businessTableFieldsVOS;
    }

    public List<BusinessTableFieldsVO> queryListDyTableId(Long tableId) {
        BusinessTableFieldsQuery query = new BusinessTableFieldsQuery();
        OrderItem orderItem = OrderItem.asc((String)"createTime");
        query.setOrders(Arrays.asList(orderItem));
        if (tableId == null) {
            throw TwException.error("", "tableId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        query.setTableId(tableId);
        List<BusinessTableFieldsVO> businessTableFieldsVOS = this.businessTableFieldsDAO.queryListDynamic(query);
        if (CollectionUtil.isNotEmpty(businessTableFieldsVOS)) {
            return businessTableFieldsVOS;
        }
        BusinessTableVO businessTableVO = this.businessTableDAO.queryByKey(tableId);
        Assert.notNull((Object)businessTableVO, (String)"\u4e0d\u5b58\u5728");
        businessTableFieldsVOS = this.query(businessTableVO.getTableName());
        businessTableFieldsVOS.forEach(businessTableFieldsVO -> businessTableFieldsVO.setTableId(tableId));
        List<BusinessTableFieldsDO> businessTableFieldsDOS = BusinessTableFieldsConvert.INSTANCE.voToDoList(businessTableFieldsVOS);
        List doList = this.businessTableFieldsRepo.saveAll(businessTableFieldsDOS);
        return BusinessTableFieldsConvert.INSTANCE.toVoList(doList);
    }

    public List<BusinessTableFieldsVO> queryList(BusinessTableFieldsQuery query) {
        Long tableId = query.getTableId();
        if (tableId == null) {
            throw TwException.error("", "tableId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<BusinessTableFieldsVO> businessTableFieldsVOS = this.businessTableFieldsDAO.queryListDynamic(query);
        return businessTableFieldsVOS;
    }

    private List<BusinessTableFieldsVO> getColumnInfos(List<BusinessTableFieldsVO> columnInfos) {
        columnInfos = columnInfos.stream().filter(columnInfo -> !columnInfo.getField().equals("tenant_id") && !columnInfo.getField().equals("delete_flag") && !columnInfo.getField().equals("audit_data_version") && !columnInfo.getField().equals("sec_bu_id") && !columnInfo.getField().equals("sec_user_id") && !columnInfo.getField().equals("tenant_org_id") && !columnInfo.getField().equals("belong_org_id") && !columnInfo.getField().equals("sec_ou_id")).collect(Collectors.toList());
        return columnInfos;
    }

    public BusinessTableFieldsVO queryByKey(Long key) {
        BusinessTableFieldsDO entity = this.businessTableFieldsRepo.findById(key).orElseGet(BusinessTableFieldsDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BusinessTableFieldsVO vo = BusinessTableFieldsConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessTableFieldsVO insert(BusinessTableFieldsPayload payload) {
        if (!StringUtils.isEmpty((CharSequence)payload.getField()) && StringUtils.isEmpty((CharSequence)payload.getFieldKey())) {
            payload.setFieldKey(StrUtil.toCamelCase((CharSequence)payload.getField()));
        }
        BusinessTableFieldsDO entityDo = BusinessTableFieldsConvert.INSTANCE.toDo(payload);
        return BusinessTableFieldsConvert.INSTANCE.toVo((BusinessTableFieldsDO)this.businessTableFieldsRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessTableFieldsVO update(BusinessTableFieldsPayload payload) {
        if (!StringUtils.isEmpty((CharSequence)payload.getField()) && StringUtils.isEmpty((CharSequence)payload.getFieldKey())) {
            payload.setFieldKey(StrUtil.toCamelCase((CharSequence)payload.getField()));
        }
        BusinessTableFieldsDO entity = this.businessTableFieldsRepo.findById(payload.getId()).orElseGet(BusinessTableFieldsDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BusinessTableFieldsDO entityDo = BusinessTableFieldsConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return BusinessTableFieldsConvert.INSTANCE.toVo((BusinessTableFieldsDO)this.businessTableFieldsRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(BusinessTableFieldsPayload payload) {
        BusinessTableFieldsDO entity = this.businessTableFieldsRepo.findById(payload.getId()).orElseGet(BusinessTableFieldsDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.businessTableFieldsDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.businessTableFieldsDAO.deleteSoft(keys);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void syncColumn(List<Long> tableIdList) {
        for (Long tableId : tableIdList) {
            BusinessTableVO businessTableVO = this.businessTableDAO.queryByKey(tableId);
            Assert.notNull((Object)businessTableVO, (String)"\u4e0d\u5b58\u5728");
            BusinessTableFieldsQuery query = new BusinessTableFieldsQuery();
            query.setTableId(tableId);
            List<BusinessTableFieldsVO> oldList = this.queryList(query);
            List<BusinessTableFieldsVO> newList = this.query(businessTableVO.getTableName());
            for (BusinessTableFieldsVO columnInfo : newList) {
                List columns = oldList.stream().filter(c -> c.getField().equals(columnInfo.getField())).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(columns)) {
                    BusinessTableFieldsVO column = (BusinessTableFieldsVO)columns.get(0);
                    column.setType(columnInfo.getType());
                    column.setExt1(columnInfo.getExt1());
                    column.setExt2(columnInfo.getExt2());
                    if (StringUtils.isBlank((CharSequence)column.getRemark())) {
                        column.setRemark(columnInfo.getRemark());
                    }
                    BusinessTableFieldsPayload businessTableFieldsPayload = BusinessTableFieldsConvert.INSTANCE.toPayload(column);
                    this.businessTableFieldsDAO.updateByKeyDynamic(businessTableFieldsPayload);
                    continue;
                }
                columnInfo.setTableId(tableId);
                BusinessTableFieldsPayload businessTableFieldsPayload = BusinessTableFieldsConvert.INSTANCE.toPayload(columnInfo);
                this.insert(businessTableFieldsPayload);
            }
        }
    }

    public BusinessTableFieldsServiceImpl(BusinessTableFieldsRepo businessTableFieldsRepo, BusinessTableFieldsDAO businessTableFieldsDAO) {
        this.businessTableFieldsRepo = businessTableFieldsRepo;
        this.businessTableFieldsDAO = businessTableFieldsDAO;
    }
}

