/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.log.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.log.constant.ApiRequestLogTypeEnum;
import com.elitesland.tw.tw5.server.log.dto.ApiRequestLogQuery;
import com.elitesland.tw.tw5.server.log.entity.ApiRequestLogDO;
import com.elitesland.tw.tw5.server.log.service.ApiRequestLogService;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.EnumUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/request"})
public class ApiRequestLogController {
    private static final Logger log = LoggerFactory.getLogger(ApiRequestLogController.class);
    private final ApiRequestLogService service;

    @GetMapping(value={"/log/{key}"})
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        boolean isSystemAdmin = GlobalUtil.getLoginGeneralUser().isSystemAdmin();
        if (!isSystemAdmin) {
            return TwOutputUtil.ok();
        }
        ApiRequestLogDO entity = this.service.queryByKey(key);
        return TwOutputUtil.ok(entity);
    }

    @GetMapping(value={"/log/paging"})
    public TwOutputUtil paging(ApiRequestLogQuery query) {
        boolean isSystemAdmin = GlobalUtil.getLoginGeneralUser().isSystemAdmin();
        if (!isSystemAdmin) {
            return TwOutputUtil.ok();
        }
        PagingVO<ApiRequestLogDO> paging = this.service.paging(query);
        return TwOutputUtil.ok(paging);
    }

    @GetMapping(value={"/log/logTypeList"})
    public TwOutputUtil logTypeList() {
        boolean isSystemAdmin = GlobalUtil.getLoginGeneralUser().isSystemAdmin();
        if (!isSystemAdmin) {
            return TwOutputUtil.ok();
        }
        List enumList = EnumUtils.getEnumList(ApiRequestLogTypeEnum.class);
        return TwOutputUtil.ok(enumList.stream().map(apiRequestLogTypeEnum -> {
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put("code", apiRequestLogTypeEnum.getCode());
            map.put("desc", apiRequestLogTypeEnum.getDesc());
            return map;
        }).collect(Collectors.toList()));
    }

    @DeleteMapping(value={"/log/deleteSoft"})
    public TwOutputUtil deleteSoft(Long[] keys) {
        boolean isSystemAdmin = GlobalUtil.getLoginGeneralUser().isSystemAdmin();
        if (isSystemAdmin) {
            this.service.deleteSoft(Arrays.asList(keys));
        }
        return TwOutputUtil.ok();
    }

    @DeleteMapping(value={"/log/delete"})
    public TwOutputUtil delete(Long[] keys) {
        boolean isSystemAdmin = GlobalUtil.getLoginGeneralUser().isSystemAdmin();
        if (isSystemAdmin) {
            this.service.delete(Arrays.asList(keys));
        }
        return TwOutputUtil.ok();
    }

    public ApiRequestLogController(ApiRequestLogService service) {
        this.service = service;
    }
}

