/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.acc.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSettingOverduePayload;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSettingPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimSettingOverdueDiscuntQuery;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimSettingOverdueQuery;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimSettingQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimSettingOverdueDiscuntService;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimSettingOverdueService;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimSettingService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSettingOverdueDiscuntVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSettingOverdueVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSettingVO;
import com.elitesland.tw.tw5.api.prd.inv.query.InvInvoiceQuery;
import com.elitesland.tw.tw5.api.prd.inv.service.InvInvoiceService;
import com.elitesland.tw.tw5.api.prd.inv.vo.InvInvoiceVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.acc.common.functionEnum.AccReimSettingTypeEnum;
import com.elitesland.tw.tw5.server.prd.acc.convert.AccReimSettingConvert;
import com.elitesland.tw.tw5.server.prd.acc.convert.AccReimSettingOverdueConvert;
import com.elitesland.tw.tw5.server.prd.acc.convert.AccReimSettingOverdueDiscuntConvert;
import com.elitesland.tw.tw5.server.prd.acc.dao.AccReimSettingOverdueDAO;
import com.elitesland.tw.tw5.server.prd.acc.dao.AccReimSettingOverdueDiscuntDAO;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccReimSettingDO;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccReimSettingOverdueDO;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccReimSettingOverdueDiscuntDO;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccReimSettingOverdueDiscuntRepo;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccReimSettingOverdueRepo;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccReimSettingRepo;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class AccReimSettingOverdueServiceImpl
extends BaseServiceImpl
implements AccReimSettingOverdueService {
    private static final Logger log = LoggerFactory.getLogger(AccReimSettingOverdueServiceImpl.class);
    private final AccReimSettingOverdueRepo accReimSettingOverdueRepo;
    private final AccReimSettingOverdueDAO accReimSettingOverdueDAO;
    private final AccReimSettingService accReimSettingService;
    private final AccReimSettingRepo accReimSettingRepo;
    private final AccReimSettingOverdueDiscuntRepo accReimSettingOverdueDiscuntRepo;
    private final AccReimSettingOverdueDiscuntDAO accReimSettingOverdueDiscuntDAO;
    private final AccReimSettingOverdueDiscuntService accReimSettingOverdueDiscuntService;
    private final InvInvoiceService invInvoiceService;

    public PagingVO<AccReimSettingOverdueVO> queryPaging(AccReimSettingOverdueQuery query) {
        return this.accReimSettingOverdueDAO.queryPaging(query);
    }

    public List<AccReimSettingOverdueVO> queryListDynamic(AccReimSettingOverdueQuery query) {
        return this.accReimSettingOverdueDAO.queryListDynamic(query);
    }

    public AccReimSettingOverdueVO queryByKey(Long key) {
        AccReimSettingOverdueDO entity = this.accReimSettingOverdueRepo.findById(key).orElseGet(AccReimSettingOverdueDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        AccReimSettingOverdueVO vo = AccReimSettingOverdueConvert.INSTANCE.toVo(entity);
        AccReimSettingQuery accReimSettingQuery = new AccReimSettingQuery();
        accReimSettingQuery.setSpecificReimSettingId(key);
        accReimSettingQuery.setReimSettingType(AccReimSettingTypeEnum.OVERDUE.getCode());
        List accReimSettingVOS = this.accReimSettingService.queryListDynamic(accReimSettingQuery);
        if (!CollectionUtils.isEmpty((Collection)accReimSettingVOS)) {
            vo.setAccReimSettingVO((AccReimSettingVO)accReimSettingVOS.get(0));
        }
        AccReimSettingOverdueDiscuntQuery accReimSettingOverdueDiscuntQuery = new AccReimSettingOverdueDiscuntQuery();
        accReimSettingOverdueDiscuntQuery.setReimSettingOverdueId(key);
        List accReimSettingOverdueDiscuntVOS = this.accReimSettingOverdueDiscuntService.queryListDynamic(accReimSettingOverdueDiscuntQuery);
        vo.setAccReimSettingOverdueDiscuntVOList(accReimSettingOverdueDiscuntVOS);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public AccReimSettingOverdueVO insert(AccReimSettingOverduePayload payload) {
        AccReimSettingPayload accReimSettingPayload = payload.getAccReimSettingPayload();
        AccReimSettingOverdueDO entityDo = AccReimSettingOverdueConvert.INSTANCE.toDo(payload);
        AccReimSettingOverdueVO accReimSettingOverdueVO = AccReimSettingOverdueConvert.INSTANCE.toVo((AccReimSettingOverdueDO)this.accReimSettingOverdueRepo.save(entityDo));
        Long id = accReimSettingOverdueVO.getId();
        accReimSettingPayload.setSpecificReimSettingId(id);
        accReimSettingPayload.setReimSettingType(AccReimSettingTypeEnum.OVERDUE.getCode());
        this.accReimSettingService.checkRepeat(accReimSettingPayload);
        AccReimSettingDO accReimSettingDO = AccReimSettingConvert.INSTANCE.toDo(accReimSettingPayload);
        AccReimSettingVO accReimSettingVO = AccReimSettingConvert.INSTANCE.toVo((AccReimSettingDO)this.accReimSettingRepo.save(accReimSettingDO));
        accReimSettingOverdueVO.setAccReimSettingVO(accReimSettingVO);
        List accReimSettingOverdueDiscuntPayloadList = payload.getAccReimSettingOverdueDiscuntPayloadList();
        accReimSettingOverdueDiscuntPayloadList.stream().forEach(e -> e.setReimSettingOverdueId(id));
        if (!accReimSettingOverdueDiscuntPayloadList.isEmpty()) {
            List<AccReimSettingOverdueDiscuntDO> accReimSettingOverdueDiscuntDOS = AccReimSettingOverdueDiscuntConvert.INSTANCE.toDoList(accReimSettingOverdueDiscuntPayloadList);
            List accReimSettingOverdueDiscuntVOS = AccReimSettingOverdueDiscuntConvert.INSTANCE.toVoList(this.accReimSettingOverdueDiscuntRepo.saveAll(accReimSettingOverdueDiscuntDOS));
            accReimSettingOverdueVO.setAccReimSettingOverdueDiscuntVOList(accReimSettingOverdueDiscuntVOS);
        }
        return accReimSettingOverdueVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public AccReimSettingOverdueVO update(AccReimSettingOverduePayload payload) {
        AccReimSettingPayload accReimSettingPayload = payload.getAccReimSettingPayload();
        this.accReimSettingService.checkRepeat(accReimSettingPayload);
        List deleteAccReimSettingOverdueDiscuntKeys = payload.getDeleteAccReimSettingOverdueDiscuntKeys();
        if (!CollectionUtils.isEmpty((Collection)deleteAccReimSettingOverdueDiscuntKeys)) {
            this.accReimSettingOverdueDiscuntDAO.deleteSoft(deleteAccReimSettingOverdueDiscuntKeys);
        }
        AccReimSettingOverdueDO entity = this.accReimSettingOverdueRepo.findById(payload.getId()).orElseGet(AccReimSettingOverdueDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        AccReimSettingOverdueDO entityDo = AccReimSettingOverdueConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        AccReimSettingOverdueVO accReimSettingOverdueVO = AccReimSettingOverdueConvert.INSTANCE.toVo((AccReimSettingOverdueDO)this.accReimSettingOverdueRepo.save(entity));
        AccReimSettingDO accReimSettingEntity = this.accReimSettingRepo.findById(accReimSettingPayload.getId()).orElseGet(AccReimSettingDO::new);
        Assert.notNull((Object)accReimSettingEntity.getId(), (String)"\u4e0d\u5b58\u5728");
        AccReimSettingDO accReimSettingDO = AccReimSettingConvert.INSTANCE.toDo(accReimSettingPayload);
        accReimSettingEntity.copy(accReimSettingDO);
        AccReimSettingVO accReimSettingVO = AccReimSettingConvert.INSTANCE.toVo((AccReimSettingDO)this.accReimSettingRepo.save(accReimSettingEntity));
        accReimSettingOverdueVO.setAccReimSettingVO(accReimSettingVO);
        List accReimSettingOverdueDiscuntPayloadList = payload.getAccReimSettingOverdueDiscuntPayloadList();
        if (!accReimSettingOverdueDiscuntPayloadList.isEmpty()) {
            List<AccReimSettingOverdueDiscuntDO> accReimSettingOverdueDiscuntDOS = AccReimSettingOverdueDiscuntConvert.INSTANCE.toDoList(accReimSettingOverdueDiscuntPayloadList);
            ArrayList<AccReimSettingOverdueDiscuntVO> accReimSettingOverdueDiscuntVOS = new ArrayList<AccReimSettingOverdueDiscuntVO>();
            for (AccReimSettingOverdueDiscuntDO accReimSettingOverdueDiscuntDO : accReimSettingOverdueDiscuntDOS) {
                if (accReimSettingOverdueDiscuntDO.getId() != null) {
                    AccReimSettingOverdueDiscuntDO accReimSettingOverdueDiscuntEntity = this.accReimSettingOverdueDiscuntRepo.findById(accReimSettingOverdueDiscuntDO.getId()).orElseGet(AccReimSettingOverdueDiscuntDO::new);
                    Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
                    accReimSettingOverdueDiscuntEntity.copy(accReimSettingOverdueDiscuntDO);
                    accReimSettingOverdueDiscuntVOS.add(AccReimSettingOverdueDiscuntConvert.INSTANCE.toVo((AccReimSettingOverdueDiscuntDO)this.accReimSettingOverdueDiscuntRepo.save(accReimSettingOverdueDiscuntEntity)));
                    continue;
                }
                accReimSettingOverdueDiscuntDO.setReimSettingOverdueId(payload.getId());
                accReimSettingOverdueDiscuntVOS.add(AccReimSettingOverdueDiscuntConvert.INSTANCE.toVo((AccReimSettingOverdueDiscuntDO)this.accReimSettingOverdueDiscuntRepo.save(accReimSettingOverdueDiscuntDO)));
            }
            accReimSettingOverdueVO.setAccReimSettingOverdueDiscuntVOList(accReimSettingOverdueDiscuntVOS);
        }
        return accReimSettingOverdueVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(AccReimSettingOverduePayload payload) {
        AccReimSettingOverdueDO entity = this.accReimSettingOverdueRepo.findById(payload.getId()).orElseGet(AccReimSettingOverdueDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.accReimSettingOverdueDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.accReimSettingOverdueDAO.deleteSoft(keys);
        }
    }

    public AccReimSettingOverdueVO ruleCheck(Long key, String expenseDate, String invoiceNo, Long reimUserId) {
        List idList;
        LocalDate compareDate = LocalDate.parse(expenseDate);
        AccReimSettingOverdueVO accReimSettingOverdueVO = this.queryByKey(key);
        AccReimSettingVO accReimSettingVO = accReimSettingOverdueVO.getAccReimSettingVO();
        String whiteList = accReimSettingVO.getWhiteList();
        if (StringUtils.hasText((String)whiteList) && (idList = Arrays.stream(whiteList.split(",")).map(Long::parseLong).collect(Collectors.toList())).contains(reimUserId)) {
            return accReimSettingOverdueVO;
        }
        String overdueStartDate = accReimSettingOverdueVO.getOverdueStartDate();
        if (overdueStartDate.equals("INVOICE_DATE")) {
            InvInvoiceQuery invInvoiceQuery = new InvInvoiceQuery();
            invInvoiceQuery.setInvoiceNo(invoiceNo);
            List invInvoiceVOS = this.invInvoiceService.queryListDynamic(invInvoiceQuery);
            InvInvoiceVO invInvoiceVO = new InvInvoiceVO();
            if (CollectionUtils.isEmpty((Collection)invInvoiceVOS)) {
                throw TwException.error("", "\u672a\u627e\u5230\u5bf9\u5e94\u7684\u53d1\u7968");
            }
            invInvoiceVO = (InvInvoiceVO)invInvoiceVOS.get(0);
            String invoiceDate = invInvoiceVO.getInvoiceDate();
            compareDate = LocalDate.parse(invoiceDate);
        }
        long daysBetween = ChronoUnit.DAYS.between(compareDate, LocalDate.now());
        List accReimSettingOverdueDiscuntVOList = accReimSettingOverdueVO.getAccReimSettingOverdueDiscuntVOList();
        for (AccReimSettingOverdueDiscuntVO accReimSettingOverdueDiscuntVO : accReimSettingOverdueDiscuntVOList) {
            Integer minDays = accReimSettingOverdueDiscuntVO.getMinDays();
            Integer maxDays = accReimSettingOverdueDiscuntVO.getMaxDays();
            if (daysBetween < (long)minDays.intValue() || (maxDays == null || (long)maxDays.intValue() < daysBetween) && maxDays != null) continue;
            BigDecimal invLimit = accReimSettingOverdueDiscuntVO.getInvLimit();
            accReimSettingOverdueVO.setInvLimit(invLimit);
            if (accReimSettingVO.getRemindText() != null) {
                accReimSettingVO.setRemindText(accReimSettingVO.getRemindText().replace("#{1}", String.valueOf(daysBetween)).replace("#{2}", String.valueOf(invLimit)));
            }
            if (accReimSettingVO.getErrorText() == null) continue;
            accReimSettingVO.setErrorText(accReimSettingVO.getErrorText().replace("#{1}", String.valueOf(daysBetween)).replace("#{2}", String.valueOf(invLimit)));
        }
        return accReimSettingOverdueVO;
    }

    public AccReimSettingOverdueServiceImpl(AccReimSettingOverdueRepo accReimSettingOverdueRepo, AccReimSettingOverdueDAO accReimSettingOverdueDAO, AccReimSettingService accReimSettingService, AccReimSettingRepo accReimSettingRepo, AccReimSettingOverdueDiscuntRepo accReimSettingOverdueDiscuntRepo, AccReimSettingOverdueDiscuntDAO accReimSettingOverdueDiscuntDAO, AccReimSettingOverdueDiscuntService accReimSettingOverdueDiscuntService, InvInvoiceService invInvoiceService) {
        this.accReimSettingOverdueRepo = accReimSettingOverdueRepo;
        this.accReimSettingOverdueDAO = accReimSettingOverdueDAO;
        this.accReimSettingService = accReimSettingService;
        this.accReimSettingRepo = accReimSettingRepo;
        this.accReimSettingOverdueDiscuntRepo = accReimSettingOverdueDiscuntRepo;
        this.accReimSettingOverdueDiscuntDAO = accReimSettingOverdueDiscuntDAO;
        this.accReimSettingOverdueDiscuntService = accReimSettingOverdueDiscuntService;
        this.invInvoiceService = invInvoiceService;
    }
}

