/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.acc.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimTripStdPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimTripStdQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimTripStdService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimTripStdVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.server.prd.acc.convert.AccReimTripStdConvert;
import com.elitesland.tw.tw5.server.prd.acc.dao.AccReimTripStdDAO;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccReimTripStdDO;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccReimTripStdRepo;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.salecon.common.functionEnum.ConCustBearEnum;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
public class AccReimTripStdServiceImpl
extends BaseServiceImpl
implements AccReimTripStdService {
    private static final Logger log = LoggerFactory.getLogger(AccReimTripStdServiceImpl.class);
    @Value(value="${tw5.reim.trip.breakfastScale:0.2}")
    private BigDecimal breakfastScale;
    @Value(value="${tw5.reim.trip.lunchScale:0.4}")
    private BigDecimal lunchScale;
    @Value(value="${tw5.reim.trip.dinnerScale:0.4}")
    private BigDecimal dinnerScale;
    @Value(value="${tw5.reim.trip.deductFee:10}")
    private BigDecimal deductFee;
    private final AccReimTripStdRepo repo;
    private final AccReimTripStdDAO dao;
    private final PrdOrgEmployeeService employeeService;

    public PagingVO<AccReimTripStdVO> queryPaging(AccReimTripStdQuery query) {
        return this.dao.queryPaging(query);
    }

    public List<AccReimTripStdVO> queryListDynamic(AccReimTripStdQuery query) {
        List<AccReimTripStdVO> voList;
        if (ObjectUtils.isEmpty((Object)query.getJobGrade())) {
            Long userId = GlobalUtil.getLoginUserId();
            PrdOrgEmployeeVO prdOrgEmployeeVO = this.employeeService.queryByUserId(userId);
            String jobGrade = prdOrgEmployeeVO.getExtString1();
            query.setJobGrade(jobGrade);
        }
        if (ObjectUtils.isEmpty(voList = this.dao.queryListDynamic(query))) {
            return voList;
        }
        voList.forEach(vo -> {
            BigDecimal oriFeeAmt = vo.getFeeAmt();
            BigDecimal breakfastFee = oriFeeAmt.multiply(this.breakfastScale);
            BigDecimal lunchFee = oriFeeAmt.multiply(this.lunchScale);
            BigDecimal dinnerFee = oriFeeAmt.multiply(this.dinnerScale);
            if (!ObjectUtils.isEmpty((Object)query.getExpenseByType()) && ConCustBearEnum.SUPP_MEALS.getCode().equals(query.getExpenseByType())) {
                breakfastFee = breakfastFee.subtract(this.deductFee);
                lunchFee = lunchFee.subtract(this.deductFee);
                dinnerFee = dinnerFee.subtract(this.deductFee);
                oriFeeAmt = oriFeeAmt.subtract(this.deductFee.multiply(new BigDecimal(3)));
            }
            vo.setFeeAmt(oriFeeAmt);
            vo.setBreakfastFee(breakfastFee);
            vo.setLunchFee(lunchFee);
            vo.setDinnerFee(dinnerFee);
        });
        return voList;
    }

    public AccReimTripStdVO queryByKey(Long key) {
        return this.dao.queryByKey(key);
    }

    @Transactional
    public AccReimTripStdVO insert(AccReimTripStdPayload payload) {
        AccReimTripStdDO entityDo = AccReimTripStdConvert.INSTANCE.toDo(payload);
        return AccReimTripStdConvert.INSTANCE.toVo((AccReimTripStdDO)this.repo.save(entityDo));
    }

    @Transactional
    public AccReimTripStdVO update(AccReimTripStdPayload payload) {
        AccReimTripStdDO entity = this.repo.findById(payload.getId()).orElseGet(AccReimTripStdDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        AccReimTripStdDO entityDo = AccReimTripStdConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return AccReimTripStdConvert.INSTANCE.toVo((AccReimTripStdDO)this.repo.save(entity));
    }

    @Transactional
    public long updateByKeyDynamic(AccReimTripStdPayload payload) {
        AccReimTripStdDO entity = this.repo.findById(payload.getId()).orElseGet(AccReimTripStdDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.dao.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.dao.deleteSoft(keys);
        }
    }

    public AccReimTripStdServiceImpl(AccReimTripStdRepo repo, AccReimTripStdDAO dao, PrdOrgEmployeeService employeeService) {
        this.repo = repo;
        this.dao = dao;
        this.employeeService = employeeService;
    }
}

