/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.cal.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalEqvaCostPayload;
import com.elitesland.tw.tw5.api.prd.cal.query.CalEqvaCostQuery;
import com.elitesland.tw.tw5.api.prd.cal.service.CalEqvaCostService;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalEqvaCostVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.cal.convert.CalEqvaCostConvert;
import com.elitesland.tw.tw5.server.prd.cal.dao.CalEqvaCostDAO;
import com.elitesland.tw.tw5.server.prd.cal.entity.CalEqvaCostDO;
import com.elitesland.tw.tw5.server.prd.cal.repo.CalEqvaCostRepo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class CalEqvaCostServiceImpl
extends BaseServiceImpl
implements CalEqvaCostService {
    private static final Logger log = LoggerFactory.getLogger(CalEqvaCostServiceImpl.class);
    private final CalEqvaCostRepo calEqvaCostRepo;
    private final CalEqvaCostDAO calEqvaCostDAO;

    public PagingVO<CalEqvaCostVO> queryPaging(CalEqvaCostQuery query) {
        PagingVO<CalEqvaCostVO> calEqvaCostVOPagingVO = this.calEqvaCostDAO.queryPaging(query);
        if (calEqvaCostVOPagingVO.getTotal() > 0L) {
            calEqvaCostVOPagingVO.getRecords().forEach(this::translateData);
        }
        return calEqvaCostVOPagingVO;
    }

    public List<CalEqvaCostVO> queryListDynamic(CalEqvaCostQuery query) {
        return this.calEqvaCostDAO.queryListDynamic(query);
    }

    public CalEqvaCostVO queryByKey(Long key) {
        CalEqvaCostVO calEqvaCostVO = this.calEqvaCostDAO.queryByKey(key);
        this.translateData(calEqvaCostVO);
        return calEqvaCostVO;
    }

    void translateData(CalEqvaCostVO calEqvaCostVO) {
        if (calEqvaCostVO.getFinYear() != null && calEqvaCostVO.getFinPeriod() != null) {
            String finPeriodName = calEqvaCostVO.getFinYear() + "-" + (calEqvaCostVO.getFinPeriod() > 9 ? "" + calEqvaCostVO.getFinPeriod() : "0" + calEqvaCostVO.getFinPeriod());
            calEqvaCostVO.setFinPeriodName(finPeriodName);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public CalEqvaCostVO insertOrUpdate(CalEqvaCostPayload payload) {
        this.checkDate(payload);
        CalEqvaCostDO entityDo = CalEqvaCostConvert.INSTANCE.toDo(payload);
        return CalEqvaCostConvert.INSTANCE.toVo((CalEqvaCostDO)this.calEqvaCostRepo.save(entityDo));
    }

    void checkDate(CalEqvaCostPayload payload) {
        if (payload.getFinPeriod() != null && payload.getFinYear() == null) {
            throw TwException.error("", "\u671f\u95f4\u5b58\u5728\uff0c\u5e74\u5ea6\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (StringUtils.hasText((String)payload.getJobType2()) && !StringUtils.hasText((String)payload.getJobType1())) {
            throw TwException.error("", "\u5de5\u79cd\u5b50\u7c7b\u5b58\u5728\uff0c\u5de5\u79cd\u4e0d\u53ef\u4e3a\u7a7a");
        }
        CalEqvaCostQuery calEqvaCostQuery = CalEqvaCostConvert.INSTANCE.toQuery(payload);
        List<Long> longs = this.calEqvaCostDAO.queryCheckData(calEqvaCostQuery);
        if (!(ObjectUtils.isEmpty(longs) || payload.getId() != null && longs.size() <= 1 && longs.get(0).equals(payload.getId()))) {
            throw TwException.error("", "\u5b58\u5728\u76f8\u540c\u6210\u672c\u914d\u7f6e");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.calEqvaCostDAO.deleteSoft(keys);
        }
    }

    public CalEqvaCostVO getEqvaCostPlus(CalEqvaCostQuery query) {
        return this.calEqvaCostDAO.getEqvaCostPlus(query);
    }

    public CalEqvaCostServiceImpl(CalEqvaCostRepo calEqvaCostRepo, CalEqvaCostDAO calEqvaCostDAO) {
        this.calEqvaCostRepo = calEqvaCostRepo;
        this.calEqvaCostDAO = calEqvaCostDAO;
    }
}

