/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.controller;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityOutCostPayload;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityOutCostService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityOutCostVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.permission.annotation.FunctionDetail;
import com.elitesland.tw.tw5.server.common.permission.annotation.PermissionDomain;
import com.elitesland.tw.tw5.server.common.permission.annotation.PermissionFunction;
import com.elitesland.tw.tw5.server.common.permission.enums.FunctionCodeEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.FunctionTypeEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionDomainEnum;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/crm"})
@PermissionDomain(domain=PermissionDomainEnum.OUTCOST)
public class CrmOpportunityOutCostController {
    private static final Logger log = LoggerFactory.getLogger(CrmOpportunityOutCostController.class);
    private final CrmOpportunityOutCostService service;

    @PostMapping(value={"/oppo/outCost/insert"})
    public TwOutputUtil insert(CrmOpportunityOutCostPayload payload) {
        CrmOpportunityOutCostVO vo = this.service.insert(payload);
        return TwOutputUtil.ok(vo);
    }

    @PostMapping(value={"/oppo/outCost/submit/{id}"})
    public TwOutputUtil submit(@PathVariable Long id) {
        this.service.submit(id);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/oppo/outCost/queryById/{id}"})
    public TwOutputUtil queryById(@PathVariable Long id) {
        return TwOutputUtil.ok(this.service.queryById(id));
    }

    @PutMapping(value={"/oppo/outCost/update"})
    public TwOutputUtil update(CrmOpportunityOutCostPayload payload) {
        this.service.update(payload);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/oppo/outCost/queryList"})
    @UdcNameClass
    @PermissionFunction(functions={@FunctionDetail(functionCode=FunctionCodeEnum.OUTCOST_PAGE, type=FunctionTypeEnum.TAB, referDomain={PermissionDomainEnum.BUSINESS_OPPORTUNITY})})
    public TwOutputUtil queryList(Long oppoId) {
        return TwOutputUtil.ok(this.service.queryList(oppoId));
    }

    @DeleteMapping(value={"/oppo/outCost/deleteSoft"})
    public TwOutputUtil deleteSoft(Long oppoId, Long[] keys) {
        this.service.deleteSoft(oppoId, Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    public CrmOpportunityOutCostController(CrmOpportunityOutCostService service) {
        this.service = service;
    }
}

