/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.dao;

import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerDataVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerOperationVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.crm.constant.CustomerOperationTypeEnum;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmCustomerOperationDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmCustomerOperationEnterpriseInfoDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmOpportunityDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmPeopleDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmCustomerOperationRepo;
import com.elitesland.tw.tw5.server.prd.partner.common.entity.QBookAccountDO;
import com.elitesland.tw.tw5.server.prd.partner.common.entity.QBookInvoiceDO;
import com.elitesland.tw.tw5.server.prd.partner.common.entity.QBusinessPartnerDO;
import com.elitesland.tw.tw5.server.prd.prj.entity.QPrjProjectDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class CrmCustomerOperationDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final CrmCustomerOperationRepo repo;
    private final QCrmCustomerOperationDO qdo = QCrmCustomerOperationDO.crmCustomerOperationDO;
    private final QBusinessPartnerDO qBusinessPartnerDO = QBusinessPartnerDO.businessPartnerDO;
    private final QBookAccountDO qBookAccountDO = QBookAccountDO.bookAccountDO;
    private final QBookInvoiceDO qBookInvoiceDO = QBookInvoiceDO.bookInvoiceDO;
    private final QCrmCustomerOperationEnterpriseInfoDO operationEnterpriseInfoDO = QCrmCustomerOperationEnterpriseInfoDO.crmCustomerOperationEnterpriseInfoDO;
    private final QCrmOpportunityDO qdoOpportunity = QCrmOpportunityDO.crmOpportunityDO;
    private final QPrjProjectDO qdoProject = QPrjProjectDO.prjProjectDO;
    private final QCrmPeopleDO qdoOperationPeople = QCrmPeopleDO.crmPeopleDO;

    private JPAQuery<CrmCustomerOperationVO> getJpaQuerySelect() {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CrmCustomerOperationVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.custNo, this.qdo.custName, this.qdo.customerId, this.qdo.parentId, this.qdo.parentCompany, this.qdo.remark, this.qdo.createUserId, this.qdo.creator, this.qdo.createTime})).from((EntityPath)this.qdo);
        return jpaQuery;
    }

    public CrmCustomerOperationVO queryCrmCustomerOperationVOByCustomerId(long customerId) {
        JPAQuery<CrmCustomerOperationVO> query = this.getJpaQuerySelect();
        return (CrmCustomerOperationVO)((JPAQuery)((JPAQuery)query.where((Predicate)this.qdo.deleteFlag.eq((Object)0))).where((Predicate)this.qdo.customerId.eq((Object)customerId))).fetchFirst();
    }

    public CrmCustomerOperationVO queryById(Long id) {
        JPAQuery<CrmCustomerOperationVO> jpaQuerySelect = this.getJpaQuerySelect();
        ((JPAQuery)jpaQuerySelect.where((Predicate)this.qdo.deleteFlag.eq((Object)0))).where((Predicate)this.qdo.id.eq((Object)id));
        return (CrmCustomerOperationVO)jpaQuerySelect.fetchFirst();
    }

    private JPAQuery<CrmCustomerDataVO> getJpaQuerySelect0() {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CrmCustomerDataVO.class, (Expression[])new Expression[]{this.qBusinessPartnerDO.id, this.qBusinessPartnerDO.bookId, this.qBusinessPartnerDO.partnerName.as("customerName"), this.qBookAccountDO.depositBank, this.qBookAccountDO.accountNo, this.qBookInvoiceDO.invoiceAddress, this.qBookInvoiceDO.invoicePhone})).from((EntityPath)this.qBusinessPartnerDO)).leftJoin((EntityPath)this.qBookAccountDO)).on((Predicate)this.qBookAccountDO.bookId.longValue().eq((Expression)this.qBusinessPartnerDO.bookId.longValue()).and((Predicate)this.qBookAccountDO.deleteFlag.eq((Object)0)).and((Predicate)this.qBookAccountDO.isDefault.eq(Boolean.valueOf(true))))).leftJoin((EntityPath)this.qBookInvoiceDO)).on((Predicate)this.qBookInvoiceDO.bookId.longValue().eq((Expression)this.qBusinessPartnerDO.bookId.longValue()).and((Predicate)this.qBookInvoiceDO.deleteFlag.eq((Object)0)).and((Predicate)this.qBookInvoiceDO.isDefault.eq(Boolean.valueOf(true))));
        return jpaQuery;
    }

    public CrmCustomerDataVO queryByCustomerId(Long customerId) {
        JPAQuery<CrmCustomerDataVO> jpaQuerySelect = this.getJpaQuerySelect0();
        ((JPAQuery)jpaQuerySelect.where((Predicate)this.qBusinessPartnerDO.deleteFlag.eq((Object)0))).where((Predicate)this.qBusinessPartnerDO.id.eq((Object)customerId));
        return (CrmCustomerDataVO)jpaQuerySelect.fetchFirst();
    }

    public long queryOpportunityCount(Long customerId) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qdoOpportunity.id).from((EntityPath)this.qdoOpportunity)).leftJoin((EntityPath)this.qdoProject)).on((Predicate)this.qdoProject.id.longValue().eq((Expression)this.qdoOpportunity.projectId.longValue()));
        jpaQuery.where((Predicate)this.qdoOpportunity.formalCustomerId.eq((Object)customerId));
        jpaQuery.where((Predicate)this.qdoOpportunity.deleteFlag.eq((Object)0));
        jpaQuery.where((Predicate)this.qdoProject.deleteFlag.eq((Object)0));
        return jpaQuery.fetchCount();
    }

    public long queryOperationPeopleCount(Long operId) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select(this.qdoOperationPeople.id).from((EntityPath)this.qdoOperationPeople);
        jpaQuery.where((Predicate)this.qdoOperationPeople.operId.eq((Object)operId));
        jpaQuery.where((Predicate)this.qdoOperationPeople.deleteFlag.eq((Object)0));
        return jpaQuery.fetchCount();
    }

    public long relationCustomer(Long key, Long customerId) {
        JPAUpdateClause where = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.customerId, (Object)customerId).where(new Predicate[]{this.qdo.id.eq((Object)key)});
        return where.execute();
    }

    public long updateCustOperStatus(Long key, String custOperStatus) {
        return this.jpaQueryFactory.update((EntityPath)this.qdo).set((Path)this.qdo.custOperStatus, (Object)custOperStatus).where(new Predicate[]{this.qdo.id.eq((Object)key)}).execute();
    }

    public List<CrmCustomerOperationVO> findOperationEnterpriseInfoAbsent() {
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CrmCustomerOperationVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.custName, this.qdo.remark})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.operationEnterpriseInfoDO)).on((Predicate)this.qdo.id.eq(this.operationEnterpriseInfoDO.operId).and((Predicate)this.operationEnterpriseInfoDO.deleteFlag.eq((Object)0)))).where((Predicate)this.qdo.deleteFlag.eq((Object)0).and((Predicate)this.qdo.custType.in((Object[])new String[]{CustomerOperationTypeEnum.ENTERPRISE.getCode(), CustomerOperationTypeEnum.ECO_PARTNER.getCode(), CustomerOperationTypeEnum.ENTERPRISE_ECO_PARTNER.getCode()})).and((Predicate)this.operationEnterpriseInfoDO.operId.isNull()))).fetch();
    }

    public List<CrmCustomerOperationVO> queryNeedOperas(LocalDate weekAgoTime) {
        LocalDateTime startOfDay = weekAgoTime.atStartOfDay();
        LocalDateTime endOfDay = weekAgoTime.atTime(LocalTime.MAX);
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CrmCustomerOperationVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.customerId, this.qdo.custName, this.qdo.custOperManagerId, this.qdo.saleOperManagerId})).from((EntityPath)this.qdo);
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        jpaQuery.where((Predicate)this.qdo.industryStand.isEmpty().or((Predicate)this.qdo.saleScale.isNull()).or((Predicate)this.qdo.companyTightness.isEmpty()).or((Predicate)this.qdo.digitalInvestment.isEmpty()).or((Predicate)this.qdo.saleOperBu.isNull()).or((Predicate)this.qdo.historyCooOutput.isNull()).or((Predicate)this.qdo.custOperBu.isNull()).or((Predicate)this.qdo.saleOperManagerId.isNull()).or((Predicate)this.qdo.businessStrategy.isEmpty()).or((Predicate)this.qdo.custOperManagerId.isNull()));
        jpaQuery.where((Predicate)this.qdo.noticeTime.lt((Comparable)endOfDay));
        return jpaQuery.fetch();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public CrmCustomerOperationDAO(JPAQueryFactory jpaQueryFactory, CrmCustomerOperationRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

