/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.service;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmGiftInfoExcelExport;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmGiftInfoPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmPeoplePayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmGiftInfoQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmGiftListQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmGiftInfoService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmPeopleService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmGiftInfoVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.excel.ExcelUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmGiftInfoConvert;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmGiftInfoDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmGiftInfoDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmGiftInfoRepo;
import com.elitesland.tw.tw5.server.prd.my.dao.PrdUserDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
public class CrmGiftInfoServiceImpl
extends BaseServiceImpl
implements CrmGiftInfoService {
    private static final Logger log = LoggerFactory.getLogger(CrmGiftInfoServiceImpl.class);
    private final CrmGiftInfoRepo crmGiftInfoRepo;
    private final CrmGiftInfoDAO crmGiftInfoDAO;
    private final PrdSystemRoleDAO systemRoleDAO;
    private final PrdUserDAO prdUserDAO;
    private final UdcUtil udcUtil;
    private final CacheUtil cacheUtil;
    private final CrmPeopleService crmPeopleService;

    public PagingVO<CrmGiftInfoVO> queryPaging(CrmGiftInfoQuery query) {
        return this.crmGiftInfoDAO.queryPaging(query);
    }

    public PagingVO<CrmGiftInfoVO> pagingByGiftList(CrmGiftListQuery query) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        List<String> roleCodes = this.systemRoleDAO.queryUserRoleCodes(loginUserId);
        if (roleCodes.contains(RoleEnum.GIFT_APPLY_QUERY_ALL.getCode())) {
            PagingVO<CrmGiftInfoVO> pagingVO = this.crmGiftInfoDAO.pagingByGiftList(query);
            if (pagingVO != null && !ObjectUtils.isEmpty((Object)pagingVO.getRecords())) {
                pagingVO.getRecords().forEach(v -> this.transferDatas((CrmGiftInfoVO)v));
            }
            return pagingVO;
        }
        this.getUser(query, loginUserId);
        PagingVO<CrmGiftInfoVO> pagingVO = this.crmGiftInfoDAO.pagingByGiftList(query);
        if (pagingVO != null && !ObjectUtils.isEmpty((Object)pagingVO.getRecords())) {
            pagingVO.getRecords().forEach(v -> this.transferDatas((CrmGiftInfoVO)v));
        }
        return pagingVO;
    }

    public List<CrmGiftInfoVO> byGiftList(CrmGiftListQuery query) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        List<String> roleCodes = this.systemRoleDAO.queryUserRoleCodes(loginUserId);
        if (roleCodes.contains(RoleEnum.GIFT_APPLY_QUERY_ALL.getCode())) {
            List<CrmGiftInfoVO> list = this.crmGiftInfoDAO.byGiftList(query);
            list.forEach(v -> this.transferDatas((CrmGiftInfoVO)v));
            return list;
        }
        this.getUser(query, loginUserId);
        List<CrmGiftInfoVO> list = this.crmGiftInfoDAO.byGiftList(query);
        list.forEach(v -> this.transferDatas((CrmGiftInfoVO)v));
        return list;
    }

    public List<CrmGiftInfoVO> queryListDynamic(CrmGiftInfoQuery query) {
        if (ObjectUtils.isEmpty((Object)query.getGiftListId())) {
            return new ArrayList<CrmGiftInfoVO>();
        }
        return this.crmGiftInfoDAO.queryListDynamic(query);
    }

    public CrmGiftInfoVO queryByKey(Long key) {
        CrmGiftInfoDO entity = this.crmGiftInfoRepo.findById(key).orElseGet(CrmGiftInfoDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        CrmGiftInfoVO vo = CrmGiftInfoConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public CrmGiftInfoVO insert(CrmGiftInfoPayload payload) {
        this.checkDatas(payload);
        CrmGiftInfoDO entityDo = CrmGiftInfoConvert.INSTANCE.toDo(payload);
        return CrmGiftInfoConvert.INSTANCE.toVo((CrmGiftInfoDO)this.crmGiftInfoRepo.save(entityDo));
    }

    public void batchInsert(List<CrmGiftInfoPayload> crmGiftInfoPayloads) {
        ArrayList<CrmGiftInfoDO> infoDOS = new ArrayList<CrmGiftInfoDO>();
        for (CrmGiftInfoPayload payload : crmGiftInfoPayloads) {
            this.checkDatas(payload);
            infoDOS.add(CrmGiftInfoConvert.INSTANCE.toDo(payload));
        }
        this.crmGiftInfoRepo.saveAll(infoDOS);
    }

    public void batchUpdate(List<CrmGiftInfoPayload> crmGiftInfoPayloads) {
        ArrayList<CrmGiftInfoDO> insertList = new ArrayList<CrmGiftInfoDO>();
        ArrayList<CrmGiftInfoDO> updateList = new ArrayList<CrmGiftInfoDO>();
        ArrayList<Long> updateIds = new ArrayList<Long>();
        for (CrmGiftInfoPayload payload : crmGiftInfoPayloads) {
            this.checkDatas(payload);
            if (ObjectUtils.isEmpty((Object)payload.getId())) {
                insertList.add(CrmGiftInfoConvert.INSTANCE.toDo(payload));
                continue;
            }
            updateList.add(CrmGiftInfoConvert.INSTANCE.toDo(payload));
            updateIds.add(payload.getId());
        }
        CrmGiftInfoQuery query = new CrmGiftInfoQuery();
        query.setGiftListId(crmGiftInfoPayloads.get(0).getGiftListId());
        List<CrmGiftInfoVO> fromDB = this.queryListDynamic(query);
        if (!ObjectUtils.isEmpty(fromDB)) {
            List<Long> delList = fromDB.stream().filter(v -> !updateIds.contains(v.getId())).map(v -> v.getId()).collect(Collectors.toList());
            this.deleteSoft(delList);
        }
        if (!ObjectUtils.isEmpty(insertList)) {
            this.crmGiftInfoDAO.saveAll(insertList);
        }
        if (!ObjectUtils.isEmpty(updateList)) {
            this.crmGiftInfoDAO.saveAll(updateList);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public CrmGiftInfoVO update(CrmGiftInfoPayload payload) {
        this.checkDatas(payload);
        CrmGiftInfoDO entity = this.crmGiftInfoRepo.findById(payload.getId()).orElseGet(CrmGiftInfoDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        CrmGiftInfoDO entityDo = CrmGiftInfoConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return CrmGiftInfoConvert.INSTANCE.toVo((CrmGiftInfoDO)this.crmGiftInfoRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(CrmGiftInfoPayload payload) {
        this.checkDatas(payload);
        CrmGiftInfoDO entity = this.crmGiftInfoRepo.findById(payload.getId()).orElseGet(CrmGiftInfoDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.crmGiftInfoDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.crmGiftInfoDAO.deleteSoft(keys);
        }
    }

    public void downloadBatch(HttpServletResponse response, CrmGiftListQuery query) {
        ExcelWriterSheetBuilder sheet;
        String sheetName = "\u793c\u54c1\u5355\u5217\u8868";
        OrderItem orderItem = OrderItem.desc((String)"applyDate");
        query.defaultOrder(orderItem);
        List<CrmGiftInfoVO> records = this.byGiftList(query);
        List resultList = CrmGiftInfoConvert.INSTANCE.voListVoExcelExport(records);
        resultList = this.udcUtil.translateList(resultList);
        String fileName = null;
        try {
            fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
        try {
            sheet = ((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), CrmGiftInfoVO.class).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).sheet(sheetName);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ExcelUtil.excelHelper(sheet, CrmGiftInfoExcelExport.class, null);
        resultList.forEach(v -> v.setApplyDateString(v.getApplyDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"))));
        sheet.doWrite(resultList);
    }

    private void getUser(CrmGiftListQuery query, Long loginUserId) {
        ArrayList<Long> userIds = new ArrayList<Long>();
        userIds.add(loginUserId);
        List<PrdOrgEmployeeRefVO> empRef = this.prdUserDAO.queryLowListByKey(null, loginUserId);
        empRef.forEach(v -> {
            if (!userIds.contains(v.getUserId())) {
                userIds.add(v.getUserId());
            }
        });
        query.setUserIds(userIds);
    }

    void transferDatas(CrmGiftInfoVO vo) {
        vo.setGiftTypeName1(this.cacheUtil.transferSystemSelection("GIFT_TYPE", vo.getGiftType1()));
        vo.setGiftTypeName2(this.cacheUtil.transferSystemSelection("GIFT_TYPE:Festival", vo.getGiftType2()));
        vo.setApplyStatusName(this.cacheUtil.transferSystemSelection("gift:status", vo.getApplyStatus()));
        vo.setCreator(this.cacheUtil.getUserName(vo.getCreateUserId()));
        if (ObjectUtils.isEmpty((Object)vo.getGiftType2())) {
            vo.setGiftTypeName(vo.getGiftTypeName1());
        } else {
            vo.setGiftTypeName(vo.getGiftTypeName1() + "/" + vo.getGiftTypeName2());
        }
    }

    void checkDatas(CrmGiftInfoPayload payload) {
        if (ObjectUtils.isEmpty((Object)payload.getGiftListId())) {
            throw TwException.error("", "\u793c\u54c1\u5355ID\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)payload.getSpecialUsersFlag())) {
            throw TwException.error("", "\u7279\u6b8a\u7533\u8bf7\u7528\u6237\u6807\u5fd7\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)payload.getGiftName())) {
            throw TwException.error("", "\u793c\u54c1\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)payload.getGiftNumber())) {
            throw TwException.error("", "\u7533\u8bf7\u6570\u91cf\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)payload.getPeopleName())) {
            throw TwException.error("", "\u8054\u7cfb\u4eba\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)payload.getMobile())) {
            throw TwException.error("", "\u8054\u7cfb\u65b9\u5f0f\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (!CrmGiftInfoServiceImpl.isValidPhoneNumber(payload.getMobile())) {
            throw TwException.error("", "\u624b\u673a\u53f7\u65e0\u6548");
        }
        if (ObjectUtils.isEmpty((Object)payload.getLocationDetail())) {
            throw TwException.error("", "\u793c\u54c1\u5bc4\u9001\u5730\u5740\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (1 != payload.getSpecialUsersFlag()) {
            if (ObjectUtils.isEmpty((Object)payload.getCustomerId())) {
                throw TwException.error("", "\u5ba2\u6237\u65b9\u4e0d\u53ef\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)payload.getCustName())) {
                throw TwException.error("", "\u5ba2\u6237\u65b9\u4e0d\u53ef\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)payload.getReason())) {
                throw TwException.error("", "\u8d60\u9001\u7406\u7531\u4e0d\u53ef\u4e3a\u7a7a");
            }
            this.createPeople(payload);
        } else if (!ObjectUtils.isEmpty((Object)payload.getCustomerId())) {
            this.createPeople(payload);
        }
    }

    void createPeople(CrmGiftInfoPayload payload) {
        if (ObjectUtils.isEmpty((Object)payload.getId()) && ObjectUtils.isEmpty((Object)payload.getPeopleId())) {
            CrmPeoplePayload peoplePayload = new CrmPeoplePayload();
            peoplePayload.setCustomerId(payload.getCustomerId());
            peoplePayload.setPeopleName(payload.getPeopleName());
            peoplePayload.setMobile(payload.getMobile());
            peoplePayload.setLocationDetail(payload.getLocationDetail());
            peoplePayload.setJobs(payload.getJobDetail());
            peoplePayload.setBu(payload.getCustOperBu());
            this.crmPeopleService.insertOrUpdate(peoplePayload);
        }
    }

    public static boolean isValidPhoneNumber(String phoneNumber) {
        String regex = "^1[3456789]\\d{9}$";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(phoneNumber);
        return matcher.matches();
    }

    public CrmGiftInfoServiceImpl(CrmGiftInfoRepo crmGiftInfoRepo, CrmGiftInfoDAO crmGiftInfoDAO, PrdSystemRoleDAO systemRoleDAO, PrdUserDAO prdUserDAO, UdcUtil udcUtil, CacheUtil cacheUtil, CrmPeopleService crmPeopleService) {
        this.crmGiftInfoRepo = crmGiftInfoRepo;
        this.crmGiftInfoDAO = crmGiftInfoDAO;
        this.systemRoleDAO = systemRoleDAO;
        this.prdUserDAO = prdUserDAO;
        this.udcUtil = udcUtil;
        this.cacheUtil = cacheUtil;
        this.crmPeopleService = crmPeopleService;
    }
}

