/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.visit.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.visit.payload.VisitSignRecordPayload;
import com.elitesland.tw.tw5.api.prd.visit.payload.VisitTaskPayload;
import com.elitesland.tw.tw5.api.prd.visit.query.VisitSignRecordQuery;
import com.elitesland.tw.tw5.api.prd.visit.service.VisitSignRecordService;
import com.elitesland.tw.tw5.api.prd.visit.vo.VisitSignRecordVO;
import com.elitesland.tw.tw5.api.prd.visit.vo.VisitTaskVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.crm.visit.constants.VisitSignTypeEnum;
import com.elitesland.tw.tw5.server.prd.crm.visit.convert.VisitSignRecordConvert;
import com.elitesland.tw.tw5.server.prd.crm.visit.dao.VisitSignRecordDAO;
import com.elitesland.tw.tw5.server.prd.crm.visit.dao.VisitTaskDAO;
import com.elitesland.tw.tw5.server.prd.crm.visit.entity.VisitSignRecordDO;
import com.elitesland.tw.tw5.server.prd.crm.visit.repo.VisitSignRecordRepo;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
public class VisitSignRecordServiceImpl
extends BaseServiceImpl
implements VisitSignRecordService {
    private static final Logger log = LoggerFactory.getLogger(VisitSignRecordServiceImpl.class);
    private final VisitSignRecordRepo visitSignRecordRepo;
    private final VisitSignRecordDAO visitSignRecordDAO;
    private final VisitTaskDAO visitTaskDAO;
    private final FileUtil fileUtil;

    public PagingVO<VisitSignRecordVO> paging(VisitSignRecordQuery query) {
        Page page = this.visitSignRecordRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), (Pageable)query.getPageRequest());
        return PageUtil.toPageVo(page.map(VisitSignRecordConvert.INSTANCE::toVo));
    }

    public PagingVO<VisitSignRecordVO> queryPaging(VisitSignRecordQuery query) {
        return this.visitSignRecordDAO.queryPaging(query);
    }

    public List<VisitSignRecordVO> queryList(VisitSignRecordQuery query) {
        return VisitSignRecordConvert.INSTANCE.toVoList(this.visitSignRecordRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), query.getPageRequest().getSort()));
    }

    public List<VisitSignRecordVO> queryListDynamic(VisitSignRecordQuery query) {
        List<VisitSignRecordVO> visitSignRecordVOS = this.visitSignRecordDAO.queryListDynamic(query);
        return visitSignRecordVOS;
    }

    public VisitSignRecordVO queryByKey(Long key) {
        VisitSignRecordDO entity = this.visitSignRecordRepo.findById(key).orElseGet(VisitSignRecordDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        VisitSignRecordVO vo = VisitSignRecordConvert.INSTANCE.toVo(entity);
        Object fileDatas = this.fileUtil.getFileDatas(vo.getFileCodes());
        vo.setFileDatas(fileDatas);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public VisitSignRecordVO insert(VisitSignRecordPayload payload) {
        this.check(payload);
        this.dataProcess(payload);
        VisitSignRecordDO entityDo = VisitSignRecordConvert.INSTANCE.toDo(payload);
        VisitSignRecordDO save = (VisitSignRecordDO)this.visitSignRecordRepo.save(entityDo);
        this.taskRunDataProcess(payload, save);
        return VisitSignRecordConvert.INSTANCE.toVo(save);
    }

    private void taskRunDataProcess(VisitSignRecordPayload payload, VisitSignRecordDO save) {
        if (VisitSignTypeEnum.IN.getCode().equals(save.getType())) {
            VisitTaskPayload taskRunPayload = new VisitTaskPayload();
            taskRunPayload.setId(save.getTaskId());
            taskRunPayload.setSignLocations(payload.getLocations());
            taskRunPayload.setSignAddress(payload.getAddress());
            taskRunPayload.setSignTime(LocalDateTime.now());
            taskRunPayload.setSignFileCodes(payload.getFileCodes());
            this.visitTaskDAO.updateByKeyDynamic(taskRunPayload);
        } else if (VisitSignTypeEnum.OUT.getCode().equals(save.getType())) {
            VisitTaskPayload taskRunPayload = new VisitTaskPayload();
            taskRunPayload.setId(save.getTaskId());
            taskRunPayload.setSignOutLocations(payload.getLocations());
            taskRunPayload.setSignOutAddress(payload.getAddress());
            taskRunPayload.setSignOutTime(LocalDateTime.now());
            taskRunPayload.setSignOutFileCodes(payload.getFileCodes());
            this.visitTaskDAO.updateByKeyDynamic(taskRunPayload);
        }
    }

    private void check(VisitSignRecordPayload payload) {
        if (null == payload.getTaskId()) {
            throw TwException.error("", "taskRunId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)payload.getType())) {
            throw TwException.error("", "type\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)payload.getLocations())) {
            throw TwException.error("", "locations\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)payload.getAddress())) {
            throw TwException.error("", "address\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void dataProcess(VisitSignRecordPayload payload) {
        payload.setSignTime(LocalDateTime.now());
        VisitTaskVO visitTaskVO = this.visitTaskDAO.queryByKey(payload.getTaskId());
        if (null == payload.getPlanId()) {
            payload.setPlanId(visitTaskVO.getPlanId());
        }
        if (ObjectUtils.isEmpty((Object)payload.getTaskName())) {
            payload.setTaskName(visitTaskVO.getTaskName());
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.visitSignRecordDAO.deleteSoft(keys);
        }
    }

    public VisitSignRecordServiceImpl(VisitSignRecordRepo visitSignRecordRepo, VisitSignRecordDAO visitSignRecordDAO, VisitTaskDAO visitTaskDAO, FileUtil fileUtil) {
        this.visitSignRecordRepo = visitSignRecordRepo;
        this.visitSignRecordDAO = visitSignRecordDAO;
        this.visitTaskDAO = visitTaskDAO;
        this.fileUtil = fileUtil;
    }
}

