/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.humanresources.eval.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdEvaluateConfigDtlPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdEvaluateConfigPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdEvaluateConfigDtlQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdEvaluateConfigQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdEvaluateConfigDtlService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdEvaluateConfigService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdEvaluateConfigVO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.humanresources.convert.PrdEvaluateConfigConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.eval.dao.PrdEvaluateConfigDao;
import com.elitesland.tw.tw5.server.prd.humanresources.eval.entity.PrdEvaluateConfigDO;
import com.elitesland.tw.tw5.server.prd.humanresources.eval.repo.PrdEvaluateConfigRepo;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PrdEvaluateConfigServiceImpl
implements PrdEvaluateConfigService {
    private static final Logger log = LoggerFactory.getLogger(PrdEvaluateConfigServiceImpl.class);
    private final PrdEvaluateConfigDao prdEvaluateConfigDao;
    private final PrdEvaluateConfigRepo prdEvaluateConfigRepo;
    private final PrdEvaluateConfigDtlService prdEvaluateConfigDtlService;
    private final CacheUtil cacheUtil;

    @Transactional(rollbackFor={Exception.class})
    public PrdEvaluateConfigVO save(PrdEvaluateConfigPayload prdEvaluateConfigPayload) {
        Long count;
        this.checkData(prdEvaluateConfigPayload);
        PrdEvaluateConfigDO prdEvaluateConfigDO = new PrdEvaluateConfigDO();
        PrdEvaluateConfigQuery prdEvaluateConfigQuery = new PrdEvaluateConfigQuery();
        prdEvaluateConfigQuery.setCate(prdEvaluateConfigPayload.getCate());
        prdEvaluateConfigQuery.setType(prdEvaluateConfigPayload.getType());
        if (null == prdEvaluateConfigPayload.getId() && (count = this.prdEvaluateConfigDao.count(prdEvaluateConfigQuery)) > 0L) {
            throw new BusinessException("\u5df2\u5b58\u5728\u8bc4\u4ef7\u7c7b\u522b/\u8bc4\u4ef7\u7c7b\u578b\u7684\u6570\u636e,\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0");
        }
        prdEvaluateConfigDO = PrdEvaluateConfigConvert.INSTANCE.p2d(prdEvaluateConfigPayload);
        PrdEvaluateConfigDO res = (PrdEvaluateConfigDO)((Object)this.prdEvaluateConfigRepo.save((Object)prdEvaluateConfigDO));
        for (Long pointId : prdEvaluateConfigPayload.getPointIdList()) {
            PrdEvaluateConfigDtlPayload prdEvaluateConfigDtlPayload = new PrdEvaluateConfigDtlPayload();
            prdEvaluateConfigDtlPayload.setPointId(pointId);
            prdEvaluateConfigDtlPayload.setConfigId(res.getId());
            this.prdEvaluateConfigDtlService.save(prdEvaluateConfigDtlPayload);
        }
        return PrdEvaluateConfigConvert.INSTANCE.d2v(res);
    }

    @Transactional(rollbackFor={Exception.class})
    public PrdEvaluateConfigVO update(PrdEvaluateConfigPayload prdEvaluateConfigPayload) {
        Assert.notNull((Object)prdEvaluateConfigPayload.getId(), (String)"id is null", (Object[])new Object[0]);
        Long del = this.prdEvaluateConfigDtlService.delByConfigId(prdEvaluateConfigPayload.getId());
        PrdEvaluateConfigVO res = this.save(prdEvaluateConfigPayload);
        return res;
    }

    public PrdEvaluateConfigVO get(Long id) {
        if (null == id) {
            return null;
        }
        PrdEvaluateConfigVO res = this.prdEvaluateConfigDao.get(id);
        PrdEvaluateConfigDtlQuery prdEvaluateConfigDtlQuery = new PrdEvaluateConfigDtlQuery();
        prdEvaluateConfigDtlQuery.setConfigId(id);
        List dtlVOList = this.prdEvaluateConfigDtlService.getList(prdEvaluateConfigDtlQuery);
        res.setPrdEvaluateConfigDtlVOList(dtlVOList);
        return res;
    }

    public PagingVO<PrdEvaluateConfigVO> page(PrdEvaluateConfigQuery prdEvaluateConfigQuery) {
        PagingVO<PrdEvaluateConfigVO> res = this.prdEvaluateConfigDao.page(prdEvaluateConfigQuery);
        res.getRecords().forEach(x -> {
            x.setTypeDesc(this.cacheUtil.transferSystemSelection("org:employee:evalClass", x.getType()));
            x.setCateDesc(this.cacheUtil.transferSystemSelection("org:employee:evalClass", x.getCate()));
        });
        return res;
    }

    @Transactional(rollbackFor={Exception.class})
    public Long del(List<Long> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = this.prdEvaluateConfigDao.del(ids);
        return res;
    }

    public List<PrdEvaluateConfigVO> getList(PrdEvaluateConfigQuery prdEvaluateConfigQuery) {
        List<PrdEvaluateConfigVO> res = this.prdEvaluateConfigDao.getList(prdEvaluateConfigQuery);
        return res;
    }

    private void checkData(PrdEvaluateConfigPayload prdEvaluateConfigPayload) {
        if (StringUtils.isBlank((CharSequence)prdEvaluateConfigPayload.getCate())) {
            throw new BusinessException("\u7c7b\u522b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)prdEvaluateConfigPayload.getType())) {
            throw new BusinessException("\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollUtil.isEmpty((Collection)prdEvaluateConfigPayload.getPointIdList())) {
            throw new BusinessException("\u914d\u7f6e\u70b9id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public Long updateByCondition(PrdEvaluateConfigPayload prdEvaluateConfigPayload) {
        Assert.notNull((Object)prdEvaluateConfigPayload.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Long res = this.prdEvaluateConfigDao.update(prdEvaluateConfigPayload);
        return res;
    }

    public PrdEvaluateConfigVO getByCondition(PrdEvaluateConfigQuery prdEvaluateConfigQuery) {
        PrdEvaluateConfigVO res = this.prdEvaluateConfigDao.getByCondition(prdEvaluateConfigQuery);
        if (null != res) {
            PrdEvaluateConfigDtlQuery prdEvaluateConfigDtlQuery = new PrdEvaluateConfigDtlQuery();
            prdEvaluateConfigDtlQuery.setConfigId(res.getId());
            List dtlVOList = this.prdEvaluateConfigDtlService.getList(prdEvaluateConfigDtlQuery);
            res.setPrdEvaluateConfigDtlVOList(dtlVOList);
        }
        return res;
    }

    public PrdEvaluateConfigServiceImpl(PrdEvaluateConfigDao prdEvaluateConfigDao, PrdEvaluateConfigRepo prdEvaluateConfigRepo, PrdEvaluateConfigDtlService prdEvaluateConfigDtlService, CacheUtil cacheUtil) {
        this.prdEvaluateConfigDao = prdEvaluateConfigDao;
        this.prdEvaluateConfigRepo = prdEvaluateConfigRepo;
        this.prdEvaluateConfigDtlService = prdEvaluateConfigDtlService;
        this.cacheUtil = cacheUtil;
    }
}

