/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.humanresources.personnel.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.param.SysUserBatchSwitchParam;
import com.elitescloud.cloudt.system.provider.SysUserRpcService;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.EmployeeDepartPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.EmployeeDepartApplyQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.EmployeeDepartService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.EmployeeDepartApplyBSVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.EmployeeDepartApplyVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.EmployeeDepartCheckVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.permission.annotation.FunctionDetail;
import com.elitesland.tw.tw5.server.common.permission.annotation.PermissionDomain;
import com.elitesland.tw.tw5.server.common.permission.annotation.PermissionFunction;
import com.elitesland.tw.tw5.server.common.permission.enums.FunctionCodeEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.FunctionTypeEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionDomainEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionTypeEnum;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.seata.spring.annotation.GlobalTransactional;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5458\u5de5\u79bb\u804c\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/api/org"})
@PermissionDomain(domain=PermissionDomainEnum.EMPLOYEE_DEPART_APPLY)
public class EmployeeDepartController {
    private static final Logger log = LoggerFactory.getLogger(EmployeeDepartController.class);
    private final EmployeeDepartService service;
    private final SysUserRpcService userRpcService;

    @ApiOperation(value="\u5458\u5de5\u79bb\u804c")
    @PutMapping(value={"/employee/depart"})
    @GlobalTransactional
    public TwOutputUtil employeeDepart(@RequestBody EmployeeDepartPayload payload) {
        this.service.employeeDepart(payload);
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u5458\u5de5\u79bb\u804c\u7533\u8bf7\u4fe1\u606f")
    @GetMapping(value={"/employee/depart/apply"})
    @UdcNameClass
    public TwOutputUtil<EmployeeDepartApplyVO> employeeDepartApply(String procId) {
        return TwOutputUtil.ok(this.service.queryEmployeeDepart(procId));
    }

    @ApiOperation(value="\u5458\u5de5\u79bb\u804c\u68c0\u67e5")
    @GetMapping(value={"/employee/depart/check/{employeeId}"})
    public TwOutputUtil<EmployeeDepartCheckVO> employeeDepartCheck(@PathVariable Long employeeId) {
        return TwOutputUtil.ok(this.service.employeeDepartCheck(employeeId));
    }

    @ApiOperation(value="\u5458\u5de5\u79bb\u804c\u7533\u8bf7\u5217\u8868")
    @GetMapping(value={"/employee/depart/apply/list"})
    @UdcNameClass
    public TwOutputUtil employeeDepartList(EmployeeDepartApplyQuery query) {
        return TwOutputUtil.ok(this.service.employeeDepartApplyList(query));
    }

    @GetMapping(value={"/permission/employee/depart/apply/list"})
    @UdcNameClass
    @PermissionFunction(functions={@FunctionDetail(functionCode=FunctionCodeEnum.EMPLOYEE_DEPART_APPLY, type=FunctionTypeEnum.TAB)}, fieldPermission=true, permissionType=PermissionTypeEnum.DATA_PERMISSION)
    @ApiOperation(value="\u6743\u9650-\u5458\u5de5\u79bb\u804c\u7533\u8bf7\u5217\u8868")
    public TwOutputUtil<PagingVO<EmployeeDepartApplyBSVO>> permissionPaging(@RequestBody EmployeeDepartApplyQuery query) {
        PagingVO res = this.service.permissionPaging(query);
        return TwOutputUtil.ok(res);
    }

    @ApiOperation(value="\u5458\u5de5\u79bb\u804c\u8d26\u53f7\u7981\u7528")
    @GetMapping(value={"/employee/depart/enable/{userId}"})
    public TwOutputUtil employeeDepartEnable(@PathVariable Long userId) {
        SysUserBatchSwitchParam sysUserBatchSwitchParam = new SysUserBatchSwitchParam();
        ArrayList<Long> userIds = new ArrayList<Long>();
        userIds.add(userId);
        sysUserBatchSwitchParam.setEnable(false);
        sysUserBatchSwitchParam.setUserIds(userIds);
        this.userRpcService.batchSwitchUserStatus(sysUserBatchSwitchParam);
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u5458\u5de5\u79bb\u804c\u7533\u8bf7\u4fe1\u606f")
    @GetMapping(value={"/employee/depart/queryByKey/{applyId}"})
    @UdcNameClass
    public TwOutputUtil<EmployeeDepartApplyVO> queryByKey(@PathVariable Long applyId) {
        return TwOutputUtil.ok(this.service.queryByKey(applyId));
    }

    public EmployeeDepartController(EmployeeDepartService service, SysUserRpcService userRpcService) {
        this.service = service;
        this.userRpcService = userRpcService;
    }
}

