/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.my.query.OvertimeApplicationQuery;
import com.elitesland.tw.tw5.server.prd.my.service.OvertimeApplicationServiceImpl;
import com.elitesland.tw.tw5.server.prd.my.vo.OvertimeApplicationVO;
import java.time.LocalDate;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/my/overtimeApplication"})
public class OvertimeApplicationController {
    private static final Logger log = LoggerFactory.getLogger(OvertimeApplicationController.class);
    @Autowired
    private OvertimeApplicationServiceImpl OvertimeApplicationService;

    @PostMapping(value={"/submitOvertime"})
    public TwOutputUtil submitOvertime(@RequestBody OvertimeApplicationVO overtimeApplicationVO) {
        if (overtimeApplicationVO.getProjectId() == null) {
            return TwOutputUtil.error("500", "\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a", null);
        }
        if (LocalDate.now().isAfter(overtimeApplicationVO.getOvertimeWorkDate())) {
            return TwOutputUtil.error("500", "\u5de5\u4f5c\u8ba1\u5212\u4e0d\u80fd\u65e9\u4e8e\u4eca\u5929", null);
        }
        Long overtimeId = this.OvertimeApplicationService.submitOvertime(overtimeApplicationVO);
        return TwOutputUtil.ok(overtimeId);
    }

    @GetMapping(value={"/findOvertimeApplicationById"})
    public TwOutputUtil findOvertimeApplicationById(@RequestParam Long id) {
        OvertimeApplicationVO overtimeApplicationVO = this.OvertimeApplicationService.findOvertimeApplicationById(id);
        return TwOutputUtil.ok(overtimeApplicationVO);
    }

    @GetMapping(value={"/findAvailableOvertimeApplications"})
    public TwOutputUtil findAvailableOvertimeApplications() {
        List<OvertimeApplicationVO> overtimeApplicationVO = this.OvertimeApplicationService.findAvailableOvertimeApplications();
        return TwOutputUtil.ok(overtimeApplicationVO);
    }

    @GetMapping(value={"/findOvertimeApplicationPage"})
    public TwOutputUtil findOvertimeApplicationPage(OvertimeApplicationQuery query) {
        PagingVO<OvertimeApplicationVO> overtimeApplicationPage = this.OvertimeApplicationService.findOvertimeApplicationPage(query);
        return TwOutputUtil.ok(overtimeApplicationPage);
    }
}

