/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.service;

import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TAttendanceRecordPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TAttendanceRecordQuery;
import com.elitesland.tw.tw5.api.prd.my.service.TAttendanceRecordService;
import com.elitesland.tw.tw5.api.prd.my.vo.TAttendanceRecordVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.util.BeanUtil;
import com.elitesland.tw.tw5.server.prd.my.convert.TAttendanceRecordConvert;
import com.elitesland.tw.tw5.server.prd.my.dao.TAttendanceRecordDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.TAttendanceRecordDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TAttendanceRecordRepo;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgSyncLogDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgSyncLogDO;
import com.xxl.job.core.log.XxlJobLogger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
public class TAttendanceRecordServiceImpl
extends BaseServiceImpl
implements TAttendanceRecordService {
    private static final Logger log = LoggerFactory.getLogger(TAttendanceRecordServiceImpl.class);
    private final TAttendanceRecordRepo tAttendanceRecordRepo;
    private final TAttendanceRecordDAO tAttendanceRecordDAO;
    private final PrdOrgSyncLogDAO daoLog;
    private final HttpUtil httpUtil;
    private final PrdOrgEmployeeService employeeService;
    private final PrdOrgOrganizationService orgService;
    @Value(value="${tw4.attendance.record}")
    private String attendanceRecordTo5Url;

    public PagingVO<TAttendanceRecordVO> queryPaging(TAttendanceRecordQuery query) {
        return this.tAttendanceRecordDAO.queryPaging(query);
    }

    public List<TAttendanceRecordVO> queryListDynamic(TAttendanceRecordQuery query) {
        return this.tAttendanceRecordDAO.queryListDynamic(query);
    }

    public TAttendanceRecordVO queryByKey(Long key) {
        TAttendanceRecordDO entity = this.tAttendanceRecordRepo.findById(key).orElseGet(TAttendanceRecordDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        TAttendanceRecordVO vo = TAttendanceRecordConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public TAttendanceRecordVO insert(TAttendanceRecordPayload payload) {
        TAttendanceRecordDO entityDo = TAttendanceRecordConvert.INSTANCE.toDo(payload);
        return TAttendanceRecordConvert.INSTANCE.toVo((TAttendanceRecordDO)((Object)this.tAttendanceRecordRepo.save((Object)entityDo)));
    }

    @Transactional(rollbackFor={Exception.class})
    public TAttendanceRecordVO update(TAttendanceRecordPayload payload) {
        TAttendanceRecordDO entity = this.tAttendanceRecordRepo.findById(payload.getId()).orElseGet(TAttendanceRecordDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        TAttendanceRecordDO entityDo = TAttendanceRecordConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TAttendanceRecordConvert.INSTANCE.toVo((TAttendanceRecordDO)((Object)this.tAttendanceRecordRepo.save((Object)entity)));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(TAttendanceRecordPayload payload) {
        TAttendanceRecordDO entity = this.tAttendanceRecordRepo.findById(payload.getId()).orElseGet(TAttendanceRecordDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.tAttendanceRecordDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.tAttendanceRecordDAO.deleteSoft(keys);
        }
    }

    public List<Long> findResAttendanceLog(Long resId, LocalDate attendanceDate) {
        return this.tAttendanceRecordDAO.findResAttendanceLog(resId, attendanceDate);
    }

    public String findStartTime(Long id) {
        return this.tAttendanceRecordDAO.findStartTime(id);
    }

    public String findResAttendanceStatus(Long id) {
        return this.tAttendanceRecordDAO.findResAttendanceStatus(id);
    }

    public String findResAttendanceResult(Long id) {
        return this.tAttendanceRecordDAO.findResAttendanceResult(id);
    }

    public void attendanceRecordTo5(String param) {
        String syncType = "attendanceRecordTo5";
        LocalDateTime localDateTime = this.daoLog.queryOrgSyncLog(syncType);
        localDateTime = localDateTime == null ? LocalDateTime.of(1970, 1, 1, 0, 0) : localDateTime.minusSeconds(10L);
        XxlJobLogger.log((String)("syncVacationApply localDateTime\uff1a" + localDateTime), (Object[])new Object[0]);
        HashMap<String, Object> reqMap = new HashMap<String, Object>();
        long asyncTimeLong = localDateTime.toEpochSecond(ZoneOffset.of("+8"));
        reqMap.put("asyncTime", asyncTimeLong);
        XxlJobLogger.log((String)("syncVacationApplyDetail syncTime\uff1a" + asyncTimeLong), (Object[])new Object[0]);
        String result = this.httpUtil.sendSyncGet(this.attendanceRecordTo5Url, reqMap);
        Map data = (Map)JSONObject.parse((String)result);
        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        Object syncData = "";
        if ("true".equals("" + data.get("ok"))) {
            if (!ObjectUtils.isEmpty(data.get("datum"))) {
                Map v4AndV5UserIds = this.employeeService.getV4AndV5UserIds();
                Object datum = data.get("datum");
                List attendanceRecordData = (List)datum;
                ArrayList<TAttendanceRecordDO> tAttendanceRecordDOList = new ArrayList<TAttendanceRecordDO>();
                List<Long> tw4AttendanceRecordIds = attendanceRecordData.stream().map(attendanceRecord -> (attendanceRecord.get("id") == null ? Integer.valueOf(0) : attendanceRecord.get("id")).longValue()).collect(Collectors.toList());
                List<TAttendanceRecordDO> oldTAttendanceRecordDOs = this.tAttendanceRecordRepo.selectByIdV4List(tw4AttendanceRecordIds);
                block0: for (TAttendanceRecordDO attendanceRecordDO : oldTAttendanceRecordDOs) {
                    Long attendanceRecordIdV4 = attendanceRecordDO.getAttendanceRecordIdV4();
                    for (Map applyData2 : attendanceRecordData) {
                        Long attendanceRecordIdV4FromV4 = (null == applyData2.get("id") ? Integer.valueOf(0) : applyData2.get("id")).longValue();
                        if (!attendanceRecordIdV4.equals(attendanceRecordIdV4FromV4)) continue;
                        TAttendanceRecordDO attendanceRecordDO1 = this.translateFromV4(applyData2, v4AndV5UserIds);
                        attendanceRecordDO1.setId(attendanceRecordDO.getId());
                        tAttendanceRecordDOList.add(attendanceRecordDO1);
                        continue block0;
                    }
                }
                this.tAttendanceRecordRepo.saveAll(tAttendanceRecordDOList);
                List newDatas = attendanceRecordData.stream().filter(applyData -> {
                    boolean flag = true;
                    Long applyId = (applyData.get("id") == null ? Integer.valueOf(0) : applyData.get("id")).longValue();
                    for (TAttendanceRecordDO attendanceRecordDO : oldTAttendanceRecordDOs) {
                        if (!attendanceRecordDO.getAttendanceRecordIdV4().equals(applyId)) continue;
                        flag = false;
                    }
                    return flag;
                }).collect(Collectors.toList());
                ArrayList<TAttendanceRecordDO> newTAttendanceRecordDOs = new ArrayList<TAttendanceRecordDO>();
                for (Map newData : newDatas) {
                    TAttendanceRecordDO attendanceRecordDO1 = this.translateFromV4(newData, v4AndV5UserIds);
                    newTAttendanceRecordDOs.add(attendanceRecordDO1);
                }
                this.tAttendanceRecordRepo.saveAll(newTAttendanceRecordDOs);
                syncData = "\u66f4\u65b0\u4e86\u6b63\u5e38\u6253\u5361" + attendanceRecordData.size() + "\u6761\u6570\u636e";
            } else {
                syncData = "\u6b63\u5e38\u6253\u5361\u6570\u636e\u672a\u53d8\u5316";
            }
        } else {
            syncData = "" + data.get("reason");
        }
        logDO.setSyncType(syncType);
        logDO.setSyncData((String)syncData);
        this.daoLog.save(logDO);
        log.info("\u3010\u6b63\u5e38\u6253\u5361\u4fe1\u606f\u540c\u6b65\uff0c\u540c\u6b65\u65e5\u5fd7\uff1a{}\u3011", (Object)logDO);
    }

    private TAttendanceRecordDO translateFromV4(Map attendanceRecordData, Map<Long, Long> v4AndV5UserIds) {
        TAttendanceRecordDO attendanceRecordDO = BeanUtil.mapToBean(TAttendanceRecordDO.class, attendanceRecordData, Arrays.asList("id", "createTime", "createUserId"));
        if (null != attendanceRecordData.get("id")) {
            attendanceRecordDO.setAttendanceRecordIdV4(((Integer)attendanceRecordData.get("id")).longValue());
        }
        if (null != attendanceRecordData.get("attendanceResId")) {
            Long attendanceResId = ((Integer)attendanceRecordData.get("attendanceResId")).longValue();
            attendanceRecordDO.setAttendanceResId(v4AndV5UserIds.get(attendanceResId));
        }
        return attendanceRecordDO;
    }

    public TAttendanceRecordServiceImpl(TAttendanceRecordRepo tAttendanceRecordRepo, TAttendanceRecordDAO tAttendanceRecordDAO, PrdOrgSyncLogDAO daoLog, HttpUtil httpUtil, PrdOrgEmployeeService employeeService, PrdOrgOrganizationService orgService) {
        this.tAttendanceRecordRepo = tAttendanceRecordRepo;
        this.tAttendanceRecordDAO = tAttendanceRecordDAO;
        this.daoLog = daoLog;
        this.httpUtil = httpUtil;
        this.employeeService = employeeService;
        this.orgService = orgService;
    }
}

