/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.service;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.UserVacationApplyDetailPayload;
import com.elitesland.tw.tw5.api.prd.my.payload.UserVacationApplyPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetQuery;
import com.elitesland.tw.tw5.api.prd.my.query.UserVacationApplyQuery;
import com.elitesland.tw.tw5.api.prd.my.service.PmsTimesheetService;
import com.elitesland.tw.tw5.api.prd.my.service.ProjectService;
import com.elitesland.tw.tw5.api.prd.my.service.UserVacationApplyService;
import com.elitesland.tw.tw5.api.prd.my.service.UserVacationService;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetVO;
import com.elitesland.tw.tw5.api.prd.my.vo.UserRecentVacationApplyVO;
import com.elitesland.tw.tw5.api.prd.my.vo.UserVacationApplyDetailVO;
import com.elitesland.tw.tw5.api.prd.my.vo.UserVacationApplyVO;
import com.elitesland.tw.tw5.api.prd.my.vo.UserVacationVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeEqvaRatioService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationRefVO;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.api.prd.task.query.TaskInfoQuery;
import com.elitesland.tw.tw5.api.prd.task.service.TaskInfoService;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskInfoVO;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.scheduling.TimeUtil;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.util.BeanUtil;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.my.constant.UserVacationIntervalEnum;
import com.elitesland.tw.tw5.server.prd.my.constant.VacationTypeEnum;
import com.elitesland.tw.tw5.server.prd.my.convert.TimesheetConvert;
import com.elitesland.tw.tw5.server.prd.my.convert.UserVacationApplyConvert;
import com.elitesland.tw.tw5.server.prd.my.convert.UserVacationApplyDetailConvert;
import com.elitesland.tw.tw5.server.prd.my.convert.UserVacationConvert;
import com.elitesland.tw.tw5.server.prd.my.dao.UserVacationApplyDAO;
import com.elitesland.tw.tw5.server.prd.my.dao.UserVacationApplyDetailDAO;
import com.elitesland.tw.tw5.server.prd.my.dao.UserVacationDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.UserVacationApplyDO;
import com.elitesland.tw.tw5.server.prd.my.entity.UserVacationApplyDetailDO;
import com.elitesland.tw.tw5.server.prd.my.entity.UserVacationDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TimesheetRepo;
import com.elitesland.tw.tw5.server.prd.my.repo.UserVacationApplyDetailRepo;
import com.elitesland.tw.tw5.server.prd.my.repo.UserVacationApplyRepo;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgSyncLogDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgSyncLogDO;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.TaskSourceTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.TaskStatusEnum;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.SetVariablesPayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.xxl.job.core.log.XxlJobLogger;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class UserVacationApplyServiceImpl
extends BaseServiceImpl
implements UserVacationApplyService {
    private static final Logger log = LoggerFactory.getLogger(UserVacationApplyServiceImpl.class);
    private final PrdOrgEmployeeService employeeService;
    private final ProjectService projectService;
    private final PrdOrgOrganizationService orgService;
    private final UserVacationApplyDAO userVacationApplyDAO;
    private final UserVacationApplyRepo userVacationApplyRepo;
    private final UserVacationApplyDetailRepo userVacationApplyDetailRepo;
    private final PrdOrgSyncLogDAO daoLog;
    private final HttpUtil httpUtil;
    private final PmsProjectService pmsProjectService;
    private final PrdOrgEmployeeDAO employeeDAO;
    private final PrdSystemRoleDAO prdSystemRoleDAO;
    private final WorkflowUtil workflowUtil;
    private final TransactionUtilService transactionUtilService;
    private final UserVacationApplyDetailDAO userVacationApplyDetailDAO;
    private final UserVacationService userVacationService;
    private final UserVacationDAO userVacationDAO;
    private final FileUtil fileUtil;
    private final CacheUtil cacheUtil;
    private final TimesheetRepo timesheetRepo;
    private final PmsTimesheetService timesheetService;
    private final TaskInfoService taskInfoService;
    private final PrdOrgEmployeeEqvaRatioService prdOrgEmployeeEqvaRatioService;
    private final PrdSystemRoleService roleService;
    @Value(value="${tw4.vacation.apply}")
    private String syncVacationApplyUrl;
    @Value(value="${tw4.vacation.applyDetail}")
    private String syncVacationApplyDetailUrl;

    public PagingVO<UserVacationApplyVO> paging(UserVacationApplyQuery query) {
        return this.userVacationApplyDetailDAO.page(query);
    }

    public List<UserVacationApplyVO> list(UserVacationApplyQuery query) {
        return this.userVacationApplyDetailDAO.list(query);
    }

    public List<UserVacationApplyVO> queryList(UserVacationApplyQuery query) {
        return this.userVacationApplyDAO.queryList(query);
    }

    @Transactional
    public void syncVacationApplyData(String param) {
        String syncType = "vacation_apply";
        LocalDateTime localDateTime = this.daoLog.queryOrgSyncLog(syncType);
        localDateTime = localDateTime == null ? LocalDateTime.of(2023, 1, 1, 0, 0) : localDateTime.minusSeconds(10L);
        XxlJobLogger.log((String)"\u7528\u6237\u8bf7\u5047\u7533\u8bf7\u6570\u636e\u540c\u6b65\u5f00\u59cb...", (Object[])new Object[0]);
        XxlJobLogger.log((String)("syncVacationApply localDateTime\uff1a" + localDateTime), (Object[])new Object[0]);
        HashMap<String, Long> reqMap = new HashMap<String, Long>();
        long asyncTimeLong = localDateTime.toEpochSecond(ZoneOffset.of("+8"));
        reqMap.put("asyncTime", asyncTimeLong);
        XxlJobLogger.log((String)("syncVacationApply syncTime\uff1a" + asyncTimeLong), (Object[])new Object[0]);
        HashMap data = new HashMap();
        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        Object syncData = "";
        if ("true".equals("" + data.get("ok"))) {
            if (!ObjectUtils.isEmpty(data.get("datum"))) {
                Map v4AndV5UserIds = this.employeeService.getV4AndV5UserIds();
                Map v4AndV5ProjectIds = this.projectService.getV4AndV5ProjectIds();
                Map v4AndV5OrgIds = this.orgService.getV4AndV5OrgIds();
                Object datum = data.get("datum");
                List userVacationApplyData = (List)datum;
                ArrayList<UserVacationApplyDO> userVacationApplyDOList = new ArrayList<UserVacationApplyDO>();
                List<Long> tw4UserVacationApplyIds = userVacationApplyData.stream().map(vacationApply -> (vacationApply.get("id") == null ? Integer.valueOf(0) : vacationApply.get("id")).longValue()).collect(Collectors.toList());
                List<UserVacationApplyDO> oldUserVacationApply4DOList = this.userVacationApplyRepo.selectByIdV4List(tw4UserVacationApplyIds);
                block0: for (UserVacationApplyDO applyDO : oldUserVacationApply4DOList) {
                    Long applyIdV4 = applyDO.getApplyIdV4();
                    for (Map applyData2 : userVacationApplyData) {
                        Long receiveApplyIdV4 = (null == applyData2.get("id") ? Integer.valueOf(0) : applyData2.get("id")).longValue();
                        if (!applyIdV4.equals(receiveApplyIdV4)) continue;
                        UserVacationApplyDO todoApplyDO = this.transApplyFromV4(applyData2, v4AndV5UserIds, v4AndV5ProjectIds, v4AndV5OrgIds);
                        todoApplyDO.setId(applyDO.getId());
                        userVacationApplyDOList.add(todoApplyDO);
                        continue block0;
                    }
                }
                this.userVacationApplyRepo.saveAll(userVacationApplyDOList);
                List newDatas = userVacationApplyData.stream().filter(applyData -> {
                    boolean flag = true;
                    Long applyId = (applyData.get("id") == null ? Integer.valueOf(0) : applyData.get("id")).longValue();
                    for (UserVacationApplyDO applyDO : oldUserVacationApply4DOList) {
                        if (!applyDO.getApplyIdV4().equals(applyId)) continue;
                        flag = false;
                    }
                    return flag;
                }).collect(Collectors.toList());
                ArrayList<UserVacationApplyDO> newApplyDOList = new ArrayList<UserVacationApplyDO>();
                for (Map newData : newDatas) {
                    UserVacationApplyDO todoApplyDO = this.transApplyFromV4(newData, v4AndV5UserIds, v4AndV5ProjectIds, v4AndV5OrgIds);
                    newApplyDOList.add(todoApplyDO);
                }
                this.userVacationApplyRepo.saveAll(newApplyDOList);
                syncData = "\u66f4\u65b0\u4e86\u7528\u6237\u8bf7\u5047\u7533\u8bf7" + userVacationApplyData.size() + "\u6761\u6570\u636e";
            } else {
                syncData = "\u6d3b\u52a8\u6570\u636e\u672a\u53d8\u5316";
            }
        } else {
            syncData = "" + data.get("reason");
        }
        logDO.setSyncType(syncType);
        logDO.setSyncData((String)syncData);
        this.daoLog.save(logDO);
        log.info("\u3010\u6d3b\u52a8\u540c\u6b65\uff0c\u540c\u6b65\u65e5\u5fd7\uff1a{}\u3011", (Object)logDO);
        XxlJobLogger.log((String)("\u7528\u6237\u8bf7\u5047\u7533\u8bf7\u540c\u6b65\u6d3b\u52a8\u7ed3\u675f..." + logDO), (Object[])new Object[0]);
    }

    @Transactional
    public void syncVacationApplyDetailData(String param) {
        String syncType = "vacation_apply_detail";
        LocalDateTime localDateTime = this.daoLog.queryOrgSyncLog(syncType);
        localDateTime = localDateTime == null ? LocalDateTime.of(2023, 1, 1, 0, 0) : localDateTime.minusSeconds(10L);
        XxlJobLogger.log((String)"\u7528\u6237\u8bf7\u5047\u7533\u8bf7\u660e\u7ec6\u6570\u636e\u540c\u6b65\u5f00\u59cb...", (Object[])new Object[0]);
        XxlJobLogger.log((String)("syncVacationApplyDetail localDateTime\uff1a" + localDateTime), (Object[])new Object[0]);
        HashMap<String, Long> reqMap = new HashMap<String, Long>();
        long asyncTimeLong = localDateTime.toEpochSecond(ZoneOffset.of("+8"));
        reqMap.put("asyncTime", asyncTimeLong);
        XxlJobLogger.log((String)("syncVacationApplyDetail syncTime\uff1a" + asyncTimeLong), (Object[])new Object[0]);
        HashMap data = new HashMap();
        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        Object syncData = "";
        if ("true".equals("" + data.get("ok"))) {
            if (!ObjectUtils.isEmpty(data.get("datum"))) {
                UserVacationApplyDetailDO todoDetailDO;
                Object datum = data.get("datum");
                List userVacationApplyDetailData = (List)datum;
                ArrayList<UserVacationApplyDetailDO> applyDetailDOList = new ArrayList<UserVacationApplyDetailDO>();
                List<Long> tw4ApplyDetailIds = userVacationApplyDetailData.stream().map(applyDetail -> (applyDetail.get("id") == null ? Integer.valueOf(0) : applyDetail.get("id")).longValue()).collect(Collectors.toList());
                List<UserVacationApplyDetailDO> oldUserVacationApplyDetail4DOList = this.userVacationApplyDetailRepo.selectByIdV4(tw4ApplyDetailIds);
                block0: for (UserVacationApplyDetailDO detailDO : oldUserVacationApplyDetail4DOList) {
                    Long detailIdV4 = detailDO.getDetailIdV4();
                    for (Map detailData2 : userVacationApplyDetailData) {
                        Long receiveDetailIdV4 = (null == detailData2.get("id") ? Integer.valueOf(0) : detailData2.get("id")).longValue();
                        if (!detailIdV4.equals(receiveDetailIdV4)) continue;
                        todoDetailDO = this.transDetailFromV4(detailData2);
                        todoDetailDO.setId(detailDO.getId());
                        applyDetailDOList.add(todoDetailDO);
                        continue block0;
                    }
                }
                this.userVacationApplyDetailRepo.saveAll(applyDetailDOList);
                List newDatas = userVacationApplyDetailData.stream().filter(detailData -> {
                    boolean flag = true;
                    Long detailId = (detailData.get("id") == null ? Integer.valueOf(0) : detailData.get("id")).longValue();
                    for (UserVacationApplyDetailDO detailDO : oldUserVacationApplyDetail4DOList) {
                        if (!detailDO.getDetailIdV4().equals(detailId)) continue;
                        flag = false;
                    }
                    return flag;
                }).collect(Collectors.toList());
                ArrayList<UserVacationApplyDetailDO> newDetailDOList = new ArrayList<UserVacationApplyDetailDO>();
                for (Map newData : newDatas) {
                    Long applyV4 = ((Integer)newData.get("applyId")).longValue();
                    UserVacationApplyDO applyDO = this.userVacationApplyRepo.selectByIdV4(applyV4);
                    todoDetailDO = this.transDetailFromV4(newData);
                    if (null != applyDO) {
                        todoDetailDO.setApplyId(applyDO.getId());
                        todoDetailDO.setBelongOrgId(applyDO.getBelongOrgId());
                    }
                    newDetailDOList.add(todoDetailDO);
                }
                this.userVacationApplyDetailRepo.saveAll(newDetailDOList);
                syncData = "\u66f4\u65b0\u4e86\u7528\u6237\u8bf7\u5047\u7533\u8bf7\u660e\u7ec6" + userVacationApplyDetailData.size() + "\u6761\u6570\u636e";
            } else {
                syncData = "\u6d3b\u52a8\u6570\u636e\u672a\u53d8\u5316";
            }
        } else {
            syncData = "" + data.get("reason");
        }
        logDO.setSyncType(syncType);
        logDO.setSyncData((String)syncData);
        this.daoLog.save(logDO);
        log.info("\u3010\u6d3b\u52a8\u540c\u6b65\uff0c\u540c\u6b65\u65e5\u5fd7\uff1a{}\u3011", (Object)logDO);
        XxlJobLogger.log((String)("\u7528\u6237\u8bf7\u5047\u7533\u8bf7\u660e\u7ec6\u540c\u6b65\u6d3b\u52a8\u7ed3\u675f..." + logDO), (Object[])new Object[0]);
    }

    public List<UserVacationApplyDetailVO> getDetailByApplyKey(Long applyId) {
        List<UserVacationApplyDetailDO> doList = this.userVacationApplyDetailRepo.selectDetailByApplyKey(applyId);
        ArrayList<UserVacationApplyDetailVO> voList = new ArrayList<UserVacationApplyDetailVO>();
        for (UserVacationApplyDetailDO detailDO : doList) {
            UserVacationApplyDetailVO vo = new UserVacationApplyDetailVO();
            BeanUtils.copyProperties((Object)((Object)detailDO), (Object)vo);
            voList.add(vo);
        }
        return voList;
    }

    private UserVacationApplyDO transApplyFromV4(Map applyData, Map<Long, Long> v4AndV5UserIds, Map<Long, Long> v4AndV5ProjectIds, Map<Long, Long> v4AndV5OrgIds) {
        UserVacationApplyDO applyDO = BeanUtil.mapToBean(UserVacationApplyDO.class, applyData, Arrays.asList("id", "createTime", "createUserId"));
        if (null != applyData.get("id")) {
            applyDO.setApplyIdV4(((Integer)applyData.get("id")).longValue());
        }
        if (StringUtils.isEmpty(applyData.get("projectId"))) {
            String projectId = (String)applyData.get("projectId");
            applyDO.setCreateUserId(v4AndV5ProjectIds.get(projectId));
        }
        if (null != applyData.get("buId")) {
            Long orgId = ((Integer)applyData.get("buId")).longValue();
            applyDO.setOrgId(v4AndV5OrgIds.get(orgId));
        }
        if (null != applyData.get("resId")) {
            Long userId = ((Integer)applyData.get("resId")).longValue();
            applyDO.setPUserId(v4AndV5UserIds.get(userId));
        }
        if (null != applyData.get("presId")) {
            Long pUserId = ((Integer)applyData.get("presId")).longValue();
            applyDO.setPUserId(v4AndV5UserIds.get(pUserId));
        }
        return applyDO;
    }

    private UserVacationApplyDetailDO transDetailFromV4(Map detailData) {
        UserVacationApplyDetailDO detailDO = BeanUtil.mapToBean(UserVacationApplyDetailDO.class, detailData, Arrays.asList("id", "createTime", "createUserId"));
        if (null != detailData.get("id")) {
            detailDO.setDetailIdV4(((Integer)detailData.get("id")).longValue());
        }
        if (null != detailData.get("applyId")) {
            detailDO.setApplyIdV4(((Integer)detailData.get("applyId")).longValue());
        }
        if (null != detailData.get("vmonth")) {
            detailDO.setVMonth((String)detailData.get("vmonth"));
        }
        if (null != detailData.get("vdate")) {
            LocalDate vdate = TimeUtil.dateFromYmd((String)detailData.get("vdate"));
            detailDO.setVDate(vdate);
        }
        if (null != detailData.get("vdays")) {
            BigDecimal vdays = new BigDecimal((String)detailData.get("vdays"));
            detailDO.setVDays(vdays);
        }
        if (null != detailData.get("vinterval")) {
            detailDO.setVInterval((String)detailData.get("vinterval"));
        }
        return detailDO;
    }

    @Transactional
    public void userVacationApply(UserVacationApplyPayload payload) {
        if (payload.getProcInstId() == null) {
            this.startProc(payload);
        } else {
            this.updateVacationApplyData(payload);
        }
    }

    @Transactional
    public void startProc(UserVacationApplyPayload payload) {
        UserVacationApplyVO applyVO;
        if (payload.getId() == null) {
            this.checkoutData(payload, true);
            String applyNo = payload.getApplyNo();
            if (payload.getId() == null) {
                applyNo = this.generateSeqNum("VACATION_APPLY_NO", new String[0]);
            }
            UserVacationApplyDO pdo = UserVacationApplyConvert.INSTANCE.payloadToDo(payload);
            pdo.setApplyNo(applyNo);
            applyVO = UserVacationApplyConvert.INSTANCE.doToVo(this.userVacationApplyDAO.save(pdo));
        } else {
            UserVacationApplyDO userVacationApplyDO = UserVacationApplyConvert.INSTANCE.payloadToDo(payload);
            applyVO = UserVacationApplyConvert.INSTANCE.doToVo(this.userVacationApplyDAO.save(userVacationApplyDO));
            payload.setId(userVacationApplyDO.getId());
            List userVacationApplyDetailPayloadList = payload.getApplyDetailPayloadList();
            this.userVacationApplyDetailDAO.deleteAllByApplyId(payload.getId());
            this.checkoutData(payload, true);
        }
        PrdOrgEmployeeVO employeeVO = this.employeeService.queryByUserId(payload.getUserId());
        HashMap<String, Object> variables = this.setWorkFlowVar(payload);
        String vacationTypeName = this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.VacationType.getCode(), payload.getVacationType());
        ProcessInfo processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.RES_VACATION.name(), (String)("A35.\u8bf7\u5047\u6d41\u7a0b-" + employeeVO.getEmployeeName() + "-" + vacationTypeName + "-" + applyVO.getStartDate() + "~" + applyVO.getEndDate()), (String)("" + applyVO.getId()), variables), new Long[0]);
        List userVacationApplyDetailPayloadList = payload.getApplyDetailPayloadList();
        userVacationApplyDetailPayloadList.forEach(userVacationApplyDetailPayload -> userVacationApplyDetailPayload.setApplyId(applyVO.getId()));
        List<UserVacationApplyDetailDO> userVacationApplyDetailDOList = UserVacationApplyDetailConvert.INSTANCE.payloadsToDos(userVacationApplyDetailPayloadList);
        userVacationApplyDetailDOList.forEach(detailDO -> detailDO.setExtVacationFlag(false));
        List<UserVacationApplyDetailDO> userVacationApplyDetailDOS = this.userVacationApplyDetailDAO.saveAll(userVacationApplyDetailDOList);
        UserVacationApplyPayload userVacationApplyPayload = new UserVacationApplyPayload();
        userVacationApplyPayload.setId(applyVO.getId());
        userVacationApplyPayload.setProcInstId(processInfo.getProcInstId());
        userVacationApplyPayload.setProcInstStatus(processInfo.getProcInstStatus());
        userVacationApplyDetailDOS.forEach(detailDO -> {
            detailDO.setProcInstId(processInfo.getProcInstId());
            detailDO.setProcInstStatus(processInfo.getProcInstStatus());
        });
        this.transactionUtilService.executeWithRunnable(() -> {
            this.userVacationApplyDAO.updateProcData(userVacationApplyPayload);
            for (UserVacationApplyDetailDO userVacationApplyDetailDO : userVacationApplyDetailDOS) {
                this.userVacationApplyDetailDAO.updateProcStatus(userVacationApplyDetailDO);
            }
        });
        List<UserVacationApplyDetailPayload> vacationApplyDetailPayloads = UserVacationApplyDetailConvert.INSTANCE.dosToPayloads(userVacationApplyDetailDOS);
        payload.setApplyDetailPayloadList(vacationApplyDetailPayloads);
        payload.setId(applyVO.getId());
        payload.setCreateTime(LocalDateTime.now());
        this.timesheetService.generateVacationPrivateTimesheet(payload);
    }

    public HashMap<String, Object> setWorkFlowVar(UserVacationApplyPayload payload) {
        Long userId;
        PrdOrgEmployeeRefVO prdOrgEmployeeRefVO;
        HashMap<String, Object> variables = new HashMap<String, Object>();
        String vacationType = payload.getVacationType();
        if (payload.getInProjectFlag() != null) {
            variables.put("inProjectFlag", payload.getInProjectFlag());
        }
        if (payload.getAddFlag() != null) {
            variables.put("addFlag", payload.getAddFlag());
        }
        if (payload.getExtVacationFlag() != null) {
            variables.put("extVacationFlag", payload.getExtVacationFlag());
        } else {
            variables.put("extVacationFlag", 0);
        }
        Boolean mmfppFlag = false;
        Boolean personalFlag = false;
        if (StringUtils.hasText((String)vacationType)) {
            if (VacationTypeEnum.MARRIAGE.getCode().equals(vacationType) || VacationTypeEnum.MATERNITY.getCode().equals(vacationType) || VacationTypeEnum.FUNERAL.getCode().equals(vacationType) || VacationTypeEnum.PATERNITY.getCode().equals(vacationType) || VacationTypeEnum.PRENATAL_EXA.getCode().equals(vacationType) || VacationTypeEnum.SICK.getCode().equals(vacationType)) {
                mmfppFlag = true;
            }
            if (VacationTypeEnum.PERSONAL.getCode().equals(vacationType)) {
                personalFlag = true;
            }
        }
        variables.put("mmfppFlag", mmfppFlag);
        variables.put("personalFlag", personalFlag);
        Boolean personalDaysFlag = false;
        Boolean sickDaysFlag = false;
        if (VacationTypeEnum.PERSONAL.getCode().equals(vacationType) || VacationTypeEnum.SICK.getCode().equals(vacationType)) {
            BigDecimal vacationDays = payload.getVacationDays();
            UserVacationApplyQuery query = new UserVacationApplyQuery();
            query.setUserId(payload.getUserId());
            query.setApprStatus(ProcInstStatus.APPROVED.name());
            query.setVacationType(payload.getVacationType());
            List<UserVacationApplyVO> userVacationApplyVOS = this.list(query);
            if (!CollectionUtils.isEmpty(userVacationApplyVOS) && !CollectionUtils.isEmpty(userVacationApplyVOS)) {
                BigDecimal days = userVacationApplyVOS.stream().filter(vo -> vo.getVacationDays() != null).map(p -> p.getVacationDays()).reduce(BigDecimal.ZERO, BigDecimal::add);
                vacationDays = vacationDays.add(days);
            }
            if (vacationDays.compareTo(new BigDecimal(5)) > 0) {
                if (VacationTypeEnum.PERSONAL.getCode().equals(vacationType)) {
                    personalDaysFlag = true;
                } else {
                    sickDaysFlag = true;
                }
            }
        }
        variables.put("personalDaysFlag", personalDaysFlag);
        variables.put("sickDaysFlag", sickDaysFlag);
        if (payload.getProjectId() != null) {
            PmsProjectVO projectVO = this.pmsProjectService.queryByKey(payload.getProjectId());
            Long pmUserId = projectVO.getPmResId();
            variables.put("Activity_1gt34xh", CollUtil.newArrayList((Object[])new Long[]{pmUserId}));
            variables.put("Activity_0qq6cd7", CollUtil.newArrayList((Object[])new Long[]{pmUserId}));
        }
        if ((prdOrgEmployeeRefVO = this.employeeDAO.queryUserOrgData(userId = payload.getUserId())) == null) {
            throw TwException.error("", "\u5458\u5de5\u7ec4\u7ec7\u5173\u7cfb\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        if (prdOrgEmployeeRefVO.getParentId() == null) {
            throw TwException.error("", "\u5458\u5de5\u4e0a\u7ea7\u4e0d\u5b58\u5728,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        variables.put("Activity_0x3r156", CollUtil.newArrayList((Object[])new Long[]{prdOrgEmployeeRefVO.getParentId()}));
        if (prdOrgEmployeeRefVO.getManageId() == null) {
            throw TwException.error("", "\u5458\u5de5BU\u8d1f\u8d23\u4eba\u4e0d\u5b58\u5728,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        variables.put("Activity_1kg2f1v", CollUtil.newArrayList((Object[])new Long[]{prdOrgEmployeeRefVO.getManageId()}));
        variables.put("Activity_1e310kk", CollUtil.newArrayList((Object[])new Long[]{prdOrgEmployeeRefVO.getManageId()}));
        Long orgId = this.cacheUtil.getDefaultOrgIdByUserId(userId);
        PrdOrgOrganizationRefVO buLevel1ByOrg = this.cacheUtil.getBULevel1ByOrgId(orgId);
        if (buLevel1ByOrg == null) {
            throw TwException.error("", "\u4e8b\u4e1a\u90e8\u8d1f\u8d23\u4eba\u4e0d\u5b58\u5728,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        variables.put("Activity_1gsq9yn", buLevel1ByOrg.getManageId());
        List<Long> vacationAdmin = this.prdSystemRoleDAO.queryUserIdByRoleCodes(CollUtil.newArrayList((Object[])new String[]{RoleEnum.PLAT_SALARY_MANAGER.getCode(), RoleEnum.PLAT_SALARY_SPECIALIST.getCode()}));
        variables.put("Activity_1ryb750", vacationAdmin);
        variables.put("Activity_0yyszxj", vacationAdmin);
        variables.put("Activity_15e26sx", CollUtil.newArrayList((Object[])new Long[]{prdOrgEmployeeRefVO.getParentId()}));
        variables.put("Activity_06oa2am", CollUtil.newArrayList((Object[])new Long[]{prdOrgEmployeeRefVO.getManageId()}));
        variables.put("Activity_1mnj3y9", this.roleService.queryUserIdByRoleCode(RoleEnum.PLAT_HRD.getCode()));
        return variables;
    }

    public void updateWorkFlowVar(UserVacationApplyPayload payload) {
        HashMap<String, Object> variables = this.setWorkFlowVar(payload);
        SetVariablesPayload setVariablesPayload = new SetVariablesPayload();
        setVariablesPayload.setProcInstId(payload.getProcInstId());
        setVariablesPayload.setVariables(variables);
        this.workflowUtil.setVaribales(setVariablesPayload);
    }

    @Transactional
    public void updateVacationApplyData(UserVacationApplyPayload payload) {
        UserVacationApplyVO applyVO = this.userVacationUpdate(payload);
        this.updateWorkFlowVar(payload);
        payload.setCreateTime(applyVO.getCreateTime());
        this.timesheetService.generateVacationPrivateTimesheet(payload);
    }

    public UserVacationApplyVO queryApply(String procId) {
        UserVacationApplyDO userVacationApplyDO = this.userVacationApplyDAO.findByProcId(procId);
        UserVacationApplyVO userVacationApplyVO = UserVacationApplyConvert.INSTANCE.doToVo(userVacationApplyDO);
        userVacationApplyVO.setAttachmentDatas(this.fileUtil.getFileDatas(userVacationApplyVO.getAttachmentCodes()));
        userVacationApplyVO.setVacationAddAttachDatas(this.fileUtil.getFileDatas(userVacationApplyVO.getVacationAddAttachCodes()));
        userVacationApplyVO.setExtVacationAttachDatas(this.fileUtil.getFileDatas(userVacationApplyVO.getExtVacationAttachCodes()));
        Long userId = userVacationApplyDO.getUserId();
        PrdOrgEmployeeRefVO prdOrgEmployeeRefVO = this.employeeDAO.queryUserOrgData(userId);
        PrdOrgEmployeeDO employeeDO = this.employeeDAO.queryByUserId(userId);
        userVacationApplyVO.setOrgId(prdOrgEmployeeRefVO.getOrgId());
        userVacationApplyVO.setParentUserId(prdOrgEmployeeRefVO.getParentId());
        userVacationApplyVO.setExtString6(employeeDO.getExtString6());
        userVacationApplyVO.setExtString9(employeeDO.getExtString9());
        userVacationApplyVO.setExtString5(employeeDO.getExtString5());
        userVacationApplyVO.setBookId(employeeDO.getBookId());
        if (!ObjectUtils.isEmpty((Object)employeeDO.getBookId())) {
            userVacationApplyVO.setCompanyName(this.cacheUtil.getCompanyNameByBookId(employeeDO.getBookId()));
        }
        userVacationApplyVO.setExtString6Name(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeType.getCode(), employeeDO.getExtString6()));
        if (Objects.equals(userVacationApplyVO.getExtString6(), "INTERNAL_RES")) {
            userVacationApplyVO.setExtString9Name(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeInternalType.getCode(), employeeDO.getExtString9()));
        } else if (Objects.equals(userVacationApplyVO.getExtString6(), "EXTERNAL_RES")) {
            userVacationApplyVO.setExtString9Name(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeExternalType.getCode(), employeeDO.getExtString9()));
        }
        List availableVacationList = this.userVacationService.getAvailableVacation(userId, userVacationApplyVO.getVacationId());
        userVacationApplyVO.setAvailableVacationVOList(availableVacationList);
        List<UserVacationApplyDetailDO> detailDOList = this.userVacationApplyDetailDAO.findByProcIdAndExtFlag(procId, false);
        userVacationApplyVO.setDetailVOList(UserVacationApplyDetailConvert.INSTANCE.dosToVos(detailDOList));
        List<UserVacationApplyDetailDO> extDetailDOList = this.userVacationApplyDetailDAO.findByProcIdAndExtFlag(procId, true);
        if (extDetailDOList != null) {
            userVacationApplyVO.setExtDetailVOList(UserVacationApplyDetailConvert.INSTANCE.dosToVos(extDetailDOList));
        }
        userVacationApplyVO.setLastThreeMonthDetailVOList(null);
        return userVacationApplyVO;
    }

    public UserVacationApplyVO queryApplyByKey(String businessKey) {
        Long applyId = Long.valueOf(businessKey);
        UserVacationApplyDO userVacationApplyDO = this.userVacationApplyDAO.findById(applyId);
        UserVacationApplyVO userVacationApplyVO = UserVacationApplyConvert.INSTANCE.doToVo(userVacationApplyDO);
        userVacationApplyVO.setAttachmentDatas(this.fileUtil.getFileDatas(userVacationApplyVO.getAttachmentCodes()));
        userVacationApplyVO.setVacationAddAttachDatas(this.fileUtil.getFileDatas(userVacationApplyVO.getVacationAddAttachCodes()));
        if (userVacationApplyDO.getProjectId() != null) {
            PmsProjectVO pmsProjectVO = this.pmsProjectService.queryByKey(Long.valueOf(userVacationApplyDO.getProjectId()));
            userVacationApplyVO.setProjectName(pmsProjectVO.getProjName());
        }
        Long userId = userVacationApplyDO.getUserId();
        PrdOrgEmployeeRefVO prdOrgEmployeeRefVO = this.employeeDAO.queryUserOrgData(userId);
        PrdOrgEmployeeDO employeeDO = this.employeeDAO.queryByUserId(userId);
        userVacationApplyVO.setOrgId(prdOrgEmployeeRefVO.getOrgId());
        userVacationApplyVO.setParentUserId(prdOrgEmployeeRefVO.getParentId());
        userVacationApplyVO.setExtString5(employeeDO.getExtString5());
        userVacationApplyVO.setExtString6(employeeDO.getExtString6());
        userVacationApplyVO.setExtString9(employeeDO.getExtString9());
        userVacationApplyVO.setBookId(employeeDO.getBookId());
        if (!ObjectUtils.isEmpty((Object)employeeDO.getBookId())) {
            userVacationApplyVO.setCompanyName(this.cacheUtil.getCompanyNameByBookId(employeeDO.getBookId()));
        }
        userVacationApplyVO.setExtString6Name(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeType.getCode(), employeeDO.getExtString6()));
        if (Objects.equals(userVacationApplyVO.getExtString6(), "INTERNAL_RES")) {
            userVacationApplyVO.setExtString9Name(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeInternalType.getCode(), employeeDO.getExtString9()));
        } else if (Objects.equals(userVacationApplyVO.getExtString6(), "EXTERNAL_RES")) {
            userVacationApplyVO.setExtString9Name(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeExternalType.getCode(), employeeDO.getExtString9()));
        }
        String companyName = this.cacheUtil.getCompanyNameByBookId(employeeDO.getBookId());
        userVacationApplyVO.setCompanyName(companyName);
        List availableVacationList = this.userVacationService.getAvailableVacation(userId, userVacationApplyVO.getVacationId());
        userVacationApplyVO.setAvailableVacationVOList(availableVacationList);
        List<UserVacationApplyDetailDO> detailDOList = this.userVacationApplyDetailDAO.findByApplyIdAndExtFlag(applyId, false);
        userVacationApplyVO.setDetailVOList(UserVacationApplyDetailConvert.INSTANCE.dosToVos(detailDOList));
        List<UserVacationApplyDetailDO> extDetailDOList = this.userVacationApplyDetailDAO.findByApplyIdAndExtFlag(applyId, true);
        if (extDetailDOList != null) {
            userVacationApplyVO.setExtDetailVOList(UserVacationApplyDetailConvert.INSTANCE.dosToVos(extDetailDOList));
        }
        List<UserRecentVacationApplyVO> recentVacationApplyVOList = this.getLastThreeMonthApplyDetailVOList(userId, userVacationApplyVO.getCreateTime().toLocalDate());
        userVacationApplyVO.setLastThreeMonthDetailVOList(recentVacationApplyVOList);
        return userVacationApplyVO;
    }

    @Transactional
    public UserVacationApplyVO userVacationInsert(UserVacationApplyPayload payload) {
        this.checkoutData(payload, false);
        String applyNo = payload.getApplyNo();
        if (payload.getId() == null) {
            applyNo = this.generateSeqNum("VACATION_APPLY_NO", new String[0]);
        }
        payload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
        UserVacationApplyDO pdo = UserVacationApplyConvert.INSTANCE.payloadToDo(payload);
        pdo.setApplyNo(applyNo);
        UserVacationApplyVO applyVO = UserVacationApplyConvert.INSTANCE.doToVo(this.userVacationApplyDAO.save(pdo));
        List userVacationApplyDetailPayloadList = payload.getApplyDetailPayloadList();
        userVacationApplyDetailPayloadList.forEach(userVacationApplyDetailPayload -> userVacationApplyDetailPayload.setApplyId(applyVO.getId()));
        List<UserVacationApplyDetailDO> userVacationApplyDetailDOList = UserVacationApplyDetailConvert.INSTANCE.payloadsToDos(userVacationApplyDetailPayloadList);
        userVacationApplyDetailDOList.forEach(detailDO -> detailDO.setExtVacationFlag(false));
        this.userVacationApplyDetailDAO.saveAll(userVacationApplyDetailDOList);
        return applyVO;
    }

    @Transactional
    public UserVacationApplyVO userVacationUpdate(UserVacationApplyPayload payload) {
        if (payload.getProcInstId() != null) {
            List<UserVacationApplyDetailDO> vacationApplyDetailDOS = this.userVacationApplyDetailDAO.findByApplyId(payload.getId());
            List detailIdList = vacationApplyDetailDOS.stream().map(e -> e.getId()).collect(Collectors.toList());
            this.timesheetService.deleteVacationPrivateTimesheet(detailIdList);
        }
        UserVacationApplyDO userVacationApplyDO = UserVacationApplyConvert.INSTANCE.payloadToDo(payload);
        UserVacationApplyVO applyVO = UserVacationApplyConvert.INSTANCE.doToVo(this.userVacationApplyDAO.save(userVacationApplyDO));
        payload.setId(userVacationApplyDO.getId());
        List userVacationApplyDetailPayloadList = payload.getApplyDetailPayloadList();
        this.userVacationApplyDetailDAO.deleteAllByApplyId(payload.getId());
        this.checkoutData(payload, false);
        List<UserVacationApplyDetailDO> userVacationApplyDetailDOList = UserVacationApplyDetailConvert.INSTANCE.payloadsToDos(userVacationApplyDetailPayloadList);
        userVacationApplyDetailDOList.forEach(detailDO -> {
            detailDO.setId(null);
            detailDO.setApplyId(payload.getId());
            detailDO.setProcInstId(payload.getProcInstId());
            detailDO.setExtVacationFlag(false);
        });
        userVacationApplyDetailDOList = this.userVacationApplyDetailDAO.saveAll(userVacationApplyDetailDOList);
        List<UserVacationApplyDetailPayload> vacationApplyDetailPayloads = UserVacationApplyDetailConvert.INSTANCE.dosToPayloads(userVacationApplyDetailDOList);
        payload.setApplyDetailPayloadList(vacationApplyDetailPayloads);
        if (payload.getExtapplyDetailPayloadList() != null) {
            List extApplyDetailPayloadList = payload.getExtapplyDetailPayloadList();
            List<UserVacationApplyDetailDO> extUserVacationApplyDetailDOList = UserVacationApplyDetailConvert.INSTANCE.payloadsToDos(extApplyDetailPayloadList);
            extUserVacationApplyDetailDOList.forEach(detailDO -> {
                detailDO.setApplyId(payload.getId());
                detailDO.setProcInstId(payload.getProcInstId());
                detailDO.setProcInstStatus(payload.getProcInstStatus());
                detailDO.setExtVacationFlag(true);
            });
            extUserVacationApplyDetailDOList = this.userVacationApplyDetailDAO.saveAll(extUserVacationApplyDetailDOList);
            List<UserVacationApplyDetailPayload> extUserVacationApplyDetailPayloadList = UserVacationApplyDetailConvert.INSTANCE.dosToPayloads(extUserVacationApplyDetailDOList);
            payload.setExtapplyDetailPayloadList(extUserVacationApplyDetailPayloadList);
        }
        return applyVO;
    }

    private void checkoutData(UserVacationApplyPayload payload, Boolean dealBreastfeedTimesheetFlag) {
        if (ObjectUtils.isEmpty((Object)payload.getApplyDetailPayloadList())) {
            throw TwException.error("", "\u8bf7\u5047\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        TimesheetQuery timesheetQuery = new TimesheetQuery();
        ArrayList<LocalDate> workDateList = new ArrayList<LocalDate>();
        workDateList.add(payload.getStartDate());
        workDateList.add(payload.getEndDate());
        timesheetQuery.setWorkDateBetween(workDateList);
        timesheetQuery.setTsUserId(payload.getUserId());
        List<TimesheetVO> timesheetVOList = TimesheetConvert.INSTANCE.toVoList(this.timesheetRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, timesheetQuery, criteriaBuilder)));
        if (!ObjectUtils.isEmpty(timesheetVOList)) {
            List vacationIdList = timesheetVOList.stream().filter(timesheetVO -> timesheetVO.getVacationApplyDetailId() != null).map(p -> p.getVacationApplyDetailId()).collect(Collectors.toList());
            UserVacationApplyQuery query = new UserVacationApplyQuery();
            query.setIds(vacationIdList);
            List<UserVacationApplyVO> userVacationApplyDetailVOS = this.list(query);
            Set<Object> breastfeedIdSet = new HashSet();
            if (!CollectionUtils.isEmpty(userVacationApplyDetailVOS)) {
                breastfeedIdSet = userVacationApplyDetailVOS.stream().filter(p -> StringUtils.hasText((String)p.getVacationType()) && VacationTypeEnum.BREASTFEED.getCode().equals(p.getVacationType())).map(s -> s.getId()).collect(Collectors.toSet());
            }
            HashSet finalBreastfeedIdSet = breastfeedIdSet;
            if (dealBreastfeedTimesheetFlag.booleanValue() && !CollectionUtils.isEmpty(finalBreastfeedIdSet)) {
                this.dealBreastfeedTimesheet(timesheetVOList, userVacationApplyDetailVOS, payload);
            }
            StringBuilder errorMsg = new StringBuilder();
            List vacationDetailList = payload.getApplyDetailPayloadList();
            Map<LocalDate, BigDecimal> result = !CollectionUtils.isEmpty(finalBreastfeedIdSet) ? timesheetVOList.stream().filter(p -> !finalBreastfeedIdSet.contains(p.getVacationApplyDetailId())).collect(Collectors.toMap(TimesheetVO::getWorkDate, TimesheetVO::getWorkHour, BigDecimal::add)) : timesheetVOList.stream().collect(Collectors.toMap(TimesheetVO::getWorkDate, TimesheetVO::getWorkHour, BigDecimal::add));
            for (UserVacationApplyDetailPayload detailPayload : vacationDetailList) {
                BigDecimal workHours;
                if (CollectionUtils.isEmpty(result) || !result.containsKey(detailPayload.getVDate()) || (workHours = result.get(detailPayload.getVDate())).add(detailPayload.getVDays().multiply(BigDecimal.valueOf(8L))).compareTo(BigDecimal.valueOf(8L)) <= 0) continue;
                errorMsg.append(detailPayload.getVDate()).append(";");
            }
            if (!errorMsg.isEmpty()) {
                errorMsg.append("\u5df2\u586b\u5199\u5de5\u65f6+\u5f53\u524d\u8bf7\u5047\u65f6\u95f4\u5df2\u7ecf\u8d85\u8fc78\u5c0f\u65f6\uff0c\u8bf7\u5904\u7406\u5de5\u65f6\u540e\u518d\u63d0\u4ea4\uff01");
                throw TwException.error("", errorMsg.toString());
            }
        }
        UserVacationVO userVacationVO = null;
        if (VacationTypeEnum.ANNUAL_W.getCode().equals(payload.getVacationType()) || VacationTypeEnum.ANNUAL.getCode().equals(payload.getVacationType()) || VacationTypeEnum.IN_LIEU.getCode().equals(payload.getVacationType()) || VacationTypeEnum.REWARD.getCode().equals(payload.getVacationType())) {
            if (ObjectUtils.isEmpty((Object)payload.getVacationId())) {
                throw TwException.error("", "\u8bf7\u9009\u62e9\u5269\u4f59\u5047\u671f");
            }
            BigDecimal approvingDays = this.userVacationApplyDAO.countApprovingDays(payload.getVacationId(), payload.getId());
            if (ObjectUtils.isEmpty((Object)approvingDays)) {
                approvingDays = BigDecimal.ZERO;
            }
            UserVacationDO userVacationDO = this.userVacationDAO.queryById(payload.getVacationId());
            userVacationVO = UserVacationConvert.INSTANCE.doToVo(userVacationDO);
            List<UserVacationVO> userVacationVOList = Collections.singletonList(userVacationVO);
            this.userVacationService.calculateAvailableDay(userVacationVOList);
            userVacationVO = userVacationVOList.get(0);
            if (userVacationVO.getAvailableDays().compareTo(approvingDays.add(payload.getVacationDays())) < 0) {
                throw TwException.error("", "\u8bf7\u5047\u5929\u6570\u5927\u4e8e\u53ef\u7528\u5929\u6570\uff0c\u5176\u4e2d\u53ef\u7528\u5047\u671f" + userVacationVO.getAvailableDays() + "\u5929\uff0c\u8bf7\u5047\u5f85\u5ba1\u6279" + approvingDays + "\u5929,\u672c\u6b21\u8bf7\u5047" + payload.getVacationDays().setScale(2) + "\u5929");
            }
            if (payload.getEndDate().isAfter(userVacationVO.getExpirationDate())) {
                throw TwException.error("", "\u4f11\u5047\u622a\u6b62\u65e5\u671f\u8d85\u8fc7\u6709\u6548\u671f\u3010" + userVacationVO.getExpirationDate() + "\u3011\uff0c\u8bf7\u8054\u7cfb\u4eba\u4e8b\u5904\u7406");
            }
            if (VacationTypeEnum.REWARD.getCode().equals(payload.getVacationType())) {
                this.handleVacationTask(payload, userVacationVO);
            }
        }
        if (payload.getStartDate() != null) {
            List dayList = payload.getApplyDetailPayloadList();
            List<ProcInstStatus> procInstStatusList = Arrays.asList(ProcInstStatus.APPROVING, ProcInstStatus.APPROVED);
            List<Object> userRecentVacationApplyVOList = this.userVacationApplyDetailDAO.queryByDateAndResId(payload.getStartDate(), payload.getEndDate(), payload.getUserId(), procInstStatusList);
            userRecentVacationApplyVOList = userRecentVacationApplyVOList.stream().filter(p -> !VacationTypeEnum.BREASTFEED.getCode().equals(p.getVacationType())).collect(Collectors.toList());
            StringBuilder errorMsg = new StringBuilder();
            if (!ObjectUtils.isEmpty(userRecentVacationApplyVOList)) {
                for (UserVacationApplyDetailPayload detailPayload : dayList) {
                    for (UserRecentVacationApplyVO userRecentVacationApplyVO : userRecentVacationApplyVOList) {
                        if (Objects.equals(payload.getVacationType(), VacationTypeEnum.BREASTFEED.getCode()) || !detailPayload.getVDate().isEqual(userRecentVacationApplyVO.getDetailVDate())) continue;
                        if (userRecentVacationApplyVO.getVacationDays().compareTo(new BigDecimal(1)) == 0) {
                            errorMsg.append(detailPayload.getVDate()).append(";");
                            continue;
                        }
                        if (detailPayload.getVDays().doubleValue() != 0.5 || !Objects.equals(detailPayload.getVInterval(), userRecentVacationApplyVO.getDetailVInterval())) continue;
                        errorMsg.append(detailPayload.getVDate()).append(" ").append(detailPayload.getVInterval()).append(";");
                    }
                }
            }
            if (!errorMsg.isEmpty()) {
                errorMsg.append("\u5df2\u7ecf\u63d0\u4ea4\u7533\u8bf7\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4");
                throw TwException.error("", errorMsg.toString());
            }
        }
    }

    void handleVacationTask(UserVacationApplyPayload payload, UserVacationVO userVacationVO) {
        TaskInfoQuery taskInfoQuery = new TaskInfoQuery();
        taskInfoQuery.setReasonType(userVacationVO.getReasonType());
        taskInfoQuery.setReasonId(userVacationVO.getReasonId());
        taskInfoQuery.setTaskResId(userVacationVO.getUserId());
        taskInfoQuery.setSourceType(TaskSourceTypeEnum.REWARD.getCode());
        taskInfoQuery.setTaskStatus(TaskStatusEnum.PENDING.getCode());
        List taskInfoVOS = this.taskInfoService.queryListCommon(taskInfoQuery);
        if (ObjectUtils.isEmpty((Object)taskInfoVOS)) {
            throw TwException.error("", "\u5956\u52b1\u5047\u5bf9\u5e94\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        BigDecimal eqvaRatio = ((TaskInfoVO)taskInfoVOS.get(0)).getEqvaRatio();
        if (eqvaRatio == null) {
            eqvaRatio = this.prdOrgEmployeeEqvaRatioService.getEqvaRatio(userVacationVO.getUserId(), LocalDate.now());
            ((TaskInfoVO)taskInfoVOS.get(0)).setEqvaRatio(eqvaRatio);
        }
        if (eqvaRatio == null) {
            throw TwException.error("", "\u5f53\u91cf\u7cfb\u6570\u4e0d\u53ef\u4e3a\u7a7a");
        }
        BigDecimal effectiveEqva = taskInfoVOS.stream().map(TaskInfoVO::getEffectiveEqva).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        if (effectiveEqva.compareTo(payload.getVacationDays().multiply(eqvaRatio)) < 0) {
            throw TwException.error("", "\u5956\u52b1\u5047\u5bf9\u5e94\u4efb\u52a1\u53ef\u7528\u5f53\u91cf\u4e0d\u8db3,\u5269\u4f59\uff1a" + effectiveEqva);
        }
    }

    public List<UserRecentVacationApplyVO> getLastThreeMonthApplyDetailVOList(Long userId, LocalDate applyDate) {
        UserVacationApplyQuery userVacationApplyQuery = new UserVacationApplyQuery();
        userVacationApplyQuery.setUserId(userId);
        userVacationApplyQuery.setVdateStart(String.valueOf(applyDate.minusMonths(3L)));
        return this.userVacationApplyDetailDAO.getRecentVacation(userVacationApplyQuery);
    }

    private void dealBreastfeedTimesheet(List<TimesheetVO> timesheetVOList, List<UserVacationApplyVO> userVacationApplyDetailVOS, UserVacationApplyPayload payload) {
        List breastfeedVOS = userVacationApplyDetailVOS.stream().filter(p -> VacationTypeEnum.BREASTFEED.getCode().equals(p.getVacationType())).collect(Collectors.toList());
        ArrayList vacationDetailIds = new ArrayList();
        Map<LocalDate, List<UserVacationApplyVO>> breastfeedMap = breastfeedVOS.stream().collect(Collectors.groupingBy(UserVacationApplyVO::getDetailVDate));
        payload.getApplyDetailPayloadList().stream().forEach(p -> {
            if (breastfeedMap.containsKey(p.getVDate())) {
                if (p.getVDays().compareTo(new BigDecimal(1)) == 0) {
                    List collect = ((List)breastfeedMap.get(p.getVDate())).stream().map(BaseViewModel::getId).collect(Collectors.toList());
                    vacationDetailIds.addAll(collect);
                } else if (UserVacationIntervalEnum.AM.getCode().equals(p.getVInterval())) {
                    List collect = ((List)breastfeedMap.get(p.getVDate())).stream().filter(vo -> UserVacationIntervalEnum.AM.getCode().equals(vo.getDetailInterval())).map(BaseViewModel::getId).collect(Collectors.toList());
                    vacationDetailIds.addAll(collect);
                } else if (UserVacationIntervalEnum.PM.getCode().equals(p.getVInterval())) {
                    List collect = ((List)breastfeedMap.get(p.getVDate())).stream().filter(vo -> UserVacationIntervalEnum.PM.getCode().equals(vo.getDetailInterval())).map(BaseViewModel::getId).collect(Collectors.toList());
                    vacationDetailIds.addAll(collect);
                }
            }
        });
        if (!CollectionUtils.isEmpty(vacationDetailIds)) {
            this.timesheetService.deleteVacationPrivateTimesheet(vacationDetailIds);
        }
    }

    public UserVacationApplyServiceImpl(PrdOrgEmployeeService employeeService, ProjectService projectService, PrdOrgOrganizationService orgService, UserVacationApplyDAO userVacationApplyDAO, UserVacationApplyRepo userVacationApplyRepo, UserVacationApplyDetailRepo userVacationApplyDetailRepo, PrdOrgSyncLogDAO daoLog, HttpUtil httpUtil, PmsProjectService pmsProjectService, PrdOrgEmployeeDAO employeeDAO, PrdSystemRoleDAO prdSystemRoleDAO, WorkflowUtil workflowUtil, TransactionUtilService transactionUtilService, UserVacationApplyDetailDAO userVacationApplyDetailDAO, UserVacationService userVacationService, UserVacationDAO userVacationDAO, FileUtil fileUtil, CacheUtil cacheUtil, TimesheetRepo timesheetRepo, PmsTimesheetService timesheetService, TaskInfoService taskInfoService, PrdOrgEmployeeEqvaRatioService prdOrgEmployeeEqvaRatioService, PrdSystemRoleService roleService) {
        this.employeeService = employeeService;
        this.projectService = projectService;
        this.orgService = orgService;
        this.userVacationApplyDAO = userVacationApplyDAO;
        this.userVacationApplyRepo = userVacationApplyRepo;
        this.userVacationApplyDetailRepo = userVacationApplyDetailRepo;
        this.daoLog = daoLog;
        this.httpUtil = httpUtil;
        this.pmsProjectService = pmsProjectService;
        this.employeeDAO = employeeDAO;
        this.prdSystemRoleDAO = prdSystemRoleDAO;
        this.workflowUtil = workflowUtil;
        this.transactionUtilService = transactionUtilService;
        this.userVacationApplyDetailDAO = userVacationApplyDetailDAO;
        this.userVacationService = userVacationService;
        this.userVacationDAO = userVacationDAO;
        this.fileUtil = fileUtil;
        this.cacheUtil = cacheUtil;
        this.timesheetRepo = timesheetRepo;
        this.timesheetService = timesheetService;
        this.taskInfoService = taskInfoService;
        this.prdOrgEmployeeEqvaRatioService = prdOrgEmployeeEqvaRatioService;
        this.roleService = roleService;
    }
}

