/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.org.service;

import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeeEqvaRatioPayload;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeEqvaRatioQuery;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeEqvaRatioService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeEqvaRatioVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeEqvaRatioDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgEmployeeEqvaRatioDO;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class PrdOrgEmployeeEqvaRatioServiceImpl
implements PrdOrgEmployeeEqvaRatioService {
    private static final Logger log = LoggerFactory.getLogger(PrdOrgEmployeeEqvaRatioServiceImpl.class);
    private final PrdOrgEmployeeEqvaRatioDAO eqvaRatioDAO;
    private final PrdOrgEmployeeDAO employeeDAO;

    public BigDecimal getEqvaRatio(Long userId, LocalDate date) {
        PrdOrgEmployeeRefVO prdOrgEmployeeRefVO = this.employeeDAO.queryUserOrgData(userId);
        if ((date == null || date.isAfter(LocalDate.now())) && !ObjectUtils.isEmpty((Object)prdOrgEmployeeRefVO)) {
            return prdOrgEmployeeRefVO.getEqvaRatio();
        }
        BigDecimal eqvaRatioDefaultZero = this.getEqvaRatioDefaultZero(userId, date);
        if (eqvaRatioDefaultZero.compareTo(BigDecimal.ZERO) < 1) {
            throw TwException.error("", "\u7528\u6237" + prdOrgEmployeeRefVO.getEmployeeName() + "\u65e5\u671f" + date + "\u5f53\u91cf\u7cfb\u6570\u67e5\u8be2\u5931\u8d25");
        }
        if (eqvaRatioDefaultZero.equals(BigDecimal.valueOf(100L))) {
            if (ObjectUtils.isEmpty((Object)prdOrgEmployeeRefVO)) {
                throw TwException.error("", "\u7528\u6237" + userId.toString() + "\u65e5\u671f" + date + "\u5f53\u91cf\u7cfb\u6570\u67e5\u8be2\u5931\u8d25");
            }
            return prdOrgEmployeeRefVO.getEqvaRatio();
        }
        return eqvaRatioDefaultZero;
    }

    public BigDecimal getEqvaRatioDefaultZero(Long userId, LocalDate date) {
        List<PrdOrgEmployeeEqvaRatioVO> eqvaRatioList = this.eqvaRatioDAO.getEqvaRatioList(userId, null);
        ArrayList<PrdOrgEmployeeEqvaRatioVO> tempList = new ArrayList<PrdOrgEmployeeEqvaRatioVO>();
        for (PrdOrgEmployeeEqvaRatioVO prdOrgEmployeeEqvaRatioVO : eqvaRatioList) {
            if (prdOrgEmployeeEqvaRatioVO.getStartDate().isAfter(date)) continue;
            if (prdOrgEmployeeEqvaRatioVO.getEndDate() != null) {
                if (prdOrgEmployeeEqvaRatioVO.getEndDate().isBefore(date)) continue;
                tempList.add(prdOrgEmployeeEqvaRatioVO);
                continue;
            }
            tempList.add(prdOrgEmployeeEqvaRatioVO);
        }
        Collections.sort(tempList);
        if (!tempList.isEmpty()) {
            return ((PrdOrgEmployeeEqvaRatioVO)tempList.get(0)).getEqvaRatio();
        }
        return BigDecimal.valueOf(100L);
    }

    public List<PrdOrgEmployeeEqvaRatioVO> getEqvaRatioListByDate(PrdOrgEmployeeEqvaRatioQuery query) {
        return this.eqvaRatioDAO.getEqvaRatioListByDate(query);
    }

    public void upsertEqvaRatio(PrdOrgEmployeeEqvaRatioPayload payload) {
        this.eqvaRatioDAO.updateEqvaDate(payload.getUserId(), payload.getStartDate().minusDays(1L));
        PrdOrgEmployeeEqvaRatioDO employeeEqvaRatioDO = new PrdOrgEmployeeEqvaRatioDO();
        employeeEqvaRatioDO.setUserId(payload.getUserId());
        employeeEqvaRatioDO.setEqvaRatio(payload.getEqvaRatio());
        employeeEqvaRatioDO.setStartDate(payload.getStartDate());
        employeeEqvaRatioDO.setEndDate(payload.getEndDate());
        this.eqvaRatioDAO.saveGrade(employeeEqvaRatioDO);
    }

    public PrdOrgEmployeeEqvaRatioServiceImpl(PrdOrgEmployeeEqvaRatioDAO eqvaRatioDAO, PrdOrgEmployeeDAO employeeDAO) {
        this.eqvaRatioDAO = eqvaRatioDAO;
        this.employeeDAO = employeeDAO;
    }
}

