/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.partner.business.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.partner.business.payload.BusinessOperationSitesPayload;
import com.elitesland.tw.tw5.api.prd.partner.business.query.BusinessOperationSitesQuery;
import com.elitesland.tw.tw5.api.prd.partner.business.vo.BusinessOperationSitesVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.partner.business.entity.BusinessOperationSitesDO;
import com.elitesland.tw.tw5.server.prd.partner.business.entity.QBusinessOperationSitesDO;
import com.elitesland.tw.tw5.server.prd.partner.business.repo.BusinessOperationSitesRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class BusinessOperationSitesDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final BusinessOperationSitesRepo repo;
    private final QBusinessOperationSitesDO qdo = QBusinessOperationSitesDO.businessOperationSitesDO;

    private JPAQuery<BusinessOperationSitesVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BusinessOperationSitesVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.bookId, this.qdo.date, this.qdo.url, this.qdo.name, this.qdo.type, this.qdo.partnerId, this.qdo.partnerName})).from((EntityPath)this.qdo);
    }

    private JPAQuery<BusinessOperationSitesVO> getJpaQueryWhere(BusinessOperationSitesQuery query) {
        JPAQuery<BusinessOperationSitesVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public long count(BusinessOperationSitesQuery query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo);
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    private Predicate where(BusinessOperationSitesQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBookId())) {
            list.add(this.qdo.bookId.eq((Object)query.getBookId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDate())) {
            list.add(this.qdo.date.eq((Object)query.getDate()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getUrl())) {
            list.add(this.qdo.url.eq((Object)query.getUrl()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getName())) {
            list.add(this.qdo.name.eq((Object)query.getName()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getType())) {
            list.add(this.qdo.type.eq((Object)query.getType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPartnerId())) {
            list.add(this.qdo.partnerId.eq((Object)query.getPartnerId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPartnerName())) {
            list.add(this.qdo.partnerName.eq((Object)query.getPartnerName()));
        }
        return ExpressionUtils.allOf(list);
    }

    public BusinessOperationSitesVO queryByKey(Long id) {
        JPAQuery<BusinessOperationSitesVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (BusinessOperationSitesVO)jpaQuery.fetchFirst();
    }

    public List<BusinessOperationSitesVO> queryListDynamic(BusinessOperationSitesQuery query) {
        JPAQuery<BusinessOperationSitesVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<BusinessOperationSitesVO> queryPaging(BusinessOperationSitesQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<BusinessOperationSitesVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public BusinessOperationSitesDO save(BusinessOperationSitesDO ado) {
        return (BusinessOperationSitesDO)this.repo.save(ado);
    }

    public List<BusinessOperationSitesDO> saveAll(List<BusinessOperationSitesDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(BusinessOperationSitesPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getBookId() != null) {
            update.set(this.qdo.bookId, (Object)payload.getBookId());
        }
        if (payload.getDate() != null) {
            update.set((Path)this.qdo.date, (Object)payload.getDate());
        }
        if (payload.getUrl() != null) {
            update.set((Path)this.qdo.url, (Object)payload.getUrl());
        }
        if (payload.getName() != null) {
            update.set((Path)this.qdo.name, (Object)payload.getName());
        }
        if (payload.getType() != null) {
            update.set((Path)this.qdo.type, (Object)payload.getType());
        }
        if (payload.getPartnerId() != null) {
            update.set(this.qdo.partnerId, (Object)payload.getPartnerId());
        }
        if (payload.getPartnerName() != null) {
            update.set((Path)this.qdo.partnerName, (Object)payload.getPartnerName());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("bookId")) {
                update.setNull(this.qdo.bookId);
            }
            if (nullFields.contains("date")) {
                update.setNull((Path)this.qdo.date);
            }
            if (nullFields.contains("url")) {
                update.setNull((Path)this.qdo.url);
            }
            if (nullFields.contains("name")) {
                update.setNull((Path)this.qdo.name);
            }
            if (nullFields.contains("type")) {
                update.setNull((Path)this.qdo.type);
            }
            if (nullFields.contains("partnerId")) {
                update.setNull(this.qdo.partnerId);
            }
            if (nullFields.contains("partnerName")) {
                update.setNull((Path)this.qdo.partnerName);
            }
        }
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public void deleteByPartnerId(Long partnerId) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.partnerId.eq((Object)partnerId)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        update.execute();
    }

    public BusinessOperationSitesDAO(JPAQueryFactory jpaQueryFactory, BusinessOperationSitesRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

