/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.system.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemRemindPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemRemindQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRemindService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemRemindVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdSystemRemindConvert;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRemindDAO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemRemindDO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PrdSystemRemindServiceImpl
implements PrdSystemRemindService {
    private static final Logger log = LoggerFactory.getLogger(PrdSystemRemindServiceImpl.class);
    private final PrdSystemRemindDAO dao;
    private final CacheUtil cacheUtil;

    @Transactional
    public PrdSystemRemindVO insert(PrdSystemRemindPayload payload) {
        String remindCode = "SYS:E:REMIND_CODE_NOT_REPEAT";
        boolean allowReturn = this.allowReturn(remindCode, (TwCommonPayload)payload);
        if (allowReturn) {
            PrdSystemRemindQuery query = new PrdSystemRemindQuery();
            query.setRemindCode(payload.getRemindCode());
            int count = this.dao.queryListDynamic(query).size();
            if (count > 0) {
                throw TwException.error("", "\u7f16\u53f7\u4e0d\u53ef\u91cd\u590d");
            }
        }
        PrdSystemRemindDO ado = PrdSystemRemindConvert.INSTANCE.toDo(payload);
        this.dao.save(ado);
        this.cacheUtil.loadRemindCache();
        return PrdSystemRemindConvert.INSTANCE.toVo(ado);
    }

    @Transactional
    public Long update(PrdSystemRemindPayload payload) {
        String remindCode = "SYS:E:REMIND_CODE_NOT_REPEAT";
        boolean allowReturn = this.allowReturn(remindCode, (TwCommonPayload)payload);
        if (allowReturn) {
            PrdSystemRemindQuery query = new PrdSystemRemindQuery();
            query.setRemindCode(payload.getRemindCode());
            int count = this.dao.queryListDynamic(query).size();
            if (count > 0) {
                throw TwException.error("", "\u7f16\u53f7\u4e0d\u53ef\u91cd\u590d");
            }
        }
        this.dao.updateByKeyDynamic(payload);
        this.cacheUtil.loadRemindCache();
        return 0L;
    }

    @Transactional
    public boolean delete(List<Long> keys) {
        this.dao.delete(keys);
        this.cacheUtil.loadRemindCache();
        return true;
    }

    @Transactional
    public boolean deleteSoft(List<Long> keys) {
        this.dao.deleteSoft(keys);
        this.cacheUtil.loadRemindCache();
        return true;
    }

    public PrdSystemRemindVO queryByKey(Long key) {
        return this.dao.queryByKey(key);
    }

    public PagingVO<PrdSystemRemindVO> paging(PrdSystemRemindQuery query) {
        return this.dao.queryPaging(query);
    }

    public boolean allowReturn(String remindCode, TwCommonPayload payload) {
        PrdSystemRemindVO remind = this.cacheUtil.getRemind(remindCode);
        if (remind == null) {
            return true;
        }
        if ("ERROR".equals(remind.getRemindType())) {
            return true;
        }
        if ("INFO".equals(remind.getRemindType())) {
            return false;
        }
        if ("WARN".equals(remind.getRemindType())) {
            return payload == null || !payload.isIgnoreWarning();
        }
        return true;
    }

    public List<PrdSystemRemindVO> selectByCondition(PrdSystemRemindQuery query) {
        return this.dao.queryListDynamic(query);
    }

    public PrdSystemRemindServiceImpl(PrdSystemRemindDAO dao, CacheUtil cacheUtil) {
        this.dao = dao;
        this.cacheUtil = cacheUtil;
    }
}

