/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.system.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemSitePayload;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemSiteRefPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemSiteQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemSiteRefService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemSiteService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSiteVO;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdSystemSiteConvert;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemSiteDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemSitePurDAO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemSiteDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemSiteRepo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class PrdSystemSiteServiceImpl
extends BaseServiceImpl
implements PrdSystemSiteService {
    private static final Logger log = LoggerFactory.getLogger(PrdSystemSiteServiceImpl.class);
    private final PrdSystemSiteRepo prdSystemSiteRepo;
    private final PrdSystemSiteDAO prdSystemSiteDAO;
    private final PrdSystemSitePurDAO prdSystemSitePurDAO;
    private final PrdSystemSiteRefService prdSystemSiteRefService;

    public PagingVO<PrdSystemSiteVO> queryPaging(PrdSystemSiteQuery query) {
        return this.prdSystemSiteDAO.queryPaging(query);
    }

    public PagingVO<PrdSystemSiteVO> queryPurPaging(PrdSystemSiteQuery query) {
        return this.prdSystemSitePurDAO.queryPaging(query);
    }

    public List<PrdSystemSiteVO> queryListDynamic(PrdSystemSiteQuery query) {
        return this.prdSystemSiteDAO.queryListDynamic(query);
    }

    public PrdSystemSiteVO queryByKey(Long key) {
        PrdSystemSiteDO entity = this.prdSystemSiteRepo.findById(key).orElseGet(PrdSystemSiteDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PrdSystemSiteVO vo = PrdSystemSiteConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public PrdSystemSiteVO insert(PrdSystemSitePayload payload) {
        PrdSystemSiteVO prdSystemSiteVO = new PrdSystemSiteVO();
        Long siteId = payload.getSiteId();
        if (payload.getSiteId() == null) {
            PrdSystemSiteDO entityDo = PrdSystemSiteConvert.INSTANCE.toDo(payload);
            prdSystemSiteVO = PrdSystemSiteConvert.INSTANCE.toVo((PrdSystemSiteDO)this.prdSystemSiteRepo.save(entityDo));
            siteId = prdSystemSiteVO.getId();
        }
        String docType = payload.getDocType();
        Long docId = payload.getDocId();
        PrdSystemSiteRefPayload prdSystemSiteRefPayload = new PrdSystemSiteRefPayload();
        prdSystemSiteRefPayload.setSiteId(siteId);
        prdSystemSiteRefPayload.setDocType(docType);
        prdSystemSiteRefPayload.setDocId(docId);
        this.prdSystemSiteRefService.insert(prdSystemSiteRefPayload);
        return prdSystemSiteVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public PrdSystemSiteVO update(PrdSystemSitePayload payload) {
        PrdSystemSiteVO prdSystemSiteVO = new PrdSystemSiteVO();
        Long siteId = payload.getSiteId();
        if (payload.getSiteId() == null) {
            PrdSystemSiteDO entityDo = PrdSystemSiteConvert.INSTANCE.toDo(payload);
            prdSystemSiteVO = PrdSystemSiteConvert.INSTANCE.toVo((PrdSystemSiteDO)this.prdSystemSiteRepo.save(entityDo));
            siteId = prdSystemSiteVO.getId();
        }
        String docType = payload.getDocType();
        Long docId = payload.getDocId();
        PrdSystemSiteRefPayload prdSystemSiteRefPayload = new PrdSystemSiteRefPayload();
        prdSystemSiteRefPayload.setSiteId(siteId);
        prdSystemSiteRefPayload.setDocType(docType);
        prdSystemSiteRefPayload.setDocId(docId);
        prdSystemSiteRefPayload.setId(payload.getRefId());
        this.prdSystemSiteRefService.updateByKeyDynamic(prdSystemSiteRefPayload);
        return prdSystemSiteVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(PrdSystemSitePayload payload) {
        PrdSystemSiteDO entity = this.prdSystemSiteRepo.findById(payload.getId()).orElseGet(PrdSystemSiteDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.prdSystemSiteDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.prdSystemSiteDAO.deleteSoft(keys);
        }
    }

    public PrdSystemSiteServiceImpl(PrdSystemSiteRepo prdSystemSiteRepo, PrdSystemSiteDAO prdSystemSiteDAO, PrdSystemSitePurDAO prdSystemSitePurDAO, PrdSystemSiteRefService prdSystemSiteRefService) {
        this.prdSystemSiteRepo = prdSystemSiteRepo;
        this.prdSystemSiteDAO = prdSystemSiteDAO;
        this.prdSystemSitePurDAO = prdSystemSitePurDAO;
        this.prdSystemSiteRefService = prdSystemSiteRefService;
    }
}

