/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.acc.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccSubjectTemplateDetailPayload;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccSubjectTemplatePayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccSubjectTemplateDetailQuery;
import com.elitesland.tw.tw5.api.prd.acc.query.AccSubjectTemplateQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccSubjectTemplateDetailService;
import com.elitesland.tw.tw5.api.prd.acc.service.AccSubjectTemplateService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccBudgetItemVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccSubjectTemplateDetailVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccSubjectTemplateVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.acc.convert.AccSubjectTemplateConvert;
import com.elitesland.tw.tw5.server.prd.acc.dao.AccSubjectTemplateDAO;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccSubjectTemplateDO;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccSubjectTemplateRepo;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.AccTemplTypeEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class AccSubjectTemplateServiceImpl
extends BaseServiceImpl
implements AccSubjectTemplateService {
    private static final Logger log = LoggerFactory.getLogger(AccSubjectTemplateServiceImpl.class);
    private final AccSubjectTemplateDetailService accSubjectTemplateDetailService;
    private final AccSubjectTemplateRepo accSubjectTemplateRepo;
    private final AccSubjectTemplateDAO accSubjectTemplateDAO;
    private final CacheUtil cacheUtil;

    public PagingVO<AccSubjectTemplateVO> queryPaging(AccSubjectTemplateQuery query) {
        PagingVO<AccSubjectTemplateVO> pagingVO = this.accSubjectTemplateDAO.queryPaging(query);
        if (!ObjectUtils.isEmpty(pagingVO)) {
            pagingVO.getRecords().forEach(vo -> this.transferData((AccSubjectTemplateVO)vo));
        }
        return pagingVO;
    }

    public List<AccSubjectTemplateVO> queryListDynamic(AccSubjectTemplateQuery query) {
        return this.accSubjectTemplateDAO.queryListDynamic(query);
    }

    public AccSubjectTemplateVO queryByKey(Long key) {
        AccSubjectTemplateVO accSubjectTemplateVO = this.accSubjectTemplateDAO.queryByKey(key);
        if (accSubjectTemplateVO != null) {
            List accSubjectTemplateDetailVOS = this.accSubjectTemplateDetailService.queryListByTmplId(key);
            accSubjectTemplateVO.setTmpldVOs(accSubjectTemplateDetailVOS);
            this.transferData(accSubjectTemplateVO);
        }
        return accSubjectTemplateVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public AccSubjectTemplateVO insert(AccSubjectTemplatePayload payload) {
        this.checkData(payload);
        List<Long> ids = this.accSubjectTemplateDAO.queryByName(payload.getTmplName());
        if (ObjectUtils.isEmpty(ids)) {
            String code = this.generateSeqNum("ACC_SUBJECT_TEMPL", new String[0]);
            payload.setTmplNo(code);
            AccSubjectTemplateDO entityDo = AccSubjectTemplateConvert.INSTANCE.toDo(payload);
            AccSubjectTemplateDO save = this.accSubjectTemplateDAO.save(entityDo);
            AccSubjectTemplateVO accSubjectTemplateVO = AccSubjectTemplateConvert.INSTANCE.toVo(save);
            return accSubjectTemplateVO;
        }
        throw TwException.error("", "\u6a21\u677f\u540d\u79f0\u4e0d\u53ef\u91cd\u590d");
    }

    @Transactional(rollbackFor={Exception.class})
    public AccSubjectTemplateVO update(AccSubjectTemplatePayload payload) {
        this.checkData(payload);
        List<Long> ids = this.accSubjectTemplateDAO.queryByName(payload.getTmplName());
        if (ObjectUtils.isEmpty(ids) || ids.size() == 1 && ids.get(0).equals(payload.getId())) {
            AccSubjectTemplateDO entityDo = AccSubjectTemplateConvert.INSTANCE.toDo(payload);
            AccSubjectTemplateDO save = (AccSubjectTemplateDO)this.accSubjectTemplateRepo.save(entityDo);
            AccSubjectTemplateVO accSubjectTemplateVO = AccSubjectTemplateConvert.INSTANCE.toVo(save);
            if (!ObjectUtils.isEmpty((Object)payload.getTmpldPayloads())) {
                payload.getTmpldPayloads().forEach(tmpldPayload -> tmpldPayload.setTmplId(save.getId()));
                this.accSubjectTemplateDetailService.bacthInsert(payload.getTmpldPayloads(), accSubjectTemplateVO);
            }
            return accSubjectTemplateVO;
        }
        throw TwException.error("", "\u6a21\u677f\u540d\u79f0\u4e0d\u53ef\u91cd\u590d");
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(AccSubjectTemplatePayload payload) {
        long result = this.accSubjectTemplateDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty() && !keys.isEmpty()) {
            this.accSubjectTemplateDAO.deleteSoft(keys);
            this.accSubjectTemplateDetailService.deleteSoftByTemlIds(keys);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateStatus(List<Long> keys, String status) {
        this.accSubjectTemplateDAO.updateStatus(keys, status);
    }

    public void deleteSoftDetail(List<Long> keys) {
        this.accSubjectTemplateDetailService.deleteSoft(keys);
    }

    public List<AccSubjectTemplateDetailVO> bacthInsert(List<AccSubjectTemplateDetailPayload> payloads) {
        List collect = payloads.stream().filter(payload -> payload.getTmplId() != null).map(AccSubjectTemplateDetailPayload::getTmplId).distinct().collect(Collectors.toList());
        if (ObjectUtils.isEmpty(collect)) {
            throw TwException.error("", "\u6a21\u677fid\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (collect.size() > 1) {
            throw TwException.error("", "\u6a21\u677fid\u4e0d\u53ef\u591a\u4e2a");
        }
        AccSubjectTemplateVO accSubjectTemplateVO = this.accSubjectTemplateDAO.queryByKey((Long)collect.get(0));
        return this.accSubjectTemplateDetailService.bacthInsert(payloads, accSubjectTemplateVO);
    }

    public PagingVO<AccSubjectTemplateDetailVO> queryPagingDetail(AccSubjectTemplateDetailQuery query) {
        return this.accSubjectTemplateDetailService.queryPaging(query);
    }

    public List<AccBudgetItemVO> queryBudgetItemList(Long tmplId) {
        return this.accSubjectTemplateDetailService.queryBudgetItemList(tmplId);
    }

    private void checkData(AccSubjectTemplatePayload payload) {
        PrdSystemSelectionVO selection;
        if (ObjectUtils.isEmpty((Object)payload.getTmplClass())) {
            throw TwException.error("", "\u6a21\u677f\u7c7b\u522b\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (AccTemplTypeEnum.PROJ_ACC.getCode().equals(payload.getTmplClass()) && !ObjectUtils.isEmpty((Object)(selection = this.cacheUtil.getSystemSelection("salecon:work_type")))) {
            String[] arr;
            List valueList = selection.getChildren().stream().map(v -> v.getSelectionValue()).collect(Collectors.toList());
            for (String value : arr = payload.getTmplType().split(",")) {
                if (valueList.contains(value)) continue;
                throw TwException.error("", "\u9002\u7528\u7c7b\u578b\u4e0d\u7b26\u5408\u9650\u5236,\u8bf7\u6838\u9a8c\uff01");
            }
        }
        if (AccTemplTypeEnum.BU_ACC.getCode().equals(payload.getTmplClass())) {
            long count;
            if (payload.getTmplType().contains(",")) {
                throw TwException.error("", "\u5f53\u6a21\u677f\u7c7b\u578b\u662fBU\u79d1\u76ee\u6a21\u677f\u65f6\uff0c\u9002\u7528\u7c7b\u578b\u53ea\u80fd\u5355\u9009");
            }
            selection = this.cacheUtil.getSystemSelection("BU:SUIT_TYPY");
            if (!ObjectUtils.isEmpty((Object)selection) && (count = selection.getChildren().stream().filter(v -> payload.getTmplType().contains(v.getSelectionValue())).count()) == 0L) {
                throw TwException.error("", "\u9002\u7528\u7c7b\u578b\u4e0d\u7b26\u5408\u9650\u5236,\u8bf7\u6838\u9a8c\uff01");
            }
        }
    }

    void transferData(AccSubjectTemplateVO templateVO) {
        if (AccTemplTypeEnum.PROJ_ACC.getCode().equals(templateVO.getTmplClass()) && !ObjectUtils.isEmpty((Object)templateVO.getTmplType())) {
            String[] arr = templateVO.getTmplType().split(",");
            PrdSystemSelectionVO selection = this.cacheUtil.getSystemSelection("salecon:work_type");
            if (selection != null && !ObjectUtils.isEmpty((Object)selection.getChildren())) {
                ArrayList<String> tmplTypeNames = new ArrayList<String>();
                List childrens = selection.getChildren();
                for (String value : arr) {
                    for (PrdSystemSelectionVO selectionVO : childrens) {
                        if (!selectionVO.getSelectionValue().equalsIgnoreCase(value)) continue;
                        tmplTypeNames.add(selectionVO.getSelectionName());
                    }
                }
                templateVO.setTmplTypeNames(String.join((CharSequence)",", tmplTypeNames));
            }
        }
        if (AccTemplTypeEnum.BU_ACC.getCode().equals(templateVO.getTmplClass()) && !ObjectUtils.isEmpty((Object)templateVO.getTmplType())) {
            String tmplTypeNames = this.cacheUtil.transferSystemSelection("BU:SUIT_TYPY", templateVO.getTmplType());
            templateVO.setTmplTypeNames(tmplTypeNames);
        }
    }

    public AccSubjectTemplateServiceImpl(AccSubjectTemplateDetailService accSubjectTemplateDetailService, AccSubjectTemplateRepo accSubjectTemplateRepo, AccSubjectTemplateDAO accSubjectTemplateDAO, CacheUtil cacheUtil) {
        this.accSubjectTemplateDetailService = accSubjectTemplateDetailService;
        this.accSubjectTemplateRepo = accSubjectTemplateRepo;
        this.accSubjectTemplateDAO = accSubjectTemplateDAO;
        this.cacheUtil = cacheUtil;
    }
}

