/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.borrow.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.borrow.payload.BorrowWriteOffPayload;
import com.elitesland.tw.tw5.api.prd.borrow.query.BorrowWriteOffQuery;
import com.elitesland.tw.tw5.api.prd.borrow.service.BorrowWriteOffService;
import com.elitesland.tw.tw5.api.prd.borrow.vo.BorrowMoneyVO;
import com.elitesland.tw.tw5.api.prd.borrow.vo.BorrowWriteOffVO;
import com.elitesland.tw.tw5.server.prd.borrow.convert.BorrowWriteOffConvert;
import com.elitesland.tw.tw5.server.prd.borrow.dao.BorrowWriteOffDAO;
import com.elitesland.tw.tw5.server.prd.borrow.entity.BorrowWriteOffDO;
import com.elitesland.tw.tw5.server.prd.borrow.repo.BorrowWriteOffRepo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class BorrowWriteOffServiceImpl
extends BaseServiceImpl
implements BorrowWriteOffService {
    private static final Logger log = LoggerFactory.getLogger(BorrowWriteOffServiceImpl.class);
    private final BorrowWriteOffRepo borrowWriteOffRepo;
    private final BorrowWriteOffDAO borrowWriteOffDAO;

    public PagingVO<BorrowWriteOffVO> queryPaging(BorrowWriteOffQuery query) {
        return this.borrowWriteOffDAO.queryPaging(query);
    }

    public List<BorrowWriteOffVO> queryListDynamic(BorrowWriteOffQuery query) {
        return this.borrowWriteOffDAO.queryListDynamic(query);
    }

    public BorrowWriteOffVO queryByKey(Long key) {
        BorrowWriteOffDO entity = this.borrowWriteOffRepo.findById(key).orElseGet(BorrowWriteOffDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BorrowWriteOffVO vo = BorrowWriteOffConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public BorrowWriteOffVO insert(BorrowWriteOffPayload payload) {
        BorrowWriteOffDO entityDo = BorrowWriteOffConvert.INSTANCE.toDo(payload);
        return BorrowWriteOffConvert.INSTANCE.toVo((BorrowWriteOffDO)this.borrowWriteOffRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public BorrowWriteOffVO update(BorrowWriteOffPayload payload) {
        BorrowWriteOffDO entity = this.borrowWriteOffRepo.findById(payload.getId()).orElseGet(BorrowWriteOffDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BorrowWriteOffDO entityDo = BorrowWriteOffConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return BorrowWriteOffConvert.INSTANCE.toVo((BorrowWriteOffDO)this.borrowWriteOffRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(BorrowWriteOffPayload payload) {
        BorrowWriteOffDO entity = this.borrowWriteOffRepo.findById(payload.getId()).orElseGet(BorrowWriteOffDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.borrowWriteOffDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.borrowWriteOffDAO.deleteSoft(keys);
        }
    }

    public List<BorrowMoneyVO> queryByReimId(Long reimId) {
        return this.borrowWriteOffDAO.queryByReimId(reimId);
    }

    @Transactional
    public void deleteByReimId(Long reimId) {
        this.borrowWriteOffDAO.deleteByReimId(reimId);
    }

    public BorrowWriteOffServiceImpl(BorrowWriteOffRepo borrowWriteOffRepo, BorrowWriteOffDAO borrowWriteOffDAO) {
        this.borrowWriteOffRepo = borrowWriteOffRepo;
        this.borrowWriteOffDAO = borrowWriteOffDAO;
    }
}

