/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.cal.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalNormSettlePayload;
import com.elitesland.tw.tw5.api.prd.cal.query.CalAccountQuery;
import com.elitesland.tw.tw5.api.prd.cal.query.CalNormSettleQuery;
import com.elitesland.tw.tw5.api.prd.cal.service.CalAccountService;
import com.elitesland.tw.tw5.api.prd.cal.service.CalNormSettleService;
import com.elitesland.tw.tw5.api.prd.cal.service.CalResourceService;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalAccountVO;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalNormSettleVO;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConReceivablePlanQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConReceivablePlanService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConReceivablePlanVO;
import com.elitesland.tw.tw5.server.common.ExcelUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.DateUtil;
import com.elitesland.tw.tw5.server.prd.cal.convert.CalNormSettleConvert;
import com.elitesland.tw.tw5.server.prd.cal.dao.CalNormSettleDAO;
import com.elitesland.tw.tw5.server.prd.cal.entity.CalNormSettleDO;
import com.elitesland.tw.tw5.server.prd.cal.repo.CalNormSettleRepo;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CalNormCreateTypeEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CalSettleStatusEnum;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class CalNormSettleServiceImpl
extends BaseServiceImpl
implements CalNormSettleService {
    private static final Logger log = LoggerFactory.getLogger(CalNormSettleServiceImpl.class);
    private final CalNormSettleRepo calNormSettleRepo;
    private final CalNormSettleDAO calNormSettleDAO;
    private final CalResourceService calResourceService;
    private final ExcelUtil excelUtil;
    private final ConReceivablePlanService conReceivablePlanService;
    private final CalAccountService calAccountService;

    public PagingVO<CalNormSettleVO> queryPaging(CalNormSettleQuery query) {
        return this.calNormSettleDAO.queryPaging(query);
    }

    public List<CalNormSettleVO> queryListDynamic(CalNormSettleQuery query) {
        return this.calNormSettleDAO.queryListDynamic(query);
    }

    public CalNormSettleVO queryByKey(Long key) {
        return this.calNormSettleDAO.queryByKey(key);
    }

    @Transactional(rollbackFor={Exception.class})
    public CalNormSettleVO insertOrUpdate(CalNormSettlePayload payload) {
        this.checkData(payload);
        Long loginUserId = GlobalUtil.getLoginUserId();
        LocalDateTime applyDate = LocalDateTime.now();
        if (payload.getId() == null) {
            String code = this.generateSeqNum("CAL_NORM_SETTLE", new String[0]);
            payload.setSettleNo(code);
        } else {
            CalNormSettleVO calNormSettleVO = this.calNormSettleDAO.queryByKey(payload.getId());
            if (calNormSettleVO == null || !calNormSettleVO.getSettleStatus().equals(CalSettleStatusEnum.CREATE.getCode())) {
                throw TwException.error("", "\u4e0d\u652f\u6301\u6539\u72b6\u6001\u6570\u636e\u4fee\u6539");
            }
            applyDate = calNormSettleVO.getApplyDate();
            loginUserId = calNormSettleVO.getApplyResId();
            payload.setCreateTime(calNormSettleVO.getCreateTime());
            payload.setCreateUserId(calNormSettleVO.getCreateUserId());
        }
        String status = CalSettleStatusEnum.CREATE.getCode();
        if (payload.getIsSubmit() != null && payload.getIsSubmit() == 1) {
            status = CalSettleStatusEnum.FINISH.getCode();
        }
        payload.setSettleStatus(status);
        payload.setApplyResId(loginUserId);
        payload.setApplyDate(applyDate);
        CalNormSettleDO entityDo = CalNormSettleConvert.INSTANCE.toDo(payload);
        CalNormSettleVO calNormSettleVO = CalNormSettleConvert.INSTANCE.toVo((CalNormSettleDO)this.calNormSettleRepo.save(entityDo));
        if (status.equals(CalSettleStatusEnum.FINISH.getCode())) {
            this.calResourceService.amountSettleTurnover(calNormSettleVO, Integer.valueOf(1));
        }
        return calNormSettleVO;
    }

    void checkData(CalNormSettlePayload payload) {
        if (payload.getSettleDate() == null) {
            throw TwException.error("", "\u7ed3\u7b97\u671f\u95f4\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)payload.getCreateType())) {
            throw TwException.error("", "\u5355\u636e\u521b\u5efa\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)payload.getBusiType())) {
            throw TwException.error("", "\u4e1a\u52a1\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (payload.getApproveSettleAmt() == null || payload.getApproveSettleAmt().compareTo(BigDecimal.ZERO) <= 0) {
            throw TwException.error("", "\u4ea4\u6613\u989d\u4e0d\u53ef\u4e3a\u7a7a\u4e14\u5927\u4e8e0");
        }
        if (payload.getInAccountId() == null) {
            throw TwException.error("", "\u652f\u51fa\u65b9\u8d26\u6237id\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (payload.getInAccount() == null) {
            throw TwException.error("", "\u652f\u51fa\u65b9\u8d26\u6237\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (payload.getOutAccountId() == null) {
            throw TwException.error("", "\u6536\u5165\u65b9\u8d26\u6237id\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (payload.getOutAccount() == null) {
            throw TwException.error("", "\u6536\u5165\u65b9\u8d26\u6237\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (payload.getContractId() != null && !StringUtils.hasText((String)payload.getContractName())) {
            throw TwException.error("", "\u5b50\u5408\u540c\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (payload.getProjId() != null && !StringUtils.hasText((String)payload.getProjName())) {
            throw TwException.error("", "\u9879\u76ee\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (payload.getInAccountId().equals(payload.getOutAccountId())) {
            throw TwException.error("", "\u652f\u51fa\u3001\u6536\u5165\u6838\u7b97\u4e3b\u4f53\u4e0d\u53ef\u76f8\u540c");
        }
        if (payload.getBusiType().equals("CONTRACT") && payload.getProjId() == null) {
            throw TwException.error("", "\u4e1a\u52a1\u7c7b\u578b\u4e3a\u3010\u5408\u540c\u6536\u76ca\u5206\u914d\u3011\uff0c\u9879\u76ee\u4e0d\u53ef\u4e3a\u7a7a");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(CalNormSettlePayload payload) {
        long result = this.calNormSettleDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            List collect;
            List<CalNormSettleVO> calNormSettleVOS = this.calNormSettleDAO.queryByKeys(keys);
            if (calNormSettleVOS.size() > 0 && (collect = calNormSettleVOS.stream().filter(vo -> !vo.getSettleStatus().equals(CalSettleStatusEnum.CREATE.getCode())).collect(Collectors.toList())).size() > 0) {
                throw TwException.error("", "\u4ec5\u652f\u6301\u65b0\u5efa\u72b6\u6001\u5220\u9664");
            }
            this.calNormSettleDAO.deleteSoft(keys);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void cancelNorm(Long key) {
        CalNormSettleVO calNormSettleVO = this.calNormSettleDAO.queryByKey(key);
        if (calNormSettleVO == null || !calNormSettleVO.getSettleStatus().equals(CalSettleStatusEnum.FINISH.getCode())) {
            throw TwException.error("", "\u4e0d\u652f\u6301\u6539\u72b6\u6001\u6570\u636e\u4fee\u6539");
        }
        calNormSettleVO.setRemark("\u6cdb\u7528\u91d1\u989d\u7ed3\u7b97\u53d6\u6d88\u8fc7\u8d26 \u5355\u53f7\uff1a" + calNormSettleVO.getSettleNo());
        this.calResourceService.amountSettleTurnover(calNormSettleVO, Integer.valueOf(0));
        CalNormSettlePayload payload = new CalNormSettlePayload();
        payload.setId(key);
        payload.setSettleStatus(CalSettleStatusEnum.CREATE.getCode());
        this.calNormSettleDAO.updateByKeyDynamic(payload);
    }

    public void downloadPlus(HttpServletResponse response) {
        ClassPathResource classPathResource = new ClassPathResource("template/calNormSettle.xlsx");
        try {
            InputStream inputStream = classPathResource.getInputStream();
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            XSSFSheet batchProjectSheet = (XSSFSheet)workbook.getSheet("\u6cdb\u7528\u91d1\u989d\u6570\u636e");
            this.excelUtil.generateRangeList(batchProjectSheet, 1, 2, "LOV", 2, "A");
            String fileName = "\u6cdb\u7528\u91d1\u989d\u5bfc\u5165\u6a21\u677f-" + LocalDate.now();
            this.excelUtil.setColumnFormulas(batchProjectSheet, 8, "VLOOKUP(B:rowNo,LOV!A:B,2,FALSE)");
            batchProjectSheet.setColumnHidden(8, true);
            ExcelUtil.writeResponse(response, fileName, workbook);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean batchImport(MultipartFile file) {
        int dataStartRow;
        Row row;
        String busiTypeName;
        if (file == null) {
            throw TwException.error("", "\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38");
        }
        Workbook workbook = null;
        try {
            workbook = WorkbookFactory.create((InputStream)file.getInputStream());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            throw TwException.error("", "\u6587\u4ef6\u89e3\u6790\u5f02\u5e38");
        }
        Sheet sheet = workbook.getSheet("\u6cdb\u7528\u91d1\u989d\u6570\u636e");
        if (sheet == null) {
            throw TwException.error("", "\u8868\u7ed3\u6784\u9519\u8bef");
        }
        ArrayList<CalNormSettlePayload> payloads = new ArrayList<CalNormSettlePayload>();
        HashSet<String> recvplanNos = new HashSet<String>();
        HashSet<String> accountNos = new HashSet<String>();
        Long loginUserId = GlobalUtil.getLoginUserId();
        LocalDateTime applyDate = LocalDateTime.now();
        String status = CalSettleStatusEnum.FINISH.getCode();
        String createType = CalNormCreateTypeEnum.HANDWORK.getCode();
        for (int i = dataStartRow = 2; i <= sheet.getLastRowNum() && StringUtils.hasText((String)(busiTypeName = ExcelUtil.getCellFormatValue((row = sheet.getRow(i)).getCell(1)))); ++i) {
            String approveSettleAmt;
            CalNormSettlePayload payload = new CalNormSettlePayload();
            String contractNo = ExcelUtil.getCellFormatValue(row.getCell(2));
            String recvplanNo = ExcelUtil.getCellFormatValue(row.getCell(3));
            if (StringUtils.hasText((String)recvplanNo)) {
                if (!StringUtils.hasText((String)contractNo)) {
                    throw TwException.error("", "\u76f8\u5173\u6536\u6b3e\u53f7\u5b58\u5728\uff0c\u5b50\u5408\u540c\u7f16\u53f7\u4e0d\u53ef\u4e3a\u7a7a");
                }
                recvplanNos.add(recvplanNo.trim());
                payload.setRecvplanNo(recvplanNo.trim());
            }
            if (!StringUtils.hasText((String)(approveSettleAmt = ExcelUtil.getCellFormatValue(row.getCell(4))))) {
                throw TwException.error("", "\u7ed3\u7b97\u91d1\u989d\u4e0d\u53ef\u4e3a\u7a7a");
            }
            String settleDate = ExcelUtil.getCellFormatValue(row.getCell(5));
            if (!StringUtils.hasText((String)settleDate)) {
                throw TwException.error("", "\u7ed3\u7b97\u671f\u95f4\u4e0d\u53ef\u4e3a\u7a7a");
            }
            String outAccountNo = ExcelUtil.getCellFormatValue(row.getCell(6));
            if (!StringUtils.hasText((String)outAccountNo)) {
                throw TwException.error("", "\u652f\u51fa\u8d26\u6237\u4e0d\u53ef\u4e3a\u7a7a");
            }
            String inAccountNo = ExcelUtil.getCellFormatValue(row.getCell(7));
            if (!StringUtils.hasText((String)inAccountNo)) {
                throw TwException.error("", "\u6536\u5165\u8d26\u6237\u4e0d\u53ef\u4e3a\u7a7a");
            }
            if (outAccountNo.equals(inAccountNo)) {
                throw TwException.error("", "\u652f\u51fa\u3001\u6536\u5165\u6838\u7b97\u4e3b\u4f53\u4e0d\u53ef\u76f8\u540c");
            }
            accountNos.add(outAccountNo.trim());
            accountNos.add(inAccountNo.trim());
            String busiType = ExcelUtil.getCellFormatValue(row.getCell(8));
            String code = this.generateSeqNum("CAL_NORM_SETTLE", new String[0]);
            payload.setSettleNo(code);
            payload.setSettleStatus(status);
            payload.setApplyDate(applyDate);
            payload.setApplyResId(loginUserId);
            payload.setCreateType(createType);
            payload.setApproveSettleAmt(new BigDecimal(approveSettleAmt));
            payload.setBusiType(busiType);
            payload.setContractNo(contractNo);
            payload.setSettleDate(DateUtil.strToLocalDate(settleDate));
            payload.setInAccount(inAccountNo.trim());
            payload.setOutAccount(outAccountNo.trim());
            payloads.add(payload);
        }
        log.info("\u521d\u59cbpayloads\uff1a{}" + ((Object)payloads).toString());
        if (recvplanNos.size() > 0) {
            this.checkContractAndRecePlan(payloads, new ArrayList<String>(recvplanNos));
        }
        List<CalAccountVO> calAccountVOS = this.checkAccount(payloads, new ArrayList<String>(accountNos));
        log.info("\u8d4b\u503c\u540epayloads\uff1a{}" + ((Object)payloads).toString());
        List<CalNormSettleDO> calNormSettleDOS = CalNormSettleConvert.INSTANCE.toDos(payloads);
        List<CalNormSettleDO> calNormSettleDOS1 = this.calNormSettleDAO.saveAll(calNormSettleDOS);
        List<CalNormSettleVO> calNormSettleVOS = CalNormSettleConvert.INSTANCE.toVos(calNormSettleDOS1);
        this.calResourceService.amountBatchSettleTurnover(calNormSettleVOS, calAccountVOS);
        return true;
    }

    List<CalAccountVO> checkAccount(List<CalNormSettlePayload> payloads, List<String> accountNos) {
        CalAccountQuery query = new CalAccountQuery();
        query.setLedgerNos(accountNos);
        List calAccountVOS = this.calAccountService.queryListDynamic(query);
        if (ObjectUtils.isEmpty((Object)calAccountVOS)) {
            throw TwException.error("", "\u8d26\u6237\u6570\u636e\u4e0d\u5b58\u5728");
        }
        payloads.forEach(payload -> {
            Optional<CalAccountVO> first = calAccountVOS.stream().filter(vo -> vo.getLedgerNo().equals(payload.getOutAccount())).findFirst();
            if (!first.isPresent()) {
                throw TwException.error("", "\u7f16\u53f7\uff1a" + payload.getOutAccount() + "\u8d26\u6237\u6570\u636e\u4e0d\u5b58\u5728");
            }
            CalAccountVO outAccountVO = first.get();
            if (outAccountVO.getLedgerStatus().equals("0")) {
                throw TwException.error("", outAccountVO.getLedgerNo() + "\u8d26\u6237\u5df2\u7981\u7528");
            }
            payload.setOutAccountId(outAccountVO.getId());
            payload.setOutAccount(outAccountVO.getLedgerName());
            Optional<CalAccountVO> first0 = calAccountVOS.stream().filter(vo -> vo.getLedgerNo().equals(payload.getInAccount())).findFirst();
            if (!first0.isPresent()) {
                throw TwException.error("", "\u7f16\u53f7\uff1a" + payload.getInAccount() + "\u8d26\u6237\u6570\u636e\u4e0d\u5b58\u5728");
            }
            CalAccountVO inAccountVO = first0.get();
            if (inAccountVO.getLedgerStatus().equals("0")) {
                throw TwException.error("", payload.getInAccount() + "\u8d26\u6237\u5df2\u7981\u7528");
            }
            payload.setInAccountId(inAccountVO.getId());
            payload.setInAccount(inAccountVO.getLedgerName());
        });
        return calAccountVOS;
    }

    void checkContractAndRecePlan(List<CalNormSettlePayload> payloads, List<String> receNos) {
        ConReceivablePlanQuery query = new ConReceivablePlanQuery();
        query.setReceNos(receNos);
        List conReceivablePlanVOS = this.conReceivablePlanService.queryListDynamic(query);
        if (ObjectUtils.isEmpty((Object)conReceivablePlanVOS)) {
            throw TwException.error("", "\u6536\u6b3e\u8ba1\u5212\u6570\u636e\u4e0d\u5b58\u5728");
        }
        payloads.forEach(payload -> {
            if (StringUtils.hasText((String)payload.getRecvplanNo())) {
                Optional<ConReceivablePlanVO> first = conReceivablePlanVOS.stream().filter(vo -> vo.getReceNo().equals(payload.getRecvplanNo().trim())).findFirst();
                if (!first.isPresent()) {
                    throw TwException.error("", "\u7f16\u53f7\uff1a" + payload.getRecvplanNo() + "\u6536\u6b3e\u8ba1\u5212\u6570\u636e\u4e0d\u5b58\u5728");
                }
                ConReceivablePlanVO planVO = first.get();
                if (!StringUtils.hasText((String)planVO.getSaleConCode()) || !planVO.getSaleConCode().equals(payload.getContractNo().trim())) {
                    throw TwException.error("", "\u7f16\u53f7\uff1a" + payload.getRecvplanNo() + "\u6536\u6b3e\u8ba1\u5212\u5f52\u5c5e\u5408\u540c\u7f16\u53f7\u4e3a\uff1a" + planVO.getSaleConCode());
                }
                payload.setContractId(planVO.getSaleConId());
                payload.setContractName(planVO.getSaleConName());
                payload.setRecvplanId(planVO.getId());
                payload.setReceStage(planVO.getReceStage());
            }
        });
    }

    public CalNormSettleServiceImpl(CalNormSettleRepo calNormSettleRepo, CalNormSettleDAO calNormSettleDAO, CalResourceService calResourceService, ExcelUtil excelUtil, ConReceivablePlanService conReceivablePlanService, CalAccountService calAccountService) {
        this.calNormSettleRepo = calNormSettleRepo;
        this.calNormSettleDAO = calNormSettleDAO;
        this.calResourceService = calResourceService;
        this.excelUtil = excelUtil;
        this.conReceivablePlanService = conReceivablePlanService;
        this.calAccountService = calAccountService;
    }
}

