/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.dao;

import com.elitesland.tw.tw5.server.prd.my.entity.QVacationDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.time.LocalDate;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class VacationDAO {
    private static final QVacationDO qVacationDO = QVacationDO.vacationDO;
    private final JPAQueryFactory jpaQueryFactory;

    public long findWorkDay(LocalDate startDate, LocalDate endDate) {
        long res = ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(VacationDAO.qVacationDO.id).from((EntityPath)qVacationDO)).where((Predicate)VacationDAO.qVacationDO.naturalDate.between((Comparable)startDate, (Comparable)endDate))).where((Predicate)VacationDAO.qVacationDO.workHours.eq((Object)Float.valueOf(8.0f)))).fetchCount();
        return res;
    }

    public List<LocalDate> findVacationDay(LocalDate startDate, LocalDate endDate) {
        List res = ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(VacationDAO.qVacationDO.naturalDate).distinct()).from((EntityPath)qVacationDO)).where((Predicate)VacationDAO.qVacationDO.naturalDate.between((Comparable)startDate, (Comparable)endDate))).where((Predicate)VacationDAO.qVacationDO.workHours.eq((Object)Float.valueOf(0.0f)))).where((Predicate)VacationDAO.qVacationDO.deleteFlag.eq((Object)0))).fetch();
        return res;
    }

    public List<LocalDate> findVacationDayIn(List<LocalDate> naturalDateList) {
        List res = ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(VacationDAO.qVacationDO.naturalDate).distinct()).from((EntityPath)qVacationDO)).where((Predicate)VacationDAO.qVacationDO.naturalDate.in(naturalDateList))).where((Predicate)VacationDAO.qVacationDO.workHours.eq((Object)Float.valueOf(0.0f)))).where((Predicate)VacationDAO.qVacationDO.deleteFlag.eq((Object)0))).fetch();
        return res;
    }

    public List<LocalDate> findWorkLocalDay(LocalDate startDate, LocalDate endDate) {
        List res = ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(VacationDAO.qVacationDO.naturalDate).distinct()).from((EntityPath)qVacationDO)).where((Predicate)VacationDAO.qVacationDO.naturalDate.between((Comparable)startDate, (Comparable)endDate))).where((Predicate)VacationDAO.qVacationDO.workHours.eq((Object)Float.valueOf(8.0f)))).where((Predicate)VacationDAO.qVacationDO.deleteFlag.eq((Object)0))).fetch();
        return res;
    }

    public VacationDAO(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

