/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.prd.my.payload.TServerApplyPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TServerApplyQuery;
import com.elitesland.tw.tw5.api.prd.my.service.TServerApplyService;
import com.elitesland.tw.tw5.api.prd.my.vo.TServerApplyVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgRoleVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.my.convert.TServerApplyConvert;
import com.elitesland.tw.tw5.server.prd.my.dao.TServerApplyDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.TServerApplyDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TServerApplyRepo;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.payload.SetVariablesPayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class TServerApplyServiceImpl
extends BaseServiceImpl
implements TServerApplyService {
    private static final Logger log = LoggerFactory.getLogger(TServerApplyServiceImpl.class);
    private final TServerApplyRepo tServerApplyRepo;
    private final TServerApplyDAO tServerApplyDAO;
    private final CacheUtil cacheUtil;
    private final WorkflowUtil workflowUtil;
    private final PrdOrgOrganizationDAO daoOrg;
    @Value(value="${tw5.workflow.enabled}")
    private Boolean workflow_enabled;
    @Value(value="${tw5.workflow.orgId}")
    private Long workflow_orgId;
    private final TransactionUtilService transactionUtilService;

    public PagingVO<TServerApplyVO> queryPaging(TServerApplyQuery query) {
        PagingVO<TServerApplyVO> paging = this.tServerApplyDAO.queryPaging(query);
        return paging;
    }

    public List<TServerApplyVO> queryListDynamic(TServerApplyQuery query) {
        return this.tServerApplyDAO.queryListDynamic(query);
    }

    public TServerApplyVO queryByKey(Long key) {
        TServerApplyDO entity = this.tServerApplyRepo.findById(key).orElseGet(TServerApplyDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        TServerApplyVO vo = TServerApplyConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public TServerApplyVO insert(TServerApplyPayload payload) {
        payload.setApplyDate(LocalDate.now());
        payload.setApplyNo(this.generateSeqNum("SERVER_APPLY_NO", new String[0]));
        TServerApplyDO entityDo = TServerApplyConvert.INSTANCE.toDo(payload);
        TServerApplyDO save = (TServerApplyDO)this.tServerApplyRepo.save(entityDo);
        if (payload.getSubmit() != null && payload.getSubmit().booleanValue()) {
            this.serverApplyProc(save);
        }
        return TServerApplyConvert.INSTANCE.toVo(save);
    }

    @Transactional(rollbackFor={Exception.class})
    public TServerApplyVO update(TServerApplyPayload payload) {
        TServerApplyDO entity = this.tServerApplyRepo.findById(payload.getId()).orElseGet(TServerApplyDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        TServerApplyDO entityDo = TServerApplyConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        TServerApplyDO save = (TServerApplyDO)this.tServerApplyRepo.save(entity);
        if (StringUtils.hasText((String)payload.getProcInstId())) {
            SetVariablesPayload setVariablesPayload = new SetVariablesPayload();
            setVariablesPayload.setProcInstId(payload.getProcInstId());
            HashMap<String, Boolean> variables = new HashMap<String, Boolean>();
            if ("CLOUD".equals(payload.getType())) {
                variables.put("cloudServerFlag", true);
            } else {
                variables.put("cloudServerFlag", false);
            }
            setVariablesPayload.setVariables(variables);
            this.workflowUtil.setVaribales(setVariablesPayload);
        }
        if (payload.getSubmit() != null && payload.getSubmit().booleanValue()) {
            this.serverApplyProc(save);
        }
        return TServerApplyConvert.INSTANCE.toVo(save);
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(TServerApplyPayload payload) {
        TServerApplyDO entity = this.tServerApplyRepo.findById(payload.getId()).orElseGet(TServerApplyDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.tServerApplyDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.tServerApplyDAO.deleteSoft(keys);
        }
    }

    private void serverApplyProc(TServerApplyDO applyDo) {
        ProcessInfo processInfo = new ProcessInfo();
        String status = WorkFlowStatusEnum.CREATE_WORK.getCode();
        if (this.workflow_enabled.booleanValue()) {
            status = WorkFlowStatusEnum.APPROVING_WORK.getCode();
            HashMap<String, Object> variables = new HashMap<String, Object>();
            Long applyResId = applyDo.getUserResId();
            if ("CLOUD".equals(applyDo.getType())) {
                variables.put("cloudServerFlag", true);
            } else {
                variables.put("cloudServerFlag", false);
            }
            Long expenseBuId = applyDo.getExpenseBuId();
            Long expenseBuManageUserId = this.daoOrg.queryManageIdById(expenseBuId);
            variables.put("Activity_0zkpvgk", expenseBuManageUserId);
            Long userBuId = applyDo.getUserBuId();
            Long userBuManageUserId = this.daoOrg.queryManageIdById(userBuId);
            variables.put("Activity_0ph077t", userBuManageUserId);
            String applyResName = this.cacheUtil.getUserName(applyResId);
            PrdOrgRoleVO platItAdmin = this.daoOrg.queryRoleByOrgIdAndRoleCode(this.workflow_orgId, "PLAT_IT_ADMIN");
            if (ObjectUtils.isEmpty((Object)platItAdmin)) {
                throw TwException.error("", "\u5e73\u53f0IT\u8d1f\u8d23\u4eba\u89d2\u8272\u4e0d\u5b58\u5728\uff01");
            }
            String[] splitByPlatItAdmin = platItAdmin.getRoleEmployees().split(",");
            variables.put("Activity_1tge65e", Arrays.asList(splitByPlatItAdmin));
            PrdOrgRoleVO purchaseManager = this.daoOrg.queryRoleByOrgIdAndRoleCode(this.workflow_orgId, "PURCHASE_MANAGER");
            if (ObjectUtils.isEmpty((Object)purchaseManager)) {
                throw TwException.error("", "\u5e73\u53f0\u91c7\u8d2d\u4e3b\u7ba1\u89d2\u8272\u4e0d\u5b58\u5728\uff01");
            }
            String[] splitByPurchaseManager = purchaseManager.getRoleEmployees().split(",");
            variables.put("Activity_1gcgq14", Arrays.asList(splitByPurchaseManager));
            processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.SERVER_APPLY.name(), (String)(applyResName + "-\u670d\u52a1\u5668\u7533\u8bf7\u6d41\u7a0b"), (String)("" + applyDo.getId()), variables), new Long[0]);
        }
        TServerApplyPayload payload = new TServerApplyPayload();
        payload.setProcInstId(processInfo.getProcInstId());
        payload.setId(applyDo.getId());
        payload.setProcInstStatus(processInfo.getProcInstStatus());
        payload.setSubmitTime(LocalDateTime.now());
        payload.setApplyStatus(status);
        this.transactionUtilService.executeWithRunnable(() -> this.tServerApplyDAO.updateByKeyDynamic(payload));
    }

    public TServerApplyServiceImpl(TServerApplyRepo tServerApplyRepo, TServerApplyDAO tServerApplyDAO, CacheUtil cacheUtil, WorkflowUtil workflowUtil, PrdOrgOrganizationDAO daoOrg, TransactionUtilService transactionUtilService) {
        this.tServerApplyRepo = tServerApplyRepo;
        this.tServerApplyDAO = tServerApplyDAO;
        this.cacheUtil = cacheUtil;
        this.workflowUtil = workflowUtil;
        this.daoOrg = daoOrg;
        this.transactionUtilService = transactionUtilService;
    }
}

