/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.partner.team.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.service.BusinessCustomerInfoService;
import com.elitesland.tw.tw5.api.prd.partner.team.payload.BusinessTeamMemberPayload;
import com.elitesland.tw.tw5.api.prd.partner.team.query.BusinessTeamMemberQuery;
import com.elitesland.tw.tw5.api.prd.partner.team.service.BusinessTeamMemberService;
import com.elitesland.tw.tw5.api.prd.partner.team.vo.BusinessTeamMemberVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessSelectionEnum;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessTeamRoleEnum;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessTeamTypeEnum;
import com.elitesland.tw.tw5.server.prd.partner.team.convert.BusinessTeamMemberConvert;
import com.elitesland.tw.tw5.server.prd.partner.team.dao.BusinessTeamMemberDAO;
import com.elitesland.tw.tw5.server.prd.partner.team.entity.BusinessTeamMemberDO;
import com.elitesland.tw.tw5.server.prd.partner.team.repo.BusinessTeamMemberRepo;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class BusinessTeamMemberServiceImpl
extends BaseServiceImpl
implements BusinessTeamMemberService {
    private static final Logger log = LoggerFactory.getLogger(BusinessTeamMemberServiceImpl.class);
    private final BusinessTeamMemberRepo businessTeamMemberRepo;
    private final BusinessTeamMemberDAO businessTeamMemberDAO;
    private final PrdSystemLogService logService;
    private final CacheUtil cacheUtil;
    private final BusinessCustomerInfoService businessCustomerInfoService;

    public PagingVO<BusinessTeamMemberVO> queryPaging(BusinessTeamMemberQuery query) {
        PagingVO<BusinessTeamMemberVO> businessTeamMemberVOPagingVO = this.businessTeamMemberDAO.queryPaging(query);
        businessTeamMemberVOPagingVO.stream().forEach(vo -> vo.setMemberRoleName(this.traslate(vo.getMemberRole(), vo.getType())));
        return businessTeamMemberVOPagingVO;
    }

    public List<BusinessTeamMemberVO> queryListDynamic(BusinessTeamMemberQuery query) {
        List<BusinessTeamMemberVO> businessTeamMemberVOS = this.businessTeamMemberDAO.queryListDynamic(query);
        businessTeamMemberVOS.stream().forEach(vo -> vo.setMemberRoleName(this.traslate(vo.getMemberRole(), vo.getType())));
        return businessTeamMemberVOS;
    }

    public BusinessTeamMemberVO queryByKey(Long key) {
        BusinessTeamMemberDO entity = this.businessTeamMemberRepo.findById(key).orElseGet(BusinessTeamMemberDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        entity.setMemberRoleName(this.traslate(entity.getMemberRole(), entity.getType()));
        BusinessTeamMemberVO vo = BusinessTeamMemberConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public List<BusinessTeamMemberVO> insert(List<BusinessTeamMemberPayload> payload) {
        Long objectId = null;
        if (payload != null && payload.size() > 0) {
            objectId = payload.get(0).getObjectId();
            this.businessTeamMemberDAO.deleteByObjectIdAndNoCreator(objectId);
        }
        HashSet<Long> userIdset = new HashSet<Long>();
        HashSet<String> memberRoleSet = new HashSet<String>();
        boolean memberRoleCount = false;
        StringBuilder createUserId = new StringBuilder();
        for (BusinessTeamMemberPayload businessTeamMemberPayload : payload) {
            if (businessTeamMemberPayload.getIsCreator() != null && businessTeamMemberPayload.getIsCreator().booleanValue()) {
                businessTeamMemberPayload.setSortNo(Integer.valueOf(1));
                createUserId.append(businessTeamMemberPayload.getUserId().toString());
            } else {
                userIdset.add(businessTeamMemberPayload.getUserId());
            }
            if (BusinessTeamRoleEnum.CREATOR.getCode().equals(businessTeamMemberPayload.getMemberRole())) continue;
            memberRoleSet.add(businessTeamMemberPayload.getMemberRole());
        }
        if (!CollectionUtils.isEmpty(userIdset) && userIdset.size() > memberRoleSet.size()) {
            throw TwException.error("", "\u8bf7\u52ff\u6dfb\u52a0\u76f8\u540c\u7684\u89d2\u8272");
        }
        if (!StringUtils.isEmpty((CharSequence)createUserId) && userIdset.contains(Long.valueOf(createUserId.toString()))) {
            throw TwException.error("", "\u521b\u5efa\u4eba\u5458\u6dfb\u52a0\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u6dfb\u52a0");
        }
        List<BusinessTeamMemberDO> entityDo = BusinessTeamMemberConvert.INSTANCE.toDoList(payload);
        if (objectId != null) {
            if (BusinessTeamTypeEnum.BID.getCode().equals(payload.get(0).getType())) {
                this.logService.saveNewLog(objectId, PrdSystemObjectEnum.BID_PROJECT.getCode(), "\u4fee\u6539\u4e86\u56e2\u961f\u6210\u5458");
            }
            if (BusinessTeamTypeEnum.PARTNER.getCode().equals(payload.get(0).getType())) {
                this.logService.saveNewLog(objectId, PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), "\u4fee\u6539\u4e86\u56e2\u961f\u6210\u5458");
            }
        }
        if (BusinessTeamTypeEnum.PARTNER.getCode().equals(payload.get(0).getType())) {
            this.businessCustomerInfoService.updateBusinessParnerCustomerModifyTime(objectId);
        }
        return BusinessTeamMemberConvert.INSTANCE.toVoList(this.businessTeamMemberRepo.saveAll(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessTeamMemberVO update(BusinessTeamMemberPayload payload) {
        BusinessTeamMemberDO entity = this.businessTeamMemberRepo.findById(payload.getId()).orElseGet(BusinessTeamMemberDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BusinessTeamMemberDO entityDo = BusinessTeamMemberConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        if (BusinessTeamTypeEnum.PARTNER.getCode().equals(entity.getType())) {
            this.businessCustomerInfoService.updateBusinessParnerCustomerModifyTime(entity.getObjectId());
        }
        return BusinessTeamMemberConvert.INSTANCE.toVo((BusinessTeamMemberDO)this.businessTeamMemberRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys, Long objectId) {
        if (!keys.isEmpty()) {
            this.businessTeamMemberDAO.deleteSoft(keys);
            if (objectId != null) {
                BusinessTeamMemberDO businessTeamMemberDO = this.businessTeamMemberRepo.findById(keys.get(0)).orElseGet(BusinessTeamMemberDO::new);
                if (BusinessTeamTypeEnum.BID.getCode().equals(businessTeamMemberDO.getType())) {
                    this.logService.saveNewLog(objectId, PrdSystemObjectEnum.BID_PROJECT.getCode(), "\u4fee\u6539\u4e86\u56e2\u961f\u6210\u5458");
                }
                if (BusinessTeamTypeEnum.PARTNER.getCode().equals(businessTeamMemberDO.getType())) {
                    this.logService.saveNewLog(objectId, PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), "\u4fee\u6539\u4e86\u56e2\u961f\u6210\u5458");
                    this.businessCustomerInfoService.updateBusinessParnerCustomerModifyTime(objectId);
                }
            }
        }
    }

    public BusinessTeamMemberVO save(BusinessTeamMemberPayload payload) {
        BusinessTeamMemberDO entityDo = BusinessTeamMemberConvert.INSTANCE.toDo(payload);
        if (BusinessTeamTypeEnum.PARTNER.getCode().equals(entityDo.getType())) {
            this.businessCustomerInfoService.updateBusinessParnerCustomerModifyTime(entityDo.getObjectId());
        }
        return BusinessTeamMemberConvert.INSTANCE.toVo((BusinessTeamMemberDO)this.businessTeamMemberRepo.save(entityDo));
    }

    public List<BusinessTeamMemberVO> saveAll(List<BusinessTeamMemberPayload> payloadList) {
        List<BusinessTeamMemberDO> entityDoList = BusinessTeamMemberConvert.INSTANCE.toDoList(payloadList);
        return BusinessTeamMemberConvert.INSTANCE.toVoList(this.businessTeamMemberRepo.saveAll(entityDoList));
    }

    public List<BusinessTeamMemberVO> queryByObjectIdAndRole(Long objectId, String role) {
        return this.businessTeamMemberDAO.queryByObjectIdAndRole(objectId, role);
    }

    public List<BusinessTeamMemberVO> queryByObjectIdsAndRole(List<Long> objectIds, String role) {
        return this.businessTeamMemberDAO.queryByObjectIdsAndRole(objectIds, role);
    }

    public List<BusinessTeamMemberVO> queryByObjectId(Long objectId) {
        return this.businessTeamMemberDAO.queryByObjectId(objectId);
    }

    public Long count(BusinessTeamMemberQuery query) {
        return this.businessTeamMemberDAO.count(query);
    }

    public void updateTeamByIdentityChange(Long objectId, String identity) {
        String selectKey = BusinessSelectionEnum.valueOf(identity).getCode();
        PrdSystemSelectionVO systemSelection = this.cacheUtil.getSystemSelection(selectKey);
        List<String> roleList = Arrays.asList(systemSelection.getExtString1().split(","));
        this.businessTeamMemberDAO.updateTeamByIdentityChange(objectId, roleList);
    }

    public String traslate(String roleCode, String type) {
        if (BusinessTeamTypeEnum.PARTNER.getCode().equals(type)) {
            return BusinessTeamRoleEnum.valueOf(roleCode).getDesc();
        }
        if (BusinessTeamTypeEnum.BID.getCode().equals(type)) {
            return BusinessTeamRoleEnum.valueOf(roleCode).getDesc();
        }
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByObjectId(Long objectId) {
        this.businessTeamMemberRepo.deleteByObjectId(objectId);
        this.businessCustomerInfoService.updateBusinessParnerCustomerModifyTime(objectId);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteTeamMember(Long objectId, String type, List<String> memberRoles) {
        this.businessTeamMemberDAO.deleteTeamMember(objectId, type, memberRoles);
    }

    public BusinessTeamMemberServiceImpl(BusinessTeamMemberRepo businessTeamMemberRepo, BusinessTeamMemberDAO businessTeamMemberDAO, PrdSystemLogService logService, CacheUtil cacheUtil, BusinessCustomerInfoService businessCustomerInfoService) {
        this.businessTeamMemberRepo = businessTeamMemberRepo;
        this.businessTeamMemberDAO = businessTeamMemberDAO;
        this.logService = logService;
        this.cacheUtil = cacheUtil;
        this.businessCustomerInfoService = businessCustomerInfoService;
    }
}

