/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeEqvaRatioService;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsResourcePlanPayload;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsResourcePlanRolePayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectQuery;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsResourcePlanDaysQuery;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsResourcePlanQuery;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsResourcePlanRoleQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsResourcePlanDaysService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsResourcePlanRoleService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsResourcePlanService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectTemplateVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsResourcePlanRoleVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsResourcePlanVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsReasonTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.ProjectStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.ResourcePlanningCycleEnum;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsResourcePlanConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectDAO;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectTemplateDAO;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsResourcePlanDAO;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsResourcePlanRoleDAO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsResourcePlanDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsResourcePlanRepo;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class PmsResourcePlanServiceImpl
extends BaseServiceImpl
implements PmsResourcePlanService {
    private static final Logger log = LoggerFactory.getLogger(PmsResourcePlanServiceImpl.class);
    private final PmsResourcePlanRepo pmsResourcePlanRepo;
    private final PmsResourcePlanDAO pmsResourcePlanDAO;
    private final PmsProjectDAO pmsProjectDAO;
    private final PmsProjectTemplateDAO pmsProjectTemplateDAO;
    private final CacheUtil cacheUtil;
    private final PmsResourcePlanRoleService resourcePlanRoleService;
    private final PmsResourcePlanDaysService resourcePlanDaysService;
    private final PmsResourcePlanRoleDAO pmsResourcePlanRoleDAO;
    private final PrdOrgEmployeeEqvaRatioService prdOrgEmployeeEqvaRatioService;

    public PagingVO<PmsResourcePlanVO> queryPaging(PmsResourcePlanQuery query) {
        return this.pmsResourcePlanDAO.queryPaging(query);
    }

    public List<PmsResourcePlanVO> queryListDynamic(PmsResourcePlanQuery query) {
        return this.pmsResourcePlanDAO.queryListDynamic(query);
    }

    public PmsResourcePlanVO queryByKey(Long key) {
        PmsResourcePlanDO entity = this.pmsResourcePlanRepo.findById(key).orElseGet(PmsResourcePlanDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PmsResourcePlanVO vo = PmsResourcePlanConvert.INSTANCE.toVo(entity);
        vo.setPlanningStatus("0");
        vo.setPlanningStatusDesc("\u6b63\u5e38");
        vo.setCreator(this.cacheUtil.getUserName(vo.getCreateUserId()));
        return vo;
    }

    public PmsResourcePlanVO queryByObjId(PmsResourcePlanQuery query) {
        if (ObjectUtils.isEmpty((Object)query.getObjId())) {
            throw TwException.error("", "\u5173\u8054\u5bf9\u8c61ID\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        PmsResourcePlanVO resourcePlanVO = null;
        List<PmsResourcePlanVO> list = this.pmsResourcePlanDAO.queryListDynamic(query);
        if (ObjectUtils.isEmpty(list)) {
            PmsProjectVO pmsProjectVO = this.pmsProjectDAO.queryByKey(query.getObjId());
            resourcePlanVO = this.fromProject(query.getObjId(), PmsReasonTypeEnum.PROJ_CONTRACT.getCode(), pmsProjectVO);
        } else {
            resourcePlanVO = list.get(0);
        }
        resourcePlanVO.setPlanningStatusDesc("\u6b63\u5e38");
        resourcePlanVO.setCreator(this.cacheUtil.getUserName(resourcePlanVO.getCreateUserId()));
        return resourcePlanVO;
    }

    public Long countByObjId(PmsResourcePlanQuery query) {
        return this.pmsResourcePlanDAO.count(query);
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsResourcePlanVO insertOrUpdate(PmsResourcePlanPayload payload) {
        if (ObjectUtils.isEmpty((Object)payload.getPlanType()) || ObjectUtils.isEmpty((Object)payload.getObjId()) || ObjectUtils.isEmpty((Object)payload.getObjName())) {
            throw TwException.error("", "\u8ba1\u5212\u7c7b\u578b\u3001\u5173\u8054\u5bf9\u8c61ID\u3001\u5173\u8054\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (ObjectUtils.isEmpty((Object)payload.getStartDate()) || ObjectUtils.isEmpty((Object)payload.getEndDate())) {
            throw TwException.error("", "\u5f00\u59cb\u65e5\u671f\u3001\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (payload.getStartDate().isAfter(payload.getEndDate())) {
            throw TwException.error("", "\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65e5\u671f!");
        }
        if (ObjectUtils.isEmpty((Object)payload.getResourcePlanningCycle())) {
            throw TwException.error("", "\u8d44\u6e90\u89c4\u5212\u5468\u671f\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (ObjectUtils.isEmpty((Object)payload.getDuration())) {
            throw TwException.error("", "\u6301\u7eed\u65f6\u957f\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (ObjectUtils.isEmpty((Object)payload.getCreateUserId()) || ObjectUtils.isEmpty((Object)payload.getModifyTime())) {
            throw TwException.error("", "\u521b\u5efa\u4eba\u3001\u66f4\u65b0\u4eba \u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (ResourcePlanningCycleEnum.WEEK.getCode().equals(payload.getResourcePlanningCycle())) {
            // empty if block
        }
        PmsResourcePlanDaysQuery daysQuery = new PmsResourcePlanDaysQuery();
        daysQuery.setPlanId(payload.getId());
        PmsResourcePlanRoleQuery resourcePlanRoleQuery = new PmsResourcePlanRoleQuery();
        resourcePlanRoleQuery.setPlanId(payload.getId());
        List pmsResourcePlanRoleVOS = null;
        LocalDate now = LocalDate.now();
        for (PmsResourcePlanRoleVO pmsResourcePlanRoleVO : pmsResourcePlanRoleVOS) {
            List daysInfo = pmsResourcePlanRoleVO.getDaysInfo();
            if (CollectionUtils.isEmpty((Collection)daysInfo)) continue;
            BigDecimal totalDays = daysInfo.stream().map(e -> e.getDays()).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            PmsResourcePlanRolePayload resourcePlanRolePayload = new PmsResourcePlanRolePayload();
            resourcePlanRolePayload.setTotalDays(totalDays);
            resourcePlanRolePayload.setId(pmsResourcePlanRoleVO.getId());
            if (pmsResourcePlanRoleVO.getDistributeRate() == null || pmsResourcePlanRoleVO.getDistributeRate().compareTo(BigDecimal.ZERO) <= 0) {
                BigDecimal eqvaRatio = this.prdOrgEmployeeEqvaRatioService.getEqvaRatio(pmsResourcePlanRoleVO.getResId(), null);
                pmsResourcePlanRoleVO.setDistributeRate(eqvaRatio);
            }
            resourcePlanRolePayload.setTotalEqva(pmsResourcePlanRoleVO.getDistributeRate().multiply(totalDays));
            this.pmsResourcePlanRoleDAO.updateByKeyDynamic(resourcePlanRolePayload);
        }
        PmsResourcePlanDO entityDo = PmsResourcePlanConvert.INSTANCE.toDo(payload);
        return PmsResourcePlanConvert.INSTANCE.toVo((PmsResourcePlanDO)this.pmsResourcePlanRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.pmsResourcePlanDAO.deleteSoft(keys);
        }
    }

    public PagingVO<PmsResourcePlanVO> resourcePlanNotice(PmsResourcePlanRoleQuery query) {
        List<Object> list = this.getPlanVOList(GlobalUtil.getLoginUserId());
        int total = list.size();
        list = list.stream().skip(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).collect(Collectors.toList());
        return PagingVO.builder().records(list).total((long)total).build();
    }

    public long findRemindCount(Long userId) {
        return this.getPlanVOList(userId).size();
    }

    private List<PmsResourcePlanVO> getPlanVOList(Long userId) {
        ArrayList<PmsResourcePlanVO> result = new ArrayList<PmsResourcePlanVO>();
        LocalDate now = LocalDate.now();
        Long projectConfigDaysTime = Long.parseLong("7");
        PmsProjectQuery projectQuery = new PmsProjectQuery();
        projectQuery.setPmResId(userId);
        projectQuery.setProjStatus(ProjectStatusEnum.ACTIVE.getCode());
        projectQuery.setWorkTypes(Arrays.asList("DELIVERY", "DEVELOP", "T&M"));
        List<PmsProjectVO> listProject = this.pmsProjectDAO.queryListDynamic(projectQuery);
        if (!ObjectUtils.isEmpty(listProject)) {
            HashMap projectMap = new HashMap();
            ArrayList projectIds = new ArrayList();
            listProject.forEach(v -> {
                Long projectId = v.getId();
                projectIds.add(projectId);
                projectMap.put(projectId, v);
            });
            PmsResourcePlanQuery query = new PmsResourcePlanQuery();
            query.setObjIds(projectIds);
            query.setPlanType(PmsReasonTypeEnum.PROJ_CONTRACT.getCode());
            List<PmsResourcePlanVO> planVOList = this.pmsResourcePlanDAO.queryListDynamic(query);
            List hasPlanProject = planVOList.stream().map(v -> v.getObjId()).collect(Collectors.toList());
            List noPlanProject = projectIds.stream().filter(item -> !hasPlanProject.contains(item)).collect(Collectors.toList());
            for (Long projectId : noPlanProject) {
                PmsProjectVO pmsProjectVO = (PmsProjectVO)projectMap.get(projectId);
                result.add(this.fromProject(projectId, PmsReasonTypeEnum.PROJ_CONTRACT.getCode(), pmsProjectVO));
            }
            for (PmsResourcePlanVO planVO : planVOList) {
                LocalDate modifyTime = planVO.getModifyTime().toLocalDate();
                long between = now.toEpochDay() - modifyTime.toEpochDay();
                if (between <= projectConfigDaysTime) continue;
                result.add(planVO);
            }
        }
        return result;
    }

    PmsResourcePlanVO fromProject(Long objId, String planType, PmsProjectVO pmsProjectVO) {
        PmsResourcePlanPayload payload = new PmsResourcePlanPayload();
        payload.setObjId(objId);
        payload.setPlanType(planType);
        payload.setPlanningStatus("0");
        if (!ObjectUtils.isEmpty((Object)pmsProjectVO)) {
            payload.setStartDate(pmsProjectVO.getPlanStartDate());
            payload.setEndDate(pmsProjectVO.getPlanEndDate());
            payload.setObjName(pmsProjectVO.getProjName());
            PmsProjectTemplateVO pmsProjectTemplateVO = this.pmsProjectTemplateDAO.queryByKey(pmsProjectVO.getProjTempId());
            payload.setResourcePlanningCycle(pmsProjectTemplateVO.getResourcePlanningCycle());
        }
        PmsResourcePlanDO entityDo = PmsResourcePlanConvert.INSTANCE.toDo(payload);
        return PmsResourcePlanConvert.INSTANCE.toVo((PmsResourcePlanDO)this.pmsResourcePlanRepo.save(entityDo));
    }

    public PmsResourcePlanServiceImpl(PmsResourcePlanRepo pmsResourcePlanRepo, PmsResourcePlanDAO pmsResourcePlanDAO, PmsProjectDAO pmsProjectDAO, PmsProjectTemplateDAO pmsProjectTemplateDAO, CacheUtil cacheUtil, PmsResourcePlanRoleService resourcePlanRoleService, PmsResourcePlanDaysService resourcePlanDaysService, PmsResourcePlanRoleDAO pmsResourcePlanRoleDAO, PrdOrgEmployeeEqvaRatioService prdOrgEmployeeEqvaRatioService) {
        this.pmsResourcePlanRepo = pmsResourcePlanRepo;
        this.pmsResourcePlanDAO = pmsResourcePlanDAO;
        this.pmsProjectDAO = pmsProjectDAO;
        this.pmsProjectTemplateDAO = pmsProjectTemplateDAO;
        this.cacheUtil = cacheUtil;
        this.resourcePlanRoleService = resourcePlanRoleService;
        this.resourcePlanDaysService = resourcePlanDaysService;
        this.pmsResourcePlanRoleDAO = pmsResourcePlanRoleDAO;
        this.prdOrgEmployeeEqvaRatioService = prdOrgEmployeeEqvaRatioService;
    }
}

