/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.purchase.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PurchaseAgreementPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.PurchaseAgreementQuery;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchaseAgreementService;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseAgreementVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.permission.annotation.FunctionDetail;
import com.elitesland.tw.tw5.server.common.permission.annotation.PermissionDomain;
import com.elitesland.tw.tw5.server.common.permission.annotation.PermissionFunction;
import com.elitesland.tw.tw5.server.common.permission.enums.FunctionCodeEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.FunctionTypeEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionDomainEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionTypeEnum;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.seata.spring.annotation.GlobalTransactional;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u91c7\u8d2d\u534f\u8bae"})
@RestController
@RequestMapping(value={"/api/purchaseAgreement"})
@PermissionDomain(domain=PermissionDomainEnum.PUR_AGREEMENT)
public class PurchaseAgreementController {
    private static final Logger log = LoggerFactory.getLogger(PurchaseAgreementController.class);
    private final PurchaseAgreementService purchaseAgreementService;

    @PostMapping
    @ApiOperation(value="\u91c7\u8d2d\u534f\u8bae-\u65b0\u589e")
    public TwOutputUtil<PurchaseAgreementVO> insert(@RequestBody PurchaseAgreementPayload payload) {
        return TwOutputUtil.ok(this.purchaseAgreementService.insert(payload));
    }

    @PutMapping
    @ApiOperation(value="\u91c7\u8d2d\u534f\u8bae-\u66f4\u65b0")
    public TwOutputUtil<PurchaseAgreementVO> update(@RequestBody PurchaseAgreementPayload payload) {
        return TwOutputUtil.ok(this.purchaseAgreementService.update(payload));
    }

    @PutMapping(value={"update"})
    @ApiOperation(value="\u91c7\u8d2d\u534f\u8bae-\u66f4\u65b0,\u652f\u6301\u7f6e\u7a7a \u7f6e\u7a7a\u7684\u5b57\u6bb5\u9700\u9700\u8981\u501f\u52a9 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody PurchaseAgreementPayload payload) {
        return TwOutputUtil.ok(this.purchaseAgreementService.updateByKeyDynamic(payload));
    }

    @GetMapping(value={"/{key}"})
    @UdcNameClass
    @ApiOperation(value="\u91c7\u8d2d\u534f\u8bae-\u4e3b\u952e\u67e5\u8be2")
    public TwOutputUtil<PurchaseAgreementVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(this.purchaseAgreementService.queryByKey(key));
    }

    @GetMapping(value={"/paging"})
    @UdcNameClass
    @ApiOperation(value="\u91c7\u8d2d\u534f\u8bae-\u5206\u9875")
    public TwOutputUtil<PagingVO<PurchaseAgreementVO>> paging(PurchaseAgreementQuery query) {
        return TwOutputUtil.ok(this.purchaseAgreementService.queryPaging(query));
    }

    @PostMapping(value={"/permission/paging"})
    @UdcNameClass
    @PermissionFunction(functions={@FunctionDetail(functionCode=FunctionCodeEnum.PCN_PURCHASE_LIST_DATA_POWER, type=FunctionTypeEnum.TAB)}, fieldPermission=true, permissionType=PermissionTypeEnum.DATA_PERMISSION)
    @ApiOperation(value="\u91c7\u8d2d\u534f\u8bae-\u6743\u9650\u5206\u9875")
    public TwOutputUtil<PagingVO<PurchaseAgreementVO>> permissionPaging(@RequestBody PurchaseAgreementQuery query) {
        return TwOutputUtil.ok(this.purchaseAgreementService.permissionPaging(query));
    }

    @GetMapping(value={"/list"})
    @UdcNameClass
    @ApiOperation(value="\u91c7\u8d2d\u534f\u8bae-\u67e5\u8be2\u5217\u8868")
    public TwOutputUtil<List<PurchaseAgreementVO>> queryList(PurchaseAgreementQuery query) {
        return TwOutputUtil.ok(this.purchaseAgreementService.queryListDynamic(query));
    }

    @DeleteMapping(value={"/deleteSoft"})
    @ApiOperation(value="\u91c7\u8d2d\u534f\u8bae-\u5220\u9664")
    public TwOutputUtil deleteSoft(Long[] keys) {
        this.purchaseAgreementService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @PatchMapping(value={"/active"})
    @ApiOperation(value="\u91c7\u8d2d\u534f\u8bae-\u6fc0\u6d3b")
    @GlobalTransactional
    public TwOutputUtil active(Long id) {
        this.purchaseAgreementService.active(id);
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u91c7\u8d2d\u534f\u8bae-\u6682\u6302")
    @PatchMapping(value={"/pending"})
    public TwOutputUtil pending(@RequestParam List<Long> ids) {
        this.purchaseAgreementService.pending(ids);
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u91c7\u8d2d\u534f\u8bae-\u7ec8\u6b62")
    @PatchMapping(value={"/break"})
    public TwOutputUtil purAgreementBreak(@RequestParam List<Long> ids, @RequestParam String overReason) {
        this.purchaseAgreementService.purAgreementBreak(ids, overReason);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/download"})
    @ApiOperation(value="\u91c7\u8d2d\u534f\u8bae-\u5bfc\u51fa")
    public void download(HttpServletResponse response, PurchaseAgreementQuery query) {
        this.purchaseAgreementService.download(response, query);
    }

    @PostMapping(value={"/permission/download"})
    @UdcNameClass
    @ApiOperation(value="\u91c7\u8d2d\u534f\u8bae-\u6279\u91cf\u5bfc\u51fa\u534f\u8baeexcel")
    public void permissionDownload(@RequestBody PurchaseAgreementQuery query, HttpServletResponse response) {
        this.purchaseAgreementService.permissionDownload(query, response);
    }

    @GetMapping(value={"/getRate/{agreementId}/{amt}"})
    @ApiOperation(value="\u6839\u636e\u91c7\u8d2d\u534f\u8baeId\u83b7\u53d6\u8d39\u7387")
    public TwOutputUtil<BigDecimal> getRateByAgreementId(@PathVariable(value="agreementId") Long agreementId, @PathVariable(value="amt") BigDecimal amt) {
        return TwOutputUtil.ok(this.purchaseAgreementService.getRateByAgreementId(agreementId, amt));
    }

    public PurchaseAgreementController(PurchaseAgreementService purchaseAgreementService) {
        this.purchaseAgreementService = purchaseAgreementService;
    }
}

