/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.purchase.repo;

import com.elitesland.tw.tw5.server.prd.purchase.entity.PurchaseContractManagerDO;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import javax.transaction.Transactional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;

public interface PurchaseContractManagerRepo
extends JpaRepository<PurchaseContractManagerDO, Long>,
JpaSpecificationExecutor<PurchaseContractManagerDO> {
    public List<PurchaseContractManagerDO> queryByPurchaseContractIdV4In(List<Long> var1);

    @Transactional
    @Modifying
    @Query(value="UPDATE PurchaseContractManagerDO PC \nSET PC.CONTRACT_STATUS = 'CLOSE',\nPC.MODIFY_TIME = SYSDATE() \nWHERE\n\tPC.CONTRACT_NO IN (\n\tSELECT\n\t\tRLT.CONTRACT_NO \n\tFROM\n\t\t(\n\t\tSELECT\n\t\t\tPCM.CONTRACT_NO \n\t\tFROM\n\t\t\tPurchaseContractManagerDO PCM,\n\t\t\tPurchasePaymentPlanDO PPP,\n\t\t\tPurchasePaymentDO PP \n\t\tWHERE\n\t\t\tPCM.CONTRACT_NO = PPP.CONTRACT_NO -- AND PPP.DOC_TYPE = ''\n\t\t\t\n\t\t\tAND PPP.PAYMENT_APPLY_ID = PP.ID \n\t\t\tAND PPP.DOC_TYPE = 'CONTRACT' \n\t\t\tAND ((\n\t\t\t\t\tPP.PAYMENT_APPLICATION_TYPE = 'CONTRACT' \n\t\t\t\t\tAND PP.STATE = 'PAID' \n\t\t\t\t\t) -- \u5408\u540c\u4ed8\u6b3e \u5e76\u4e14 \u5df2\u652f\u4ed8\n\t\t\t\t\n\t\t\tOR ( PP.PAYMENT_APPLICATION_TYPE = 'ADVANCEPAYWRITEOFF' AND PP.STATE = 'APPROVED' )) -- \u9884\u4ed8\u6b3e\u6838\u9500 \u5e76\u4e14 \u5df2\u5ba1\u6279\n\t\t\t\n\t\t\tAND PCM.CONTRACT_STATUS = 'ACTIVE' -- \u53ea\u770b\u91c7\u8d2d\u5408\u540c\u4e3a\u6fc0\u6d3b\u7684\n\t\t\t\n\t\t\tAND PCM.DEL_FLAG = 0 \n\t\t\tAND PP.DEL_FLAG = 0 \n\t\t\tAND PPP.DEL_FLAG = 0 \n\t\tGROUP BY\n\t\t\tPCM.CONTRACT_NO,\n\t\t\tPCM.AMT \n\t\tHAVING\n\t\t\tPCM.AMT = SUM( PPP.PAYMENT_AMT ) \n\t\t) RLT \n\t);", nativeQuery=true)
    public int purchaseContractCloseBatch();

    public Optional<PurchaseContractManagerDO> findByPurchaseContractNo(String var1);

    @Query(value="SELECT SUM(IFNULL( PPP.payment_amt, 0 ) - IFNULL( PPP.current_payment_amt, 0 ) + IF( PP.state = 'write_off_part', P2.curr_payment_amt, 0 )) AS payable_amt FROM t_purchase_payment_plan PPP LEFT JOIN t_purchase_payment PP ON PPP.payment_apply_id = PP.id LEFT JOIN (SELECT PP2.payment_no, SUM( PP2.curr_payment_amt ) AS curr_payment_amt FROM t_purchase_payment PP2 WHERE PP2.delete_flag = 0 AND PP2.payment_no IS NOT NULL GROUP BY PP2.payment_no ) P2 ON P2.payment_no = PP.payment_no WHERE PPP.delete_flag = 0 AND ( PP.state <> 'written_off' OR PP.state IS NULL )AND PPP.contract_id = ?1 AND PPP.doc_type = 'contract'GROUP BY PPP.contract_id,PPP.contract_no ", nativeQuery=true)
    public BigDecimal findPayableAmt(Long var1);

    @Query(value="SELECT amt - IFNULL( sum_amt, 0 ) FROM t_purchase_contract_manager AS con  LEFT JOIN (SELECT SUM(current_payment_amt) AS sum_amt , contract_id FROM t_purchase_payment_plan ppp LEFT JOIN t_purchase_payment pp ON ppp.payment_apply_id = pp.id WHERE ppp.delete_flag = 0 AND ppp.payment_apply_id IS NOT NULL AND ppp.contract_id = ?1 AND pp.payment_application_type <> 'advance_pay_write_off' ) AS plan ON con.id = plan.contract_id WHERE con.id = ?1 ", nativeQuery=true)
    public BigDecimal findPayableAmtNew(Long var1);
}

