/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.purchase.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PurchaseAgreementAssociationPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.PurchaseAgreementAssociationQuery;
import com.elitesland.tw.tw5.api.prd.purchase.query.PurchaseAgreementQuery;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchaseAgreementAssociationService;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchaseAgreementService;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseAgreementAssociationVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseAgreementVO;
import com.elitesland.tw.tw5.server.prd.purchase.convert.PurchaseAgreementAssociationConvert;
import com.elitesland.tw.tw5.server.prd.purchase.dao.PurchaseAgreementAssociationDAO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.PurchaseAgreementAssociationDO;
import com.elitesland.tw.tw5.server.prd.purchase.repo.PurchaseAgreementAssociationRepo;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
public class PurchaseAgreementAssociationServiceImpl
extends BaseServiceImpl
implements PurchaseAgreementAssociationService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseAgreementAssociationServiceImpl.class);
    private final PurchaseAgreementAssociationRepo purchaseAgreementAssociationRepo;
    private final PurchaseAgreementAssociationDAO purchaseAgreementAssociationDAO;
    @Autowired
    private PurchaseAgreementService purchaseAgreementService;

    public PagingVO<PurchaseAgreementAssociationVO> queryPaging(PurchaseAgreementAssociationQuery query) {
        return this.purchaseAgreementAssociationDAO.queryPaging(query);
    }

    public List<PurchaseAgreementAssociationVO> queryListDynamic(PurchaseAgreementAssociationQuery query) {
        List<PurchaseAgreementAssociationVO> purchaseAgreementAssociationVOS = this.purchaseAgreementAssociationDAO.queryListDynamic(query);
        List associationAgreementIds = purchaseAgreementAssociationVOS.stream().map(PurchaseAgreementAssociationVO::getAssociationAgreementId).collect(Collectors.toList());
        PurchaseAgreementQuery purchaseAgreementQuery = new PurchaseAgreementQuery();
        purchaseAgreementQuery.setIds(associationAgreementIds);
        List purchaseAgreementVOS = this.purchaseAgreementService.queryListDynamic(purchaseAgreementQuery);
        Map purchaseAgreementVOMap = purchaseAgreementVOS.stream().collect(Collectors.toMap(PurchaseAgreementVO::getId, Function.identity()));
        for (PurchaseAgreementAssociationVO purchaseAgreementAssociation : purchaseAgreementAssociationVOS) {
            Long associationAgreementId = purchaseAgreementAssociation.getAssociationAgreementId();
            PurchaseAgreementVO purchaseAgreementVO = (PurchaseAgreementVO)purchaseAgreementVOMap.get(associationAgreementId);
            if (ObjectUtils.isEmpty((Object)purchaseAgreementVO)) continue;
            purchaseAgreementAssociation.setAgreementName(purchaseAgreementVO.getPurchaseAgreementName());
            purchaseAgreementAssociation.setAgreementCode(purchaseAgreementVO.getPurchaseAgreementNo());
            purchaseAgreementAssociation.setAssociationContentDescription(purchaseAgreementVO.getAgreementContentDescription());
            purchaseAgreementAssociation.setSupplierBookId(purchaseAgreementVO.getSupplierBookId());
            purchaseAgreementAssociation.setSupplierName(purchaseAgreementVO.getSupplierName());
        }
        return purchaseAgreementAssociationVOS;
    }

    public PurchaseAgreementAssociationVO queryByKey(Long key) {
        PurchaseAgreementAssociationDO entity = this.purchaseAgreementAssociationRepo.findById(key).orElseGet(PurchaseAgreementAssociationDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PurchaseAgreementAssociationVO vo = PurchaseAgreementAssociationConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public PurchaseAgreementAssociationVO insert(PurchaseAgreementAssociationPayload payload) {
        PurchaseAgreementAssociationDO entityDo = PurchaseAgreementAssociationConvert.INSTANCE.toDo(payload);
        return PurchaseAgreementAssociationConvert.INSTANCE.toVo((PurchaseAgreementAssociationDO)this.purchaseAgreementAssociationRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public PurchaseAgreementAssociationVO update(PurchaseAgreementAssociationPayload payload) {
        PurchaseAgreementAssociationDO entity = this.purchaseAgreementAssociationRepo.findById(payload.getId()).orElseGet(PurchaseAgreementAssociationDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PurchaseAgreementAssociationDO entityDo = PurchaseAgreementAssociationConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PurchaseAgreementAssociationConvert.INSTANCE.toVo((PurchaseAgreementAssociationDO)this.purchaseAgreementAssociationRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(PurchaseAgreementAssociationPayload payload) {
        PurchaseAgreementAssociationDO entity = this.purchaseAgreementAssociationRepo.findById(payload.getId()).orElseGet(PurchaseAgreementAssociationDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.purchaseAgreementAssociationDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.purchaseAgreementAssociationDAO.deleteSoft(keys);
        }
    }

    public void deleteSoftByDocumentIdList(List<Long> documentIdList) {
        this.purchaseAgreementAssociationDAO.deleteSoftByDocumentIdList(documentIdList);
    }

    public PurchaseAgreementAssociationServiceImpl(PurchaseAgreementAssociationRepo purchaseAgreementAssociationRepo, PurchaseAgreementAssociationDAO purchaseAgreementAssociationDAO) {
        this.purchaseAgreementAssociationRepo = purchaseAgreementAssociationRepo;
        this.purchaseAgreementAssociationDAO = purchaseAgreementAssociationDAO;
    }
}

