/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.system.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemProblemFeedbackPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemProblemFeedbackQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemProblemFeedbackService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemProblemFeedbackVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u7cfb\u7edf\u529f\u80fd\u5904\u7406-\u95ee\u9898\u53cd\u9988")
@RestController
@RequestMapping(value={"/api/system"})
public class PrdSystemProblemFeedbackController {
    private static final Logger log = LoggerFactory.getLogger(PrdSystemProblemFeedbackController.class);
    private final PrdSystemProblemFeedbackService service;

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/problemFeedback/insert"})
    public TwOutputUtil insert(PrdSystemProblemFeedbackPayload payload) {
        PrdSystemProblemFeedbackVO vo = this.service.insert(payload);
        return TwOutputUtil.ok(vo);
    }

    @ApiOperation(value="\u4fee\u6539")
    @PutMapping(value={"/problemFeedback/update"})
    public TwOutputUtil update(PrdSystemProblemFeedbackPayload payload) {
        PrdSystemProblemFeedbackVO vo = this.service.update(payload);
        return TwOutputUtil.ok(vo);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    @GetMapping(value={"/problemFeedback/paging"})
    public TwOutputUtil paging(PrdSystemProblemFeedbackQuery query) {
        PagingVO paging = this.service.paging(query);
        return TwOutputUtil.ok(paging);
    }

    @ApiOperation(value="\u4e3b\u952e\u67e5\u8be2")
    @GetMapping(value={"/problemFeedback/{key}"})
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        PrdSystemProblemFeedbackVO vo = this.service.queryByKey(key);
        return TwOutputUtil.ok(vo);
    }

    @ApiOperation(value="\u6839\u636e\u4e3b\u952e\u52a8\u6001\u4fee\u6539")
    @PutMapping(value={"/problemFeedback/updateByKeyDynamic"})
    public TwOutputUtil updateByKeyDynamic(PrdSystemProblemFeedbackPayload payload) {
        this.service.updateByKeyDynamic(payload);
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u5173\u95ed\u95ee\u9898")
    @PutMapping(value={"/problemFeedback/close"})
    public TwOutputUtil closeProblemFeedback(PrdSystemProblemFeedbackPayload payload) {
        this.service.closeProblemFeedback(payload);
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u6253\u5f00\u95ee\u9898")
    @PutMapping(value={"/problemFeedback/open"})
    public TwOutputUtil openProblemFeedback(PrdSystemProblemFeedbackPayload payload) {
        this.service.openProblemFeedback(payload);
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u7533\u8bf7\u52a0\u6025")
    @PutMapping(value={"/problemFeedback/urgent"})
    public TwOutputUtil urgentProblemFeedback(PrdSystemProblemFeedbackPayload payload) {
        this.service.urgentProblemFeedback(payload);
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u4fee\u6539\u5e38\u89c1\u95ee\u9898\u6807\u5fd7")
    @PutMapping(value={"/problemFeedback/common"})
    public TwOutputUtil commonProblemFeedback(PrdSystemProblemFeedbackPayload payload) {
        this.service.commonProblemFeedback(payload);
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u67e5\u8be2\u65f6\u95f4\u6bb5\u5185\u7684\u95ee\u9898\u6570\u91cf\u548c\u89e3\u51b3\u6570\u91cf")
    @GetMapping(value={"/problemFeedback/statisticalNumber"})
    public TwOutputUtil statisticalNumber(PrdSystemProblemFeedbackQuery query) {
        LocalDateTime startCreateTime = query.getStartCreateTime();
        LocalDateTime endCreateTime = query.getEndCreateTime();
        Map resultMap = this.service.statisticalNumber(startCreateTime, endCreateTime);
        return TwOutputUtil.ok(resultMap);
    }

    @ApiOperation(value="\u67e5\u8be2\u65f6\u95f4\u6bb5\u5185\u7684\u95ee\u9898\u7c7b\u578b\u7edf\u8ba1")
    @GetMapping(value={"/problemFeedback/statisticalGroupByProblemType"})
    public TwOutputUtil findNumberStatisticalGroupByProblemType(PrdSystemProblemFeedbackQuery query) {
        LocalDateTime startCreateTime = query.getStartCreateTime();
        LocalDateTime endCreateTime = query.getEndCreateTime();
        List resultList = this.service.findNumberStatisticalGroupByProblemType(startCreateTime, endCreateTime);
        return TwOutputUtil.ok(resultList);
    }

    @ApiOperation(value="\u67e5\u8be2\u65f6\u95f4\u6bb5\u5185\u7684\u95ee\u9898\u6240\u5c5e\u529f\u80fd\u7edf\u8ba1")
    @GetMapping(value={"/problemFeedback/statisticalGroupByFunctionId"})
    public TwOutputUtil findNumberStatisticalGroupByFunctionId(PrdSystemProblemFeedbackQuery query) {
        LocalDateTime startCreateTime = query.getStartCreateTime();
        LocalDateTime endCreateTime = query.getEndCreateTime();
        List resultList = this.service.findNumberStatisticalGroupByFunctionId(startCreateTime, endCreateTime);
        return TwOutputUtil.ok(resultList);
    }

    public PrdSystemProblemFeedbackController(PrdSystemProblemFeedbackService service) {
        this.service = service;
    }
}

