/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.task.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.task.payload.TaskPackagePayload;
import com.elitesland.tw.tw5.api.prd.task.query.TaskPackageQuery;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskPackageVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.task.entity.QTaskPackageDO;
import com.elitesland.tw.tw5.server.prd.task.entity.TaskPackageDO;
import com.elitesland.tw.tw5.server.prd.task.repo.TaskPackageRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class TaskPackageDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final TaskPackageRepo repo;
    private final QTaskPackageDO qdo = QTaskPackageDO.taskPackageDO;

    private JPAQuery<TaskPackageVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(TaskPackageVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.remark, this.qdo.createUserId, this.qdo.creator, this.qdo.createTime, this.qdo.modifyUserId, this.qdo.updater, this.qdo.modifyTime, this.qdo.reasonId, this.qdo.reasonName, this.qdo.reasonType, this.qdo.taskPackageName, this.qdo.disterResId, this.qdo.receiverResId, this.qdo.receiverBuId, this.qdo.compositeAbilityId, this.qdo.startDate, this.qdo.endDate, this.qdo.taskPackageStatus, this.qdo.taskPackageType, this.qdo.taskPackageDes, this.qdo.acceptorId, this.qdo.acceptMethod, this.qdo.pricingMethod, this.qdo.autoSettleFlag, this.qdo.guaranteeRate, this.qdo.settlePrice, this.qdo.incomePrice, this.qdo.jobType1, this.qdo.jobType2, this.qdo.taskPackageNo, this.qdo.eqvaRatio})).from((EntityPath)this.qdo);
    }

    private JPAQuery<TaskPackageVO> getJpaQueryWhere(TaskPackageQuery query) {
        JPAQuery<TaskPackageVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public long count(TaskPackageQuery query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo);
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        Long total = (Long)jpaQuery.fetchOne();
        total = total == null ? 0L : total;
        return total;
    }

    private Predicate where(TaskPackageQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReasonType())) {
            list.add(this.qdo.reasonType.eq((Object)query.getReasonType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReasonId())) {
            list.add(this.qdo.reasonId.eq((Object)query.getReasonId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReasonTypes())) {
            list.add(this.qdo.reasonType.in((Collection)query.getReasonTypes()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReasonName())) {
            list.add(this.qdo.reasonName.like(SqlUtil.toSqlLikeString(query.getReasonName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTaskPackageName())) {
            list.add(this.qdo.taskPackageName.like(SqlUtil.toSqlLikeString(query.getTaskPackageName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDisterResId())) {
            list.add(this.qdo.disterResId.eq((Object)query.getDisterResId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReceiverResId())) {
            list.add(this.qdo.receiverResId.eq((Object)query.getReceiverResId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReceiverResIds())) {
            list.add(this.qdo.receiverResId.in((Collection)query.getReceiverResIds()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReceiverBuId())) {
            list.add(this.qdo.receiverBuId.eq((Object)query.getReceiverBuId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCompositeAbilityId())) {
            list.add(this.qdo.compositeAbilityId.eq((Object)query.getCompositeAbilityId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getStartDate())) {
            list.add(this.qdo.startDate.eq((Object)query.getStartDate()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getEndDate())) {
            list.add(this.qdo.endDate.eq((Object)query.getEndDate()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTaskPackageStatus())) {
            list.add(this.qdo.taskPackageStatus.eq((Object)query.getTaskPackageStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTaskPackageType())) {
            list.add(this.qdo.taskPackageType.eq((Object)query.getTaskPackageType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTaskPackageDes())) {
            list.add(this.qdo.taskPackageDes.eq((Object)query.getTaskPackageDes()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAcceptorId())) {
            list.add(this.qdo.acceptorId.eq((Object)query.getAcceptorId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAcceptMethod())) {
            list.add(this.qdo.acceptMethod.eq((Object)query.getAcceptMethod()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPricingMethod())) {
            list.add(this.qdo.pricingMethod.eq((Object)query.getPricingMethod()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAutoSettleFlag())) {
            list.add(this.qdo.autoSettleFlag.eq((Object)query.getAutoSettleFlag()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getGuaranteeRate())) {
            list.add(this.qdo.guaranteeRate.eq((Object)query.getGuaranteeRate()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSettlePrice())) {
            list.add(this.qdo.settlePrice.eq((Object)query.getSettlePrice()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getIncomePrice())) {
            list.add(this.qdo.incomePrice.eq((Object)query.getIncomePrice()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getJobType1())) {
            list.add(this.qdo.jobType1.eq((Object)query.getJobType1()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getJobType2())) {
            list.add(this.qdo.jobType2.eq((Object)query.getJobType2()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getIds())) {
            list.add(this.qdo.id.in((Collection)query.getIds()));
        }
        return ExpressionUtils.allOf(list);
    }

    public TaskPackageVO queryByKey(Long id) {
        JPAQuery<TaskPackageVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (TaskPackageVO)jpaQuery.fetchFirst();
    }

    public List<TaskPackageVO> queryByKeys(List<Long> ids) {
        JPAQuery<TaskPackageVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.in(ids));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public List<TaskPackageVO> queryListDynamic(TaskPackageQuery query) {
        JPAQuery<TaskPackageVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<TaskPackageVO> queryPaging(TaskPackageQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<TaskPackageVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public TaskPackageDO save(TaskPackageDO ado) {
        return (TaskPackageDO)this.repo.save(ado);
    }

    public List<TaskPackageDO> saveAll(List<TaskPackageDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(TaskPackagePayload payload) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getReasonId() != null) {
            update.set(this.qdo.reasonId, (Object)payload.getReasonId());
        }
        if (payload.getReasonType() != null) {
            update.set((Path)this.qdo.reasonType, (Object)payload.getReasonType());
        }
        if (payload.getReasonName() != null) {
            update.set((Path)this.qdo.reasonName, (Object)payload.getReasonName());
        }
        if (payload.getTaskPackageName() != null) {
            update.set((Path)this.qdo.taskPackageName, (Object)payload.getTaskPackageName());
        }
        if (payload.getTaskPackageStatus() != null) {
            update.set((Path)this.qdo.taskPackageStatus, (Object)payload.getTaskPackageStatus());
        }
        if (payload.getTaskPackageType() != null) {
            update.set((Path)this.qdo.taskPackageType, (Object)payload.getTaskPackageType());
        }
        if (payload.getTaskPackageDes() != null) {
            update.set((Path)this.qdo.taskPackageDes, (Object)payload.getTaskPackageDes());
        }
        if (payload.getAcceptorId() != null) {
            update.set(this.qdo.acceptorId, (Object)payload.getAcceptorId());
        }
        if (payload.getAcceptMethod() != null) {
            update.set((Path)this.qdo.acceptMethod, (Object)payload.getAcceptMethod());
        }
        if (payload.getPricingMethod() != null) {
            update.set((Path)this.qdo.pricingMethod, (Object)payload.getPricingMethod());
        }
        if (payload.getAutoSettleFlag() != null) {
            update.set(this.qdo.autoSettleFlag, (Object)payload.getAutoSettleFlag());
        }
        if (payload.getGuaranteeRate() != null) {
            update.set(this.qdo.guaranteeRate, (Object)payload.getGuaranteeRate());
        }
        if (payload.getSettlePrice() != null) {
            update.set(this.qdo.settlePrice, (Object)payload.getSettlePrice());
        }
        if (payload.getIncomePrice() != null) {
            update.set(this.qdo.incomePrice, (Object)payload.getIncomePrice());
        }
        if (payload.getJobType1() != null) {
            update.set((Path)this.qdo.jobType1, (Object)payload.getJobType1());
        }
        if (payload.getJobType2() != null) {
            update.set((Path)this.qdo.jobType2, (Object)payload.getJobType2());
        }
        if (payload.getReceiverResId() != null) {
            update.set(this.qdo.receiverResId, (Object)payload.getReceiverResId());
        }
        if (payload.getEqvaRatio() != null) {
            update.set(this.qdo.eqvaRatio, (Object)payload.getEqvaRatio());
        }
        if (payload.getReceiverBuId() != null) {
            update.set(this.qdo.receiverBuId, (Object)payload.getReceiverBuId());
        }
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public TaskPackageDAO(JPAQueryFactory jpaQueryFactory, TaskPackageRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

