package com.elitesland.tw.tw5.server.common.funConfig.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 易稻壳yeedoc通用文档类型配置表
 *
 * @author duwh
 * @date 2023-12-07
 */
@Entity
@Table(name = "prd_business_doc_type_config", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "prd_business_doc_type_config", comment = "易稻壳yeedoc通用文档类型配置表")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class BusinessDocTypeConfigDO extends BaseModel implements Serializable  {
    /** 名称 */
    @Comment("名称")
    @Column()
    private String name;
    /** 编码 */
    @Comment("编码")
    @Column()
    private String code;
    /** 功能主键 prd_system_function.id */
    @Comment("功能主键 prd_system_function.id")
    @Column()
    private Long functionId;
    /** 业务对象主键 prd_business_table.id */
    @Comment("业务对象主键 prd_business_table.id")
    @Column()
    private Long tableId;
    /** 数据库表名 prd_business_table.table_name */
    @Comment("数据库表名 prd_business_table.table_name")
    @Column()
    private String tableName;
    /** 业务对象字段明细主键 prd_business_table_fields.id */
    @Comment("业务对象字段明细主键 prd_business_table_fields.id")
    @Column()
    private Long fieldId;
    /** 字段展示名称 prd_business_table_fields.show_name */
    @Comment("字段展示名称 prd_business_table_fields.show_name")
    @Column()
    private String fieldShowName;
    /** 是否启用 */
    @Comment("是否启用")
    @Column()
    private Boolean enabled;
    /** 是否需要权限控制 */
    @Comment("是否需要权限控制")
    @Column()
    private Boolean permissionControlFlag;
    /** 排序号 */
    @Comment("排序号")
    @Column()
    private Integer sortNo;
    /** 拓展字段1 */
    @Comment("拓展字段1")
    @Column()
    private String ext1;
    /** 拓展字段2 */
    @Comment("拓展字段2")
    @Column()
    private String ext2;
    /** 拓展字段3 */
    @Comment("拓展字段3")
    @Column()
    private String ext3;

    public void copy(BusinessDocTypeConfigDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
