package com.elitesland.tw.tw5.server.common.permission.strategy.execute;

import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemPermissionRuleVO;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionLevelScopeEnum;
import com.elitesland.tw.tw5.server.common.permission.strategy.OrgUserStrategyService;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

import java.util.Set;

/**
 * @Author Quruiqizz
 * @Date 2023/11/9 9:56
 **/
@Service(value = "ORG_ORG_PRINCIPAL")
public class OrgUserOrgPrincipal implements OrgUserStrategyService {

    @Value("${tw5.sys_default.dimensionId}")
    private Long defaultDimensionId;

    @Lazy
    @Autowired
    private PrdOrgOrganizationService prdOrgOrganizationService;

    /**
     * 组织负责人情况下的执行
     *
     * @param rule  权限规则
     * @param defaultOrgId  用户默认组织
     * @param childOrgSet   用户组织及子组织
     * @return
     */
    @Override
    public boolean execute(PrdSystemPermissionRuleVO rule, Long defaultOrgId, Set<Long> childOrgSet) {

        PrdOrgOrganizationVO prdOrgOrganizationVO = prdOrgOrganizationService.queryDetail(defaultDimensionId, Long.parseLong(rule.getRuleScope()));
        return prdOrgOrganizationVO.getManageId().equals(GlobalUtil.getLoginUserId());
//        579785848950752737
    }

}
